<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Test_google_calendar_integration extends MX_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('google_calendar');
    }

    public function index() {
        // Test the Google Calendar integration
        echo "<h1>Google Calendar Integration Test</h1>";
        
        // Check if authenticated
        $is_authenticated = $this->google_calendar->is_authenticated();
        echo "<p>Authentication Status: " . ($is_authenticated ? "✅ Authenticated" : "❌ Not Authenticated") . "</p>";
        
        if ($is_authenticated) {
            // Test creating an event
            $event_id = $this->google_calendar->add_event(
                'Test Appointment',
                'This is a test appointment from the clinic system',
                date('c'),
                date('c', time() + 3600) // 1 hour from now
            );
            
            if ($event_id) {
                echo "<p>✅ Event created successfully with ID: " . htmlspecialchars($event_id) . "</p>";
            } else {
                echo "<p>❌ Failed to create event</p>";
            }
        } else {
            echo "<p>Please authenticate with Google first:</p>";
            echo "<a href='" . base_url('google_auth') . "'>Authenticate with Google</a>";
        }
    }
}