<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Test_google_auth_url extends MX_Controller {

    public function index() {
        $doctor_id = $this->input->get('doctor_id');
        
        if (!$doctor_id) {
            echo "Please provide a doctor_id parameter";
            return;
        }
        
        // Load the Google Calendar library with doctor context
        $this->load->library('google_calendar', $doctor_id);
        
        // Get auth URL
        $auth_url = $this->google_calendar->get_auth_url();
        
        echo "<h1>Google Auth URL Test</h1>";
        echo "<p>Doctor ID: " . $doctor_id . "</p>";
        echo "<p>Auth URL: " . htmlspecialchars($auth_url) . "</p>";
        echo "<p>URL Length: " . strlen($auth_url) . "</p>";
        
        // Check if URL contains any problematic characters
        $problematic_chars = array('<', '>', '{', '}', '|', '\\', '^', '[', ']', '`');
        foreach ($problematic_chars as $char) {
            if (strpos($auth_url, $char) !== false) {
                echo "<p style='color: red;'>Contains problematic character: " . htmlspecialchars($char) . "</p>";
            }
        }
        
        echo "<p><a href='" . $auth_url . "'>Try Auth URL</a></p>";
    }
}