<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Test_doctor_email extends MX_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('doctor/doctor_model');
    }

    public function index($doctor_id = 1) {
        echo "<h1>Test Doctor Google Calendar Email Retrieval</h1>";
        
        $doctor_info = $this->doctor_model->getDoctorById($doctor_id);
        
        if ($doctor_info) {
            echo "<p>✅ Doctor info retrieved successfully.</p>";
            echo "<h2>Doctor Details:</h2>";
            echo "<ul>";
            echo "<li><strong>ID:</strong> " . htmlspecialchars($doctor_info->id) . "</li>";
            echo "<li><strong>Name:</strong> " . htmlspecialchars($doctor_info->name) . "</li>";
            echo "<li><strong>Google Calendar Email:</strong> " . htmlspecialchars($doctor_info->google_calendar_gmail) . "</li>";
            echo "<li><strong>Phone:</strong> " . htmlspecialchars($doctor_info->phone) . "</li>";
            echo "</ul>";
            
            if (!empty($doctor_info->google_calendar_gmail)) {
                if (filter_var($doctor_info->google_calendar_gmail, FILTER_VALIDATE_EMAIL)) {
                    echo "<p>✅ Doctor Google Calendar email is valid: " . htmlspecialchars($doctor_info->google_calendar_gmail) . "</p>";
                    echo "<p>This email can be used for Google Calendar invitations.</p>";
                } else {
                    echo "<p>❌ Doctor Google Calendar email format is invalid: " . htmlspecialchars($doctor_info->google_calendar_gmail) . "</p>";
                    echo "<p>Please correct the email format in the doctor's profile.</p>";
                }
            } else {
                echo "<p>❌ Doctor Google Calendar email is empty.</p>";
                echo "<p>Please add a Google Calendar email address to the doctor's profile.</p>";
            }
        } else {
            echo "<p>❌ Failed to retrieve doctor info for ID: " . $doctor_id . "</p>";
        }
        
        echo "<h2>Test Other Doctors</h2>";
        echo "<p>To test another doctor, modify the URL:</p>";
        echo "<p><code>" . base_url('test_doctor_email/index/') . "{doctor_id}</code></p>";
    }
}