<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Google_calendar_test extends MX_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('google_calendar');
    }

    public function index() {
        echo "<h1>Google Calendar Library Test</h1>";
        
        // Test if the library is loaded
        echo "<p>✅ Google Calendar library loaded successfully.</p>";
        
        // Test authentication status
        $is_authenticated = $this->google_calendar->is_authenticated();
        echo "<p>Authentication Status: " . ($is_authenticated ? "✅ Authenticated" : "❌ Not Authenticated") . "</p>";
        
        // Test auth URL generation
        $auth_url = $this->google_calendar->get_auth_url();
        echo "<p>Auth URL Generation: " . (!empty($auth_url) ? "✅ Success" : "❌ Failed") . "</p>";
        
        if (!empty($auth_url)) {
            echo "<p>Auth URL: <code>" . htmlspecialchars($auth_url) . "</code></p>";
        }
        
        // Test mock event creation
        echo "<h2>Mock Event Test</h2>";
        $result = $this->google_calendar->add_event(
            'Test Event',
            'This is a test event',
            date('c'),
            date('c', time() + 3600)
        );
        
        echo "<p>Event Creation: " . ($result ? "✅ Success (ID: " . htmlspecialchars($result) . ")" : "❌ Failed") . "</p>";
        
        echo "<h2>File Status</h2>";
        $credentials_file = APPPATH . 'credentials/client_secret.json';
        $token_file = APPPATH . 'credentials/token.json';
        
        echo "<p>Client Secret File: " . (file_exists($credentials_file) ? "✅ Found" : "❌ Missing") . "</p>";
        echo "<p>Token File: " . (file_exists($token_file) ? "✅ Found (Authenticated)" : "❌ Missing (Not Authenticated)") . "</p>";
        
        echo "<h2>Next Steps</h2>";
        echo "<ol>";
        echo "<li>Place your <code>client_secret.json</code> file in <code>application/credentials/</code></li>";
        if (!$is_authenticated) {
            echo "<li><a href='" . base_url('google_auth') . "'>Authenticate with Google</a></li>";
        } else {
            echo "<li>Create a new appointment to test the integration</li>";
        }
        echo "<li>Check your Google Calendar for events</li>";
        echo "</ol>";
    }
}