<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Google_api_test extends MX_Controller {

    public function index() {
        echo "<h1>Google API Client Test</h1>";
        
        // Test various autoload paths
        $autoloadPaths = [
            FCPATH . 'vendor/autoload.php',
            FCPATH . 'vendor/google/apiclient/vendor/autoload.php',
            APPPATH . 'third_party/google_api_php_client/vendor/autoload.php',
            FCPATH . 'application/third_party/google_api_php_client/vendor/autoload.php'
        ];
        
        echo "<h2>Autoload Path Check</h2>";
        $autoloadFound = false;
        foreach ($autoloadPaths as $path) {
            $exists = file_exists($path);
            echo "<p>" . ($exists ? "✅" : "❌") . " " . htmlspecialchars($path) . "</p>";
            if ($exists) {
                $autoloadFound = true;
            }
        }
        
        if (!$autoloadFound) {
            echo "<p>❌ No autoload file found. Google API client may not be properly installed.</p>";
            return;
        }
        
        // Try to load the autoloader
        echo "<h2>Autoloader Loading Test</h2>";
        $autoloadLoaded = false;
        foreach ($autoloadPaths as $path) {
            if (file_exists($path)) {
                require_once $path;
                $autoloadLoaded = true;
                echo "<p>✅ Successfully loaded autoloader from: " . htmlspecialchars($path) . "</p>";
                break;
            }
        }
        
        if (!$autoloadLoaded) {
            echo "<p>❌ Failed to load autoloader.</p>";
            return;
        }
        
        // Test if Google classes exist
        echo "<h2>Google Class Availability</h2>";
        
        // Check for client classes
        $clientClassExists = false;
        $clientClassName = '';
        if (class_exists('Google\Client')) {
            $clientClassExists = true;
            $clientClassName = 'Google\Client';
            echo "<p>✅ Google\Client class found</p>";
        } elseif (class_exists('Google_Client')) {
            $clientClassExists = true;
            $clientClassName = 'Google_Client';
            echo "<p>✅ Google_Client class found</p>";
        } else {
            echo "<p>❌ No Google client class found</p>";
        }
        
        // Check for calendar service classes
        $calendarClassExists = false;
        $calendarClassName = '';
        if (class_exists('Google\Service\Calendar')) {
            $calendarClassExists = true;
            $calendarClassName = 'Google\Service\Calendar';
            echo "<p>✅ Google\Service\Calendar class found</p>";
        } elseif (class_exists('Google_Service_Calendar')) {
            $calendarClassExists = true;
            $calendarClassName = 'Google_Service_Calendar';
            echo "<p>✅ Google_Service_Calendar class found</p>";
        } else {
            echo "<p>❌ No Google Calendar service class found</p>";
        }
        
        // Test Calendar service instantiation if classes exist
        echo "<h2>Calendar Service Test</h2>";
        if ($clientClassExists && $calendarClassExists) {
            try {
                // Instantiate client
                $client = new $clientClassName();
                echo "<p>✅ " . htmlspecialchars($clientClassName) . " instantiated successfully</p>";
                
                // Instantiate Calendar service
                $service = new $calendarClassName($client);
                echo "<p>✅ " . htmlspecialchars($calendarClassName) . " instantiated successfully</p>";
                
                echo "<p>✅ All Google API components are working correctly!</p>";
            } catch (Exception $e) {
                echo "<p>❌ Error instantiating Google services: " . htmlspecialchars($e->getMessage()) . "</p>";
            }
        } else {
            echo "<p>❌ Skipping instantiation test due to missing classes</p>";
        }
        
        echo "<h2>Next Steps</h2>";
        echo "<p>If all tests passed, the Google API client is properly installed.</p>";
        echo "<p>If some tests failed, you may need to:</p>";
        echo "<ol>";
        echo "<li>Reinstall the Google API client: <code>composer require google/apiclient:^2.12.1</code></li>";
        echo "<li>Check that your <code>client_secret.json</code> file is valid</li>";
        echo "<li>Authenticate with Google via the <a href='" . base_url('google_auth') . "'>Google Auth</a> page</li>";
        echo "</ol>";
    }
}