<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Debug_google_calendar_invitations extends MX_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('google_calendar');
        $this->load->model('doctor/doctor_model');
    }

    public function index() {
        echo "<h1>Debug Google Calendar Invitations</h1>";
        
        // Test if the library is loaded
        echo "<p>✅ Google Calendar library loaded successfully.</p>";
        
        // Test authentication status
        $is_authenticated = $this->google_calendar->is_authenticated();
        echo "<p>Admin Authentication Status: " . ($is_authenticated ? "✅ Authenticated" : "❌ Not Authenticated") . "</p>";
        
        if ($is_authenticated) {
            // Test getting doctor info
            $doctor_id = 1; // Test with first doctor
            $doctor_info = $this->doctor_model->getDoctorById($doctor_id);
            
            if ($doctor_info) {
                echo "<p>✅ Doctor info retrieved successfully.</p>";
                echo "<p>Doctor Name: " . htmlspecialchars($doctor_info->name) . "</p>";
                echo "<p>Doctor Google Calendar Email: " . htmlspecialchars($doctor_info->google_calendar_gmail) . "</p>";
                
                if (!empty($doctor_info->google_calendar_gmail)) {
                    echo "<p>✅ Doctor Google Calendar email found. Testing event creation with attendee...</p>";
                    
                    // Test creating an event with attendees
                    $attendees = array($doctor_info->google_calendar_gmail);
                    
                    $event_id = $this->google_calendar->add_event(
                        'Test Appointment with Attendee',
                        'This is a test appointment with attendee from the clinic system',
                        date('c'),
                        date('c', time() + 3600), // 1 hour from now
                        'Asia/Dhaka',
                        $attendees
                    );
                    
                    if ($event_id) {
                        echo "<p>✅ Event with attendee created successfully with ID: " . htmlspecialchars($event_id) . "</p>";
                        echo "<p>Check the doctor's Google Calendar email (" . htmlspecialchars($doctor_info->google_calendar_gmail) . ") for the invitation.</p>";
                    } else {
                        echo "<p>❌ Failed to create event with attendee</p>";
                        echo "<p>Check the error logs for more details.</p>";
                    }
                } else {
                    echo "<p>❌ Doctor Google Calendar email is empty. Cannot send invitation.</p>";
                    echo "<p>Please ensure the doctor has a valid Google Calendar email address in their profile.</p>";
                }
            } else {
                echo "<p>❌ Failed to retrieve doctor info</p>";
            }
        } else {
            echo "<p>Please authenticate with Google first:</p>";
            echo "<a href='" . base_url('google_auth') . "'>Authenticate with Google</a>";
        }
        
        echo "<h2>Debug Information</h2>";
        echo "<p>This test creates a Google Calendar event with a doctor as an attendee.</p>";
        echo "<p>If successful, the doctor should receive an email invitation from Google.</p>";
        echo "<p>If not, check:</p>";
        echo "<ol>";
        echo "<li>Doctor's Google Calendar email address is valid and correctly stored</li>";
        echo "<li>Admin's Google Calendar integration is properly configured</li>";
        echo "<li>Admin's Google account has permission to send invitations</li>";
        echo "<li>Check application logs for Google Calendar API errors</li>";
        echo "</ol>";
    }
    
    public function test_doctor_email($doctor_id = null) {
        if (!$doctor_id) {
            echo "<h1>Test Doctor Google Calendar Email Retrieval</h1>";
            echo "<p>Please provide a doctor ID. Example: " . base_url('debug_google_calendar_invitations/test_doctor_email/1') . "</p>";
            return;
        }
        
        echo "<h1>Test Doctor Google Calendar Email Retrieval for ID: " . $doctor_id . "</h1>";
        
        $doctor_info = $this->doctor_model->getDoctorById($doctor_id);
        
        if ($doctor_info) {
            echo "<p>✅ Doctor info retrieved successfully.</p>";
            echo "<pre>" . print_r($doctor_info, true) . "</pre>";
            
            if (!empty($doctor_info->google_calendar_gmail)) {
                echo "<p>✅ Doctor Google Calendar email found: " . htmlspecialchars($doctor_info->google_calendar_gmail) . "</p>";
            } else {
                echo "<p>❌ Doctor Google Calendar email is empty.</p>";
            }
        } else {
            echo "<p>❌ Failed to retrieve doctor info for ID: " . $doctor_id . "</p>";
        }
    }
}