# Google Calendar Invitation Troubleshooting Guide

## Problem: Doctor is not receiving Google Calendar invitations

## Common Causes and Solutions

### 1. Doctor's Google Calendar Email Address Issues

**Check if the doctor has a valid Google Calendar email address:**

1. Navigate to the doctor's profile in the admin panel
2. Verify that the `google_calendar_gmail` field is filled with a valid email address
3. Ensure the email address is correctly formatted (e.g., doctor@example.com)

**Test the doctor's email retrieval:**
```
Access: /test_doctor_email/index/{doctor_id}
```

### 2. Admin Google Calendar Authentication Issues

**Verify that the admin's Google Calendar is properly authenticated:**

1. Go to Google Calendar settings in the admin panel
2. Check if the connection status shows as "Connected"
3. If not connected, re-authenticate with Google

**Test the connection:**
```
Access: /debug_google_calendar_invitations
```

### 3. Google Calendar API Permission Issues

**Ensure the admin's Google account has proper permissions:**

1. Check that the Google Cloud project has the Calendar API enabled
2. Verify that the OAuth consent screen is properly configured
3. Make sure the application has the required scopes:
   - `https://www.googleapis.com/auth/calendar`

### 4. Event Creation Logging

**Check the application logs for event creation messages:**

Look for entries like:
```
INFO - Creating Google Calendar event: Appointment: John Doe with Dr. Smith
INFO - Added attendee: doctor@example.com
INFO - Google Calendar event created successfully with ID: xxxxxxxx
```

### 5. Email Validation

**The system now validates email addresses before adding them as attendees:**

- Invalid email formats are logged as errors
- Only valid email addresses are added as attendees

### 6. Debug Steps

1. **Test the debug controller:**
   ```
   Access: /debug_google_calendar_invitations
   ```

2. **Check application logs:**
   - Look in `application/logs/` for recent log files
   - Search for "Google Calendar" entries

3. **Verify doctor email:**
   ```
   Access: /test_doctor_email/index/{doctor_id}
   ```

4. **Manually test event creation:**
   - Create a test appointment
   - Check logs for success/failure messages

### 7. Common Fixes

#### Fix 1: Update Doctor Google Calendar Email
If the doctor's Google Calendar email is missing or invalid:
1. Go to the doctor management section
2. Edit the doctor's profile
3. Enter a valid Google Calendar email address in the `google_calendar_gmail` field
4. Save the changes

#### Fix 2: Re-authenticate Admin Google Calendar
If the admin authentication is expired:
1. Go to Google Calendar settings
2. Click "Disconnect Google Calendar"
3. Click "Connect Google Calendar"
4. Complete the OAuth flow

#### Fix 3: Check Google Cloud Project Settings
If there are API permission issues:
1. Go to Google Cloud Console
2. Select your project
3. Enable the Google Calendar API
4. Check OAuth consent screen settings
5. Verify the credentials are correct

### 8. Additional Debugging Information

#### Log Messages to Look For:

1. **Successful event creation:**
   ```
   INFO - Google Calendar event created successfully with ID: xxxxxxxx
   INFO - Event created with attendees: doctor@example.com
   ```

2. **Email validation errors:**
   ```
   ERROR - Invalid email format for attendee: invalid-email
   ```

3. **Authentication issues:**
   ```
   ERROR - Google Calendar client not loaded properly
   ```

#### Testing with the Debug Controller:

The debug controller provides:
- Doctor Google Calendar email validation
- Event creation testing
- Authentication status checking

Access it at: `/debug_google_calendar_invitations`

### 9. If the Problem Persists

1. **Check spam/junk folders** in the doctor's Google Calendar email account
2. **Verify Google Calendar settings** in the doctor's account:
   - Check invitation settings
   - Ensure automatic acceptance is not disabled
3. **Test with a different doctor** to isolate the issue
4. **Check Google Calendar API quotas** in the Google Cloud Console

### 10. Contact Support

If none of the above solutions work:
1. Provide the relevant log entries
2. Include the doctor's ID and Google Calendar email address
3. Describe the steps you've taken to troubleshoot
4. Include screenshots of the issue if possible

## Recent Improvements

The Google Calendar library has been enhanced with:
- Email validation for attendees
- Better logging of attendee information
- Improved error handling for event creation
- More detailed debug information

These improvements should help identify and resolve the invitation issue more quickly.

## Important Note

The system now uses the `google_calendar_gmail` field from the doctor table instead of the general `email` field for Google Calendar invitations. Make sure this field is properly populated with the doctor's Google account email address.