<div class="content-wrapper bg-light">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row my-2 pl-1">
                <div class="col-sm-6">
                    <h1 class="font-weight-bold">
                        <i class="fas fa-sms mr-2"></i>
                        <?php echo lang('sms_gateways') ?>
                    </h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="home"><?php echo lang('home') ?></a></li>
                        <li class="breadcrumb-item active"><?php echo lang('sms_gateways') ?></li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-7">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title"><?php echo lang('All the Sms Gateway names and related informations'); ?></h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table class="table table-bordered table-hover" id="editable-sample">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo lang('name'); ?></th>
                                        <th><?php echo lang('options'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $i = 0;
                                    foreach ($sgateways as $sgateway) {
                                        $i = $i + 1;
                                    ?>
                                        <tr class="">
                                            <td><?php echo $i; ?></td>
                                            <td><?php
                                                if (!empty($sgateway->name)) {
                                                    echo $sgateway->name;
                                                }
                                                ?></td>

                                            <td>
                                                <button class="btn btn-info btn-sm" data-toggle="modal" data-target="#smsSettingsModal" 
                                                        onclick="loadSmsSettings(<?php echo $sgateway->id; ?>, '<?php echo addslashes($sgateway->name); ?>')">
                                                    <i class="fa fa-cog"></i> <?php echo lang('manage'); ?>
                                                </button>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <div class="col-md-5">
                    <div class="card">
                        <div class="card-header">
                            <?php echo lang('select'); ?> <?php echo lang('sms_gateway'); ?>
                        </div>
                        <div class="card-body">
                            <form role="form" id="editAppointmentForm" action="settings/selectSmsGateway" class="clearfix" method="post" enctype="multipart/form-data">
                                <?php foreach ($sgateways as $sgateway) { ?>
                                    <div class="form-group">
                                        <div class="custom-control custom-radio">
                                            <input type="radio" class="custom-control-input" readonly="" name="sms_gateway" id="customRadio<?php echo $sgateway->id; ?>" value='<?php echo $sgateway->name; ?>' <?php
                                                                                                                                                                                                                if (!empty($sgateway->name)) {
                                                                                                                                                                                                                    if ($settings->sms_gateway == $sgateway->name) {
                                                                                                                                                                                                                        echo 'checked';
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                                ?>>
                                            <label class="custom-control-label" for="customRadio<?php echo $sgateway->id; ?>"><?php echo $sgateway->name; ?></label>
                                        </div>
                                    </div>
                                <?php } ?>
                                <input type="hidden" name="id" value="<?php echo $settings->id; ?>">
                                <div class="col-md-12">
                                    <button type="submit" name="submit" class="btn btn-info float-right"> <?php echo lang('submit'); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>

    <!-- /.content -->
</div>

<!-- SMS Settings Modal -->
<div class="modal fade" id="smsSettingsModal" tabindex="-1" role="dialog" aria-labelledby="smsSettingsModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="smsSettingsModalLabel">
                    <i class="fas fa-cog mr-2"></i><span id="gatewayName"></span> SMS Settings
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div id="modalContent">
                    <div class="text-center">
                        <i class="fas fa-spinner fa-spin fa-2x"></i>
                        <p class="mt-2">Loading settings...</p>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-info" id="saveSettingsBtn" onclick="saveSmsSettings()">
                    <i class="fas fa-save mr-1"></i>Save Changes
                </button>
            </div>
        </div>
    </div>
</div>

<script src="common/js/codearistos.min.js"></script>
<script src="common/extranal/js/sms/settings.js"></script>

<script>
function loadSmsSettings(gatewayId, gatewayName) {
    // Update modal title
    document.getElementById('gatewayName').textContent = gatewayName;
    
    // Show loading state
    document.getElementById('modalContent').innerHTML = `
        <div class="text-center">
            <i class="fas fa-spinner fa-spin fa-2x"></i>
            <p class="mt-2">Loading ${gatewayName} settings...</p>
        </div>
    `;
    
    // Fetch gateway settings via AJAX
    $.ajax({
        url: 'sms/getSettingsForModal',
        type: 'GET',
        data: { id: gatewayId },
        success: function(response) {
            document.getElementById('modalContent').innerHTML = response;
        },
        error: function() {
            document.getElementById('modalContent').innerHTML = `
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-triangle mr-2"></i>
                    Error loading settings. Please try again.
                </div>
            `;
        }
    });
}

function saveSmsSettings() {
    // Get form data
    var formData = new FormData(document.getElementById('smsSettingsForm'));
    
    // Show loading state on save button
    var saveBtn = document.getElementById('saveSettingsBtn');
    var originalText = saveBtn.innerHTML;
    saveBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-1"></i>Saving...';
    saveBtn.disabled = true;
    
    // Submit form via AJAX
    $.ajax({
        url: 'sms/addNewSettings',
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function(response) {
            // Show success message
            toastr.success('SMS settings updated successfully!');
            // Close modal
            $('#smsSettingsModal').modal('hide');
            // Reload page to refresh the list
            setTimeout(function() {
                location.reload();
            }, 1000);
        },
        error: function() {
            toastr.error('Error saving settings. Please try again.');
        },
        complete: function() {
            // Reset save button
            saveBtn.innerHTML = originalText;
            saveBtn.disabled = false;
        }
    });
}
</script>