<?php $doctor_details =  $this->db->get_where('doctor', array('id' => $doctorr))->row(); ?>
<div class="content-wrapper bg-light">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row my-2 pl-1">
                <div class="col-sm-6">
                    <h1 class="font-weight-bold"><i class="fas fa-calendar-alt mr-2"></i><?php echo lang('time_schedule'); ?> (<?php echo $doctor_details->name; ?>)</h1>
                </div>
                <div class="col-sm-6 text-right">
                    <?php if ($this->ion_auth->in_group(array('Doctor')) && isset($hospitals)) { ?>
                        <select class="form-control form-control-sm d-inline-block mb-2 mr-2" id="doctor_hospital_select" name="hospital_id" 
                                style="width: 250px; border: 2px solid #007bff;">
                            <option value="consolidated" <?php echo ($selected_hospital === 'consolidated') ? 'selected' : ''; ?>>
                                📊 All Hospitals Data
                            </option>
                            <?php foreach ($hospitals as $hospital) { ?>
                                <option value="<?php echo $hospital->id; ?>" 
                                        <?php echo ($selected_hospital == $hospital->id) ? 'selected' : ''; ?>>
                                    🏥 <?php echo $hospital->name; ?>
                                </option>
                            <?php } ?>
                        </select>
                    <?php } ?>
                    <ol class="breadcrumb float-sm-right bg-transparent mb-0">
                        <li class="breadcrumb-item"><a href="home"><?php echo lang('home') ?></a></li>
                        <li class="breadcrumb-item active"><?php echo lang('time_schedule'); ?></li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <?php if ($this->session->flashdata('feedback')) { ?>
                <div class="alert <?php echo $this->session->flashdata('feedback_class'); ?> alert-dismissible fade show" role="alert">
                    <?php echo $this->session->flashdata('feedback'); ?>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            <?php } ?>
            
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header bg-white">
                            <ul class="nav nav-tabs card-header-tabs" id="doctorScheduleTabs" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active" id="weekday-tab" data-toggle="tab" href="#weekday-schedule" role="tab">
                                        <i class="fas fa-calendar-week mr-2"></i><?php echo lang('weekday_wise_schedule'); ?>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="date-tab" data-toggle="tab" href="#date-schedule" role="tab">
                                        <i class="fas fa-calendar-day mr-2"></i><?php echo lang('date_wise_schedule'); ?>
                                    </a>
                                </li>
                            </ul>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <div class="tab-content" id="scheduleTabContent">
                                <!-- Weekday Schedule Tab -->
                                <div class="tab-pane fade show active" id="weekday-schedule" role="tabpanel">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <h5 class="font-weight-bold mb-0"><?php echo lang('weekday_wise_schedule'); ?></h5>
                                        <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#myModal">
                                            <i class="fa fa-plus mr-2"></i><?php echo lang('add'); ?> <?php echo lang('schedule'); ?>
                                        </button>
                                    </div>
                            <table class="table table-bordered table-hover" id="editable-sample">
                                <thead>
                                    <tr>
                                        <th> # </th>
                                        <th><i class="fas fa-hospital mr-1"></i><?php echo lang('hospital'); ?></th>
                                        <th> <?php echo lang('weekday'); ?></th>
                                        <th> <?php echo lang('start_time'); ?></th>
                                        <th> <?php echo lang('end_time'); ?></th>
                                        <th> <?php echo lang('duration'); ?></th>
                                        <th> <?php echo lang('options'); ?></th>

                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $i = 0;
                                    foreach ($schedules as $schedule) {
                                        if ($this->settings->time_format == 24) {
                                            $schedule->s_time = $this->settings_model->convert_to_24h($schedule->s_time);
                                            $schedule->e_time = $this->settings_model->convert_to_24h($schedule->e_time);
                                        }
                                        $i = $i + 1; ?>
                                        <tr class="">
                                            <td> <?php echo $i; ?></td>
                                            <td>
                                                <span class="badge badge-primary">
                                                    🏥 <?php echo $this->db->get_where('hospital', array('id' => $schedule->hospital_id))->row()->name; ?>
                                                </span>
                                            </td>
                                            <td> <?php echo $schedule->weekday; ?></td>
                                            <td><?php echo $schedule->s_time; ?></td>
                                            <td><?php echo $schedule->e_time; ?></td>
                                            <td><?php echo $schedule->duration * 5 . ' ' . lang('minitues'); ?></td>
                                            <td>
                                                <a class="btn btn-danger btn-sm btn_width delete_button" href="schedule/deleteSchedule?id=<?php echo $schedule->id; ?>&doctor=<?php echo $doctorr; ?>&weekday=<?php echo $schedule->weekday; ?>" onclick="return confirm('Are you sure you want to delete this item?');"><i class="fa fa-trash"> </i> <?php echo lang(''); ?></a>
                                            </td>
                                        </tr>
                                    <?php
                                    } ?>
                                </tbody>
                            </table>
                        </div>
                        
                        <!-- Date Schedule Tab -->
                        <div class="tab-pane fade" id="date-schedule" role="tabpanel">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h5 class="font-weight-bold mb-0"><?php echo lang('date_wise_schedule'); ?></h5>
                                <button class="btn btn-primary btn-sm" data-toggle="modal" data-target="#dateModal">
                                    <i class="fa fa-plus"></i> <?php echo lang('add_new'); ?> <?php echo lang('date_wise_schedule'); ?>
                                </button>
                            </div>
                            <table class="table table-bordered table-hover" id="date-table" width="100%">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><i class="fas fa-hospital mr-1"></i><?php echo lang('hospital'); ?></th>
                                        <th><?php echo lang('date'); ?></th>
                                        <th><?php echo lang('start_time'); ?></th>
                                        <th><?php echo lang('end_time'); ?></th>
                                        <th><?php echo lang('duration'); ?></th>
                                        <th><?php echo lang('options'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $i = 0;
                                    if (!empty($date_schedules)) {
                                        foreach ($date_schedules as $schedule) {
                                            if ($this->settings->time_format == 24) {
                                                $start_time = $this->settings_model->convert_to_24h($schedule->s_time);
                                                $end_time = $this->settings_model->convert_to_24h($schedule->e_time);
                                            } else {
                                                $start_time = $schedule->s_time;
                                                $end_time = $schedule->e_time;
                                            }
                                            $i++;
                                    ?>
                                    <tr>
                                        <td><?php echo $i; ?></td>
                                        <td>
                                            <span class="badge badge-primary">
                                                🏥 <?php echo $this->db->get_where('hospital', array('id' => $schedule->hospital_id))->row()->name; ?>
                                            </span>
                                        </td>
                                        <td>
                                            <span class="badge badge-primary">
                                                <?php 
                                                if (isset($schedule->schedule_date) && !empty($schedule->schedule_date)) {
                                                    echo date('M d, Y', strtotime($schedule->schedule_date));
                                                } else {
                                                    echo $schedule->date_of_month;
                                                    $suffix = 'th';
                                                    if ($schedule->date_of_month == 1 || $schedule->date_of_month == 21 || $schedule->date_of_month == 31) $suffix = 'st';
                                                    elseif ($schedule->date_of_month == 2 || $schedule->date_of_month == 22) $suffix = 'nd';
                                                    elseif ($schedule->date_of_month == 3 || $schedule->date_of_month == 23) $suffix = 'rd';
                                                    echo $suffix;
                                                }
                                                ?>
                                            </span>
                                        </td>
                                        <td><?php echo $start_time; ?></td>
                                        <td><?php echo $end_time; ?></td>
                                        <td><?php echo $schedule->duration * 5; ?> <?php echo lang('minutes'); ?></td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <button type="button" class="btn btn-info btn-sm editDateScheduleBtn" 
                                                    data-id="<?php echo $schedule->id; ?>"
                                                    data-date="<?php echo isset($schedule->schedule_date) && !empty($schedule->schedule_date) ? $schedule->schedule_date : $schedule->date_of_month; ?>"
                                                    data-start="<?php echo $schedule->s_time; ?>"
                                                    data-end="<?php echo $schedule->e_time; ?>"
                                                    data-duration="<?php echo $schedule->duration; ?>"
                                                    data-toggle="modal" data-target="#editDateModal">
                                                    <i class="fa fa-edit"></i>
                                                </button>
                                                <a href="schedule/deleteSchedule?id=<?php echo $schedule->id; ?>&doctor=<?php echo $doctorr; ?>&weekday=&all=all" 
                                                   class="btn btn-danger btn-sm"
                                                   onclick="return confirm('<?php echo lang('are_you_sure'); ?>')">
                                                    <i class="fa fa-trash"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php } } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>

    <!-- /.content -->
</div>




<!--main content end-->
<!--footer start-->




<!-- Add Time Slot Modal-->
<div class="modal fade" id="myModal" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title font-weight-bold"> <?php echo lang('add'); ?> <?php echo lang('schedule'); ?></h4>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            <div class="modal-body">
                <form role="form" action="schedule/addSchedule" method="post" enctype="multipart/form-data">
                    <div class="row">
                        <?php if ($this->ion_auth->in_group(array('Doctor')) && isset($hospitals)) { ?>
                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted">
                                    <i class="fas fa-hospital mr-2"></i><?php echo lang('hospital'); ?> <span class="text-danger">*</span>
                                </label>
                                <select class="form-control form-control-lg shadow-sm" id="timeschedule_hospital_id" name="schedule_hospital_id" required>
                                    <?php foreach ($hospitals as $hospital) { ?>
                                        <option value="<?php echo $hospital->id; ?>" 
                                                <?php echo ($selected_hospital == $hospital->id) ? 'selected' : ''; ?>>
                                            🏥 <?php echo $hospital->name; ?>
                                        </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <?php } ?>

                   <div class="col-md-6 mb-4">
                            <div class="form-group">
                        <label for="exampleInputEmail1"> <?php echo lang('doctor'); ?> &ast;</label>
                        <select class="form-control col-sm-9 m-bot15 js-example-basic-single" name="doctor" id="doctorchoose" value='' required="">
                            <?php if (!empty($doctor_details)) { ?>
                                <option value="<?php echo $doctor_details->id; ?>" selected="selected"><?php echo $doctor_details->name; ?> - <?php echo $doctor_details->id; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                        </div>

                       <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('weekday'); ?>
                                    <span class="text-danger">*</span></label>
                                <select class="form-control form-control-lg shadow-sm" id="weekday" name="weekday"
                                    required="">
                                    <option value="Friday"><?php echo lang('friday') ?></option>
                                    <option value="Saturday"><?php echo lang('saturday') ?></option>
                                    <option value="Sunday"><?php echo lang('sunday') ?></option>
                                    <option value="Monday"><?php echo lang('monday') ?></option>
                                    <option value="Tuesday"><?php echo lang('tuesday') ?></option>
                                    <option value="Wednesday"><?php echo lang('wednesday') ?></option>
                                    <option value="Thursday"><?php echo lang('thursday') ?></option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('start_time'); ?>
                                    <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="text"
                                        class="form-control form-control-lg shadow-sm timepicker-default1" name="s_time"
                                        id="s_time" required="" autocomplete="off">
                                    <div class="input-group-append">
                                    <a type="button" class="btn btn-default" class="input-group-text"><i class="fa fa-clock" style="padding-top:6px;"></i></a>
                                        <!-- <span class="input-group-text"><i class="fa fa-clock"></i></span> -->
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('end_time'); ?>
                                    <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="text"
                                        class="form-control form-control-lg shadow-sm timepicker-default1" name="e_time"
                                        id="e_time" required="" autocomplete="off">
                                    <div class="input-group-append">
                                        <!-- <span class="input-group-text"><i class="fa fa-clock"></i></span> -->
                                        <a type="button" class="btn btn-default" class="input-group-text"><i class="fa fa-clock" style="padding-top:6px;"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>




                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('appointment') ?>
                                    <?php echo lang('duration') ?> <span class="text-danger">*</span></label>
                                <select class="form-control form-control-lg shadow-sm" name="duration" required="">
                                    <option value="1">5 Minutes</option>
                                    <option value="2">10 Minutes</option>
                                    <option value="3">15 Minutes</option>
                                    <option value="4">20 Minutes</option>
                                    <option value="6">30 Minutes</option>
                                    <option value="9">45 Minutes</option>
                                    <option value="12">60 Minutes</option>
                                </select>
                            </div>
                        </div>

                    <input type="hidden" name="doctor" value='<?php echo $doctorr; ?>'>
                    <input type="hidden" name="redirect" value='schedule/timeSchedule?doctor=<?php echo $doctorr; ?>'>
                    <input type="hidden" name="id" value=''>
                    <input type="hidden" name="schedule_type" value="weekday">
                    <div class="form-group col-md-12">
                        <button type="submit" name="submit" class="btn btn-info float-right"> <?php echo lang('submit'); ?></button>
                    </div>
                    </div>
                </form>

            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>
<!-- Add Time Slot Modal-->





<!-- Edit Time Slot Modal-->
<div class="modal fade" id="myModal2" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title font-weight-bold"><i class="fa fa-plus-circle"></i> <?php echo lang('edit'); ?> <?php echo lang('time_slot'); ?></h4>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            <div class="modal-body">
                <form role="form" id="editTimeSlotForm" action="schedule/addSchedule" method="post" enctype="multipart/form-data">
                    <div class="form-group">
                        <label for="exampleInputEmail1"> <?php echo lang('start_time'); ?></label>
                        <div class="input-group bootstrap-timepicker col-sm-9">
                            <input type="text" class="form-control timepicker-default" name="s_time">
                            <span class="input-group-btn">
                                <button class="btn btn-default" type="button"><i class="fa fa-clock-o"></i></button>
                            </span>
                        </div>

                    </div>
                    <div class="form-group bootstrap-timepicker d-flex">
                        <label for="exampleInputEmail1"> <?php echo lang('end_time'); ?></label>
                        <div class="input-group bootstrap-timepicker col-sm-9">
                            <input type="text" class="form-control timepicker-default" name="e_time" value=''>
                            <span class="input-group-btn">
                                <button class="btn btn-default" type="button"><i class="fa fa-clock-o"></i></button>
                            </span>
                        </div>
                    </div>
                    <div class="form-group bootstrap-timepicker d-flex">
                        <label for="exampleInputEmail1"> <?php echo lang('weekday'); ?></label>
                        <div class="input-group bootstrap-timepicker col-sm-9">
                            <select class="form-control form-control-lg m-bot15" id="weekday" name="weekday" value=''>
                                <option value="Friday"><?php echo lang('friday') ?></option>
                                <option value="Saturday"><?php echo lang('saturday') ?></option>
                                <option value="Sunday"><?php echo lang('sunday') ?></option>
                                <option value="Monday"><?php echo lang('monday') ?></option>
                                <option value="Tuesday"><?php echo lang('tuesday') ?></option>
                                <option value="Wednesday"><?php echo lang('wednesday') ?></option>
                                <option value="Thursday"><?php echo lang('thursday') ?></option>
                            </select>

                        </div>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"> <?php echo lang('appointment') ?> <?php echo lang('duration') ?> </label>
                        <select class="form-control form-control-lg m-bot15" name="duration" value=''>

                            <option value="1" <?php
                                                if (!empty($settings->duration)) {
                                                    if ($settings->duration == '1') {
                                                        echo 'selected';
                                                    }
                                                }
                                                ?>> 5 Minitues </option>

                            <option value="2" <?php
                                                if (!empty($settings->duration)) {
                                                    if ($settings->duration == '2') {
                                                        echo 'selected';
                                                    }
                                                }
                                                ?>> 10 Minitues </option>


                            <option value="3" <?php
                                                if (!empty($settings->duration)) {
                                                    if ($settings->duration == '3') {
                                                        echo 'selected';
                                                    }
                                                }
                                                ?>> 15 Minitues </option>

                            <option value="4" <?php
                                                if (!empty($settings->duration)) {
                                                    if ($settings->duration == '4') {
                                                        echo 'selected';
                                                    }
                                                }
                                                ?>> 20 Minitues </option>

                            <option value="6" <?php
                                                if (!empty($settings->duration)) {
                                                    if ($settings->duration == '6') {
                                                        echo 'selected';
                                                    }
                                                }
                                                ?>> 30 Minitues </option>

                            <option value="9" <?php
                                                if (!empty($settings->duration)) {
                                                    if ($settings->duration == '9') {
                                                        echo 'selected';
                                                    }
                                                }
                                                ?>> 45 Minitues </option>

                            <option value="12" <?php
                                                if (!empty($settings->duration)) {
                                                    if ($settings->duration == '12') {
                                                        echo 'selected';
                                                    }
                                                }
                                                ?>> 60 Minitues </option>

                        </select>
                    </div>

                    <input type="hidden" name="doctor" value="<?php echo $doctorr; ?>">
                    <input type="hidden" name="redirect" value='schedule/timeSchedule'>
                    <input type="hidden" name="id" value=''>
                    <button type="submit" name="submit" class="btn btn-info float-right"> <?php echo lang('submit'); ?></button>
                </form>

            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>

<!-- Add Date Schedule Modal -->
<div class="modal fade" id="dateModal" tabindex="-1" role="dialog" aria-labelledby="dateModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title font-weight-bold"><?php echo lang('add'); ?> <?php echo lang('date_wise_schedule'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form role="form" action="schedule/addSchedule" method="post">
                    <div class="row">
                        <?php if ($this->ion_auth->in_group(array('Doctor')) && isset($hospitals)) { ?>
                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted">
                                    <i class="fas fa-hospital mr-2"></i><?php echo lang('hospital'); ?> <span class="text-danger">*</span>
                                </label>
                                <select class="form-control form-control-lg shadow-sm" id="time_date_schedule_hospital_id" name="schedule_hospital_id" required>
                                    <?php foreach ($hospitals as $hospital) { ?>
                                        <option value="<?php echo $hospital->id; ?>" 
                                                <?php echo ($selected_hospital == $hospital->id) ? 'selected' : ''; ?>>
                                            🏥 <?php echo $hospital->name; ?>
                                        </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <?php } ?>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('date'); ?>
                                    <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="date" class="form-control form-control-lg shadow-sm" name="schedule_date" required="" autocomplete="off">
                                    <div class="input-group-append">
                                        <a type="button" class="btn btn-default" class="input-group-text"><i class="fa fa-calendar" style="padding-top:6px;"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('duration'); ?> (<?php echo lang('minutes'); ?>)
                                    <span class="text-danger">*</span></label>
                                <select class="form-control form-control-lg shadow-sm" name="duration" required="">
                                    <option value="">Select Duration</option>
                                    <option value="1">5 Minutes</option>
                                    <option value="2">10 Minutes</option>
                                    <option value="3">15 Minutes</option>
                                    <option value="4">20 Minutes</option>
                                    <option value="6">30 Minutes</option>
                                    <option value="9">45 Minutes</option>
                                    <option value="12">60 Minutes</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('start_time'); ?>
                                    <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="text"
                                        class="form-control form-control-lg shadow-sm timepicker-default1" name="s_time"
                                        required="" autocomplete="off">
                                    <div class="input-group-append">
                                        <a type="button" class="btn btn-default" class="input-group-text"><i class="fa fa-clock" style="padding-top:6px;"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('end_time'); ?>
                                    <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="text"
                                        class="form-control form-control-lg shadow-sm timepicker-default1" name="e_time"
                                        required="" autocomplete="off">
                                    <div class="input-group-append">
                                        <a type="button" class="btn btn-default" class="input-group-text"><i class="fa fa-clock" style="padding-top:6px;"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <input type="hidden" name="redirect" value="schedule/timeSchedule?doctor=<?php echo $doctorr; ?>">
                    <input type="hidden" name="id" value="">
                    <input type="hidden" name="schedule_type" value="date">
                    <input type="hidden" name="weekday" value="">
                    <input type="hidden" name="doctor" value="<?php echo $doctorr; ?>">
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo lang('close'); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo lang('save'); ?> <?php echo lang('schedule'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Edit Date Schedule Modal -->
<div class="modal fade" id="editDateModal" tabindex="-1" role="dialog" aria-labelledby="editDateModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title font-weight-bold"><?php echo lang('edit'); ?> <?php echo lang('date_wise_schedule'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form role="form" action="schedule/addSchedule" method="post" id="editDateScheduleForm">
                    <input type="hidden" name="id" id="edit_date_schedule_id">
                    <div class="row">
                        <?php if ($this->ion_auth->in_group(array('Doctor')) && isset($hospitals)) { ?>
                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted">
                                    <i class="fas fa-hospital mr-2"></i><?php echo lang('hospital'); ?> <span class="text-danger">*</span>
                                </label>
                                <select class="form-control form-control-lg shadow-sm" id="edit_time_date_schedule_hospital_id" name="schedule_hospital_id" required>
                                    <?php foreach ($hospitals as $hospital) { ?>
                                        <option value="<?php echo $hospital->id; ?>" 
                                                <?php echo ($selected_hospital == $hospital->id) ? 'selected' : ''; ?>>
                                            🏥 <?php echo $hospital->name; ?>
                                        </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <?php } ?>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('date'); ?>
                                    <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="date" class="form-control form-control-lg shadow-sm" name="schedule_date" id="edit_time_schedule_date" required="" autocomplete="off">
                                    <div class="input-group-append">
                                        <a type="button" class="btn btn-default" class="input-group-text"><i class="fa fa-calendar" style="padding-top:6px;"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('duration'); ?> (<?php echo lang('minutes'); ?>)
                                    <span class="text-danger">*</span></label>
                                <select class="form-control form-control-lg shadow-sm" name="duration" id="edit_duration" required="">
                                    <option value="">Select Duration</option>
                                    <option value="1">5 Minutes</option>
                                    <option value="2">10 Minutes</option>
                                    <option value="3">15 Minutes</option>
                                    <option value="4">20 Minutes</option>
                                    <option value="6">30 Minutes</option>
                                    <option value="9">45 Minutes</option>
                                    <option value="12">60 Minutes</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('start_time'); ?>
                                    <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="text"
                                        class="form-control form-control-lg shadow-sm timepicker-default1" name="s_time" id="edit_start_time"
                                        required="" autocomplete="off">
                                    <div class="input-group-append">
                                        <a type="button" class="btn btn-default" class="input-group-text"><i class="fa fa-clock" style="padding-top:6px;"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('end_time'); ?>
                                    <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="text"
                                        class="form-control form-control-lg shadow-sm timepicker-default1" name="e_time" id="edit_end_time"
                                        required="" autocomplete="off">
                                    <div class="input-group-append">
                                        <a type="button" class="btn btn-default" class="input-group-text"><i class="fa fa-clock" style="padding-top:6px;"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <input type="hidden" name="redirect" value="schedule/timeSchedule?doctor=<?php echo $doctorr; ?>">
                    <input type="hidden" name="schedule_type" value="date">
                    <input type="hidden" name="weekday" value="">
                    <input type="hidden" name="doctor" value="<?php echo $doctorr; ?>">
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo lang('close'); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo lang('update'); ?> <?php echo lang('schedule'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script src="common/js/codearistos.min.js"></script>
<script type="text/javascript">
    var select_doctor = "<?php echo lang('select_doctor'); ?>";
</script>
<script type="text/javascript">
    var select_patient = "<?php echo lang('select_patient'); ?>";
</script>
<script type="text/javascript">
    var language = "<?php echo $this->language; ?>";
</script>
<script type="text/javascript">
    var time_format = "<?php echo $this->settings->time_format; ?>";
</script>
<script src="common/extranal/js/schedule/timeschedule.js"></script>

<script>
$(document).ready(function() {
    // Check if DataTable is already initialized for weekday table
    if (!$.fn.DataTable.isDataTable('#editable-sample')) {
        $('#editable-sample').DataTable({
            "responsive": true,
            "autoWidth": false,
        });
    }
    
    // Initialize DataTable for date table (only if it exists and not already initialized)
    if ($('#date-table').length && !$.fn.DataTable.isDataTable('#date-table')) {
        $('#date-table').DataTable({
            "responsive": true,
            "autoWidth": false,
        });
    }

    // Fix timepicker for date schedule modals
    $('#dateModal, #editDateModal').on('shown.bs.modal', function() {
        // Re-initialize timepickers when modal is shown to ensure proper configuration
        $(this).find('.timepicker-default1').timepicker('destroy').timepicker({
            defaultTime: false, // Don't set a default time
            minuteStep: 15,
            timeFormat: time_format,
            showMeridian: (time_format == 12)
        });
    });

    // Handle edit date schedule button click
    $('.editDateScheduleBtn').click(function() {
        var id = $(this).data('id');
        var date = $(this).data('date');
        var start = $(this).data('start');
        var end = $(this).data('end');
        var duration = $(this).data('duration');

        // Populate the edit modal form
        $('#edit_date_schedule_id').val(id);
        
        // Check if date is a full date (YYYY-MM-DD) or just day of month
        if (date && date.toString().includes('-')) {
            // It's a full date, use it directly
            $('#edit_time_schedule_date').val(date);
        } else if (date && !isNaN(date)) {
            // It's just a day of month, create a date for current month
            var today = new Date();
            var year = today.getFullYear();
            var month = String(today.getMonth() + 1).padStart(2, '0');
            var day = String(date).padStart(2, '0');
            var formattedDate = year + '-' + month + '-' + day;
            $('#edit_time_schedule_date').val(formattedDate);
        }
        
        $('#edit_start_time').val(start);
        $('#edit_end_time').val(end);
        $('#edit_duration').val(duration);
    });
});
</script>

<?php if ($this->ion_auth->in_group(array('Doctor')) && isset($hospitals)) { ?> 
<script>
$(document).ready(function() {
    // Doctor hospital selection dropdown change handler
    $('#doctor_hospital_select').change(function() {
        const selectedHospital = $(this).val();
        
        // Build URL with hospital parameter
        let url = '<?php echo base_url(); ?>schedule/timeSchedule';
        if (selectedHospital) {
            url += '?hospital_id=' + selectedHospital;
        }
        
        // Show loading feedback
        $(this).next('.loading-feedback').remove();
        $(this).after('<div class="loading-feedback ml-2"><i class="fas fa-spinner fa-spin mr-2"></i>Loading hospital schedule data...</div>');
        
        // Redirect to reload page with selected hospital
        window.location.href = url;
    });
});
</script>
<?php } ?>