<div class="content-wrapper bg-gradient-light" style="min-height: 2726.9px;">
    <section class="content-header py-4 bg-white shadow-sm">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h1 class="display-4 font-weight-black mb-0">
                        <i class="fas fa-calendar-alt text-primary mr-3"></i>
                        <?php echo lang('schedule'); ?>
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb bg-transparent mb-0">
                            <li class="breadcrumb-item"><a href="home"><?php echo lang('home'); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo lang('schedule'); ?></li>
                        </ol>
                    </nav>
                </div>
                <div class="col-sm-6 text-right">
                    <a data-toggle="modal" href="#myModal" class="btn btn-primary btn-sm px-4 py-3">
                        <i class="fa fa-plus"></i> <?php echo lang('add_new'); ?> <?php echo lang('schedule'); ?>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <section class="content py-5">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card shadow-lg border-0">
                        <div class="card-header bg-white">
                            <ul class="nav nav-tabs card-header-tabs" id="scheduleTabs" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active" id="weekday-tab" data-toggle="tab" href="#weekday-schedule" role="tab">
                                        <i class="fas fa-calendar-week mr-2"></i><?php echo lang('weekday_wise_schedule'); ?>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="date-tab" data-toggle="tab" href="#date-schedule" role="tab">
                                        <i class="fas fa-calendar-day mr-2"></i><?php echo lang('date_wise_schedule'); ?>
                                    </a>
                                </li>
                            </ul>
                        </div>
                        <div class="card-body bg-light p-4">
                            <div class="tab-content" id="scheduleTabContent">
                                <!-- Weekday Schedule Tab -->
                                <div class="tab-pane fade show active" id="weekday-schedule" role="tabpanel">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <h5 class="font-weight-bold mb-0"><?php echo lang('weekday_wise_schedule'); ?></h5>
                                        <button class="btn btn-primary btn-sm" data-toggle="modal" data-target="#myModal">
                                            <i class="fa fa-plus"></i> <?php echo lang('add_new'); ?> <?php echo lang('schedule'); ?>
                                        </button>
                                    </div>
                                    <table class="table table-hover datatables" id="weekday-table" width="100%">
                                <thead>
                                    <tr class="bg-light">
                                        <th class="font-weight-bold text-uppercase">#</th>
                                        <th class="font-weight-bold"><?php echo lang('doctor'); ?></th>
                                        <th class="font-weight-bold"><i class="fas fa-hospital mr-1"></i><?php echo lang('hospital'); ?></th>
                                        <th class="font-weight-bold"><?php echo lang('weekday'); ?></th>
                                        <th class="font-weight-bold"><?php echo lang('start_time'); ?></th>
                                        <th class="font-weight-bold"><?php echo lang('end_time'); ?></th>
                                        <th class="font-weight-bold"><?php echo lang('duration'); ?></th>
                                        <?php if ($this->ion_auth->in_group(array('admin', 'Doctor'))) { ?>
                                        <th class="font-weight-bold"><?php echo lang('options'); ?></th>
                                        <?php } ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $i = 0;
                                    foreach ($schedules as $schedule) {
                                        if ($this->settings->time_format == 24) {
                                            $schedule->s_time = $this->settings_model->convert_to_24h($schedule->s_time);
                                            $schedule->e_time = $this->settings_model->convert_to_24h($schedule->e_time);
                                        }
                                        $i = $i + 1;
                                    ?>
                                    <tr>
                                        <td><?php echo $i; ?></td>
                                        <td><?php echo $this->doctor_model->getDoctorById($schedule->doctor)->name; ?>
                                        </td>
                                        <td>
                                            <span class="badge badge-primary">
                                                🏥 <?php echo $this->db->get_where('hospital', array('id' => $schedule->hospital_id))->row()->name; ?>
                                            </span>
                                        </td>
                                        <td><?php echo $schedule->weekday; ?></td>
                                        <td><?php echo $schedule->s_time; ?></td>
                                        <td><?php echo $schedule->e_time; ?></td>
                                        <td><?php echo $schedule->duration * 5 . ' ' . lang('minitues'); ?></td>
                                        <?php if ($this->ion_auth->in_group(array('admin', 'Doctor'))) { ?>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <button type="button" class="btn btn-outline-primary btn-sm editWeekdayScheduleBtn" 
                                                    data-id="<?php echo $schedule->id; ?>"
                                                    data-doctor="<?php echo $schedule->doctor; ?>"
                                                    data-weekday="<?php echo $schedule->weekday; ?>"
                                                    data-start="<?php echo $schedule->s_time; ?>"
                                                    data-end="<?php echo $schedule->e_time; ?>"
                                                    data-duration="<?php echo $schedule->duration; ?>"
                                                    <?php if (isset($schedule->hospital_id)) { ?>
                                                    data-hospital="<?php echo $schedule->hospital_id; ?>"
                                                    <?php } ?>
                                                    data-toggle="modal" data-target="#editWeekdayModal">
                                                    <i class="fa fa-edit"></i>
                                                </button>
                                                <a class="btn btn-outline-danger btn-sm"
                                                    href="schedule/deleteSchedule?id=<?php echo $schedule->id; ?>&doctor=<?php echo $schedule->doctor; ?>&weekday=<?php echo $schedule->weekday; ?>&all=all"
                                                    onclick="return confirm('Are you sure you want to delete this item?');">
                                                    <i class="fa fa-trash"></i>
                                                </a>
                                            </div>
                                        </td>
                                        <?php } ?>
                                    </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                        
                        <!-- Date Schedule Tab -->
                        <div class="tab-pane fade" id="date-schedule" role="tabpanel">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h5 class="font-weight-bold mb-0"><?php echo lang('date_wise_schedule'); ?></h5>
                                <button class="btn btn-primary btn-sm" data-toggle="modal" data-target="#dateModal">
                                    <i class="fa fa-plus"></i> <?php echo lang('add_new'); ?> <?php echo lang('date_wise_schedule'); ?>
                                </button>
                            </div>
                            <table class="table table-hover datatables" id="date-table" width="100%">
                                <thead>
                                    <tr class="bg-light">
                                        <th class="font-weight-bold text-uppercase">#</th>
                                        <th class="font-weight-bold"><?php echo lang('doctor'); ?></th>
                                        <th class="font-weight-bold"><i class="fas fa-hospital mr-1"></i><?php echo lang('hospital'); ?></th>
                                        <th class="font-weight-bold"><?php echo lang('date'); ?></th>
                                        <th class="font-weight-bold"><?php echo lang('start_time'); ?></th>
                                        <th class="font-weight-bold"><?php echo lang('end_time'); ?></th>
                                        <th class="font-weight-bold"><?php echo lang('duration'); ?></th>
                                        <?php if ($this->ion_auth->in_group(array('admin', 'Doctor'))) { ?>
                                        <th class="font-weight-bold"><?php echo lang('options'); ?></th>
                                        <?php } ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $i = 0;
                                    if (!empty($date_schedules)) {
                                        foreach ($date_schedules as $schedule) {
                                            // DEBUG: Let's see what values we're getting
                                            echo "<!-- DEBUG: Schedule ID: " . $schedule->id . " -->";
                                            echo "<!-- DEBUG: s_time: " . $schedule->s_time . " -->";
                                            echo "<!-- DEBUG: e_time: " . $schedule->e_time . " -->";
                                            echo "<!-- DEBUG: duration: " . $schedule->duration . " -->";
                                            echo "<!-- DEBUG: schedule_type: " . (isset($schedule->schedule_type) ? $schedule->schedule_type : 'NULL') . " -->";
                                            
                                            if ($this->settings->time_format == 24) {
                                                $start_time = $this->settings_model->convert_to_24h($schedule->s_time);
                                                $end_time = $this->settings_model->convert_to_24h($schedule->e_time);
                                            } else {
                                                $start_time = $schedule->s_time;
                                                $end_time = $schedule->e_time;
                                            }
                                            $i++;
                                    ?>
                                    <tr>
                                        <td><?php echo $i; ?></td>
                                        <td><?php echo $schedule->doctor_name; ?></td>
                                        <td>
                                            <span class="badge badge-primary">
                                                🏥 <?php echo $this->db->get_where('hospital', array('id' => $schedule->hospital_id))->row()->name; ?>
                                            </span>
                                        </td>
                                        <td>
                                            <span class="badge badge-primary">
                                                <?php 
                                                if (isset($schedule->schedule_date) && !empty($schedule->schedule_date)) {
                                                    echo date('M d, Y', strtotime($schedule->schedule_date));
                                                } else {
                                                    echo $schedule->date_of_month;
                                                    $suffix = 'th';
                                                    if ($schedule->date_of_month == 1 || $schedule->date_of_month == 21 || $schedule->date_of_month == 31) $suffix = 'st';
                                                    elseif ($schedule->date_of_month == 2 || $schedule->date_of_month == 22) $suffix = 'nd';
                                                    elseif ($schedule->date_of_month == 3 || $schedule->date_of_month == 23) $suffix = 'rd';
                                                    echo $suffix;
                                                }
                                                ?>
                                            </span>
                                        </td>
                                        <td><?php echo $start_time; ?></td>
                                        <td><?php echo $end_time; ?></td>
                                        <td><?php echo $schedule->duration * 5; ?> <?php echo lang('minutes'); ?></td>
                                        <?php if ($this->ion_auth->in_group(array('admin', 'Doctor'))) { ?>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <button type="button" class="btn btn-outline-primary btn-sm editDateScheduleBtn" 
                                                    data-id="<?php echo $schedule->id; ?>"
                                                    data-doctor="<?php echo $schedule->doctor_id; ?>"
                                                    data-date="<?php echo isset($schedule->schedule_date) && !empty($schedule->schedule_date) ? $schedule->schedule_date : $schedule->date_of_month; ?>"
                                                    data-start="<?php echo $schedule->s_time; ?>"
                                                    data-end="<?php echo $schedule->e_time; ?>"
                                                    data-duration="<?php echo $schedule->duration; ?>"
                                                    data-toggle="modal" data-target="#editDateModal">
                                                    <i class="fa fa-edit"></i>
                                                </button>
                                                <a href="schedule/deleteSchedule?id=<?php echo $schedule->id; ?>&doctor=<?php echo $schedule->doctor_id; ?>&weekday=&all=all" 
                                                   class="btn btn-outline-danger btn-sm"
                                                   onclick="return confirm('<?php echo lang('are_you_sure'); ?>')">
                                                    <i class="fa fa-trash"></i>
                                                </a>
                                            </div>
                                        </td>
                                        <?php } ?>
                                    </tr>
                                    <?php } } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
</div>

<!-- Add Schedule Modal -->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title font-weight-bold"><?php echo lang('add'); ?> <?php echo lang('schedule'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form role="form" action="schedule/addSchedule" method="post" enctype="multipart/form-data">
                    <div class="row">
                        <?php if ($this->ion_auth->in_group(array('Doctor')) && isset($hospitals)) { ?>
                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted">
                                    <i class="fas fa-hospital mr-2"></i><?php echo lang('hospital'); ?> <span class="text-danger">*</span>
                                </label>
                                <select class="form-control form-control-lg shadow-sm" id="schedule_hospital_id" name="schedule_hospital_id" required>
                                    <?php foreach ($hospitals as $hospital) { ?>
                                        <option value="<?php echo $hospital->id; ?>" 
                                                <?php echo ($selected_hospital == $hospital->id) ? 'selected' : ''; ?>>
                                            🏥 <?php echo $hospital->name; ?>
                                        </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <?php } ?>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('doctor'); ?>
                                    <span class="text-danger">*</span></label>
                                <select class="form-control form-control-lg shadow-sm" id="doctorchoose" name="doctor"
                                    required="">
                                    <?php if (!empty($prescription->doctor)) { ?>
                                    <option value="<?php echo $doctors->id; ?>" selected="selected">
                                        <?php echo $doctors->name; ?> - <?php echo $doctors->id; ?></option>
                                    <?php } ?>
                                    <?php
                                    if (!empty($setval)) {
                                        $doctordetails1 = $this->db->get_where('doctor', array('id' => set_value('doctor')))->row();
                                    ?>
                                    <option value="<?php echo $doctordetails1->id; ?>" selected="selected">
                                        <?php echo $doctordetails1->name; ?> - <?php echo $doctordetails1->id; ?>
                                    </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('weekday'); ?>
                                    <span class="text-danger">*</span></label>
                                <select class="form-control form-control-lg shadow-sm" id="weekday" name="weekday"
                                    required="">
                                    <option value="Friday"><?php echo lang('friday') ?></option>
                                    <option value="Saturday"><?php echo lang('saturday') ?></option>
                                    <option value="Sunday"><?php echo lang('sunday') ?></option>
                                    <option value="Monday"><?php echo lang('monday') ?></option>
                                    <option value="Tuesday"><?php echo lang('tuesday') ?></option>
                                    <option value="Wednesday"><?php echo lang('wednesday') ?></option>
                                    <option value="Thursday"><?php echo lang('thursday') ?></option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('start_time'); ?>
                                    <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="text"
                                        class="form-control form-control-lg shadow-sm timepicker-default1" name="s_time"
                                        id="s_time" required="" autocomplete="off">
                                    <div class="input-group-append">
                                    <a type="button" class="btn btn-default" class="input-group-text"><i class="fa fa-clock" style="padding-top:6px;"></i></a>
                                        <!-- <span class="input-group-text"><i class="fa fa-clock"></i></span> -->
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('end_time'); ?>
                                    <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="text"
                                        class="form-control form-control-lg shadow-sm timepicker-default1" name="e_time"
                                        id="e_time" required="" autocomplete="off">
                                    <div class="input-group-append">
                                        <!-- <span class="input-group-text"><i class="fa fa-clock"></i></span> -->
                                        <a type="button" class="btn btn-default" class="input-group-text"><i class="fa fa-clock" style="padding-top:6px;"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>




                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('appointment') ?>
                                    <?php echo lang('duration') ?> <span class="text-danger">*</span></label>
                                <select class="form-control form-control-lg shadow-sm" name="duration" required="">
                                    <option value="1">5 Minutes</option>
                                    <option value="2">10 Minutes</option>
                                    <option value="3">15 Minutes</option>
                                    <option value="4">20 Minutes</option>
                                    <option value="6">30 Minutes</option>
                                    <option value="9">45 Minutes</option>
                                    <option value="12">60 Minutes</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <input type="hidden" name="redirect" value="schedule">
                            <input type="hidden" name="id" value="">
                            <input type="hidden" name="schedule_type" value="weekday">
                            <button type="submit"
                                class="btn btn-primary float-right"><?php echo lang('submit'); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Add Date Schedule Modal -->
<div class="modal fade" id="dateModal" tabindex="-1" role="dialog" aria-labelledby="dateModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title font-weight-bold"><?php echo lang('add'); ?> <?php echo lang('date_wise_schedule'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form role="form" action="schedule/addSchedule" method="post" id="dateScheduleForm">
                    <div class="row">
                        <?php if ($this->ion_auth->in_group(array('Doctor')) && isset($hospitals)) { ?>
                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted">
                                    <i class="fas fa-hospital mr-2"></i><?php echo lang('hospital'); ?> <span class="text-danger">*</span>
                                </label>
                                <select class="form-control form-control-lg shadow-sm" id="date_schedule_hospital_id" name="schedule_hospital_id" required>
                                    <?php foreach ($hospitals as $hospital) { ?>
                                        <option value="<?php echo $hospital->id; ?>" 
                                                <?php echo ($selected_hospital == $hospital->id) ? 'selected' : ''; ?>>
                                            🏥 <?php echo $hospital->name; ?>
                                        </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <?php } ?>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('doctor'); ?>
                                    <span class="text-danger">*</span></label>
                                <select class="form-control form-control-lg shadow-sm" name="doctor" required="">
                                    <option value=""><?php echo lang('select_doctor'); ?></option>
                                    <?php foreach ($doctors as $doctor) { ?>
                                        <option value="<?php echo $doctor->id; ?>">
                                            <?php echo $doctor->name; ?> - <?php echo $doctor->id; ?>
                                        </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('date'); ?>
                                    <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="date" class="form-control form-control-lg shadow-sm" name="schedule_date" required="" autocomplete="off">
                                    <div class="input-group-append">
                                        <a type="button" class="btn btn-default" class="input-group-text"><i class="fa fa-calendar" style="padding-top:6px;"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('start_time'); ?>
                                    <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="text"
                                        class="form-control form-control-lg shadow-sm timepicker-default1" name="s_time"
                                        required="" autocomplete="off">
                                    <div class="input-group-append">
                                        <a type="button" class="btn btn-default" class="input-group-text"><i class="fa fa-clock" style="padding-top:6px;"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('end_time'); ?>
                                    <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="text"
                                        class="form-control form-control-lg shadow-sm timepicker-default1" name="e_time"
                                        required="" autocomplete="off">
                                    <div class="input-group-append">
                                        <a type="button" class="btn btn-default" class="input-group-text"><i class="fa fa-clock" style="padding-top:6px;"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-12 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('duration'); ?> (<?php echo lang('minutes'); ?>)
                                    <span class="text-danger">*</span></label>
                                <select class="form-control form-control-lg shadow-sm" name="duration" required="">
                                    <option value="">Select Duration</option>
                                    <option value="1">5 Minutes</option>
                                    <option value="2">10 Minutes</option>
                                    <option value="3">15 Minutes</option>
                                    <option value="4">20 Minutes</option>
                                    <option value="6">30 Minutes</option>
                                    <option value="9">45 Minutes</option>
                                    <option value="12">60 Minutes</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <input type="hidden" name="redirect" value="schedule">
                            <input type="hidden" name="id" value="">
                            <input type="hidden" name="schedule_type" value="date">
                            <input type="hidden" name="weekday" value="">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo lang('close'); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo lang('save'); ?> <?php echo lang('schedule'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Edit Weekday Schedule Modal -->
<div class="modal fade" id="editWeekdayModal" tabindex="-1" role="dialog" aria-labelledby="editWeekdayModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title font-weight-bold"><?php echo lang('edit'); ?> <?php echo lang('weekday_wise_schedule'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form role="form" action="schedule/addSchedule" method="post" id="editWeekdayScheduleForm">
                    <input type="hidden" name="id" id="edit_weekday_schedule_id">
                    <div class="row">
                        <?php if ($this->ion_auth->in_group(array('Doctor')) && isset($hospitals)) { ?>
                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted">
                                    <i class="fas fa-hospital mr-2"></i><?php echo lang('hospital'); ?> <span class="text-danger">*</span>
                                </label>
                                <select class="form-control form-control-lg shadow-sm" id="edit_weekday_schedule_hospital_id" name="schedule_hospital_id" required>
                                    <?php foreach ($hospitals as $hospital) { ?>
                                        <option value="<?php echo $hospital->id; ?>" 
                                                <?php echo ($selected_hospital == $hospital->id) ? 'selected' : ''; ?>>
                                            🏥 <?php echo $hospital->name; ?>
                                        </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <?php } ?>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('doctor'); ?>
                                    <span class="text-danger">*</span></label>
                                <select class="form-control form-control-lg shadow-sm" name="doctor" id="edit_weekday_doctor" required="">
                                    <option value=""><?php echo lang('select_doctor'); ?></option>
                                    <?php foreach ($doctors as $doctor) { ?>
                                        <option value="<?php echo $doctor->id; ?>">
                                            <?php echo $doctor->name; ?> - <?php echo $doctor->id; ?>
                                        </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('weekday'); ?>
                                    <span class="text-danger">*</span></label>
                                <select class="form-control form-control-lg shadow-sm" id="edit_weekday" name="weekday" required="">
                                    <option value="Friday"><?php echo lang('friday') ?></option>
                                    <option value="Saturday"><?php echo lang('saturday') ?></option>
                                    <option value="Sunday"><?php echo lang('sunday') ?></option>
                                    <option value="Monday"><?php echo lang('monday') ?></option>
                                    <option value="Tuesday"><?php echo lang('tuesday') ?></option>
                                    <option value="Wednesday"><?php echo lang('wednesday') ?></option>
                                    <option value="Thursday"><?php echo lang('thursday') ?></option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('start_time'); ?>
                                    <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="text"
                                        class="form-control form-control-lg shadow-sm timepicker-default1" name="s_time" id="edit_weekday_start_time"
                                        required="" autocomplete="off">
                                    <div class="input-group-append">
                                        <a type="button" class="btn btn-default" class="input-group-text"><i class="fa fa-clock" style="padding-top:6px;"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('end_time'); ?>
                                    <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="text"
                                        class="form-control form-control-lg shadow-sm timepicker-default1" name="e_time" id="edit_weekday_end_time"
                                        required="" autocomplete="off">
                                    <div class="input-group-append">
                                        <a type="button" class="btn btn-default" class="input-group-text"><i class="fa fa-clock" style="padding-top:6px;"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('appointment') ?>
                                    <?php echo lang('duration') ?> <span class="text-danger">*</span></label>
                                <select class="form-control form-control-lg shadow-sm" name="duration" id="edit_weekday_duration" required="">
                                    <option value="1">5 Minutes</option>
                                    <option value="2">10 Minutes</option>
                                    <option value="3">15 Minutes</option>
                                    <option value="4">20 Minutes</option>
                                    <option value="6">30 Minutes</option>
                                    <option value="9">45 Minutes</option>
                                    <option value="12">60 Minutes</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <input type="hidden" name="redirect" value="schedule">
                            <input type="hidden" name="schedule_type" value="weekday">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo lang('close'); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo lang('update'); ?> <?php echo lang('schedule'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Edit Date Schedule Modal -->
<div class="modal fade" id="editDateModal" tabindex="-1" role="dialog" aria-labelledby="editDateModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title font-weight-bold"><?php echo lang('edit'); ?> <?php echo lang('date_wise_schedule'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form role="form" action="schedule/addSchedule" method="post" id="editDateScheduleForm">
                    <input type="hidden" name="id" id="edit_date_schedule_id">
                    <div class="row">
                        <?php if ($this->ion_auth->in_group(array('Doctor')) && isset($hospitals)) { ?>
                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted">
                                    <i class="fas fa-hospital mr-2"></i><?php echo lang('hospital'); ?> <span class="text-danger">*</span>
                                </label>
                                <select class="form-control form-control-lg shadow-sm" id="edit_date_schedule_hospital_id" name="schedule_hospital_id" required>
                                    <?php foreach ($hospitals as $hospital) { ?>
                                        <option value="<?php echo $hospital->id; ?>" 
                                                <?php echo ($selected_hospital == $hospital->id) ? 'selected' : ''; ?>>
                                            🏥 <?php echo $hospital->name; ?>
                                        </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <?php } ?>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('doctor'); ?>
                                    <span class="text-danger">*</span></label>
                                <select class="form-control form-control-lg shadow-sm" name="doctor" id="edit_doctor" required="">
                                    <option value=""><?php echo lang('select_doctor'); ?></option>
                                    <?php foreach ($doctors as $doctor) { ?>
                                        <option value="<?php echo $doctor->id; ?>">
                                            <?php echo $doctor->name; ?> - <?php echo $doctor->id; ?>
                                        </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('date'); ?>
                                    <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="date" class="form-control form-control-lg shadow-sm" name="schedule_date" id="edit_schedule_date" required="" autocomplete="off">
                                    <div class="input-group-append">
                                        <a type="button" class="btn btn-default" class="input-group-text"><i class="fa fa-calendar" style="padding-top:6px;"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('start_time'); ?>
                                    <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="text"
                                        class="form-control form-control-lg shadow-sm timepicker-default1" name="s_time" id="edit_start_time"
                                        required="" autocomplete="off">
                                    <div class="input-group-append">
                                        <a type="button" class="btn btn-default" class="input-group-text"><i class="fa fa-clock" style="padding-top:6px;"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('end_time'); ?>
                                    <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="text"
                                        class="form-control form-control-lg shadow-sm timepicker-default1" name="e_time" id="edit_end_time"
                                        required="" autocomplete="off">
                                    <div class="input-group-append">
                                        <a type="button" class="btn btn-default" class="input-group-text"><i class="fa fa-clock" style="padding-top:6px;"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-12 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('duration'); ?> (<?php echo lang('minutes'); ?>)
                                    <span class="text-danger">*</span></label>
                                <select class="form-control form-control-lg shadow-sm" name="duration" id="edit_duration" required="">
                                    <option value="">Select Duration</option>
                                    <option value="1">5 Minutes</option>
                                    <option value="2">10 Minutes</option>
                                    <option value="3">15 Minutes</option>
                                    <option value="4">20 Minutes</option>
                                    <option value="6">30 Minutes</option>
                                    <option value="9">45 Minutes</option>
                                    <option value="12">60 Minutes</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="col-md-12">
                            <input type="hidden" name="redirect" value="schedule">
                            <input type="hidden" name="schedule_type" value="date">
                            <input type="hidden" name="weekday" value="">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo lang('close'); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo lang('update'); ?> <?php echo lang('schedule'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script src="common/js/codearistos.min.js"></script>
<script type="text/javascript">
var select_doctor = "<?php echo lang('select_doctor'); ?>";
var select_patient = "<?php echo lang('select_patient'); ?>";
var language = "<?php echo $this->language; ?>";
var time_format = "<?php echo $this->settings->time_format; ?>";
</script>
<script src="common/extranal/js/schedule/schedule.js"></script>

<script>
$(document).ready(function() {
    // Initialize separate DataTables for each tab
    $('#weekday-table').DataTable({
        "responsive": true,
        "autoWidth": false,
    });
    
    $('#date-table').DataTable({
        "responsive": true,
        "autoWidth": false,
    });

    // Handle edit weekday schedule button click
    $('.editWeekdayScheduleBtn').click(function() {
        var id = $(this).data('id');
        var doctor = $(this).data('doctor');
        var weekday = $(this).data('weekday');
        var start = $(this).data('start');
        var end = $(this).data('end');
        var duration = $(this).data('duration');
        var hospital = $(this).data('hospital');

        // Populate the edit modal form
        $('#edit_weekday_schedule_id').val(id);
        $('#edit_weekday_doctor').val(doctor);
        $('#edit_weekday').val(weekday);
        $('#edit_weekday_start_time').val(start);
        $('#edit_weekday_end_time').val(end);
        $('#edit_weekday_duration').val(duration);
        
        // Set hospital if available
        if (hospital) {
            $('#edit_weekday_schedule_hospital_id').val(hospital);
        }
    });

    // Handle edit date schedule button click
    $('.editDateScheduleBtn').click(function() {
        var id = $(this).data('id');
        var doctor = $(this).data('doctor');
        var date = $(this).data('date');
        var start = $(this).data('start');
        var end = $(this).data('end');
        var duration = $(this).data('duration');

        // Populate the edit modal form
        $('#edit_date_schedule_id').val(id);
        $('#edit_doctor').val(doctor);
        
        // Check if date is a full date (YYYY-MM-DD) or just day of month
        if (date && date.toString().includes('-')) {
            // It's a full date, use it directly
            $('#edit_schedule_date').val(date);
        } else if (date && !isNaN(date)) {
            // It's just a day of month, create a date for current month
            var today = new Date();
            var year = today.getFullYear();
            var month = String(today.getMonth() + 1).padStart(2, '0');
            var day = String(date).padStart(2, '0');
            var formattedDate = year + '-' + month + '-' + day;
            $('#edit_schedule_date').val(formattedDate);
        }
        
        $('#edit_start_time').val(start);
        $('#edit_end_time').val(end);
        $('#edit_duration').val(duration);
    });

    // Fix timepicker for all schedule modals
    $('#dateModal, #editDateModal, #editWeekdayModal').on('shown.bs.modal', function() {
        // Re-initialize timepickers when modal is shown to ensure proper configuration
        $(this).find('.timepicker-default1').timepicker('destroy').timepicker({
            defaultTime: false, // Don't set a default time
            minuteStep: 15,
            timeFormat: time_format,
            showMeridian: (time_format == 12)
        });
    });


});
</script>