<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Report extends MX_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('report_model');
        $this->load->model('doctor/doctor_model');
        $this->load->model('patient/patient_model');
        if (!$this->ion_auth->in_group(array('admin', 'Nurse', 'Doctor', 'Laboratorist', 'Patient'))) {
            redirect('home/permission');
        }
    }

    public function index()
    {
        if ($this->ion_auth->in_group('Patient')) {
            redirect('home/permission');
        }
        $data['reports'] = $this->report_model->getReport();
        $this->load->view('home/dashboard');
        $this->load->view('birth_report', $data);
        $this->load->view('home/footer');
    }

    function birth()
    {
        if ($this->ion_auth->in_group('Patient')) {
            redirect('home/permission');
        }
        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        $type = 'birth';
        $data['patients'] = $this->patient_model->getPatient();
        $data['doctors'] = $this->doctor_model->getDoctor();
        $data['reports'] = $this->report_model->getReportByType($type);
        $this->load->view('home/dashboard');
        $this->load->view('birth_report', $data);
        $this->load->view('home/footer');
    }

    function operation()
    {
        if ($this->ion_auth->in_group('Patient')) {
            redirect('home/permission');
        }
        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        $type = 'operation';
        $data['patients'] = $this->patient_model->getPatient();
        $data['doctors'] = $this->doctor_model->getDoctor();
        $data['reports'] = $this->report_model->getReportByType($type);
        $this->load->view('home/dashboard');
        $this->load->view('operation_report', $data);
        $this->load->view('home/footer');
    }

    function expire()
    {
        if ($this->ion_auth->in_group('Patient')) {
            redirect('home/permission');
        }
        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        $type = 'expire';
        $data['patients'] = $this->patient_model->getPatient();
        $data['doctors'] = $this->doctor_model->getDoctor();
        $data['reports'] = $this->report_model->getReportByType($type);
        $this->load->view('home/dashboard');
        $this->load->view('expire_report', $data);
        $this->load->view('home/footer');
    }

    public function addReportView()
    {
        if ($this->ion_auth->in_group('Patient')) {
            redirect('home/permission');
        }
        $data = array();
        $data['doctors'] = $this->doctor_model->getDoctor();
        $data['patients'] = $this->patient_model->getPatient();
        $this->load->view('home/dashboard');
        $this->load->view('add_report', $data);
        $this->load->view('home/footer');
    }

    public function addReport()
    {
        if ($this->ion_auth->in_group('Patient')) {
            redirect('home/permission');
        }
        $id = $this->input->post('id');
        $type = $this->input->post('type');
        $description = $this->input->post('description');
        $patient = $this->input->post('patient');
        $doctor = $this->input->post('doctor');
        $date = $this->input->post('date');
        if ((empty($id))) {
            $add_date = date('m/d/y');
        } else {
            $add_date = $this->db->get_where('report', array('id' => $id))->row()->add_date;
        }
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        // Validating Name Field
        $this->form_validation->set_rules('type', 'Type', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        // Validating Category Field
        $this->form_validation->set_rules('description', 'Description', 'trim|required|min_length[1]|max_length[1000]|xss_clean');
        // Validating Price Field
        $this->form_validation->set_rules('patient', 'Patient', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        // Validating Generic Name Field
        $this->form_validation->set_rules('doctor', 'Doctor', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        // Validating Company Name Field
        $this->form_validation->set_rules('date', 'Date', 'trim|required|min_length[1]|max_length[100]|xss_clean');


        if ($this->form_validation->run() == FALSE) {
            if (!empty($id)) {
                show_swal(lang('validation_error'), 'error', lang('error'));
                redirect('report/editReport?id' . $id);
            } else {
                $data = array();
                $data['setval'] = 'setval';
                $data['doctors'] = $this->doctor_model->getDoctor();
                $data['patients'] = $this->patient_model->getPatient();
                $this->load->view('home/dashboard');
                $this->load->view('add_report', $data);
                $this->load->view('home/footer');
            }
        } else {
            $data = array();
            $data = array(
                'report_type' => $type,
                'description' => $description,
                'patient' => $patient,
                'doctor' => $doctor,
                'date' => $date,
                'add_date' => $add_date
            );
            if (empty($id)) {
                $this->report_model->insertReport($data);
                show_swal(lang('report') . ' ' . lang('added'), 'success', lang('added'));
            } else {
                $this->report_model->updateReport($id, $data);
                show_swal(lang('report') . ' ' . lang('updated'), 'success', lang('updated'));
            }
            if ($type == 'birth') {
                redirect('report/birth');
            } elseif ($type == 'operation') {
                redirect('report/operation');
            } else {
                redirect('report/expire');
            }
        }
    }

    function editReport()
    {
        if ($this->ion_auth->in_group('Patient')) {
            redirect('home/permission');
        }
        $data = array();
        $data['doctors'] = $this->doctor_model->getDoctor();
        $data['patients'] = $this->patient_model->getPatient();
        $id = $this->input->get('id');
        $data['report'] = $this->report_model->getReportById($id);
        $this->load->view('home/dashboard');
        $this->load->view('add_report', $data);
        $this->load->view('home/footer');
    }

    function editReportByJason()
    {
        $id = $this->input->get('id');
        $data['report'] = $this->report_model->getReportById($id);
        $doctor = $data['report']->doctor;
        $data['doctor'] = $this->doctor_model->getDoctorById($doctor);
        $patient = $data['report']->patient;
        $data['patient'] = $this->patient_model->getPatientById($patient);
        echo json_encode($data);
    }

    function myReport()
    {
        if ($this->ion_auth->in_group('Patient')) {
            $data = array();
            $id = $this->ion_auth->get_user_id();
            $data['report'] = $this->report_model->getReportById($id);
        }
    }

    function myreports()
    {
        if ($this->ion_auth->in_group(array('Patient'))) {
            $user_id = $this->ion_auth->user()->row()->id;
            $patient_id = $this->db->get_where('patient', array('ion_user_id' => $user_id))->row()->id;
            
            // Hospital selection logic
            $selected_hospital = $this->input->get('hospital_id');
            $data['hospitals'] = $this->db->get('hospital')->result();
            
            // Set default hospital if none selected
            if (empty($selected_hospital)) {
                $current_hospital_id = $this->session->userdata('hospital_id');
                if (empty($current_hospital_id)) {
                    $patient_data = $this->db->get_where('patient', array('ion_user_id' => $user_id))->row();
                    $current_hospital_id = $patient_data->hospital_id;
                    $this->session->set_userdata('hospital_id', $current_hospital_id);
                }
                $selected_hospital = $current_hospital_id;
            }
            $data['selected_hospital'] = $selected_hospital;
            
            // Set hospital context and get data
            if ($selected_hospital === 'consolidated') {
                $this->session->unset_userdata('hospital_id');
                $data['reports'] = $this->getConsolidatedReportsByPatient($patient_id);
            } else {
                $this->session->set_userdata('hospital_id', $selected_hospital);
                $data['reports'] = $this->report_model->getReport();
            }
            
            $data['user_id'] = $user_id;
            $data['patient_id'] = $patient_id;
        } else {
            $data['reports'] = $this->report_model->getReport();
            $data['user_id'] = $this->ion_auth->user()->row()->id;
        }
        
        $this->load->view('home/dashboard');
        $this->load->view('myreports', $data);
        $this->load->view('home/footer');
    }

    function delete()
    {
        if ($this->ion_auth->in_group('Patient')) {
            redirect('home/permission');
        }
        $id = $this->input->get('id');
        $type = $this->report_model->getReportById($id)->report_type;
        $this->report_model->deleteReport($id);
        show_swal(lang('report') . ' ' . lang('deleted'), 'warning', lang('deleted'));
        if ($type == 'birth') {
            redirect('report/birth');
        } elseif ($type == 'operation') {
            redirect('report/operation');
        } else {
            redirect('report/expire');
        }
    }
    // Consolidated helper function for patient reports
    private function getConsolidatedReportsByPatient($patient_id)
    {
        try {
            $this->db->select('report.*, hospital.name as hospital_name');
            $this->db->from('report');
            $this->db->join('hospital', 'report.hospital_id = hospital.id', 'left');
            $this->db->where('report.patient', $patient_id);
            $this->db->order_by('report.date', 'desc');
            return $this->db->get()->result();
        } catch (Exception $e) {
            log_message('error', 'Error fetching consolidated reports by patient: ' . $e->getMessage());
            return array();
        }
    }
}

/* End of file report.php */
/* Location: ./application/modules/report/controllers/re.phportp */
