<!--sidebar end-->
<!--main content start-->
<div class="content-wrapper bg-light">
    <section class="content-header py-4 bg-white shadow-sm">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h1 class="display-4 font-weight-black mb-0">
                        <i class="fas fa-clock text-primary mr-3"></i>
                        My Queue Status
                    </h1>
                    <p class="text-muted mb-0">
                        <i class="fas fa-calendar mr-2"></i><?php echo date('l, F j, Y', strtotime($selected_date)); ?>
                    </p>
                </div>
                <div class="col-sm-6 text-right">
                    <button onclick="refreshQueue()" class="btn btn-primary btn-sm">
                        <i class="fas fa-sync-alt mr-2"></i>Refresh
                    </button>
                    <a href="patient/medicalHistory" class="btn btn-secondary btn-sm ml-2">
                        <i class="fas fa-arrow-left mr-2"></i>Back to Dashboard
                    </a>
                </div>
            </div>
        </div>
    </section>

    <section class="content py-4">
        <div class="container-fluid">
            <?php if (empty($patient_appointments)): ?>
                <!-- No appointments today -->
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body text-center py-5">
                                <i class="fas fa-calendar-times fa-4x text-muted mb-4"></i>
                                <h3 class="text-muted">No Appointments Today</h3>
                                <p class="text-muted">You don't have any appointments scheduled for today.</p>
                                <a href="appointment" class="btn btn-primary">
                                    <i class="fas fa-plus mr-2"></i>Book an Appointment
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            <?php else: ?>
                <!-- Show queues for each doctor -->
                <?php foreach ($queue_data as $doctor_id => $queue_info): ?>
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header bg-primary text-white">
                                    <div class="row align-items-center">
                                        <div class="col-md-8">
                                            <h5 class="mb-0">
                                                <i class="fas fa-user-md mr-2"></i>
                                                Dr. <?php echo $queue_info['doctor_name']; ?>
                                                <?php if ($queue_info['department_name']): ?>
                                                    <small class="ml-2">- <?php echo $queue_info['department_name']; ?></small>
                                                <?php endif; ?>
                                            </h5>
                                        </div>
                                        <div class="col-md-4 text-right">
                                            <span class="badge badge-light">
                                                <i class="fas fa-clock mr-1"></i>
                                                Scheduled: <?php echo date('h:i A', strtotime($queue_info['appointment']->time)); ?>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                
                                <?php if ($queue_info['patient_position']): ?>
                                    <!-- Patient's position info -->
                                    <div class="card-body">
                                        <div class="row mb-4">
                                            <div class="col-md-4">
                                                <div class="text-center p-4 bg-primary text-white rounded">
                                                    <h2 class="mb-1">
                                                        #<?php echo $queue_info['patient_position']->queue_number; ?>
                                                    </h2>
                                                    <p class="mb-0">Your Queue Number</p>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="text-center p-4 bg-warning text-white rounded">
                                                    <h2 class="mb-1">
                                                        <?php echo $queue_info['patient_position']->position_in_queue + 1; ?>
                                                    </h2>
                                                    <p class="mb-0">Your Position</p>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="text-center p-4 <?php echo getStatusCard($queue_info['patient_position']->queue_status); ?> text-white rounded">
                                                    <h4 class="mb-1">
                                                        <i class="<?php echo getStatusIcon($queue_info['patient_position']->queue_status); ?> mr-2"></i>
                                                        <?php echo ucfirst(str_replace('_', ' ', $queue_info['patient_position']->queue_status)); ?>
                                                    </h4>
                                                    <p class="mb-0">Current Status</p>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Status-specific messages -->
                                        <?php if ($queue_info['patient_position']->queue_status == 'waiting'): ?>
                                            <?php if ($queue_info['patient_position']->position_in_queue == 0): ?>
                                                <div class="alert alert-info">
                                                    <i class="fas fa-info-circle mr-2"></i>
                                                    <strong>You're next!</strong> Please be ready, the doctor will call you soon.
                                                </div>
                                            <?php elseif ($queue_info['patient_position']->position_in_queue <= 2): ?>
                                                <div class="alert alert-warning">
                                                    <i class="fas fa-clock mr-2"></i>
                                                    <strong>Almost your turn!</strong> There are <?php echo $queue_info['patient_position']->position_in_queue; ?> patient(s) ahead of you.
                                                </div>
                                            <?php else: ?>
                                                <div class="alert alert-secondary">
                                                    <i class="fas fa-users mr-2"></i>
                                                    You have <?php echo $queue_info['patient_position']->position_in_queue; ?> patient(s) ahead of you. Please wait comfortably.
                                                </div>
                                            <?php endif; ?>
                                        <?php elseif ($queue_info['patient_position']->queue_status == 'in_progress'): ?>
                                            <div class="alert alert-success">
                                                <i class="fas fa-user-md mr-2"></i>
                                                <strong>Your consultation is in progress!</strong> Please follow the doctor's instructions.
                                            </div>
                                        <?php elseif ($queue_info['patient_position']->queue_status == 'treated'): ?>
                                            <div class="alert alert-success">
                                                <i class="fas fa-check-circle mr-2"></i>
                                                <strong>Consultation completed!</strong> Thank you for visiting.
                                            </div>
                                        <?php endif; ?>

                                        <!-- Queue list -->
                                        <h6 class="mb-3">
                                            <i class="fas fa-list mr-2"></i>Today's Queue
                                        </h6>
                                        <div class="table-responsive">
                                            <table class="table table-sm">
                                                <thead class="thead-light">
                                                    <tr>
                                                        <th>Queue #</th>
                                                        <th>Patient</th>
                                                        <th>Status</th>
                                                        <th>Time</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php foreach ($queue_info['queue'] as $queue_item): ?>
                                                        <tr class="<?php 
                                                            if ($queue_item->patient_id == $patient_id) {
                                                                echo 'table-primary font-weight-bold';
                                                            } elseif ($queue_item->queue_status == 'treated') {
                                                                echo 'table-success';
                                                            } elseif ($queue_item->queue_status == 'in_progress') {
                                                                echo 'table-warning';
                                                            }
                                                        ?>">
                                                            <td>
                                                                <span class="badge badge-primary">
                                                                    #<?php echo $queue_item->queue_number; ?>
                                                                </span>
                                                                <?php if ($queue_item->patient_id == $patient_id): ?>
                                                                    <i class="fas fa-arrow-left text-primary ml-2" title="This is you"></i>
                                                                <?php endif; ?>
                                                            </td>
                                                            <td>
                                                                <?php if ($queue_item->patient_id == $patient_id): ?>
                                                                    <strong>You</strong>
                                                                <?php else: ?>
                                                                    Patient #<?php echo $queue_item->queue_number; ?>
                                                                <?php endif; ?>
                                                            </td>
                                                            <td>
                                                                <span class="badge <?php echo getStatusBadgeClass($queue_item->queue_status); ?>">
                                                                    <?php echo ucfirst(str_replace('_', ' ', $queue_item->queue_status)); ?>
                                                                </span>
                                                            </td>
                                                            <td>
                                                                <?php echo date('h:i A', strtotime($queue_item->time)); ?>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <!-- No queue position found -->
                                    <div class="card-body">
                                        <div class="alert alert-warning">
                                            <i class="fas fa-exclamation-triangle mr-2"></i>
                                            <strong>Queue not yet generated</strong> - Please check back later or contact reception.
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </section>
</div>

<!-- Auto-refresh notification -->
<div id="refresh-notification" class="alert alert-info alert-dismissible" style="position: fixed; top: 20px; right: 20px; z-index: 9999; display: none;">
    <button type="button" class="close" data-dismiss="alert">&times;</button>
    <i class="fas fa-sync-alt mr-2"></i>Queue status updated
</div>

<script>
let refreshInterval;

$(document).ready(function() {
    // Auto-refresh every 45 seconds
    refreshInterval = setInterval(refreshQueue, 45000);
});

function refreshQueue() {
    // Reload the page to get fresh data
    window.location.reload();
}

// Clear interval when leaving page
$(window).on('beforeunload', function() {
    if (refreshInterval) {
        clearInterval(refreshInterval);
    }
});

// Add sound notification for status changes (optional)
function playNotificationSound() {
    if ('speechSynthesis' in window) {
        // Simple text-to-speech notification
        const msg = new SpeechSynthesisUtterance('Your queue status has been updated');
        msg.volume = 0.3;
        msg.rate = 1;
        speechSynthesis.speak(msg);
    }
}
</script>

<?php
function getStatusCard($status) {
    switch ($status) {
        case 'waiting': return 'bg-warning';
        case 'in_progress': return 'bg-success';
        case 'treated': return 'bg-success';
        case 'missed': return 'bg-danger';
        default: return 'bg-secondary';
    }
}

function getStatusIcon($status) {
    switch ($status) {
        case 'waiting': return 'fas fa-clock';
        case 'in_progress': return 'fas fa-user-md';
        case 'treated': return 'fas fa-check-circle';
        case 'missed': return 'fas fa-times-circle';
        default: return 'fas fa-question-circle';
    }
}

function getStatusBadgeClass($status) {
    switch ($status) {
        case 'waiting': return 'badge-warning';
        case 'in_progress': return 'badge-primary';
        case 'treated': return 'badge-success';
        case 'missed': return 'badge-danger';
        default: return 'badge-secondary';
    }
}
?>

<style>
.card {
    border-radius: 0.75rem;
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
}

.card-header {
    border-radius: 0.75rem 0.75rem 0 0 !important;
}

/* Enhanced badge styling for better contrast */
.badge {
    color: #fff !important;
    font-weight: 500;
    text-shadow: 0 1px 2px rgba(0, 0, 0, 0.2);
}

.badge-primary {
    background: linear-gradient(45deg, #007bff, #0056b3) !important;
    border: 1px solid #0056b3;
}

.badge-warning {
    background: linear-gradient(45deg, #ffc107, #e0a800) !important;
    border: 1px solid #d39e00;
}

.badge-success {
    background: linear-gradient(45deg, #28a745, #1e7e34) !important;
    border: 1px solid #1c7430;
}

.badge-danger {
    background: linear-gradient(45deg, #dc3545, #c82333) !important;
    border: 1px solid #bd2130;
}

.badge-secondary {
    background: linear-gradient(45deg, #6c757d, #545b62) !important;
    border: 1px solid #4e555b;
}

.table-primary {
    background-color: rgba(0, 123, 255, 0.1);
}

.table-success {
    background-color: rgba(40, 167, 69, 0.1);
}

.table-warning {
    background-color: rgba(255, 193, 7, 0.1);
}

#refresh-notification {
    min-width: 250px;
}

.rounded {
    border-radius: 0.5rem !important;
}
</style> 