<!--sidebar end-->
<!--main content start-->

<link href="common/extranal/css/patient/my_case_list.css" rel="stylesheet">

<div class="content-wrapper bg-light">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row my-2 pl-1">
                <div class="col-sm-6">
                    <h1 class="font-weight-bold"><i class="fas fa-folder-open mr-2"></i><?php echo lang('my'); ?> <?php echo lang('cases'); ?></h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="home"><?php echo lang('home') ?></a></li>
                        <li class="breadcrumb-item active"><?php echo lang('department') ?></li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header bg-light border-bottom">
                            <div class="row align-items-center">
                                <div class="col-md-6">
                                    <h3 class="card-title mb-0">
                                        <i class="fas fa-folder-open mr-2 text-primary"></i>
                                        <?php echo lang('All the case history details'); ?>
                                    </h3>
                                </div>
                                <?php if ($this->ion_auth->in_group(array('Patient')) && isset($hospitals)) { ?>
                                    <div class="col-md-6 text-right">
                                        <select class="form-control form-control-sm d-inline-block" id="patient_hospital_select" name="hospital_id" 
                                                style="width: 280px; border: 2px solid #007bff;">
                                            <option value="consolidated" <?php echo ($selected_hospital === 'consolidated') ? 'selected' : ''; ?>>
                                                📊 All Hospitals Data
                                            </option>
                                            <?php foreach ($hospitals as $hospital) { ?>
                                                <option value="<?php echo $hospital->id; ?>" 
                                                        <?php echo ($selected_hospital == $hospital->id) ? 'selected' : ''; ?>>
                                                    🏥 <?php echo $hospital->name; ?>
                                                </option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table class="table table-bordered table-hover" id="editable-sample">
                                <thead>
                                    <tr>
                                        <th class="id_table"><?php echo lang('id'); ?></th>
                                        <th class="id_table1"><?php echo lang('case'); ?> <?php echo lang('title'); ?></th>
                                        <th class="id_table2"><?php echo lang('case'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php foreach ($medical_histories as $medical_history) { ?>
                                        <?php $patient_info = $this->db->get_where('patient', array('id' => $medical_history->patient_id))->row(); ?>

                                        <tr class="">

                                            <td>
                                                <?php
                                                echo $medical_history->id;
                                                ?>
                                            </td>

                                            <td>
                                                <?php
                                                echo $medical_history->title;
                                                ?>
                                            </td>

                                            <td><?php
                                                if (!empty($medical_history->description)) {
                                                    echo $medical_history->description;
                                                }
                                                ?></td>

                                        </tr>
                                    <?php } ?>

                                </tbody>

                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>

    <!-- /.content -->
</div>


<!--main content end-->
<!--footer start-->



<?php
$current_user = $this->ion_auth->get_user_id();
if ($this->ion_auth->in_group('Doctor')) {
    $doctor_id = $this->db->get_where('doctor', array('ion_user_id' => $current_user))->row()->id;
}
?>

<script src="common/js/codearistos.min.js"></script>
<script type="text/javascript">
    var language = "<?php echo $this->language; ?>";
</script>

<script src="common/extranal/js/patient/my_case_list.js"></script>

<script>
// Wait for all scripts to load, then initialize hospital dropdown
$(window).on('load', function() {
    console.log('Case List: Window loaded, initializing dropdown...');
    
    // Small delay to ensure all scripts are ready
    setTimeout(function() {
        // Patient hospital selection dropdown change handler
        $('#patient_hospital_select').off('change.hospital').on('change.hospital', function() {
            console.log('Case List: Dropdown changed to:', $(this).val());
            const selectedHospital = $(this).val();
            
            // Build URL with hospital parameter
            let url = 'patient/myCaseList';
            if (selectedHospital) {
                url += '?hospital_id=' + selectedHospital;
            }
            
            console.log('Case List: Redirecting to:', url);
            
            // Show loading indication
            $(this).prop('disabled', true);
            $('body').append('<div id="loading-overlay" style="position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,0.5);z-index:9999;display:flex;align-items:center;justify-content:center;color:white;font-size:18px;"><i class="fas fa-spinner fa-spin mr-2"></i>Loading hospital data...</div>');
            
            // Redirect to reload page with selected hospital
            window.location.href = url;
        });
        
        // Check if dropdown exists
        if ($('#patient_hospital_select').length) {
            console.log('Case List: Dropdown found successfully');
        } else {
            console.log('Case List: Dropdown NOT found!');
        }
    }, 100);
});
</script>