<!--sidebar end-->
<!--main content start-->
<link href="common/extranal/css/patient/add_new.css" rel="stylesheet">

<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>
                        <i class="fas fa-users mr-2 text-primary"></i>
                        My Dependents
                    </h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="home">Home</a></li>
                        <li class="breadcrumb-item active">Dependents</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid">
            
            <!-- Welcome Message for Guardian -->
            <?php if ($this->session->flashdata('guardian_welcome')) { ?>
                <div class="alert alert-success alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                    <h5><i class="icon fas fa-check"></i> Welcome!</h5>
                    <?php echo $this->session->flashdata('guardian_welcome'); ?>
                </div>
            <?php } ?>

            <!-- Guardian Summary Cards -->
            <div class="row mb-4">
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-info">
                        <div class="inner">
                            <h3><?php echo $dependent_count; ?></h3>
                            <p>Total Dependents</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-users"></i>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-success">
                        <div class="inner">
                            <h3>
                                <?php 
                                $total_appointments = 0;
                                if (!empty($dependents)) {
                                    foreach ($dependents as $dependent) {
                                        $total_appointments += $dependent->appointment_count;
                                    }
                                }
                                echo $total_appointments;
                                ?>
                            </h3>
                            <p>Total Appointments</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-calendar-alt"></i>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-warning">
                        <div class="inner">
                            <h3><?php echo $guardian->name; ?></h3>
                            <p>Guardian</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-user-shield"></i>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-danger">
                        <div class="inner">
                            <h3>
                                <a href="<?php echo base_url('patient/guardianDependentCalendar'); ?>" class="text-white">
                                    <i class="fas fa-calendar"></i>
                                </a>
                            </h3>
                            <p>View Calendar</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-calendar-week"></i>
                        </div>
                        <a href="<?php echo base_url('patient/guardianDependentCalendar'); ?>" class="small-box-footer">
                            View All Appointments <i class="fas fa-arrow-circle-right"></i>
                        </a>
                    </div>
                </div>
            </div>

            <!-- Dependents Cards -->
            <?php if (empty($dependents)) { ?>
                <div class="card">
                    <div class="card-body text-center py-5">
                        <i class="fas fa-users fa-5x text-muted mb-4"></i>
                        <h4 class="text-muted">No Dependent Patients</h4>
                        <p class="text-muted">You don't have any dependent patients registered yet.</p>
                        <a href="patient/addNewView" class="btn btn-primary btn-lg">
                            <i class="fas fa-plus mr-2"></i>Add New Dependent
                        </a>
                    </div>
                </div>
            <?php } else { ?>
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-users mr-2"></i>
                            Your Dependent Patients
                        </h3>
                        <div class="card-tools">
                            <a href="patient/addNewView" class="btn btn-success btn-sm">
                                <i class="fas fa-plus mr-1"></i>Add New Dependent
                            </a>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="row">
                            <?php foreach ($dependents as $dependent) { ?>
                                <div class="col-md-6 col-lg-4">
                                    <div class="card card-widget widget-user shadow-sm m-3">
                                        <!-- Add the bg color to the header using any of the bg-* classes -->
                                        <div class="widget-user-header bg-info">
                                            <h3 class="widget-user-username"><?php echo $dependent->name; ?></h3>
                                            <h5 class="widget-user-desc">
                                                <?php echo ucfirst($dependent->relationship_to_guardian); ?>
                                                <span class="badge badge-light ml-2"><?php echo $dependent->sex; ?></span>
                                            </h5>
                                        </div>
                                        <div class="widget-user-image">
                                            <?php if (!empty($dependent->img_url)) { ?>
                                                <img class="img-circle elevation-2" src="<?php echo base_url() . $dependent->img_url; ?>" alt="Patient Avatar">
                                            <?php } else { ?>
                                                <div class="img-circle elevation-2 bg-secondary d-flex align-items-center justify-content-center" style="width: 65px; height: 65px;">
                                                    <i class="fas fa-user fa-2x text-white"></i>
                                                </div>
                                            <?php } ?>
                                        </div>
                                        <div class="card-footer">
                                            <div class="row">
                                                <div class="col-sm-4 border-right">
                                                    <div class="description-block">
                                                        <h5 class="description-header"><?php echo $dependent->age; ?></h5>
                                                        <span class="description-text">Age</span>
                                                    </div>
                                                </div>
                                                <div class="col-sm-4 border-right">
                                                    <div class="description-block">
                                                        <h5 class="description-header"><?php echo $dependent->appointment_count; ?></h5>
                                                        <span class="description-text">Appointments</span>
                                                    </div>
                                                </div>
                                                <div class="col-sm-4">
                                                    <div class="description-block">
                                                        <h5 class="description-header">
                                                            <?php if (!empty($dependent->phone)) { ?>
                                                                <i class="fas fa-phone text-success"></i>
                                                            <?php } else { ?>
                                                                <i class="fas fa-phone text-warning"></i>
                                                            <?php } ?>
                                                        </h5>
                                                        <span class="description-text">Contact</span>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <!-- Action Buttons -->
                                            <div class="row mt-3">
                                                <div class="col-12">
                                                    <div class="btn-group btn-group-sm w-100" role="group">
                                                        <a href="<?php echo base_url('patient/guardianViewDependent?id=' . $dependent->id); ?>" class="btn btn-primary" title="View Details">
                                                            <i class="fas fa-eye"></i> Details
                                                        </a>
                                                        <a href="<?php echo base_url('patient/guardianDependentHistory?id=' . $dependent->id); ?>" class="btn btn-info" title="Medical History">
                                                            <i class="fas fa-history"></i> History
                                                        </a>
                                                        <a href="<?php echo base_url('appointment/addNewView?patient_id=' . $dependent->id . '&guardian_booking=1'); ?>" class="btn btn-success" title="Book Appointment">
                                                            <i class="fas fa-calendar-plus"></i> Book
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            <?php } ?>

            <!-- Quick Actions Card -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-bolt mr-2"></i>
                        Quick Actions
                    </h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3">
                            <a href="patient/addNewView" class="btn btn-outline-primary btn-block">
                                <i class="fas fa-plus mr-2"></i>Add New Dependent
                            </a>
                        </div>
                        <div class="col-md-3">
                            <a href="<?php echo base_url('patient/guardianDependentCalendar'); ?>" class="btn btn-outline-info btn-block">
                                <i class="fas fa-calendar mr-2"></i>View All Appointments
                            </a>
                        </div>
                        <div class="col-md-3">
                            <a href="patient/medicalHistory" class="btn btn-outline-success btn-block">
                                <i class="fas fa-user mr-2"></i>My Medical History
                            </a>
                        </div>
                        <div class="col-md-3">
                            <a href="patient" class="btn btn-outline-secondary btn-block">
                                <i class="fas fa-list mr-2"></i>Patient Portal
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<style>
.content-wrapper {
    background-color: #f4f6f9;
}

.widget-user .widget-user-image > img,
.widget-user .widget-user-image > div {
    margin-left: auto;
    margin-right: auto;
}

.small-box {
    border-radius: 10px;
}

.card {
    border-radius: 10px;
    box-shadow: 0 0 1px rgba(0,0,0,.125), 0 1px 3px rgba(0,0,0,.2);
}

.widget-user {
    border-radius: 10px;
}

.widget-user-header {
    border-radius: 10px 10px 0 0;
}

.btn-group-sm > .btn, .btn-sm {
    border-radius: 5px;
}

.description-header {
    font-size: 15px;
    font-weight: 700;
    margin: 0;
}

.description-text {
    font-size: 12px;
    color: #6c757d;
    text-transform: uppercase;
    font-weight: 600;
}
</style> 