<div class="content-wrapper">
    <section class="content-header">
        <h1><?php echo lang('otp_management') ?: 'OTP Management'; ?></h1>
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i> <?php echo lang('home') ?: 'Home'; ?></a></li>
            <li class="active"><?php echo lang('otp_management') ?: 'OTP Management'; ?></li>
        </ol>
    </section>

    <section class="content">
        <div class="row">
            <!-- OTP Status Cards -->
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3><?php echo !empty($otp_settings) && $otp_settings->otp_enabled ? 'ON' : 'OFF'; ?></h3>
                        <p><?php echo lang('otp_status') ?: 'OTP Status'; ?></p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-shield"></i>
                    </div>
                    <a href="<?php echo base_url('otp/settings'); ?>" class="small-box-footer">
                        <?php echo lang('configure') ?: 'Configure'; ?> <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-blue">
                    <div class="inner">
                        <h3><?php echo !empty($otp_settings) ? $otp_settings->otp_length : '6'; ?></h3>
                        <p><?php echo lang('otp_length') ?: 'OTP Length'; ?></p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-key"></i>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3><?php echo !empty($otp_settings) ? $otp_settings->otp_expiry_minutes : '5'; ?> min</h3>
                        <p><?php echo lang('expiry_time') ?: 'Expiry Time'; ?></p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-clock-o"></i>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3><?php echo count($otp_logs); ?></h3>
                        <p><?php echo lang('recent_otps') ?: 'Recent OTPs'; ?></p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-list"></i>
                    </div>
                    <a href="<?php echo base_url('otp/logs'); ?>" class="small-box-footer">
                        <?php echo lang('view_logs') ?: 'View Logs'; ?> <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-8">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><?php echo lang('recent_otp_activity') ?: 'Recent OTP Activity'; ?></h3>
                        <div class="box-tools pull-right">
                            <a href="<?php echo base_url('otp/logs'); ?>" class="btn btn-sm btn-default">
                                <i class="fa fa-list"></i> <?php echo lang('view_all') ?: 'View All'; ?>
                            </a>
                        </div>
                    </div>
                    <div class="box-body">
                        <?php if (!empty($otp_logs)): ?>
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th><?php echo lang('phone') ?: 'Phone'; ?></th>
                                            <th><?php echo lang('purpose') ?: 'Purpose'; ?></th>
                                            <th><?php echo lang('status') ?: 'Status'; ?></th>
                                            <th><?php echo lang('created_at') ?: 'Created At'; ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach (array_slice($otp_logs, 0, 10) as $log): ?>
                                            <tr>
                                                <td><?php echo substr($log->phone, 0, -4) . '****'; ?></td>
                                                <td>
                                                    <span class="label label-info">
                                                        <?php echo ucwords(str_replace('_', ' ', $log->purpose)); ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <?php if ($log->is_verified): ?>
                                                        <span class="label label-success">
                                                            <i class="fa fa-check"></i> <?php echo lang('verified') ?: 'Verified'; ?>
                                                        </span>
                                                    <?php else: ?>
                                                        <span class="label label-warning">
                                                            <i class="fa fa-clock-o"></i> <?php echo lang('pending') ?: 'Pending'; ?>
                                                        </span>
                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo date('M j, Y H:i', strtotime($log->created_at)); ?></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <div class="text-center text-muted">
                                <i class="fa fa-info-circle fa-3x"></i>
                                <p><?php echo lang('no_otp_activity') ?: 'No OTP activity found'; ?></p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title"><?php echo lang('quick_actions') ?: 'Quick Actions'; ?></h3>
                    </div>
                    <div class="box-body">
                        <a href="<?php echo base_url('otp/settings'); ?>" class="btn btn-primary btn-block">
                            <i class="fa fa-cog"></i> <?php echo lang('configure_otp') ?: 'Configure OTP'; ?>
                        </a>
                        <a href="<?php echo base_url('sms'); ?>" class="btn btn-info btn-block">
                            <i class="fa fa-envelope"></i> <?php echo lang('sms_settings') ?: 'SMS Settings'; ?>
                        </a>
                        <a href="<?php echo base_url('otp/logs'); ?>" class="btn btn-default btn-block">
                            <i class="fa fa-list"></i> <?php echo lang('view_logs') ?: 'View Logs'; ?>
                        </a>
                    </div>
                </div>

                <?php if (empty($otp_settings) || !$otp_settings->otp_enabled): ?>
                    <div class="box box-warning">
                        <div class="box-header with-border">
                            <h3 class="box-title"><?php echo lang('setup_required') ?: 'Setup Required'; ?></h3>
                        </div>
                        <div class="box-body">
                            <p><?php echo lang('otp_not_configured') ?: 'OTP verification is not properly configured. Please complete the setup to enable OTP functionality.'; ?></p>
                            <a href="<?php echo base_url('otp/settings'); ?>" class="btn btn-warning">
                                <i class="fa fa-wrench"></i> <?php echo lang('setup_now') ?: 'Setup Now'; ?>
                            </a>
                        </div>
                    </div>
                <?php endif; ?>

                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><?php echo lang('current_settings') ?: 'Current Settings'; ?></h3>
                    </div>
                    <div class="box-body">
                        <?php if (!empty($otp_settings)): ?>
                            <dl class="dl-horizontal">
                                <dt><?php echo lang('status') ?: 'Status'; ?>:</dt>
                                <dd>
                                    <span class="label label-<?php echo $otp_settings->otp_enabled ? 'success' : 'danger'; ?>">
                                        <?php echo $otp_settings->otp_enabled ? 'Enabled' : 'Disabled'; ?>
                                    </span>
                                </dd>
                                <dt><?php echo lang('length') ?: 'Length'; ?>:</dt>
                                <dd><?php echo $otp_settings->otp_length; ?> digits</dd>
                                <dt><?php echo lang('expiry') ?: 'Expiry'; ?>:</dt>
                                <dd><?php echo $otp_settings->otp_expiry_minutes; ?> minutes</dd>
                                <dt><?php echo lang('max_attempts') ?: 'Max Attempts'; ?>:</dt>
                                <dd><?php echo $otp_settings->max_attempts; ?></dd>
                                <dt><?php echo lang('cooldown') ?: 'Cooldown'; ?>:</dt>
                                <dd><?php echo $otp_settings->resend_cooldown_seconds; ?> seconds</dd>
                            </dl>
                        <?php else: ?>
                            <p class="text-muted"><?php echo lang('no_settings_configured') ?: 'No settings configured yet'; ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>