<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Otp_model extends CI_model
{
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    function getOTPSettingsByHospitalId($hospital_id)
    {
        $this->db->where('hospital_id', $hospital_id);
        $query = $this->db->get('otp_settings');
        return $query->row();
    }

    function addOTPSettings($data)
    {
        $this->db->insert('otp_settings', $data);
        return $this->db->insert_id();
    }

    function updateOTPSettings($hospital_id, $data)
    {
        $this->db->where('hospital_id', $hospital_id);
        $this->db->update('otp_settings', $data);
        return $this->db->affected_rows();
    }

    function getOTPLogs($hospital_id, $limit = 50)
    {
        $this->db->select('ov.*, s.gateway');
        $this->db->from('otp_verification ov');
        $this->db->join('sms s', 's.phone = ov.phone AND s.purpose LIKE "OTP_%"', 'left');
        $this->db->where('ov.hospital_id', $hospital_id);
        $this->db->order_by('ov.created_at', 'DESC');
        $this->db->limit($limit);
        
        $query = $this->db->get();
        return $query->result();
    }

    function deleteExpiredOTPs()
    {
        $this->db->where('expires_at <', date('Y-m-d H:i:s'));
        $this->db->where('is_verified', 0);
        $this->db->delete('otp_verification');
        
        return $this->db->affected_rows();
    }

    function getOTPStats($hospital_id, $days = 30)
    {
        $date_from = date('Y-m-d', strtotime('-' . $days . ' days'));
        
        // Total OTPs sent
        $this->db->where('hospital_id', $hospital_id);
        $this->db->where('created_at >=', $date_from);
        $total_sent = $this->db->count_all_results('otp_verification');
        
        // Total OTPs verified
        $this->db->where('hospital_id', $hospital_id);
        $this->db->where('created_at >=', $date_from);
        $this->db->where('is_verified', 1);
        $total_verified = $this->db->count_all_results('otp_verification');
        
        // Success rate
        $success_rate = $total_sent > 0 ? round(($total_verified / $total_sent) * 100, 2) : 0;
        
        return array(
            'total_sent' => $total_sent,
            'total_verified' => $total_verified,
            'success_rate' => $success_rate
        );
    }
}