<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $settings->title; ?> - Our Services</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'primary': '#667eea',
                        'secondary': '#764ba2',
                    }
                }
            }
        }
    </script>
    <style>
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .card-hover {
            transition: all 0.3s ease;
        }
        .card-hover:hover {
            transform: translateY(-8px);
        }
        .service-icon {
            transition: all 0.3s ease;
        }
        .service-card:hover .service-icon {
            transform: scale(1.1);
        }
    </style>
</head>
<body class="font-sans">
    <!-- Navigation -->
    <nav class="backdrop-blur-md shadow-lg fixed w-full top-0 z-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center h-16">
                <!-- Logo -->
                <div class="flex items-center">
                    <a href="<?php echo base_url('frontend/public_portal'); ?>" class="flex items-center">
                        <div class="w-8 h-8 bg-gradient-to-r from-primary to-secondary rounded-lg flex items-center justify-center mr-3">
                            <i class="fas fa-hospital text-white text-sm"></i>
                        </div>
                        <span class="font-bold text-xl text-white"><?php echo $settings->title; ?></span>
                    </a>
                </div>
                
                <!-- Desktop Navigation -->
                <div class="hidden md:flex items-center space-x-8">
                    <a href="<?php echo base_url('frontend/public_portal'); ?>" class="text-white hover:text-blue-200 transition-colors duration-200 font-medium">
                        <i class="fas fa-home mr-1"></i>Home
                    </a>
                    <a href="<?php echo base_url('frontend/about_us'); ?>" class="text-white hover:text-blue-200 transition-colors duration-200 font-medium">
                        <i class="fas fa-info-circle mr-1"></i>About Us
                    </a>
                    <a href="<?php echo base_url('frontend/our_services'); ?>" class="text-blue-200 border-b-2 border-blue-200 font-medium">
                        <i class="fas fa-medical-kit mr-1"></i>Our Services
                    </a>
                    <a href="<?php echo base_url('auth/login'); ?>" class="bg-gradient-to-r from-primary to-secondary text-white px-6 py-2 rounded-lg hover:from-primary-600 hover:to-secondary-600 transition-all duration-200 font-medium">
                        <i class="fas fa-sign-in-alt mr-1"></i>Login
                    </a>
                </div>
                
                <!-- Mobile Menu Button -->
                <div class="md:hidden">
                    <button id="mobile-menu-button" class="text-white hover:text-blue-200 focus:outline-none">
                        <i class="fas fa-bars text-xl"></i>
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Mobile Navigation -->
        <div id="mobile-menu" class="hidden md:hidden bg-white border-t border-gray-200">
            <div class="px-2 pt-2 pb-3 space-y-1">
                <a href="<?php echo base_url('frontend/public_portal'); ?>" class="block px-3 py-2 text-gray-700 hover:text-primary hover:bg-gray-50 rounded-md font-medium">
                    <i class="fas fa-home mr-2"></i>Home
                </a>
                <a href="<?php echo base_url('frontend/about_us'); ?>" class="block px-3 py-2 text-gray-700 hover:text-primary hover:bg-gray-50 rounded-md font-medium">
                    <i class="fas fa-info-circle mr-2"></i>About Us
                </a>
                <a href="<?php echo base_url('frontend/our_services'); ?>" class="block px-3 py-2 text-primary bg-blue-50 rounded-md font-medium">
                    <i class="fas fa-medical-kit mr-2"></i>Our Services
                </a>
                <a href="<?php echo base_url('auth/login'); ?>" class="block px-3 py-2 bg-gradient-to-r from-primary to-secondary text-white rounded-md font-medium">
                    <i class="fas fa-sign-in-alt mr-2"></i>Login
                </a>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="gradient-bg pt-20 pb-16">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center text-white py-16">
                <h1 class="text-5xl md:text-6xl font-bold mb-6">Our Services</h1>
                <p class="text-xl md:text-2xl text-blue-100 max-w-3xl mx-auto">
                    Comprehensive healthcare services across multiple specialties to meet all your medical needs.
                </p>
            </div>
        </div>
    </section>

    <!-- Services Overview -->
    <section class="py-16 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-800 mb-4">Comprehensive Healthcare Solutions</h2>
                <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                    From routine checkups to specialized treatments, we provide a full range of medical services with state-of-the-art technology and expert care.
                </p>
            </div>
            
            <div class="grid md:grid-cols-3 gap-8 mb-16">
                <!-- 24/7 Emergency Care -->
                <div class="bg-white rounded-2xl p-8 text-center shadow-lg card-hover service-card">
                    <div class="service-icon w-20 h-20 bg-gradient-to-r from-red-500 to-pink-600 rounded-full flex items-center justify-center mx-auto mb-6">
                        <i class="fas fa-ambulance text-3xl text-white"></i>
                    </div>
                    <h3 class="text-2xl font-bold text-gray-800 mb-4">24/7 Emergency Care</h3>
                    <p class="text-gray-600 leading-relaxed">
                        Round-the-clock emergency medical services with fully equipped trauma centers and expert emergency physicians.
                    </p>
                </div>
                
                <!-- Advanced Diagnostics -->
                <div class="bg-white rounded-2xl p-8 text-center shadow-lg card-hover service-card">
                    <div class="service-icon w-20 h-20 bg-gradient-to-r from-blue-500 to-purple-600 rounded-full flex items-center justify-center mx-auto mb-6">
                        <i class="fas fa-microscope text-3xl text-white"></i>
                    </div>
                    <h3 class="text-2xl font-bold text-gray-800 mb-4">Advanced Diagnostics</h3>
                    <p class="text-gray-600 leading-relaxed">
                        State-of-the-art diagnostic equipment including MRI, CT scan, X-ray, and comprehensive laboratory services.
                    </p>
                </div>
                
                <!-- Surgical Excellence -->
                <div class="bg-white rounded-2xl p-8 text-center shadow-lg card-hover service-card">
                    <div class="service-icon w-20 h-20 bg-gradient-to-r from-green-500 to-teal-600 rounded-full flex items-center justify-center mx-auto mb-6">
                        <i class="fas fa-procedure text-3xl text-white"></i>
                    </div>
                    <h3 class="text-2xl font-bold text-gray-800 mb-4">Surgical Excellence</h3>
                    <p class="text-gray-600 leading-relaxed">
                        Modern operating theaters with minimally invasive techniques and experienced surgical teams across specialties.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Medical Specialties -->
    <section class="py-16 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-800 mb-4">Medical Specialties</h2>
                <p class="text-xl text-gray-600">Expert care across multiple medical disciplines</p>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <?php 
                $specialty_icons = [
                    'Cardiology' => 'fa-heartbeat',
                    'Neurology' => 'fa-brain',
                    'Orthopedics' => 'fa-bone',
                    'Pediatrics' => 'fa-child',
                    'Gynecology' => 'fa-female',
                    'Oncology' => 'fa-ribbon',
                    'Dermatology' => 'fa-user-md',
                    'Psychiatry' => 'fa-head-side-virus',
                    'Ophthalmology' => 'fa-eye',
                    'ENT' => 'fa-ear-listen',
                    'Urology' => 'fa-kidneys',
                    'General Surgery' => 'fa-cut'
                ];
                
                foreach ($specialities as $speciality): 
                    $icon = isset($specialty_icons[$speciality->name]) ? $specialty_icons[$speciality->name] : 'fa-stethoscope';
                ?>
                <div class="bg-gray-50 rounded-xl p-6 hover:bg-white hover:shadow-lg transition-all duration-300 service-card">
                    <div class="flex items-center">
                        <div class="service-icon w-12 h-12 bg-gradient-to-r from-primary to-secondary rounded-lg flex items-center justify-center mr-4">
                            <i class="fas <?php echo $icon; ?> text-white"></i>
                        </div>
                        <div>
                            <h3 class="text-lg font-semibold text-gray-800"><?php echo $speciality->name; ?></h3>
                            <p class="text-sm text-gray-600">Expert specialized care</p>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <!-- Technology & Equipment -->
    <section class="py-16 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-800 mb-4">Advanced Technology</h2>
                <p class="text-xl text-gray-600">Cutting-edge medical equipment for accurate diagnosis and effective treatment</p>
            </div>
            
            <div class="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
                <!-- MRI -->
                <div class="bg-white rounded-xl p-6 text-center shadow-lg card-hover">
                    <div class="w-16 h-16 bg-gradient-to-r from-blue-500 to-purple-600 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-magnet text-2xl text-white"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-800 mb-2">MRI Scanning</h3>
                    <p class="text-sm text-gray-600">High-resolution magnetic resonance imaging</p>
                </div>
                
                <!-- CT Scan -->
                <div class="bg-white rounded-xl p-6 text-center shadow-lg card-hover">
                    <div class="w-16 h-16 bg-gradient-to-r from-green-500 to-teal-600 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-circle-radiation text-2xl text-white"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-800 mb-2">CT Scanning</h3>
                    <p class="text-sm text-gray-600">Advanced computed tomography</p>
                </div>
                
                <!-- Digital X-Ray -->
                <div class="bg-white rounded-xl p-6 text-center shadow-lg card-hover">
                    <div class="w-16 h-16 bg-gradient-to-r from-purple-500 to-pink-600 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-x-ray text-2xl text-white"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-800 mb-2">Digital X-Ray</h3>
                    <p class="text-sm text-gray-600">Digital radiography systems</p>
                </div>
                
                <!-- Laboratory -->
                <div class="bg-white rounded-xl p-6 text-center shadow-lg card-hover">
                    <div class="w-16 h-16 bg-gradient-to-r from-orange-500 to-red-600 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-flask text-2xl text-white"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-800 mb-2">Laboratory</h3>
                    <p class="text-sm text-gray-600">Comprehensive lab testing</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Hospital Network -->
    <section class="py-16 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-800 mb-4">Our Hospital Network</h2>
                <p class="text-xl text-gray-600">Quality healthcare across multiple locations</p>
            </div>
            
            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
                <?php foreach ($hospitals as $hospital): ?>
                <div class="bg-gray-50 rounded-xl p-6 hover:bg-white hover:shadow-lg transition-all duration-300">
                    <div class="flex items-center mb-4">
                        <div class="w-12 h-12 bg-gradient-to-r from-primary to-secondary rounded-lg flex items-center justify-center mr-4">
                            <i class="fas fa-hospital text-white"></i>
                        </div>
                        <div>
                            <h3 class="text-lg font-semibold text-gray-800"><?php echo $hospital->name; ?></h3>
                            <p class="text-sm text-gray-600"><?php echo $hospital->address; ?></p>
                        </div>
                    </div>
                    <div class="text-sm text-gray-600">
                        <p><i class="fas fa-phone mr-2 text-primary"></i><?php echo $hospital->phone; ?></p>
                        <p><i class="fas fa-envelope mr-2 text-primary"></i><?php echo $hospital->email; ?></p>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <!-- Call to Action -->
    <section class="py-16 gradient-bg">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <h2 class="text-3xl md:text-4xl font-bold text-white mb-6">Need Medical Attention?</h2>
            <p class="text-xl text-blue-100 mb-8 max-w-2xl mx-auto">
                Our expert medical team is ready to provide you with the best possible care. Book an appointment today.
            </p>
            
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="<?php echo base_url('frontend/appointment_request'); ?>" 
                   class="inline-flex items-center px-8 py-4 bg-white text-primary font-semibold rounded-xl hover:bg-gray-50 transform hover:scale-105 transition-all duration-300 shadow-lg">
                    <i class="fas fa-calendar-check mr-2"></i>
                    Book Appointment
                </a>
                <a href="<?php echo base_url('frontend/patient_registration'); ?>" 
                   class="inline-flex items-center px-8 py-4 border-2 border-white text-white font-semibold rounded-xl hover:bg-white hover:text-primary transition-all duration-300">
                    <i class="fas fa-user-plus mr-2"></i>
                    Register as Patient
                </a>
            </div>
        </div>
    </section>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        // Mobile menu functionality
        document.getElementById('mobile-menu-button').addEventListener('click', function() {
            const mobileMenu = document.getElementById('mobile-menu');
            const icon = this.querySelector('i');
            
            if (mobileMenu.classList.contains('hidden')) {
                mobileMenu.classList.remove('hidden');
                icon.classList.remove('fa-bars');
                icon.classList.add('fa-times');
            } else {
                mobileMenu.classList.add('hidden');
                icon.classList.remove('fa-times');
                icon.classList.add('fa-bars');
            }
        });
    </script>
</body>
</html> 