<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $settings->title; ?> - Healthcare Portal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'primary': '#667eea',
                        'secondary': '#764ba2',
                    }
                }
            }
        }
    </script>
    <style>
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .card-hover {
            transition: all 0.3s ease;
        }
        .card-hover:hover {
            transform: translateY(-8px);
            box-shadow: 0 25px 50px rgba(0,0,0,0.15);
        }
        .feature-icon {
            animation: float 3s ease-in-out infinite;
        }
        @keyframes float {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
        }
        .stats-counter {
            font-family: 'Courier New', monospace;
        }
        .testimonial-card {
            backdrop-filter: blur(10px);
        }
        .section-divider {
            background: linear-gradient(90deg, transparent, #667eea, transparent);
        }
    </style>
</head>
<body class="font-sans overflow-x-hidden">
    <!-- Navigation -->
    <nav class="bg-white/95 backdrop-blur-md shadow-lg fixed w-full top-0 z-50 border-b border-gray-200/50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center h-16">
                <!-- Logo -->
                <div class="flex items-center">
                    <a href="<?php echo base_url('frontend/public_portal'); ?>" class="flex items-center">
                        <div class="w-10 h-10 bg-gradient-to-r from-primary to-secondary rounded-lg flex items-center justify-center mr-3">
                            <i class="fas fa-heartbeat text-white text-lg"></i>
                        </div>
                        <span class="font-bold text-xl text-gray-800"><?php echo $settings->title; ?></span>
                    </a>
                </div>
                
                <!-- Desktop Navigation -->
                <div class="hidden md:flex items-center space-x-8">
                    <a href="#home" class="text-gray-700 hover:text-primary transition-colors duration-200 font-medium">
                        <i class="fas fa-home mr-1"></i>Home
                    </a>
                    <a href="#services" class="text-gray-700 hover:text-primary transition-colors duration-200 font-medium">
                        <i class="fas fa-medical-kit mr-1"></i>Services
                    </a>
                    <a href="<?php echo base_url('frontend/guest_appointment'); ?>" class="text-gray-700 hover:text-primary transition-colors duration-200 font-medium">
                        <i class="fas fa-user-clock mr-1"></i>Book as Guest
                    </a>
                    <a href="#about" class="text-gray-700 hover:text-primary transition-colors duration-200 font-medium">
                        <i class="fas fa-info-circle mr-1"></i>About
                    </a>
                    <a href="#contact" class="text-gray-700 hover:text-primary transition-colors duration-200 font-medium">
                        <i class="fas fa-envelope mr-1"></i>Contact
                    </a>
                    <a href="<?php echo base_url('auth/login'); ?>" class="bg-gradient-to-r from-primary to-secondary text-white px-6 py-2 rounded-lg hover:from-primary-600 hover:to-secondary-600 transition-all duration-200 font-medium shadow-lg">
                        <i class="fas fa-sign-in-alt mr-1"></i>Login
                    </a>
                </div>
                
                <!-- Mobile Menu Button -->
                <div class="md:hidden">
                    <button id="mobile-menu-button" class="text-gray-700 hover:text-primary focus:outline-none">
                        <i class="fas fa-bars text-xl"></i>
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Mobile Navigation -->
        <div id="mobile-menu" class="hidden md:hidden bg-white/95 backdrop-blur-md border-t border-gray-200">
            <div class="px-2 pt-2 pb-3 space-y-1">
                <a href="#home" class="block px-3 py-2 text-gray-700 hover:text-primary hover:bg-gray-50 rounded-md font-medium">
                    <i class="fas fa-home mr-2"></i>Home
                </a>
                <a href="#services" class="block px-3 py-2 text-gray-700 hover:text-primary hover:bg-gray-50 rounded-md font-medium">
                    <i class="fas fa-medical-kit mr-2"></i>Services
                </a>
                <a href="<?php echo base_url('frontend/guest_appointment'); ?>" class="block px-3 py-2 text-gray-700 hover:text-primary hover:bg-gray-50 rounded-md font-medium">
                    <i class="fas fa-user-clock mr-2"></i>Book as Guest
                </a>
                <a href="#about" class="block px-3 py-2 text-gray-700 hover:text-primary hover:bg-gray-50 rounded-md font-medium">
                    <i class="fas fa-info-circle mr-2"></i>About
                </a>
                <a href="#contact" class="block px-3 py-2 text-gray-700 hover:text-primary hover:bg-gray-50 rounded-md font-medium">
                    <i class="fas fa-envelope mr-2"></i>Contact
                </a>
                <a href="<?php echo base_url('auth/login'); ?>" class="block px-3 py-2 bg-gradient-to-r from-primary to-secondary text-white rounded-md font-medium">
                    <i class="fas fa-sign-in-alt mr-2"></i>Login
                </a>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section id="home" class="gradient-bg relative overflow-hidden min-h-screen flex items-center">
        <!-- Background Elements -->
        <div class="absolute inset-0 opacity-10">
            <div class="absolute top-20 left-10 w-32 h-32 bg-white rounded-full opacity-20 animate-pulse"></div>
            <div class="absolute top-40 right-20 w-24 h-24 bg-white rounded-full opacity-15 animate-pulse" style="animation-delay: 1s;"></div>
            <div class="absolute bottom-20 left-1/4 w-40 h-40 bg-white rounded-full opacity-10 animate-pulse" style="animation-delay: 2s;"></div>
            <div class="absolute top-1/2 right-1/3 w-20 h-20 bg-white rounded-full opacity-25 animate-pulse" style="animation-delay: 0.5s;"></div>
        </div>
        
        <div class="container mx-auto px-4 pt-16">
            <div class="max-w-6xl mx-auto text-center text-white">
                <!-- Hero Badge -->
                <div class="inline-flex items-center bg-white/20 backdrop-blur-sm rounded-full px-6 py-3 mb-8 border border-white/30">
                    <span class="w-2 h-2 bg-green-400 rounded-full mr-3 animate-pulse"></span>
                    <span class="text-sm font-medium">Trusted Healthcare Network Since 2020</span>
                </div>

                <!-- Hero Title -->
                <h1 class="text-5xl md:text-7xl font-bold mb-6 leading-tight">
                    Your Health, <br>
                    <span class="bg-gradient-to-r from-yellow-300 via-orange-300 to-red-300 bg-clip-text text-transparent">
                        Our Priority
                    </span>
                </h1>

                <!-- Hero Subtitle -->
                <p class="text-xl md:text-2xl mb-10 text-blue-100 max-w-4xl mx-auto leading-relaxed">
                    Connect with medical professionals, manage appointments, and access quality healthcare services through our comprehensive platform.
                </p>

                <!-- Hero Stats -->
                <div class="grid grid-cols-2 md:grid-cols-4 gap-8 mb-12 max-w-4xl mx-auto">
                    <div class="text-center">
                        <div class="text-3xl md:text-4xl font-bold stats-counter mb-2">24/7</div>
                        <div class="text-sm text-blue-200">Healthcare Support</div>
                    </div>
                    <div class="text-center">
                        <div class="text-3xl md:text-4xl font-bold stats-counter mb-2">100+</div>
                        <div class="text-sm text-blue-200">Expert Doctors</div>
                    </div>
                    <div class="text-center">
                        <div class="text-3xl md:text-4xl font-bold stats-counter mb-2">50+</div>
                        <div class="text-sm text-blue-200">Medical Specialties</div>
                    </div>
                    <div class="text-center">
                        <div class="text-3xl md:text-4xl font-bold stats-counter mb-2">10K+</div>
                        <div class="text-sm text-blue-200">Happy Patients</div>
                    </div>
                </div>

                <!-- Hero CTA -->
                <div class="flex flex-col sm:flex-row gap-4 justify-center">
                    <a href="#services" class="inline-flex items-center px-8 py-4 bg-white text-primary font-semibold rounded-full hover:bg-gray-100 transform hover:scale-105 transition-all duration-300 shadow-xl">
                        <i class="fas fa-arrow-down mr-2"></i>
                        Explore Services
                    </a>
                    <a href="<?php echo base_url('frontend/appointment_request'); ?>" class="inline-flex items-center px-8 py-4 border-2 border-white text-white font-semibold rounded-full hover:bg-white hover:text-primary transform hover:scale-105 transition-all duration-300">
                        <i class="fas fa-calendar-check mr-2"></i>
                        Book Appointment
                    </a>
                    <a href="<?php echo base_url('frontend/guest_appointment'); ?>" class="inline-flex items-center px-8 py-4 bg-gradient-to-r from-yellow-500 to-orange-500 text-white font-semibold rounded-full hover:from-yellow-600 hover:to-orange-600 transform hover:scale-105 transition-all duration-300 shadow-xl">
                        <i class="fas fa-user-clock mr-2"></i>
                        Book as Guest
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Services Section -->
    <section id="services" class="py-20 bg-gray-50">
        <div class="container mx-auto px-4">
            <div class="max-w-6xl mx-auto">
                <!-- Section Header -->
                <div class="text-center mb-16">
                    <div class="inline-block bg-primary/10 text-primary px-4 py-2 rounded-full text-sm font-medium mb-4">
                        Our Services
                    </div>
                    <h2 class="text-4xl md:text-5xl font-bold text-gray-800 mb-6">
                        Everything You Need for Better Health
                    </h2>
                    <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                        Comprehensive healthcare solutions designed to make medical care accessible, efficient, and personalized for everyone.
                    </p>
                </div>
                
                <!-- Service Cards -->
                <div class="grid md:grid-cols-3 gap-8 mb-16">
                    <!-- Patient Registration -->
                    <div class="bg-white rounded-3xl shadow-xl p-8 card-hover border border-gray-100 relative overflow-hidden">
                        <div class="absolute top-0 right-0 w-32 h-32 bg-gradient-to-br from-blue-500/10 to-purple-600/10 rounded-full -mr-16 -mt-16"></div>
                        <div class="relative">
                            <div class="w-20 h-20 bg-gradient-to-r from-blue-500 to-purple-600 rounded-2xl flex items-center justify-center mx-auto mb-6 feature-icon">
                                <i class="fas fa-user-plus text-3xl text-white"></i>
                            </div>
                            <h3 class="text-2xl font-bold text-gray-800 mb-4 text-center">Patient Portal</h3>
                            <p class="text-gray-600 mb-6 leading-relaxed text-center">
                                Register as a new patient to access our healthcare services, manage appointments, and view your medical records securely.
                            </p>
                            <ul class="space-y-2 mb-6 text-sm text-gray-600">
                                <li class="flex items-center">
                                    <i class="fas fa-check text-green-500 mr-2"></i>
                                    Easy online registration
                                </li>
                                <li class="flex items-center">
                                    <i class="fas fa-check text-green-500 mr-2"></i>
                                    Secure medical records
                                </li>
                                <li class="flex items-center">
                                    <i class="fas fa-check text-green-500 mr-2"></i>
                                    Appointment management
                                </li>
                            </ul>
                            <a href="<?php echo base_url('frontend/patient_registration'); ?>" 
                               class="block w-full text-center px-6 py-3 bg-gradient-to-r from-blue-500 to-purple-600 text-white font-semibold rounded-xl hover:from-blue-600 hover:to-purple-700 transform hover:scale-105 transition-all duration-300 shadow-lg">
                                <i class="fas fa-user-plus mr-2"></i>
                                Register as Patient
                            </a>
                        </div>
                    </div>

                    <!-- Doctor Registration -->
                    <div class="bg-white rounded-3xl shadow-xl p-8 card-hover border border-gray-100 relative overflow-hidden">
                        <div class="absolute top-0 right-0 w-32 h-32 bg-gradient-to-br from-green-500/10 to-teal-600/10 rounded-full -mr-16 -mt-16"></div>
                        <div class="relative">
                            <div class="w-20 h-20 bg-gradient-to-r from-green-500 to-teal-600 rounded-2xl flex items-center justify-center mx-auto mb-6 feature-icon">
                                <i class="fas fa-user-md text-3xl text-white"></i>
                            </div>
                            <h3 class="text-2xl font-bold text-gray-800 mb-4 text-center">Medical Professionals</h3>
                            <p class="text-gray-600 mb-6 leading-relaxed text-center">
                                Join our network of healthcare professionals. Expand your practice and provide quality care to more patients.
                            </p>
                            <ul class="space-y-2 mb-6 text-sm text-gray-600">
                                <li class="flex items-center">
                                    <i class="fas fa-check text-green-500 mr-2"></i>
                                    Expand your practice
                                </li>
                                <li class="flex items-center">
                                    <i class="fas fa-check text-green-500 mr-2"></i>
                                    Digital patient management
                                </li>
                                <li class="flex items-center">
                                    <i class="fas fa-check text-green-500 mr-2"></i>
                                    Professional network
                                </li>
                            </ul>
                            <a href="<?php echo base_url('frontend/doctor_registration'); ?>" 
                               class="block w-full text-center px-6 py-3 bg-gradient-to-r from-green-500 to-teal-600 text-white font-semibold rounded-xl hover:from-green-600 hover:to-teal-700 transform hover:scale-105 transition-all duration-300 shadow-lg">
                                <i class="fas fa-user-md mr-2"></i>
                                Join Our Network
                            </a>
                        </div>
                    </div>
                    
                    <!-- Appointment Booking -->
                    <div class="bg-white rounded-3xl shadow-xl p-8 card-hover border border-gray-100 relative overflow-hidden">
                        <div class="absolute top-0 right-0 w-32 h-32 bg-gradient-to-br from-indigo-500/10 to-purple-600/10 rounded-full -mr-16 -mt-16"></div>
                        <div class="relative">
                            <div class="w-20 h-20 bg-gradient-to-r from-indigo-500 to-purple-600 rounded-2xl flex items-center justify-center mx-auto mb-6 feature-icon">
                                <i class="fas fa-calendar-check text-3xl text-white"></i>
                            </div>
                            <h3 class="text-2xl font-bold text-gray-800 mb-4 text-center">Book Appointment</h3>
                            <p class="text-gray-600 mb-6 leading-relaxed text-center">
                                Schedule your visit with our qualified doctors. Choose from available time slots and get instant confirmation.
                            </p>
                            <ul class="space-y-2 mb-6 text-sm text-gray-600">
                                <li class="flex items-center">
                                    <i class="fas fa-check text-green-500 mr-2"></i>
                                    Real-time availability
                                </li>
                                <li class="flex items-center">
                                    <i class="fas fa-check text-green-500 mr-2"></i>
                                    Instant confirmation
                                </li>
                                <li class="flex items-center">
                                    <i class="fas fa-check text-green-500 mr-2"></i>
                                    Appointment reminders
                                </li>
                            </ul>
                            <a href="<?php echo base_url('frontend/appointment_request'); ?>" 
                               class="block w-full text-center px-6 py-3 bg-gradient-to-r from-indigo-500 to-purple-600 text-white font-semibold rounded-xl hover:from-indigo-600 hover:to-purple-700 transform hover:scale-105 transition-all duration-300 shadow-lg">
                                <i class="fas fa-calendar-check mr-2"></i>
                                Book Now
                            </a>
                        </div>
                    </div>
                    
                    <!-- Guest Appointment Booking -->
                    <div class="bg-white rounded-3xl shadow-xl p-8 card-hover border border-gray-100 relative overflow-hidden">
                        <div class="absolute top-0 right-0 w-32 h-32 bg-gradient-to-br from-yellow-500/10 to-orange-600/10 rounded-full -mr-16 -mt-16"></div>
                        <div class="relative">
                            <div class="w-20 h-20 bg-gradient-to-r from-yellow-500 to-orange-600 rounded-2xl flex items-center justify-center mx-auto mb-6 feature-icon">
                                <i class="fas fa-user-clock text-3xl text-white"></i>
                            </div>
                            <h3 class="text-2xl font-bold text-gray-800 mb-4 text-center">Book as Guest</h3>
                            <p class="text-gray-600 mb-6 leading-relaxed text-center">
                                No registration required! Book your appointment instantly and complete patient registration when you visit the hospital.
                            </p>
                            <ul class="space-y-2 mb-6 text-sm text-gray-600">
                                <li class="flex items-center">
                                    <i class="fas fa-check text-green-500 mr-2"></i>
                                    No registration needed
                                </li>
                                <li class="flex items-center">
                                    <i class="fas fa-check text-green-500 mr-2"></i>
                                    Quick booking process
                                </li>
                                <li class="flex items-center">
                                    <i class="fas fa-check text-green-500 mr-2"></i>
                                    Register at hospital
                                </li>
                            </ul>
                            <a href="<?php echo base_url('frontend/guest_appointment'); ?>" 
                               class="block w-full text-center px-6 py-3 bg-gradient-to-r from-yellow-500 to-orange-600 text-white font-semibold rounded-xl hover:from-yellow-600 hover:to-orange-700 transform hover:scale-105 transition-all duration-300 shadow-lg">
                                <i class="fas fa-user-clock mr-2"></i>
                                Book as Guest
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section class="py-20 bg-white">
        <div class="container mx-auto px-4">
            <div class="max-w-6xl mx-auto">
                <div class="text-center mb-16">
                    <div class="inline-block bg-secondary/10 text-secondary px-4 py-2 rounded-full text-sm font-medium mb-4">
                        Why Choose Us
                    </div>
                    <h2 class="text-4xl md:text-5xl font-bold text-gray-800 mb-6">
                        Advanced Healthcare Solutions
                    </h2>
                </div>

                <div class="grid md:grid-cols-3 gap-8">
                    <div class="text-center group">
                        <div class="w-20 h-20 bg-gradient-to-r from-blue-500 to-purple-600 rounded-2xl flex items-center justify-center mx-auto mb-6 feature-icon group-hover:scale-110 transition-transform duration-300">
                            <i class="fas fa-hospital text-3xl text-white"></i>
                        </div>
                        <h4 class="text-xl font-bold text-gray-800 mb-4">Multiple Hospitals</h4>
                        <p class="text-gray-600 leading-relaxed">Access services across our network of partner hospitals with unified digital platform.</p>
                    </div>
                    <div class="text-center group">
                        <div class="w-20 h-20 bg-gradient-to-r from-green-500 to-teal-600 rounded-2xl flex items-center justify-center mx-auto mb-6 feature-icon group-hover:scale-110 transition-transform duration-300">
                            <i class="fas fa-user-md text-3xl text-white"></i>
                        </div>
                        <h4 class="text-xl font-bold text-gray-800 mb-4">Expert Doctors</h4>
                        <p class="text-gray-600 leading-relaxed">Book appointments with qualified specialists across various medical fields and specialties.</p>
                    </div>
                    <div class="text-center group">
                        <div class="w-20 h-20 bg-gradient-to-r from-indigo-500 to-purple-600 rounded-2xl flex items-center justify-center mx-auto mb-6 feature-icon group-hover:scale-110 transition-transform duration-300">
                            <i class="fas fa-clock text-3xl text-white"></i>
                        </div>
                        <h4 class="text-xl font-bold text-gray-800 mb-4">Real-time Booking</h4>
                        <p class="text-gray-600 leading-relaxed">View and book available appointment slots instantly with real-time updates and confirmations.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- About Section -->
    <section id="about" class="py-20 bg-gray-50">
        <div class="container mx-auto px-4">
            <div class="max-w-6xl mx-auto">
                <div class="grid lg:grid-cols-2 gap-12 items-center">
                    <div>
                        <div class="inline-block bg-primary/10 text-primary px-4 py-2 rounded-full text-sm font-medium mb-4">
                            About <?php echo $settings->title; ?>
                        </div>
                        <h2 class="text-4xl md:text-5xl font-bold text-gray-800 mb-6">
                            Transforming Healthcare Through Technology
                        </h2>
                        <p class="text-lg text-gray-600 mb-6 leading-relaxed">
                            We're committed to making quality healthcare accessible to everyone through our innovative digital platform. Our system connects patients with medical professionals seamlessly.
                        </p>
                        <div class="space-y-4 mb-8">
                            <div class="flex items-start">
                                <div class="w-6 h-6 bg-green-500 rounded-full flex items-center justify-center mr-4 mt-1 flex-shrink-0">
                                    <i class="fas fa-check text-white text-xs"></i>
                                </div>
                                <div>
                                    <h4 class="font-semibold text-gray-800 mb-1">Digital Health Records</h4>
                                    <p class="text-gray-600">Secure and accessible medical records for better care coordination.</p>
                                </div>
                            </div>
                            <div class="flex items-start">
                                <div class="w-6 h-6 bg-green-500 rounded-full flex items-center justify-center mr-4 mt-1 flex-shrink-0">
                                    <i class="fas fa-check text-white text-xs"></i>
                                </div>
                                <div>
                                    <h4 class="font-semibold text-gray-800 mb-1">Smart Appointment System</h4>
                                    <p class="text-gray-600">Intelligent scheduling that reduces waiting times and improves efficiency.</p>
                                </div>
                            </div>
                            <div class="flex items-start">
                                <div class="w-6 h-6 bg-green-500 rounded-full flex items-center justify-center mr-4 mt-1 flex-shrink-0">
                                    <i class="fas fa-check text-white text-xs"></i>
                                </div>
                                <div>
                                    <h4 class="font-semibold text-gray-800 mb-1">Multi-Hospital Network</h4>
                                    <p class="text-gray-600">Seamless access to multiple healthcare facilities through one platform.</p>
                                </div>
                            </div>
                        </div>
                        <a href="#contact" class="inline-flex items-center px-8 py-4 bg-gradient-to-r from-primary to-secondary text-white font-semibold rounded-xl hover:from-primary-600 hover:to-secondary-600 transform hover:scale-105 transition-all duration-300 shadow-lg">
                            <i class="fas fa-arrow-right mr-2"></i>
                            Learn More
                        </a>
                    </div>
                    <div class="relative">
                        <div class="bg-gradient-to-r from-primary to-secondary rounded-3xl p-8 text-white">
                            <div class="grid grid-cols-2 gap-6">
                                <div class="text-center">
                                    <div class="text-3xl font-bold mb-2">99.9%</div>
                                    <div class="text-sm opacity-90">System Uptime</div>
                                </div>
                                <div class="text-center">
                                    <div class="text-3xl font-bold mb-2">24/7</div>
                                    <div class="text-sm opacity-90">Support Available</div>
                                </div>
                                <div class="text-center">
                                    <div class="text-3xl font-bold mb-2">256-bit</div>
                                    <div class="text-sm opacity-90">SSL Encryption</div>
                                </div>
                                <div class="text-center">
                                    <div class="text-3xl font-bold mb-2">HIPAA</div>
                                    <div class="text-sm opacity-90">Compliant</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    <section id="contact" class="py-20 bg-white">
        <div class="container mx-auto px-4">
            <div class="max-w-4xl mx-auto text-center">
                <div class="inline-block bg-primary/10 text-primary px-4 py-2 rounded-full text-sm font-medium mb-4">
                    Get in Touch
                </div>
                <h2 class="text-4xl md:text-5xl font-bold text-gray-800 mb-6">
                    Ready to Get Started?
                </h2>
                <p class="text-xl text-gray-600 mb-12 max-w-2xl mx-auto">
                    Join thousands of patients and healthcare professionals who trust our platform for their medical needs.
                </p>
                
                <div class="grid md:grid-cols-3 gap-8 mb-12">
                    <div class="text-center">
                        <div class="w-16 h-16 bg-primary/10 rounded-2xl flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-phone text-2xl text-primary"></i>
                        </div>
                        <h4 class="font-semibold text-gray-800 mb-2">Phone Support</h4>
                        <p class="text-gray-600"><?php echo $settings->phone ?? '+1-234-567-8900'; ?></p>
                    </div>
                    <div class="text-center">
                        <div class="w-16 h-16 bg-primary/10 rounded-2xl flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-envelope text-2xl text-primary"></i>
                        </div>
                        <h4 class="font-semibold text-gray-800 mb-2">Email Support</h4>
                        <p class="text-gray-600"><?php echo $settings->email ?? 'support@healthcare.com'; ?></p>
                    </div>
                    <div class="text-center">
                        <div class="w-16 h-16 bg-primary/10 rounded-2xl flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-map-marker-alt text-2xl text-primary"></i>
                        </div>
                        <h4 class="font-semibold text-gray-800 mb-2">Main Office</h4>
                        <p class="text-gray-600"><?php echo $settings->address ?? 'Healthcare Plaza, City'; ?></p>
                    </div>
                </div>

                <div class="flex flex-col sm:flex-row gap-4 justify-center">
                    <a href="<?php echo base_url('frontend/patient_registration'); ?>" class="inline-flex items-center px-8 py-4 bg-gradient-to-r from-primary to-secondary text-white font-semibold rounded-xl hover:from-primary-600 hover:to-secondary-600 transform hover:scale-105 transition-all duration-300 shadow-lg">
                        <i class="fas fa-user-plus mr-2"></i>
                        Register Now
                    </a>
                    <a href="<?php echo base_url('auth/login'); ?>" class="inline-flex items-center px-8 py-4 border-2 border-primary text-primary font-semibold rounded-xl hover:bg-primary hover:text-white transform hover:scale-105 transition-all duration-300">
                        <i class="fas fa-sign-in-alt mr-2"></i>
                        Login to Portal
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-gray-800 text-white py-12">
        <div class="container mx-auto px-4">
            <div class="max-w-6xl mx-auto">
                <div class="grid md:grid-cols-4 gap-8">
                    <div class="md:col-span-2">
                        <div class="flex items-center mb-4">
                            <div class="w-10 h-10 bg-gradient-to-r from-primary to-secondary rounded-lg flex items-center justify-center mr-3">
                                <i class="fas fa-heartbeat text-white text-lg"></i>
                            </div>
                            <span class="font-bold text-xl"><?php echo $settings->title; ?></span>
                        </div>
                        <p class="text-gray-400 mb-4 max-w-md">
                            Transforming healthcare through innovative technology solutions that connect patients and medical professionals seamlessly.
                        </p>
                        <div class="flex space-x-4">
                            <a href="#" class="w-10 h-10 bg-gray-700 rounded-lg flex items-center justify-center hover:bg-primary transition-colors duration-300">
                                <i class="fab fa-facebook-f"></i>
                            </a>
                            <a href="#" class="w-10 h-10 bg-gray-700 rounded-lg flex items-center justify-center hover:bg-primary transition-colors duration-300">
                                <i class="fab fa-twitter"></i>
                            </a>
                            <a href="#" class="w-10 h-10 bg-gray-700 rounded-lg flex items-center justify-center hover:bg-primary transition-colors duration-300">
                                <i class="fab fa-linkedin-in"></i>
                            </a>
                            <a href="#" class="w-10 h-10 bg-gray-700 rounded-lg flex items-center justify-center hover:bg-primary transition-colors duration-300">
                                <i class="fab fa-instagram"></i>
                            </a>
                        </div>
                    </div>
                    <div>
                        <h4 class="font-semibold text-lg mb-4">Quick Links</h4>
                        <ul class="space-y-2 text-gray-400">
                            <li><a href="#home" class="hover:text-white transition-colors duration-300">Home</a></li>
                            <li><a href="#services" class="hover:text-white transition-colors duration-300">Services</a></li>
                            <li><a href="#about" class="hover:text-white transition-colors duration-300">About</a></li>
                            <li><a href="<?php echo base_url('auth/login'); ?>" class="hover:text-white transition-colors duration-300">Login</a></li>
                        </ul>
                    </div>
                    <div>
                        <h4 class="font-semibold text-lg mb-4">Services</h4>
                        <ul class="space-y-2 text-gray-400">
                            <li><a href="<?php echo base_url('frontend/patient_registration'); ?>" class="hover:text-white transition-colors duration-300">Patient Registration</a></li>
                            <li><a href="<?php echo base_url('frontend/doctor_registration'); ?>" class="hover:text-white transition-colors duration-300">Doctor Registration</a></li>
                            <li><a href="<?php echo base_url('frontend/appointment_request'); ?>" class="hover:text-white transition-colors duration-300">Book Appointment</a></li>
                        </ul>
                    </div>
                </div>
                <div class="border-t border-gray-700 pt-8 mt-8 text-center text-gray-400">
                    <p>&copy; <?php echo date('Y'); ?> <?php echo $settings->title; ?>. All rights reserved. | Powered by Healthcare Management System</p>
                </div>
            </div>
        </div>
    </footer>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        // Mobile menu functionality
        document.getElementById('mobile-menu-button').addEventListener('click', function() {
            const mobileMenu = document.getElementById('mobile-menu');
            const icon = this.querySelector('i');
            
            if (mobileMenu.classList.contains('hidden')) {
                mobileMenu.classList.remove('hidden');
                icon.classList.remove('fa-bars');
                icon.classList.add('fa-times');
            } else {
                mobileMenu.classList.add('hidden');
                icon.classList.remove('fa-times');
                icon.classList.add('fa-bars');
            }
        });

        // Smooth scrolling for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });

        // Add scroll effect to navbar
        window.addEventListener('scroll', function() {
            const navbar = document.querySelector('nav');
            if (window.scrollY > 50) {
                navbar.classList.add('bg-white/98');
                navbar.classList.remove('bg-white/95');
            } else {
                navbar.classList.add('bg-white/95');
                navbar.classList.remove('bg-white/98');
            }
        });

        // Animation on scroll
        const observerOptions = {
            threshold: 0.1,
            rootMargin: '0px 0px -50px 0px'
        };

        const observer = new IntersectionObserver(function(entries) {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateY(0)';
                }
            });
        }, observerOptions);

        // Observe elements for animation
        document.querySelectorAll('.card-hover, .feature-icon').forEach(el => {
            el.style.opacity = '0';
            el.style.transform = 'translateY(20px)';
            el.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
            observer.observe(el);
        });
    </script>
</body>
</html> 