<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Guest Appointment Confirmation - <?php echo $settings->title; ?></title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <style>
        @media print {
            .no-print { display: none !important; }
            .print-only { display: block !important; }
            body { background: white !important; }
            .container { max-width: 100% !important; margin: 0 !important; padding: 0 !important; }
        }
        .print-only { display: none; }
        
        .confirmation-card {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            border-radius: 20px;
            color: white;
            box-shadow: 0 15px 35px rgba(40, 167, 69, 0.1);
        }
        
        .detail-card {
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.08);
            transition: transform 0.2s ease;
        }
        
        .detail-card:hover {
            transform: translateY(-2px);
        }
        
        .status-badge {
            background: linear-gradient(45deg, #ffc107, #fd7e14);
            border-radius: 25px;
            padding: 8px 20px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .btn-action {
            border-radius: 12px;
            padding: 12px 24px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-action:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
        }
        
        .guest-badge {
            background: linear-gradient(45deg, #17a2b8, #6f42c1);
            color: white;
            border-radius: 20px;
            padding: 5px 15px;
            font-size: 0.8rem;
            font-weight: 600;
        }
    </style>
</head>
<body class="bg-gray-50">
    <!-- Navigation -->
    <nav class="backdrop-blur-md shadow-lg fixed w-full top-0 z-50 no-print">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center h-16">
                <!-- Logo -->
                <div class="flex items-center">
                    <a href="<?php echo base_url('frontend/public_portal'); ?>" class="flex items-center">
                        <div class="w-8 h-8 bg-gradient-to-r from-primary to-secondary rounded-lg flex items-center justify-center mr-3">
                            <i class="fas fa-hospital text-white text-sm"></i>
                        </div>
                        <span class="font-bold text-xl text-white"><?php echo $settings->title; ?></span>
                    </a>
                </div>
                
                <!-- Navigation Links -->
                <div class="hidden md:flex items-center space-x-6">
                    <a href="<?php echo base_url('frontend/public_portal'); ?>" class="text-white hover:text-blue-200 transition-colors duration-200 font-medium">
                        <i class="fas fa-home mr-2"></i>Home
                    </a>
                    <a href="<?php echo base_url('frontend/guest_appointment'); ?>" class="text-white hover:text-blue-200 transition-colors duration-200 font-medium">
                        <i class="fas fa-calendar-plus mr-2"></i>Book Another
                    </a>
                </div>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <div class="container mx-auto px-4 py-8 mt-20">
        <!-- Success Header -->
        <div class="confirmation-card p-8 mb-8 text-center">
            <div class="mb-4">
                <div class="w-20 h-20 bg-white bg-opacity-20 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-user-clock text-4xl text-white"></i>
                </div>
                <h1 class="text-3xl font-bold mb-2">Guest Appointment Submitted!</h1>
                <p class="text-lg opacity-90">Your appointment request has been received and is pending registration</p>
                <div class="guest-badge mt-3 d-inline-block">
                    <i class="fas fa-user-friends mr-2"></i>Guest Appointment
                </div>
            </div>
            
            <div class="row g-4 text-left">
                <div class="col-md-6">
                    <div class="bg-white bg-opacity-20 rounded-lg p-4">
                        <h6 class="text-dark fw-bold mb-1" style="font-size: 0.9rem;">Appointment Date</h6>
                        <p class="text-dark fw-bold mb-0" style="font-size: 1.3rem;"><?php echo date('l, F j, Y', $appointment->date); ?></p>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="bg-white bg-opacity-20 rounded-lg p-4">
                        <h6 class="text-dark fw-bold mb-1" style="font-size: 0.9rem;">Time Slot</h6>
                        <p class="text-dark fw-bold mb-0" style="font-size: 1.3rem;"><?php echo date('g:i A', strtotime($appointment->time)); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Print/Download Actions -->
        <div class="text-center mb-6 no-print">
            <button onclick="window.print()" class="btn btn-primary btn-action me-3">
                <i class="fas fa-print me-2"></i>Print Details
            </button>
            <a href="<?php echo base_url('frontend/public_portal'); ?>" class="btn btn-outline-secondary btn-action">
                <i class="fas fa-home me-2"></i>Back to Home
            </a>
        </div>

        <!-- Appointment Details -->
        <div class="row g-4">
            <!-- Guest Information -->
            <div class="col-lg-6">
                <div class="detail-card bg-white p-6 h-100">
                    <h4 class="text-primary mb-4">
                        <i class="fas fa-user-circle me-2"></i>Guest Information
                    </h4>
                    <div class="row g-3">
                        <div class="col-sm-6">
                            <label class="form-label text-secondary small fw-bold">Full Name</label>
                            <p class="fw-semibold text-dark"><?php echo $appointment->guest_name; ?></p>
                        </div>
                        <div class="col-sm-6">
                            <label class="form-label text-secondary small fw-bold">Phone Number</label>
                            <p class="fw-semibold text-dark"><?php echo $appointment->guest_phone; ?></p>
                        </div>
                        <?php if (!empty($appointment->guest_email)): ?>
                        <div class="col-sm-6">
                            <label class="form-label text-secondary small fw-bold">Email</label>
                            <p class="fw-semibold text-dark"><?php echo $appointment->guest_email; ?></p>
                        </div>
                        <?php endif; ?>
                        <div class="col-sm-6">
                            <label class="form-label text-secondary small fw-bold">Age</label>
                            <p class="fw-semibold text-dark"><?php echo $appointment->guest_age; ?> years</p>
                        </div>
                        <div class="col-sm-6">
                            <label class="form-label text-secondary small fw-bold">Gender</label>
                            <p class="fw-semibold text-dark"><?php echo $appointment->guest_gender; ?></p>
                        </div>
                        <?php if (!empty($appointment->guest_emergency_contact)): ?>
                        <div class="col-sm-6">
                            <label class="form-label text-secondary small fw-bold">Emergency Contact</label>
                            <p class="fw-semibold text-dark"><?php echo $appointment->guest_emergency_contact; ?></p>
                        </div>
                        <?php endif; ?>
                        <?php if (!empty($appointment->guest_address)): ?>
                        <div class="col-12">
                            <label class="form-label text-secondary small fw-bold">Address</label>
                            <p class="fw-semibold text-dark"><?php echo $appointment->guest_address; ?></p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Doctor Information -->
            <div class="col-lg-6">
                <div class="detail-card bg-white p-6 h-100">
                    <h4 class="text-primary mb-4">
                        <i class="fas fa-user-md me-2"></i>Doctor Information
                    </h4>
                    <div class="row g-3">
                        <div class="col-12">
                            <label class="form-label text-secondary small fw-bold">Doctor Name</label>
                            <p class="fw-semibold text-dark"><?php echo $doctor->name; ?></p>
                        </div>
                        <?php if (!empty($doctor->speciality)): ?>
                        <div class="col-sm-6">
                            <label class="form-label text-secondary small fw-bold">Specialization</label>
                            <p class="fw-semibold text-dark"><?php echo $doctor->speciality; ?></p>
                        </div>
                        <?php endif; ?>
                        <?php if (!empty($doctor->phone)): ?>
                        <div class="col-sm-6">
                            <label class="form-label text-secondary small fw-bold">Contact</label>
                            <p class="fw-semibold text-dark"><?php echo $doctor->phone; ?></p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Appointment Details -->
            <div class="col-lg-8">
                <div class="detail-card bg-white p-6">
                    <h4 class="text-primary mb-4">
                        <i class="fas fa-calendar-check me-2"></i>Appointment Details
                    </h4>
                    <div class="row g-3">
                        <div class="col-sm-6">
                            <label class="form-label text-secondary small fw-bold">Appointment ID</label>
                            <p class="fw-semibold text-dark">#<?php echo str_pad($appointment->id, 6, '0', STR_PAD_LEFT); ?></p>
                        </div>
                        <div class="col-sm-6">
                            <label class="form-label text-secondary small fw-bold">Status</label>
                            <p><span class="status-badge text-white"><?php echo $appointment->status; ?></span></p>
                        </div>
                        <div class="col-sm-6">
                            <label class="form-label text-secondary small fw-bold">Hospital</label>
                            <p class="fw-semibold text-dark"><?php echo $hospital->name ?? 'N/A'; ?></p>
                        </div>
                        <div class="col-sm-6">
                            <label class="form-label text-secondary small fw-bold">Booking Source</label>
                            <p class="fw-semibold text-dark">Online Guest</p>
                        </div>
                        <?php if (!empty($appointment->remarks)): ?>
                        <div class="col-12">
                            <label class="form-label text-secondary small fw-bold">Problem/Remarks</label>
                            <p class="fw-semibold text-dark"><?php echo $appointment->remarks; ?></p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Next Steps -->
            <div class="col-lg-4">
                <div class="detail-card bg-light border-start border-warning border-4 p-6">
                    <h4 class="text-warning mb-4">
                        <i class="fas fa-exclamation-circle me-2"></i>Next Steps
                    </h4>
                    <div class="d-flex align-items-center mb-3">
                        <div class="flex-shrink-0">
                            <div class="w-8 h-8 bg-warning rounded-full d-flex align-items-center justify-content-center me-3">
                                <span class="text-white fw-bold">1</span>
                            </div>
                        </div>
                        <p class="mb-0 small">Hospital will contact you to confirm appointment</p>
                    </div>
                    <div class="d-flex align-items-center mb-3">
                        <div class="flex-shrink-0">
                            <div class="w-8 h-8 bg-warning rounded-full d-flex align-items-center justify-content-center me-3">
                                <span class="text-white fw-bold">2</span>
                            </div>
                        </div>
                        <p class="mb-0 small">Arrive 15 minutes early with valid ID</p>
                    </div>
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="w-8 h-8 bg-warning rounded-full d-flex align-items-center justify-content-center me-3">
                                <span class="text-white fw-bold">3</span>
                            </div>
                        </div>
                        <p class="mb-0 small">Complete patient registration at hospital</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Important Notes -->
        <div class="detail-card bg-info bg-opacity-10 border-start border-info border-4 p-4 mt-4">
            <h5 class="text-info mb-3">
                <i class="fas fa-info-circle me-2"></i>Important Information
            </h5>
            <ul class="list-unstyled mb-0">
                <li class="mb-2"><i class="fas fa-clock text-info me-2"></i><strong>Pending Status:</strong> Your appointment is currently pending admin approval and patient registration</li>
                <li class="mb-2"><i class="fas fa-phone text-info me-2"></i><strong>Confirmation Call:</strong> Hospital staff will contact you within 24 hours to confirm your appointment</li>
                <li class="mb-2"><i class="fas fa-id-card text-info me-2"></i><strong>Registration Required:</strong> You must complete patient registration when you arrive at the hospital</li>
                <li class="mb-2"><i class="fas fa-money-bill text-info me-2"></i><strong>Payment:</strong> Consultation fees will be collected after registration at the hospital</li>
                <li class="mb-0"><i class="fas fa-calendar-times text-info me-2"></i><strong>Cancellation:</strong> To cancel, please call the hospital directly at <?php echo $hospital->phone ?? $settings->phone; ?></li>
            </ul>
        </div>

        <!-- Print Footer -->
        <div class="print-only mt-5 pt-4 border-top text-center">
            <p class="text-secondary fw-semibold mb-1">Generated on: <?php echo date('F j, Y \a\t g:i A'); ?></p>
            <p class="text-secondary fw-semibold"><?php echo $settings->title; ?> - <?php echo $settings->address; ?></p>
            <p class="text-muted small mt-2">This is a guest appointment confirmation. Patient registration required upon arrival.</p>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Add some animation on load
        document.addEventListener('DOMContentLoaded', function() {
            const cards = document.querySelectorAll('.detail-card');
            cards.forEach((card, index) => {
                setTimeout(() => {
                    card.style.opacity = '0';
                    card.style.transform = 'translateY(20px)';
                    card.style.transition = 'all 0.5s ease';
                    setTimeout(() => {
                        card.style.opacity = '1';
                        card.style.transform = 'translateY(0)';
                    }, 100);
                }, index * 100);
            });
        });
    </script>
</body>
</html>