<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Appointment Confirmation - <?php echo $settings->title; ?></title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <style>
        @media print {
            .no-print { display: none !important; }
            .print-only { display: block !important; }
            body { background: white !important; }
            .container { max-width: 100% !important; margin: 0 !important; padding: 0 !important; }
        }
        .print-only { display: none; }
        
        .confirmation-card {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 20px;
            color: white;
            box-shadow: 0 15px 35px rgba(102, 126, 234, 0.1);
        }
        
        .detail-card {
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.08);
            transition: transform 0.2s ease;
        }
        
        .detail-card:hover {
            transform: translateY(-2px);
        }
        
        .status-badge {
            background: linear-gradient(45deg, #28a745, #20c997);
            border-radius: 25px;
            padding: 8px 20px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .qr-placeholder {
            width: 120px;
            height: 120px;
            background: #f8f9fa;
            border: 2px dashed #dee2e6;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #6c757d;
        }
        
        .btn-action {
            border-radius: 12px;
            padding: 12px 24px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-action:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
        }
        
        /* Enhanced text contrast */
        .text-enhanced {
            color: #2d3748 !important;
            font-weight: 600 !important;
        }
        
        .label-enhanced {
            color: #4a5568 !important;
            font-weight: 700 !important;
        }
        
        /* Enhanced header text visibility */
        .confirmation-card .text-dark {
            text-shadow: none;
            color: #212529 !important;
        }
        
        /* Print specific enhancements */
        @media print {
            .text-secondary { color: #495057 !important; }
            .text-dark { color: #212529 !important; }
            .fw-semibold { font-weight: 600 !important; }
            .fw-bold { font-weight: 700 !important; }
            
            /* Print header with better contrast */
            .confirmation-card {
                background: #667eea !important;
                color: white !important;
            }
            .confirmation-card .text-dark {
                color: #212529 !important;
                text-shadow: none !important;
            }
            .confirmation-card .bg-white {
                background: rgba(255, 255, 255, 0.9) !important;
            }
        }
    </style>
</head>
<body class="bg-gray-50">
    <!-- Navigation -->
    <nav class="backdrop-blur-md shadow-lg fixed w-full top-0 z-50 no-print">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center h-16">
                <!-- Logo -->
                <div class="flex items-center">
                    <a href="<?php echo base_url('frontend/public_portal'); ?>" class="flex items-center">
                        <div class="w-8 h-8 bg-gradient-to-r from-primary to-secondary rounded-lg flex items-center justify-center mr-3">
                            <i class="fas fa-hospital text-white text-sm"></i>
                        </div>
                        <span class="font-bold text-xl text-white"><?php echo $settings->title; ?></span>
                    </a>
                </div>
                
                <!-- Navigation Links -->
                <div class="hidden md:flex items-center space-x-6">
                    <a href="<?php echo base_url('frontend/public_portal'); ?>" class="text-white hover:text-blue-200 transition-colors duration-200 font-medium">
                        <i class="fas fa-home mr-2"></i>Home
                    </a>
                    <a href="<?php echo base_url('frontend/appointment_request'); ?>" class="text-white hover:text-blue-200 transition-colors duration-200 font-medium">
                        <i class="fas fa-calendar-plus mr-2"></i>Book Another
                    </a>
                </div>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <div class="container mx-auto px-4 py-8 mt-20">
        <!-- Success Header -->
        <div class="confirmation-card p-8 mb-8 text-center">
            <div class="mb-4">
                <div class="w-20 h-20 bg-white bg-opacity-20 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-check-circle text-4xl text-white"></i>
                </div>
                <h1 class="text-3xl font-bold mb-2">Appointment Confirmed!</h1>
                <p class="text-lg opacity-90">Your appointment has been successfully scheduled</p>
            </div>
            
            <div class="row g-4 text-left">
                <div class="col-md-6">
                    <div class="bg-white bg-opacity-20 rounded-lg p-4">
                        <h6 class="text-dark fw-bold mb-1" style="font-size: 0.9rem;">Appointment Date</h6>
                        <p class="text-dark fw-bold mb-0" style="font-size: 1.3rem;"><?php echo date('l, F j, Y', $appointment->date); ?></p>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="bg-white bg-opacity-20 rounded-lg p-4">
                        <h6 class="text-dark fw-bold mb-1" style="font-size: 0.9rem;">Time Slot</h6>
                        <p class="text-dark fw-bold mb-0" style="font-size: 1.3rem;"><?php echo date('g:i A', strtotime($appointment->time)); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Print/Download Actions -->
        <div class="text-center mb-6 no-print">
            <button onclick="window.print()" class="btn btn-primary btn-action me-3">
                <i class="fas fa-print me-2"></i>Print Details
            </button>
            <button onclick="downloadPDF()" class="btn btn-success btn-action me-3">
                <i class="fas fa-download me-2"></i>Download PDF
            </button>
            <a href="<?php echo base_url('frontend/public_portal'); ?>" class="btn btn-outline-secondary btn-action">
                <i class="fas fa-home me-2"></i>Back to Home
            </a>
        </div>

        <!-- Appointment Details -->
        <div class="row g-4">
            <!-- Patient Information -->
            <div class="col-lg-6">
                <div class="detail-card bg-white p-6 h-100">
                    <h4 class="text-primary mb-4">
                        <i class="fas fa-user-circle me-2"></i>Patient Information
                    </h4>
                    <div class="row g-3">
                        <div class="col-sm-6">
                            <label class="form-label text-secondary small fw-bold">Full Name</label>
                            <p class="fw-semibold text-dark"><?php echo $patient->name; ?></p>
                        </div>
                        <div class="col-sm-6">
                            <label class="form-label text-secondary small fw-bold">Phone Number</label>
                            <p class="fw-semibold text-dark"><?php echo $patient->phone; ?></p>
                        </div>
                        <?php if (!empty($patient->email)): ?>
                        <div class="col-sm-6">
                            <label class="form-label text-secondary small fw-bold">Email</label>
                            <p class="fw-semibold text-dark"><?php echo $patient->email; ?></p>
                        </div>
                        <?php endif; ?>
                        <div class="col-sm-6">
                            <label class="form-label text-secondary small fw-bold">Patient ID</label>
                            <p class="fw-semibold text-dark"><?php echo $patient->patient_id ?? 'N/A'; ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Doctor Information -->
            <div class="col-lg-6">
                <div class="detail-card bg-white p-6 h-100">
                    <h4 class="text-primary mb-4">
                        <i class="fas fa-user-md me-2"></i>Doctor Information
                    </h4>
                    <div class="row g-3">
                        <div class="col-12">
                            <label class="form-label text-secondary small fw-bold">Doctor Name</label>
                            <p class="fw-semibold text-dark"><?php echo $doctor->name; ?></p>
                        </div>
                        <?php if (!empty($doctor->speciality)): ?>
                        <div class="col-sm-6">
                            <label class="form-label text-secondary small fw-bold">Specialization</label>
                            <p class="fw-semibold text-dark"><?php echo $doctor->speciality; ?></p>
                        </div>
                        <?php endif; ?>
                        <?php if (!empty($doctor->phone)): ?>
                        <div class="col-sm-6">
                            <label class="form-label text-secondary small fw-bold">Contact</label>
                            <p class="fw-semibold text-dark"><?php echo $doctor->phone; ?></p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Appointment Details -->
            <div class="col-lg-8">
                <div class="detail-card bg-white p-6">
                    <h4 class="text-primary mb-4">
                        <i class="fas fa-calendar-check me-2"></i>Appointment Details
                    </h4>
                    <div class="row g-3">
                        <div class="col-sm-6">
                            <label class="form-label text-secondary small fw-bold">Appointment ID</label>
                            <p class="fw-semibold text-dark">#<?php echo str_pad($appointment->id, 6, '0', STR_PAD_LEFT); ?></p>
                        </div>
                        <div class="col-sm-6">
                            <label class="form-label text-secondary small fw-bold">Status</label>
                            <p><span class="status-badge text-white"><?php echo $appointment->status; ?></span></p>
                        </div>
                        <div class="col-sm-6">
                            <label class="form-label text-secondary small fw-bold">Hospital</label>
                            <p class="fw-semibold text-dark"><?php echo $hospital->name ?? 'N/A'; ?></p>
                        </div>
                        <?php if (!empty($visit_type)): ?>
                        <div class="col-sm-6">
                            <label class="form-label text-secondary small fw-bold">Visit Type</label>
                            <p class="fw-semibold text-dark"><?php echo $visit_type->visit_description; ?></p>
                        </div>
                        <?php endif; ?>
                        <?php if (!empty($appointment->symptoms)): ?>
                        <div class="col-12">
                            <label class="form-label text-secondary small fw-bold">Symptoms/Problem</label>
                            <p class="fw-semibold text-dark"><?php echo $appointment->symptoms; ?></p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Payment Information -->
            <div class="col-lg-4">
                <div class="detail-card bg-white p-6">
                    <h4 class="text-primary mb-4">
                        <i class="fas fa-credit-card me-2"></i>Payment Details
                    </h4>
                    <?php if ($payment && $payment->gross_total > 0): ?>
                        <div class="mb-3">
                            <label class="form-label text-secondary small fw-bold">Consultation Fee</label>
                            <p class="fw-semibold fs-5 text-dark"><?php echo $settings->currency; ?> <?php echo number_format($payment->gross_total, 2); ?></p>
                        </div>
                        <div class="mb-3">
                            <label class="form-label text-secondary small fw-bold">Payment Status</label>
                            <?php 
                            $total_deposited = $this->finance_model->getDepositAmountByPaymentId($payment->id) ?? 0;
                            $total_due = $payment->gross_total - $total_deposited;
                            if ($total_due <= 0): ?>
                                <p><span class="badge bg-success fs-6">Paid</span></p>
                            <?php else: ?>
                                <p><span class="badge bg-warning fs-6">Due: <?php echo $settings->currency; ?> <?php echo number_format($total_due, 2); ?></span></p>
                            <?php endif; ?>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-4">
                            <i class="fas fa-gift text-success fs-1 mb-3"></i>
                            <p class="fw-semibold text-success fs-5">Free Consultation</p>
                            <small class="text-secondary fw-bold">No payment required</small>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Important Notes -->
        <div class="detail-card bg-light border-start border-primary border-4 p-4 mt-4">
            <h5 class="text-primary mb-3">
                <i class="fas fa-info-circle me-2"></i>Important Notes
            </h5>
            <ul class="list-unstyled mb-0">
                <li class="mb-2"><i class="fas fa-check text-success me-2"></i>Please arrive 15 minutes before your appointment time</li>
                <li class="mb-2"><i class="fas fa-check text-success me-2"></i>Bring your ID and any relevant medical documents</li>
                <li class="mb-2"><i class="fas fa-check text-success me-2"></i>If you need to cancel, please do so at least 24 hours in advance</li>
                <li class="mb-0"><i class="fas fa-check text-success me-2"></i>For emergency contact: <?php echo $hospital->phone ?? $settings->phone; ?></li>
            </ul>
        </div>

        <!-- Print Footer -->
        <div class="print-only mt-5 pt-4 border-top text-center">
            <p class="text-secondary fw-semibold mb-1">Generated on: <?php echo date('F j, Y \a\t g:i A'); ?></p>
            <p class="text-secondary fw-semibold"><?php echo $settings->title; ?> - <?php echo $settings->address; ?></p>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
    
    <script>
        function downloadPDF() {
            // Hide no-print elements
            const noPrintElements = document.querySelectorAll('.no-print');
            noPrintElements.forEach(el => el.style.display = 'none');
            
            // Show print-only elements
            const printOnlyElements = document.querySelectorAll('.print-only');
            printOnlyElements.forEach(el => el.style.display = 'block');
            
            // Generate PDF
            window.jsPDF = window.jspdf.jsPDF;
            const pdf = new jsPDF();
            
            html2canvas(document.body, {
                scale: 0.8,
                useCORS: true,
                allowTaint: true
            }).then(function(canvas) {
                const imgData = canvas.toDataURL('image/png');
                const imgWidth = 190;
                const pageHeight = 297;
                const imgHeight = (canvas.height * imgWidth) / canvas.width;
                let heightLeft = imgHeight;
                let position = 10;

                pdf.addImage(imgData, 'PNG', 10, position, imgWidth, imgHeight);
                heightLeft -= pageHeight;

                while (heightLeft >= 0) {
                    position = heightLeft - imgHeight + 10;
                    pdf.addPage();
                    pdf.addImage(imgData, 'PNG', 10, position, imgWidth, imgHeight);
                    heightLeft -= pageHeight;
                }

                pdf.save('appointment-confirmation-<?php echo $appointment->id; ?>.pdf');
                
                // Restore original display
                noPrintElements.forEach(el => el.style.display = '');
                printOnlyElements.forEach(el => el.style.display = 'none');
            });
        }

        // Add some animation on load
        document.addEventListener('DOMContentLoaded', function() {
            const cards = document.querySelectorAll('.detail-card');
            cards.forEach((card, index) => {
                setTimeout(() => {
                    card.style.opacity = '0';
                    card.style.transform = 'translateY(20px)';
                    card.style.transition = 'all 0.5s ease';
                    setTimeout(() => {
                        card.style.opacity = '1';
                        card.style.transform = 'translateY(0)';
                    }, 100);
                }, index * 100);
            });
        });
    </script>
</body>
</html>