<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Public extends MX_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('doctor/doctor_model');
        $this->load->model('patient/patient_model');
        $this->load->model('hospital/hospital_model');
        $this->load->model('speciality/speciality_model');
        $this->load->model('department/department_model');
        $this->load->model('appointment/appointment_model');
        $this->load->model('schedule/schedule_model');
        $this->load->model('settings/settings_model');
        $language = $this->db->get('settings')->row()->language;
        $this->lang->load('system_syntax', $language);
    }

    function index()
    {
        $data['settings'] = $this->settings_model->getSettings();
        $data['hospitals'] = $this->hospital_model->getHospital();
        $this->load->view('public/index', $data);
    }

    function patient_registration()
    {
        $data['settings'] = $this->settings_model->getSettings();
        $data['hospitals'] = $this->hospital_model->getHospital();
        $this->load->view('public/patient_registration', $data);
    }

    function appointment_request()
    {
        $data['settings'] = $this->settings_model->getSettings();
        $data['hospitals'] = $this->hospital_model->getHospital();
        $data['specialities'] = $this->speciality_model->getAllActiveSpecialities();
        $this->load->view('public/appointment_request', $data);
    }

    function check_existing_patient()
    {
        $email = $this->input->post('email');
        $phone = $this->input->post('phone');
        
        $patient = null;
        if (!empty($email)) {
            $patient = $this->patient_model->getPatientByEmail($email);
        }
        
        if (!$patient && !empty($phone)) {
            $this->db->where('phone', $phone);
            $patient = $this->db->get('patient')->row();
        }

        if ($patient) {
            $hospital_name = '';
            if (!empty($patient->hospital_id)) {
                $hospital = $this->db->get_where('hospital', array('id' => $patient->hospital_id))->row();
                if ($hospital) {
                    $hospital_name = $hospital->name;
                }
            }
            
            echo json_encode(array(
                'exists' => true,
                'patient' => array(
                    'id' => $patient->id,
                    'name' => $patient->name,
                    'email' => $patient->email,
                    'phone' => $patient->phone,
                    'hospital_id' => $patient->hospital_id,
                    'hospital_name' => $hospital_name
                )
            ));
        } else {
            echo json_encode(array('exists' => false));
        }
    }

    function register_patient()
    {
        $name = $this->input->post('name');
        $email = $this->input->post('email');
        $phone = $this->input->post('phone');
        $address = $this->input->post('address');
        $age = $this->input->post('age');
        $sex = $this->input->post('sex');
        $hospital_id = $this->input->post('hospital_id');
        
        // Create patient data
        $patient_data = array(
            'name' => $name,
            'email' => $email,
            'phone' => $phone,
            'address' => $address,
            'age' => $age,
            'sex' => $sex,
            'hospital_id' => $hospital_id,
            'patient_id' => 'P' . time(),
            'add_date' => date('Y-m-d H:i:s')
        );

        $this->db->insert('patient', $patient_data);
        $patient_id = $this->db->insert_id();

        echo json_encode(array(
            'success' => true,
            'patient_id' => $patient_id,
            'message' => 'Patient registered successfully!'
        ));
    }

    function get_specialities_by_hospital()
    {
        $hospital_id = $this->input->post('hospital_id');
        
        // Get all active specialities (since we now show all doctors from all hospitals)
        $specialities = $this->speciality_model->getAllActiveSpecialities();
        
        echo json_encode($specialities);
    }

    function get_doctors_by_speciality()
    {
        $hospital_id = $this->input->post('hospital_id');
        $speciality_id = $this->input->post('speciality_id');
        
        $this->db->select('doctor.*, hospital.name as hospital_name');
        $this->db->from('doctor');
        $this->db->join('hospital', 'doctor.hospital_id = hospital.id', 'left');
        if (!empty($speciality_id)) {
            $this->db->where('doctor.speciality_id', $speciality_id);
        }
        $this->db->where('doctor.available', 1); // Only show available doctors
        $doctors = $this->db->get()->result();
        
        echo json_encode($doctors);
    }

    function get_available_slots()
    {
        $doctor_id = $this->input->post('doctor_id');
        $date = $this->input->post('date');
        
        $weekday = date("l", strtotime($date));
        $date_timestamp = strtotime($date);
        
        // Check if doctor is on holiday
        $this->db->where('date', $date_timestamp);
        $this->db->where('doctor', $doctor_id);
        $holiday = $this->db->get('holidays')->row();
        
        if ($holiday) {
            echo json_encode(array());
            return;
        }
        
        // Get doctor's time slots for this weekday
        $this->db->where('doctor', $doctor_id);
        $this->db->where('weekday', $weekday);
        $this->db->order_by('s_time_key', 'asc');
        $time_slots = $this->db->get('time_slot')->result();
        
        if (empty($time_slots)) {
            echo json_encode(array());
            return;
        }
        
        // Get booked appointments for this date and doctor
        $this->db->where('doctor', $doctor_id);
        $this->db->where('date', $date);
        $this->db->where('status !=', 'Cancelled');
        $booked_appointments = $this->db->get('appointment')->result();
        
        $booked_slots = array();
        foreach ($booked_appointments as $appointment) {
            $booked_slots[] = $appointment->time_slot;
        }
        
        // Prepare available slots
        $available_slots = array();
        foreach ($time_slots as $slot) {
            $slot_text = $slot->s_time . ' To ' . $slot->e_time;
            if (!in_array($slot_text, $booked_slots)) {
                $available_slots[] = array(
                    'slot' => $slot_text,
                    'start_time' => $slot->s_time,
                    'end_time' => $slot->e_time
                );
            }
        }
        
        echo json_encode($available_slots);
    }

    function book_appointment()
    {
        $patient_id = $this->input->post('patient_id');
        $doctor_id = $this->input->post('doctor_id');
        $hospital_id = $this->input->post('hospital_id');
        $date = $this->input->post('date');
        $time_slot = $this->input->post('time_slot');
        $problem = $this->input->post('problem');
        
        // Get patient and doctor details
        $patient = $this->patient_model->getPatientById($patient_id);
        $doctor = $this->doctor_model->getDoctorById($doctor_id);
        
        $appointment_data = array(
            'patient' => $patient_id,
            'doctor' => $doctor_id,
            'hospital_id' => $hospital_id,
            'date' => $date,
            'time_slot' => $time_slot,
            'problem' => $problem,
            'patientname' => $patient->name,
            'doctorname' => $doctor->name,
            'status' => 'Confirmed',
            'add_date' => date('Y-m-d H:i:s'),
            'timestamp' => strtotime($date)
        );

        $this->db->insert('appointment', $appointment_data);
        $appointment_id = $this->db->insert_id();

        echo json_encode(array(
            'success' => true,
            'appointment_id' => $appointment_id,
            'message' => 'Appointment booked successfully!'
        ));
    }
} 