<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

use Twilio\Rest\Client;

class Frontend extends MX_Controller
{

    function __construct()
    {
        parent::__construct();

        $this->load->model('frontend_model');
        $this->load->model('doctor/doctor_model');
        $this->load->model('hospital/package_model');
        $this->load->model('patient/patient_model');
        $this->load->model('frontend/slide_model');
        $this->load->model('frontend/service_model');
        $this->load->model('featured/featured_model');
        $this->load->model('appointment/appointment_model');
        $this->load->model('finance/finance_model');
        require APPPATH . 'third_party/stripe/stripe-php/init.php';
        $this->load->module('paypal');
        $this->load->model('email/email_model');
        $this->load->model('pgateway/pgateway_model');
        $this->load->model('hospital/hospital_model');
        $this->load->model('donor/donor_model');
        $this->load->model('sms/sms_model');
        $this->load->model('settings/settings_model');
        $this->load->model('facilitie/facilitie_model');
        $this->load->model('faq/faq_model');
        $this->load->model('speciality/speciality_model');
    }

    public function index()
    {
        $data['settings'] = $this->db->get_where('settings', ['hospital_id' => 'superadmin'])->row();
        $data['hospitals'] = $this->hospital_model->getHospital();
        $this->load->view('public/index', $data);
    }

    public function frontend2()
    {
        $data = array();
        $data['contact_message'] = $this->input->get('contact_message');
        $data['hospital_message'] = $this->input->get('hospital_message');
        $data['doctors'] = $this->doctor_model->getDoctor();
        $data['packages'] = $this->package_model->getPackage();
        $data['slides'] = $this->slide_model->getSlide();
        $data['services'] = $this->service_model->getService();
        $data['featureds'] = $this->featured_model->getFeatured();
        $data['settings1'] = $this->db->get_where('settings', array('hospital_id' => 'superadmin'))->row();
        $data['gateway'] = $this->db->get_where('paymentGateway', array('name' => $data['settings1']->payment_gateway, 'hospital_id' => 'superadmin'))->row();
        $this->load->view('front_end', $data);
        // $this->load->view('index', $data);
    }

    function sendHutchSMS()
    {
        $username = "ashankodagodasl@gmail.com"; // your Hutch username
        $password = "C4Z2s73AHfdE6pv@"; // your Hutch password
        $mask     = "CyberGrab"; // pre-approved sender ID
        $number   = "94777033678";
        $message  = "This is a test message from Hutch sms";
        $campaign = "Test Campaign";

        // 1. Login to get access token
        $loginUrl = "https://bsms.hutch.lk/api/login";
        $loginData = [
            "username" => $username,
            "password" => $password
        ];

        $ch = curl_init($loginUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Content-Type: application/json",
            "Accept: */*",
            "X-API-VERSION: v1"
        ]);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($loginData));
        $loginResponse = curl_exec($ch);
        curl_close($ch);

        $loginResult = json_decode($loginResponse, true);

        if (empty($loginResult['accessToken'])) {
            echo "Login failed: " . $loginResponse;
            return;
        }

        $accessToken = $loginResult['accessToken'];

        // 2. Send SMS using access token
        $smsUrl = "https://bsms.hutch.lk/api/sendsms";
        $smsData = [
            "campaignName" => $campaign,
            "mask" => $mask,
            "numbers" => $number,
            "content" => $message,
            "deliveryReportRequest" => true
        ];

        $ch = curl_init($smsUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Content-Type: application/json",
            "Accept: */*",
            "X-API-VERSION: v1",
            "Authorization: Bearer " . $accessToken
        ]);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($smsData));
        $smsResponse = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        echo "HTTP Code: " . $httpCode . "<br>";
        echo "Response: " . $smsResponse;
    }








    function testSmsDemo()
    {


        error_reporting(E_ALL);
        date_default_timezone_set('Asia/Colombo');

        $now = date("Y-m-d\TH:i:s");
        $username = "hemalp";
        $password = "nv$^69YM";
        $digest = md5($password);
        $number = "94777033678";
        $mask = "Dialog_Test";
        $text = "This is a test message";
        $campaignName = 'Hospital SMS Campaign';
        $clientRef = str_pad(mt_rand(0, 9999999), 7, '0', STR_PAD_LEFT);

        // Build the payload as a PHP array
        $bodyArray = [
            "messages" => [
                [
                    "clientRef" => $clientRef,
                    "number" => $number,
                    "mask" => $mask,
                    "text" => $text,
                    "campaignName" => $campaignName
                ]
            ]
        ];

        // Convert array to JSON
        $body = json_encode($bodyArray);

        // Initialize CURL
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://richcommunication.dialog.lk/api/sms/send");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        // Set headers
        $headers = [
            'Content-Type: application/json',
            'USER: ' . $username,
            'DIGEST: ' . $digest,
            'CREATED: ' . $now
        ];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        // Execute request
        $server_output = curl_exec($ch);
        $curl_error = curl_error($ch);
        curl_close($ch);
        $response = json_decode($server_output, true);
        var_dump($response);
    }

    function sendSms($to, $message, $data, $hospital_id)
    {
        $sms_gateway = $this->db->get_where('settings', array('hospital_id' => $hospital_id))->row()->sms_gateway;
        if (!empty($sms_gateway)) {
            $smsSettings = $this->frontend_model->getSmsSettingsByGatewayName($sms_gateway, $hospital_id);
        } else {
            show_swal(lang('gatewany_not_selected'), 'error', lang('error'));
            redirect('sms/sendView');
        }
        $j = sizeof($data);
        foreach ($data as $key => $value) {
            foreach ($value as $key2 => $value2) {

                if ($smsSettings->name == 'Bdbulksms') {

                    $token = $smsSettings->sms_token;
                    $url = "https://api.bdbulksms.net/api.php?json";
                    $data = array(
                        'to' => "$key2",
                        'message' => "$value2",
                        'token' => "$token"
                    );
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $url);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
                    curl_setopt($ch, CURLOPT_ENCODING, '');
                    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    $smsresult = curl_exec($ch);
                }
                if ($smsSettings->name == 'Clickatell') {
                    $username = $smsSettings->username;
                    $password = $smsSettings->password;
                    $api_id = $smsSettings->api_id;

                    $racepage[] = file_get_contents("https://api.clickatell.com/http/sendmsg?user=" . $username . "&password=" . $password . "&api_id=" . $api_id . "&to=" . $key2 . "&text=" . $value2);
                }

                if ($smsSettings->name == 'MSG91') {
                    $authkey = $smsSettings->authkey;
                    $sender = $smsSettings->sender;
                    $value2 = urlencode($value2);

                    file_get_contents('http://world.msg91.com/api/v2/sendsms?authkey=' . $authkey . '&mobiles=' . $key2 . '&message=' . $value2 . '&sender=' . $sender . '&route=4&country=0');
                }

                if ($smsSettings->name == 'Twilio') {
                    $sid = $smsSettings->sid;
                    $token = $smsSettings->token;
                    $sendername = $smsSettings->sendernumber;
                    if (!empty($sid) && !empty($token) && !empty($sendername)) {
                        $client = new Client($sid, $token);
                        $client->messages->create(
                            $key2, // Text this number
                            array(
                                'from' => $sendername, // From a valid Twilio number
                                'body' => $value2
                            )
                        );
                    }
                }

                if ($smsSettings->name == '80Kobo') {
                    $email = $smsSettings->email;
                    $password = $smsSettings->password;
                    $sender_name = $smsSettings->sender_name;

                    $data = array("email" => $email, "password" => $password, "message" => $value2, "sender_name" => $sender_name, "recipients" => $key2);

                    $data_string = json_encode($data);
                    $ch = curl_init('https://api.80kobosms.com/v2/app/sms');
                    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json', 'Content-Length: ' . strlen($data_string)));
                    $result = curl_exec($ch);
                    $res_array = json_decode($result);
                }

                if ($smsSettings->name == 'Hutch BSMS') {
                    $username = $smsSettings->hutch_username; // your Hutch username
                    $password = $smsSettings->hutch_password; // your Hutch password
                    $mask     = $smsSettings->mask; // pre-approved sender ID
                    $number   = $key2;
                    $text  = $value2;
                    $campaign = "Hospital Campaign";
                    // 1. Login to get access token
                    $loginUrl = "https://bsms.hutch.lk/api/login";
                    $loginData = [
                        "username" => $username,
                        "password" => $password
                    ];

                    $ch = curl_init($loginUrl);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_POST, true);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, [
                        "Content-Type: application/json",
                        "Accept: */*",
                        "X-API-VERSION: v1"
                    ]);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($loginData));
                    $loginResponse = curl_exec($ch);
                    curl_close($ch);

                    $loginResult = json_decode($loginResponse, true);

                    if (empty($loginResult['accessToken'])) {
                        echo "Login failed: " . $loginResponse;
                        return;
                    }

                    $accessToken = $loginResult['accessToken'];

                    // 2. Send SMS using access token
                    $smsUrl = "https://bsms.hutch.lk/api/sendsms";
                    $smsData = [
                        "campaignName" => $campaign,
                        "mask" => $mask,
                        "numbers" => $number,
                        "content" => $text,
                        "deliveryReportRequest" => true
                    ];

                    $ch = curl_init($smsUrl);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_POST, true);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, [
                        "Content-Type: application/json",
                        "Accept: */*",
                        "X-API-VERSION: v1",
                        "Authorization: Bearer " . $accessToken
                    ]);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($smsData));
                    $smsResponse = curl_exec($ch);
                    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                    curl_close($ch);
                    return array('success' => true, 'message' => 'SMS sent successfully');
                }
                if ($smsSettings->name == 'Dialog') {


                    error_reporting(E_ALL);
                    date_default_timezone_set('Asia/Colombo');

                    $now = date("Y-m-d\TH:i:s");
                    $username = $smsSettings->dialog_username;
                    $password = $smsSettings->dialog_password;
                    $digest = md5($password);
                    $number = $key2;
                    $mask = $smsSettings->dialog_mask;
                    $text = $value2;
                    $campaignName = 'Hospital SMS Campaign';
                    $clientRef = str_pad(mt_rand(0, 9999999), 7, '0', STR_PAD_LEFT);

                    // Build the payload as a PHP array
                    $bodyArray = [
                        "messages" => [
                            [
                                "clientRef" => $clientRef,
                                "number" => $number,
                                "mask" => $mask,
                                "text" => $text,
                                "campaignName" => $campaignName
                            ]
                        ]
                    ];

                    // Convert array to JSON
                    $body = json_encode($bodyArray);

                    // Initialize CURL
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, "https://richcommunication.dialog.lk/api/sms/send");
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                    // Set headers
                    $headers = [
                        'Content-Type: application/json',
                        'USER: ' . $username,
                        'DIGEST: ' . $digest,
                        'CREATED: ' . $now
                    ];
                    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

                    // Execute request
                    $server_output = curl_exec($ch);
                    $curl_error = curl_error($ch);
                    curl_close($ch);
                    $response = json_decode($server_output, true);
                    var_dump($response);
                }
            }
        }
    }

    public function addNew()
    {
        $id = $this->input->post('id');

        $patient = $this->input->post('patient');

        $doctor = $this->input->post('doctor');
        $date = $this->input->post('date');
        if (!empty($date)) {
            $date = strtotime($date);
        }


        $time_slot = $this->input->post('time_slot');

        $time_slot_explode = explode('To', $time_slot);

        $s_time = trim($time_slot_explode[0]);
        $e_time = trim($time_slot_explode[1]);

        $remarks = $this->input->post('remarks');

        $sms = $this->input->post('sms');

        $status = 'Requested';

        $redirect = 'frontend';

        $request = 'Yes';

        $user = '';

        if ((empty($id))) {
            $add_date = date('m/d/y');
            $registration_time = time();
            $patient_add_date = $add_date;
            $patient_registration_time = $registration_time;
        }

        $s_time_key = $this->getArrayKey($s_time);

        $p_name = $this->input->post('p_name');
        $p_email = $this->input->post('p_email');
        if (empty($p_email)) {
            $p_email = $p_name . '-' . rand(1, 1000) . '-' . $p_name . '-' . rand(1, 1000) . '@example.com';
        }
        if (!empty($p_name)) {
            $password = $p_name . '-' . rand(1, 100000000);
        }
        $p_phone = $this->input->post('p_phone');
        $p_age = $this->input->post('p_age');
        $p_gender = $this->input->post('p_gender');
        $patient_id = rand(10000, 1000000);

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

        if ($patient == 'add_new') {
            $this->form_validation->set_rules('p_name', 'Patient Name', 'trim|required|min_length[1]|max_length[100]|xss_clean');
            $this->form_validation->set_rules('p_phone', 'Patient Phone', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        }

        if ($patient == 'patient_id') {
            $this->form_validation->set_rules('patient_id', 'Patient Name', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        }


        // Validating Name Field
        $this->form_validation->set_rules('patient', 'Patient', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        // Validating Doctor Field
        $this->form_validation->set_rules('doctor', 'Doctor', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        // Validating Date Field
        $this->form_validation->set_rules('date', 'Date', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        // Validating Address Field   
        $this->form_validation->set_rules('remarks', 'Remarks', 'trim|min_length[1]|max_length[1000]|xss_clean');

        if ($this->form_validation->run() == FALSE) {

            show_swal('Form Validation Error!', 'error', lang('error'));
            redirect("frontend");
        } else {


            if ($patient == 'patient_id') {
                $patient = $this->input->post('patient_id');

                if (!empty($patient)) {
                    $patient_exist = $this->patient_model->getPatientById($patient)->id;
                }

                if (empty($patient_exist)) {
                    show_swal('Invalid Patient Id !', 'error', lang('error'));
                    redirect("frontend");
                }
            }

            if ($patient == 'add_new') {
                $data_p = array(
                    'patient_id' => $patient_id,
                    'name' => $p_name,
                    'email' => $p_email,
                    'phone' => $p_phone,
                    'sex' => $p_gender,
                    'age' => $p_age,
                    'add_date' => $patient_add_date,
                    'registration_time' => $patient_registration_time,
                    'how_added' => 'from_appointment'
                );
                $username = $this->input->post('p_name');
                // Adding New Patient
                if ($this->ion_auth->phone_check($p_phone)) {
                    show_swal(lang('this_mobile_number_is_already_registered'), 'warning', lang('warning'));
                    redirect($redirect);
                } else {
                    $dfg = 5;
                    $additional_data = array('phone' => $p_phone);
                    $this->ion_auth->register($p_phone, $password, $p_email, $dfg, $additional_data);
                    $identity_column = $this->config->item('identity', 'ion_auth');
                    $ion_user_id = $this->db->get_where('users', array($identity_column => $p_phone))->row()->id;
                    $this->patient_model->insertPatient($data_p);
                    $patient_user_id = $this->db->get_where('patient', array('phone' => $p_phone))->row()->id;
                    $id_info = array('ion_user_id' => $ion_user_id);
                    $this->patient_model->updatePatient($patient_user_id, $id_info);
                }

                $patient = $patient_user_id;
                //    }
            }
            //$error = array('error' => $this->upload->display_errors());
            $data = array();
            $data = array(
                'patient' => $patient,
                'doctor' => $doctor,
                'date' => $date,
                's_time' => $s_time,
                'e_time' => $e_time,
                'time_slot' => $time_slot,
                'remarks' => $remarks,
                'add_date' => $add_date,
                'registration_time' => $registration_time,
                'status' => $status,
                's_time_key' => $s_time_key,
                'user' => $user,
                'request' => $request
            );
            $username = $this->input->post('name');
            if (empty($id)) {     // Adding New department
                $this->frontend_model->insertAppointment($data);

                if (!empty($sms)) {
                    $this->sms->sendSmsDuringAppointment($patient, $doctor, $date, $s_time, $e_time);
                }

                $patient_doctor = $this->patient_model->getPatientById($patient)->doctor;

                $patient_doctors = explode(',', $patient_doctor);

                if (!in_array($doctor, $patient_doctors)) {
                    $patient_doctors[] = $doctor;
                    $doctorss = implode(',', $patient_doctors);
                    $data_d = array();
                    $data_d = array('doctor' => $doctorss);
                    $this->patient_model->updatePatient($patient, $data_d);
                }
                show_swal('Appointment Added Successfully. Please wait. You will get a confirmation sms.', 'success', lang('success'));
            }

            if (!empty($redirect)) {
                redirect($redirect);
            } else {
                redirect('appointment');
            }
        }
    }

    function getArrayKey($s_time)
    {
        $all_slot = array(
            '0' => '12:00 AM',
            '1' => '12:05 AM',
            '2' => '12:10 AM',
            '3' => '12:15 AM',
            '4' => '12:20 AM',
            '5' => '12:25 AM',
            '6' => '12:30 AM',
            '7' => '12:35 AM',
            '8' => '12:40 PM',
            '9' => '12:45 AM',
            '10' => '12:50 AM',
            '11' => '12:55 AM',
            '12' => '01:00 AM',
            '13' => '01:05 AM',
            '14' => '01:10 AM',
            '15' => '01:15 AM',
            '16' => '01:20 AM',
            '17' => '01:25 AM',
            '18' => '01:30 AM',
            '19' => '01:35 AM',
            '20' => '01:40 AM',
            '21' => '01:45 AM',
            '22' => '01:50 AM',
            '23' => '01:55 AM',
            '24' => '02:00 AM',
            '25' => '02:05 AM',
            '26' => '02:10 AM',
            '27' => '02:15 AM',
            '28' => '02:20 AM',
            '29' => '02:25 AM',
            '30' => '02:30 AM',
            '31' => '02:35 AM',
            '32' => '02:40 AM',
            '33' => '02:45 AM',
            '34' => '02:50 AM',
            '35' => '02:55 AM',
            '36' => '03:00 AM',
            '37' => '03:05 AM',
            '38' => '03:10 AM',
            '39' => '03:15 AM',
            '40' => '03:20 AM',
            '41' => '03:25 AM',
            '42' => '03:30 AM',
            '43' => '03:35 AM',
            '44' => '03:40 AM',
            '45' => '03:45 AM',
            '46' => '03:50 AM',
            '47' => '03:55 AM',
            '48' => '04:00 AM',
            '49' => '04:05 AM',
            '50' => '04:10 AM',
            '51' => '04:15 AM',
            '52' => '04:20 AM',
            '53' => '04:25 AM',
            '54' => '04:30 AM',
            '55' => '04:35 AM',
            '56' => '04:40 AM',
            '57' => '04:45 AM',
            '58' => '04:50 AM',
            '59' => '04:55 AM',
            '60' => '05:00 AM',
            '61' => '05:05 AM',
            '62' => '05:10 AM',
            '63' => '05:15 AM',
            '64' => '05:20 AM',
            '65' => '05:25 AM',
            '66' => '05:30 AM',
            '67' => '05:35 AM',
            '68' => '05:40 AM',
            '69' => '05:45 AM',
            '70' => '05:50 AM',
            '71' => '05:55 AM',
            '72' => '06:00 AM',
            '73' => '06:05 AM',
            '74' => '06:10 AM',
            '75' => '06:15 AM',
            '76' => '06:20 AM',
            '77' => '06:25 AM',
            '78' => '06:30 AM',
            '79' => '06:35 AM',
            '80' => '06:40 AM',
            '81' => '06:45 AM',
            '82' => '06:50 AM',
            '83' => '06:55 AM',
            '84' => '07:00 AM',
            '85' => '07:05 AM',
            '86' => '07:10 AM',
            '87' => '07:15 AM',
            '88' => '07:20 AM',
            '89' => '07:25 AM',
            '90' => '07:30 AM',
            '91' => '07:35 AM',
            '92' => '07:40 AM',
            '93' => '07:45 AM',
            '94' => '07:50 AM',
            '95' => '07:55 AM',
            '96' => '08:00 AM',
            '97' => '08:05 AM',
            '98' => '08:10 AM',
            '99' => '08:15 AM',
            '100' => '08:20 AM',
            '101' => '08:25 AM',
            '102' => '08:30 AM',
            '103' => '08:35 AM',
            '104' => '08:40 AM',
            '105' => '08:45 AM',
            '106' => '08:50 AM',
            '107' => '08:55 AM',
            '108' => '09:00 AM',
            '109' => '09:05 AM',
            '110' => '09:10 AM',
            '111' => '09:15 AM',
            '112' => '09:20 AM',
            '113' => '09:25 AM',
            '114' => '09:30 AM',
            '115' => '09:35 AM',
            '116' => '09:40 AM',
            '117' => '09:45 AM',
            '118' => '09:50 AM',
            '119' => '09:55 AM',
            '120' => '10:00 AM',
            '121' => '10:05 AM',
            '122' => '10:10 AM',
            '123' => '10:15 AM',
            '124' => '10:20 AM',
            '125' => '10:25 AM',
            '126' => '10:30 AM',
            '127' => '10:35 AM',
            '128' => '10:40 AM',
            '129' => '10:45 AM',
            '130' => '10:50 AM',
            '131' => '10:55 AM',
            '132' => '11:00 AM',
            '133' => '11:05 AM',
            '134' => '11:10 AM',
            '135' => '11:15 AM',
            '136' => '11:20 AM',
            '137' => '11:25 AM',
            '138' => '11:30 AM',
            '139' => '11:35 AM',
            '140' => '11:40 AM',
            '141' => '11:45 AM',
            '142' => '11:50 AM',
            '143' => '11:55 AM',
            '144' => '12:00 PM',
            '145' => '12:05 PM',
            '146' => '12:10 PM',
            '147' => '12:15 PM',
            '148' => '12:20 PM',
            '149' => '12:25 PM',
            '150' => '12:30 PM',
            '151' => '12:35 PM',
            '152' => '12:40 PM',
            '153' => '12:45 PM',
            '154' => '12:50 PM',
            '155' => '12:55 PM',
            '156' => '01:00 PM',
            '157' => '01:05 PM',
            '158' => '01:10 PM',
            '159' => '01:15 PM',
            '160' => '01:20 PM',
            '161' => '01:25 PM',
            '162' => '01:30 PM',
            '163' => '01:35 PM',
            '164' => '01:40 PM',
            '165' => '01:45 PM',
            '166' => '01:50 PM',
            '167' => '01:55 PM',
            '168' => '02:00 PM',
            '169' => '02:05 PM',
            '170' => '02:10 PM',
            '171' => '02:15 PM',
            '172' => '02:20 PM',
            '173' => '02:25 PM',
            '174' => '02:30 PM',
            '175' => '02:35 PM',
            '176' => '02:40 PM',
            '177' => '02:45 PM',
            '178' => '02:50 PM',
            '179' => '02:55 PM',
            '180' => '03:00 PM',
            '181' => '03:05 PM',
            '182' => '03:10 PM',
            '183' => '03:15 PM',
            '184' => '03:20 PM',
            '185' => '03:25 PM',
            '186' => '03:30 PM',
            '187' => '03:35 PM',
            '188' => '03:40 PM',
            '189' => '03:45 PM',
            '190' => '03:50 PM',
            '191' => '03:55 PM',
            '192' => '04:00 PM',
            '193' => '04:05 PM',
            '194' => '04:10 PM',
            '195' => '04:15 PM',
            '196' => '04:20 PM',
            '197' => '04:25 PM',
            '198' => '04:30 PM',
            '199' => '04:35 PM',
            '200' => '04:40 PM',
            '201' => '04:45 PM',
            '202' => '04:50 PM',
            '203' => '04:55 PM',
            '204' => '05:00 PM',
            '205' => '05:05 PM',
            '206' => '05:10 PM',
            '207' => '05:15 PM',
            '208' => '05:20 PM',
            '209' => '05:25 PM',
            '210' => '05:30 PM',
            '211' => '05:35 PM',
            '212' => '05:40 PM',
            '213' => '05:45 PM',
            '214' => '05:50 PM',
            '215' => '05:55 PM',
            '216' => '06:00 PM',
            '217' => '06:05 PM',
            '218' => '06:10 PM',
            '219' => '06:15 PM',
            '220' => '06:20 PM',
            '221' => '06:25 PM',
            '222' => '06:30 PM',
            '223' => '06:35 PM',
            '224' => '06:40 PM',
            '225' => '06:45 PM',
            '226' => '06:50 PM',
            '227' => '06:55 PM',
            '228' => '07:00 PM',
            '229' => '07:05 PM',
            '230' => '07:10 PM',
            '231' => '07:15 PM',
            '232' => '07:20 PM',
            '233' => '07:25 PM',
            '234' => '07:30 PM',
            '235' => '07:35 PM',
            '236' => '07:40 PM',
            '237' => '07:45 PM',
            '238' => '07:50 PM',
            '239' => '07:55 PM',
            '240' => '08:00 PM',
            '241' => '08:05 PM',
            '242' => '08:10 PM',
            '243' => '08:15 PM',
            '244' => '08:20 PM',
            '245' => '08:25 PM',
            '246' => '08:30 PM',
            '247' => '08:35 PM',
            '248' => '08:40 PM',
            '249' => '08:45 PM',
            '250' => '08:50 PM',
            '251' => '08:55 PM',
            '252' => '09:00 PM',
            '253' => '09:05 PM',
            '254' => '09:10 PM',
            '255' => '09:15 PM',
            '256' => '09:20 PM',
            '257' => '09:25 PM',
            '258' => '09:30 PM',
            '259' => '09:35 PM',
            '260' => '09:40 PM',
            '261' => '09:45 PM',
            '262' => '09:50 PM',
            '263' => '09:55 PM',
            '264' => '10:00 PM',
            '265' => '10:05 PM',
            '266' => '10:10 PM',
            '267' => '10:15 PM',
            '268' => '10:20 PM',
            '269' => '10:25 PM',
            '270' => '10:30 PM',
            '271' => '10:35 PM',
            '272' => '10:40 PM',
            '273' => '10:45 PM',
            '274' => '10:50 PM',
            '275' => '10:55 PM',
            '276' => '11:00 PM',
            '277' => '11:05 PM',
            '278' => '11:10 PM',
            '279' => '11:15 PM',
            '280' => '11:20 PM',
            '281' => '11:25 PM',
            '282' => '11:30 PM',
            '283' => '11:35 PM',
            '284' => '11:40 PM',
            '285' => '11:45 PM',
            '286' => '11:50 PM',
            '287' => '11:55 PM',
        );

        $key = array_search($s_time, $all_slot);
        return $key;
    }

    public function settings()
    {
        if (!$this->ion_auth->in_group('superadmin')) {
            redirect('home/permission');
        }
        $data = array();
        $data['settings'] = $this->frontend_model->getSettings();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('settings', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    public function update()
    {
        if (!$this->ion_auth->in_group('superadmin')) {
            redirect('home/permission');
        }
        $id = $this->input->post('id');
        $title = $this->input->post('title');
        $email = $this->input->post('email');
        $address = $this->input->post('address');
        $phone = $this->input->post('phone');
        $emergency = $this->input->post('emergency');
        $support = $this->input->post('support');
        $currency = $this->input->post('currency');
        $logo = $this->input->post('logo');
        $block_1_text_under_title = $this->input->post('block_1_text_under_title');
        $service_block_text_under_title = $this->input->post('service_block__text_under_title');
        $doctor_block_text_under_title = $this->input->post('doctor_block__text_under_title');
        $registration_block_text = $this->input->post('registration_block_text');
        $facebook_id = $this->input->post('facebook_id');
        $twitter_id = $this->input->post('twitter_id');
        $twitter_username = $this->input->post('twitter_username');
        $google_id = $this->input->post('google_id');
        $youtube_id = $this->input->post('youtube_id');
        $skype_id = $this->input->post('skype_id');
        $comment_1 = $this->input->post('comment_1');
        $comment_2 = $this->input->post('comment_2');
        $verified_1 = $this->input->post('verified_1');
        $verified_2 = $this->input->post('verified_2');
        $comment_logo_1 = $this->input->post('comment_logo_1');
        $comment_logo_2 = $this->input->post('comment_logo_2');
        $partner_header_title = $this->input->post('partner_header_title');
        $partner_header_description = $this->input->post('partner_header_description');
        $section_title_1 = $this->input->post('section_title_1');
        $section_title_2 = $this->input->post('section_title_2');
        $section_title_3 = $this->input->post('section_title_3');
        $section_description_1 = $this->input->post('section_description_1');
        $section_description_2 = $this->input->post('section_description_2');
        $section_description_3 = $this->input->post('section_description_3');
        $section_1_text_1 = $this->input->post('section_1_text_1');
        $section_1_text_2 = $this->input->post('section_1_text_2');
        $section_1_text_3 = $this->input->post('section_1_text_3');
        $section_2_text_1 = $this->input->post('section_2_text_1');
        $section_2_text_2 = $this->input->post('section_2_text_2');
        $section_2_text_3 = $this->input->post('section_2_text_3');
        $section_3_text_1 = $this->input->post('section_3_text_1');
        $section_3_text_2 = $this->input->post('section_3_text_2');
        $section_3_text_3 = $this->input->post('section_3_text_3');
        $partner_image_1 = $this->input->post('partner_image_1');
        $partner_image_2 = $this->input->post('partner_image_2');
        $partner_image_3 = $this->input->post('partner_image_3');
        $market_title = $this->input->post('market_title');
        $market_description = $this->input->post('market_description');
        $market_button_link = $this->input->post('market_button_link');
        $market_image = $this->input->post('market_image');
        $market_commentator_name = $this->input->post('market_commentator_name');
        $market_commentator_designation = $this->input->post('market_commentator_designation');
        $market_comment = $this->input->post('market_comment');
        $commentator_profile_image = $this->input->post('commentator_profile_image');
        $commentator_logo_1 = $this->input->post('commentator_logo_1');
        $commentator_logo_2 = $this->input->post('commentator_logo_2');
        $commentator_logo_3 = $this->input->post('commentator_logo_3');
        $team_title = $this->input->post('team_title');
        $team_description = $this->input->post('team_description');
        $team_button_link = $this->input->post('team_button_link');
        $team_commentator_name = $this->input->post('team_commentator_name');
        $team_commentator_designation = $this->input->post('team_commentator_designation');
        $team_comment = $this->input->post('team_comment');
        $team_verified = $this->input->post('team_verified');
        $team_review_logo = $this->input->post('team_review_logo');
        $team_commentator_image = $this->input->post('team_commentator_image');
        $contact_us = $this->input->post('contact_us');
        $chat_js = $this->input->post('chat_js');
        $google_translation_switch_in_frontend = $this->input->post('google_translation_switch_in_frontend');
        if (empty($google_translation_switch_in_frontend)) {
            $google_translation_switch_in_frontend = '';
        }

        $question1 = $this->input->post('question1');
        $question2 = $this->input->post('question2');
        $question3 = $this->input->post('question3');
        $question4 = $this->input->post('question4');
        $question5 = $this->input->post('question5');
        $question6 = $this->input->post('question6');
        $question7 = $this->input->post('question7');
        $question8 = $this->input->post('question8');
        $question9 = $this->input->post('question9');
        $answer1 = $this->input->post('answer1');
        $answer2 = $this->input->post('answer2');
        $answer3 = $this->input->post('answer3');
        $answer4 = $this->input->post('answer4');
        $answer5 = $this->input->post('answer5');
        $answer6 = $this->input->post('answer6');
        $answer7 = $this->input->post('answer7');
        $answer8 = $this->input->post('answer8');
        $answer9 = $this->input->post('answer9');
        $tawk_to_status = $this->input->post('tawk_to_status');




        if (!empty($email)) {
            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
            // Validating Title Field
            $this->form_validation->set_rules('title', 'Title', 'trim|required|min_length[1]|max_length[100]|xss_clean');
            // Validating Email Field
            $this->form_validation->set_rules('email', 'Email', 'trim|required|min_length[1]|max_length[100]|xss_clean');
            // Validating Address Field   
            $this->form_validation->set_rules('address', 'Address', 'trim|required|min_length[1]|max_length[1000]|xss_clean');
            // Validating Phone Field           
            $this->form_validation->set_rules('phone', 'Phone', 'trim|required|min_length[1]|max_length[100]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('currency', 'Currency', 'trim|required|min_length[1]|max_length[100]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('logo', 'Logo', 'trim|min_length[1]|max_length[100]|xss_clean');

            // Validating Currency Field   
            $this->form_validation->set_rules('emergency', 'Emergency', 'trim|min_length[1]|max_length[100]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('support', 'Support', 'trim|min_length[1]|max_length[100]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('logo', 'Logo', 'trim|min_length[1]|max_length[100]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('block_1_text_under_title', 'Block 1 Text Under Title', 'trim|min_length[1]|max_length[500]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('service_block__text_under_title', 'Service Block Text Under Title', 'trim|min_length[1]|max_length[500]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('doctor_block__text_under_title', 'Doctor Block Text Under Title', 'trim|min_length[1]|max_length[500]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('facebook_id', 'Facebook Id', 'trim|min_length[1]|max_length[100]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('twitter_id', 'Teitter Id', 'trim|min_length[1]|max_length[100]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('twitter_username', 'Teitter Username', 'trim|min_length[1]|max_length[100]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('google_id', 'Google Id', 'trim|min_length[1]|max_length[100]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('youtube_id', 'Youtube Id', 'trim|min_length[1]|max_length[100]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('skype_id', 'Skype Id', 'trim|min_length[1]|max_length[100]|xss_clean');

            // Validating Currency Field   
            $this->form_validation->set_rules('comment_1', 'Comment 1', 'trim|min_length[1]|max_length[1000]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('comment_2', 'Comment 2', 'trim|min_length[1]|max_length[1000]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('verified_1', 'Verified 1', 'trim|min_length[1]|max_length[200]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('verified_2', 'Verified 2', 'trim|min_length[1]|max_length[200]|xss_clean');

            // Validating Currency Field   
            $this->form_validation->set_rules('partner_header_title', 'Header Title', 'trim|min_length[1]|max_length[300]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('partner_header_description', 'Header Description', 'trim|min_length[1]|max_length[800]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('section_title_1', 'Title', 'trim|min_length[1]|max_length[200]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('section_description_1', 'Description', 'trim|min_length[1]|max_length[800]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('section_1_text_1', 'Text 1', 'trim|min_length[1]|max_length[200]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('section_1_text_2', 'Text 2', 'trim|min_length[1]|max_length[200]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('section_1_text_3', 'Text 3', 'trim|min_length[1]|max_length[200]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('section_title_2', 'Title', 'trim|min_length[1]|max_length[200]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('section_description_2', 'Description', 'trim|min_length[1]|max_length[800]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('section_2_text_1', 'Text 1', 'trim|min_length[1]|max_length[200]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('section_2_text_2', 'Text 2', 'trim|min_length[1]|max_length[200]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('section_2_text_3', 'Text 3', 'trim|min_length[1]|max_length[200]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('section_title_3', 'Title', 'trim|min_length[1]|max_length[200]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('section_description_3', 'Description', 'trim|min_length[1]|max_length[800]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('section_3_text_1', 'Text 1', 'trim|min_length[1]|max_length[200]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('section_3_text_2', 'Text 2', 'trim|min_length[1]|max_length[200]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('section_3_text_3', 'Text 3', 'trim|min_length[1]|max_length[200]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('market_title', 'Title', 'trim|min_length[1]|max_length[300]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('market_description', 'Description', 'trim|min_length[1]|max_length[800]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('market_button_link', 'Button Link', 'trim|min_length[1]|max_length[300]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('market_commentator_name', 'Commentator Name', 'trim|min_length[1]|max_length[300]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('market_commentator_designation', 'Commentator Designation', 'trim|min_length[1]|max_length[500]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('market_comment', 'Comment', 'trim|min_length[1]|max_length[1000]|xss_clean');

            // Validating Currency Field   
            $this->form_validation->set_rules('team_title', 'Title', 'trim|min_length[1]|max_length[300]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('team_description', 'Description', 'trim|min_length[1]|max_length[800]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('team_button_link', 'Button Link', 'trim|min_length[1]|max_length[300]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('team_commentator_name', 'Commentator Name', 'trim|min_length[1]|max_length[300]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('team_commentator_designation', 'Commentator Designation', 'trim|min_length[1]|max_length[500]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('team_comment', 'Comment', 'trim|min_length[1]|max_length[800]|xss_clean');
            // Validating Currency Field   
            $this->form_validation->set_rules('contact_us', 'Contact Us Text', 'trim|min_length[1]|max_length[300]|xss_clean');

            if ($this->form_validation->run() == FALSE) {
                $data = array();
                $data['settings'] = $this->settings_model->getSettings();
                $this->load->view('home/dashboard'); // just the header file
                $this->load->view('settings', $data);
                $this->load->view('home/footer'); // just the footer file
            } else {

                $file_name = $_FILES['img_url']['name'];
                $file_name_pieces = explode('_', $file_name);
                $new_file_name = '';
                $count = 1;
                foreach ($file_name_pieces as $piece) {
                    if ($count !== 1) {
                        $piece = ucfirst($piece);
                    }

                    $new_file_name .= $piece;
                    $count++;
                }
                $config = array(
                    'file_name' => $new_file_name,
                    'upload_path' => "./uploads/",
                    'allowed_types' => "gif|jpg|png|jpeg|pdf",
                    'overwrite' => False,
                    'max_size' => "20480000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
                    'max_height' => "1768",
                    'max_width' => "2024"
                );

                $this->load->library('Upload', $config);
                $this->upload->initialize($config);

                if ($this->upload->do_upload('img_url')) {
                    $path = $this->upload->data();
                    $img_url = "uploads/" . $path['file_name'];
                    $data = array();
                    $data = array(
                        'title' => $title,
                        'address' => $address,
                        'phone' => $phone,
                        'email' => $email,
                        'currency' => $currency,
                        'emergency' => $emergency,
                        'support' => $support,
                        'block_1_text_under_title' => $block_1_text_under_title,
                        'service_block__text_under_title' => $service_block_text_under_title,
                        'doctor_block__text_under_title' => $doctor_block_text_under_title,
                        'registration_block_text' => $registration_block_text,
                        'facebook_id' => $facebook_id,
                        'twitter_id' => $twitter_id,
                        'twitter_username' => $twitter_username,
                        'google_id' => $google_id,
                        'youtube_id' => $youtube_id,
                        'skype_id' => $skype_id,
                        'logo' => $img_url,
                        'comment_1' => $comment_1,
                        'comment_2' => $comment_2,
                        'verified_1' => $verified_1,
                        'verified_2' => $verified_2,
                        'partner_header_title' => $partner_header_title,
                        'partner_header_description' => $partner_header_description,
                        'section_title_1' => $section_title_1,
                        'section_description_1' => $section_description_1,
                        'section_1_text_1' => $section_1_text_1,
                        'section_1_text_2' => $section_1_text_2,
                        'section_1_text_3' => $section_1_text_3,
                        'section_title_2' => $section_title_2,
                        'section_description_2' => $section_description_2,
                        'section_2_text_1' => $section_2_text_1,
                        'section_2_text_2' => $section_2_text_2,
                        'section_2_text_3' => $section_2_text_3,
                        'section_title_3' => $section_title_3,
                        'section_description_3' => $section_description_3,
                        'section_3_text_1' => $section_3_text_1,
                        'section_3_text_2' => $section_3_text_2,
                        'section_3_text_3' => $section_3_text_3,
                        'market_title' => $market_title,
                        'market_description' => $market_description,
                        'market_button_link' => $market_button_link,
                        'market_commentator_name' => $market_commentator_name,
                        'market_commentator_designation' => $market_commentator_designation,
                        'market_comment' => $market_comment,
                        'team_title' => $team_title,
                        'team_description' => $team_description,
                        'team_button_link' => $team_button_link,
                        'team_commentator_name' => $team_commentator_name,
                        'team_commentator_designation' => $team_commentator_designation,
                        'team_comment' => $team_comment,
                        'team_verified' => $team_verified,
                        'contact_us' => $contact_us,
                        'chat_js' => $chat_js,
                        'google_translation_switch_in_frontend' => $google_translation_switch_in_frontend,

                        'question1' => $question1,
                        'question2' => $question2,
                        'question3' => $question3,
                        'question4' => $question4,
                        'question5' => $question5,
                        'question6' => $question6,
                        'question7' => $question7,
                        'question8' => $question8,
                        'question9' => $question9,
                        'answer1' => $answer1,
                        'answer2' => $answer2,
                        'answer3' => $answer3,
                        'answer4' => $answer4,
                        'answer5' => $answer5,
                        'answer6' => $answer6,
                        'answer7' => $answer7,
                        'answer8' => $answer8,
                        'answer9' => $answer9,
                        'tawk_to_status' => $tawk_to_status
                    );
                } else {
                    $data = array();
                    $data = array(
                        'title' => $title,
                        'address' => $address,
                        'phone' => $phone,
                        'email' => $email,
                        'currency' => $currency,
                        'emergency' => $emergency,
                        'support' => $support,
                        'block_1_text_under_title' => $block_1_text_under_title,
                        'service_block__text_under_title' => $service_block_text_under_title,
                        'doctor_block__text_under_title' => $doctor_block_text_under_title,
                        'registration_block_text' => $registration_block_text,
                        'facebook_id' => $facebook_id,
                        'twitter_id' => $twitter_id,
                        'twitter_username' => $twitter_username,
                        'google_id' => $google_id,
                        'youtube_id' => $youtube_id,
                        'skype_id' => $skype_id,
                        'comment_1' => $comment_1,
                        'comment_2' => $comment_2,
                        'verified_1' => $verified_1,
                        'verified_2' => $verified_2,
                        'partner_header_title' => $partner_header_title,
                        'partner_header_description' => $partner_header_description,
                        'section_title_1' => $section_title_1,
                        'section_description_1' => $section_description_1,
                        'section_1_text_1' => $section_1_text_1,
                        'section_1_text_2' => $section_1_text_2,
                        'section_1_text_3' => $section_1_text_3,
                        'section_title_2' => $section_title_2,
                        'section_description_2' => $section_description_2,
                        'section_2_text_1' => $section_2_text_1,
                        'section_2_text_2' => $section_2_text_2,
                        'section_2_text_3' => $section_2_text_3,
                        'section_title_3' => $section_title_3,
                        'section_description_3' => $section_description_3,
                        'section_3_text_1' => $section_3_text_1,
                        'section_3_text_2' => $section_3_text_2,
                        'section_3_text_3' => $section_3_text_3,
                        'market_title' => $market_title,
                        'market_description' => $market_description,
                        'market_button_link' => $market_button_link,
                        'market_commentator_name' => $market_commentator_name,
                        'market_commentator_designation' => $market_commentator_designation,
                        'market_comment' => $market_comment,
                        'team_title' => $team_title,
                        'team_description' => $team_description,
                        'team_button_link' => $team_button_link,
                        'team_commentator_name' => $team_commentator_name,
                        'team_commentator_designation' => $team_commentator_designation,
                        'team_comment' => $team_comment,
                        'team_verified' => $team_verified,
                        'contact_us' => $contact_us,
                        'chat_js' => $chat_js,
                        'google_translation_switch_in_frontend' => $google_translation_switch_in_frontend,
                        'question1' => $question1,
                        'question2' => $question2,
                        'question3' => $question3,
                        'question4' => $question4,
                        'question5' => $question5,
                        'question6' => $question6,
                        'question7' => $question7,
                        'question8' => $question8,
                        'question9' => $question9,
                        'answer1' => $answer1,
                        'answer2' => $answer2,
                        'answer3' => $answer3,
                        'answer4' => $answer4,
                        'answer5' => $answer5,
                        'answer6' => $answer6,
                        'answer7' => $answer7,
                        'answer8' => $answer8,
                        'answer9' => $answer9,
                        'tawk_to_status' => $tawk_to_status
                    );
                }


                $this->frontend_model->updateSettings($id, $data);
                $data2 = array();
                $file_name = $_FILES['block_img_url']['name'];
                $file_name_pieces = explode('_', $file_name);
                $new_file_name = '';
                $count = 1;
                foreach ($file_name_pieces as $piece) {
                    if ($count !== 1) {
                        $piece = ucfirst($piece);
                    }

                    $new_file_name .= $piece;
                    $count++;
                }
                $config = array(
                    'file_name' => $new_file_name,
                    'upload_path' => "./uploads/",
                    'allowed_types' => "gif|jpg|png|jpeg|pdf",
                    'overwrite' => False,
                    'max_size' => "20480000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
                    'max_height' => "10000",
                    'max_width' => "10000"
                );

                $this->load->library('Upload', $config);
                $this->upload->initialize($config);

                if ($this->upload->do_upload('block_img_url')) {
                    $path = $this->upload->data();
                    $img_url = "uploads/" . $path['file_name'];

                    $data2 = array(
                        'block_img_url' => $img_url
                    );
                    $this->frontend_model->updateSettings($id, $data2);
                }
                $data3 = array();
                $file_name = $_FILES['comment_logo_1']['name'];
                $file_name_pieces = explode('_', $file_name);
                $new_file_name = '';
                $count = 1;
                foreach ($file_name_pieces as $piece) {
                    if ($count !== 1) {
                        $piece = ucfirst($piece);
                    }

                    $new_file_name .= $piece;
                    $count++;
                }
                $config = array(
                    'file_name' => $new_file_name,
                    'upload_path' => "./uploads/",
                    'allowed_types' => "gif|jpg|png|jpeg|pdf",
                    'overwrite' => False,
                    'max_size' => "20480000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
                    'max_height' => "10000",
                    'max_width' => "10000"
                );

                $this->load->library('Upload', $config);
                $this->upload->initialize($config);

                if ($this->upload->do_upload('comment_logo_1')) {
                    $path = $this->upload->data();
                    $img_url = "uploads/" . $path['file_name'];

                    $data3 = array(
                        'comment_logo_1' => $img_url
                    );
                    $this->frontend_model->updateSettings($id, $data3);
                }

                $data4 = array();
                $file_name = $_FILES['comment_logo_2']['name'];
                $file_name_pieces = explode('_', $file_name);
                $new_file_name = '';
                $count = 1;
                foreach ($file_name_pieces as $piece) {
                    if ($count !== 1) {
                        $piece = ucfirst($piece);
                    }

                    $new_file_name .= $piece;
                    $count++;
                }
                $config = array(
                    'file_name' => $new_file_name,
                    'upload_path' => "./uploads/",
                    'allowed_types' => "gif|jpg|png|svg|jpeg|pdf",
                    'overwrite' => False,
                    'max_size' => "20480000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
                    'max_height' => "10000",
                    'max_width' => "10000"
                );

                $this->load->library('Upload', $config);
                $this->upload->initialize($config);

                if ($this->upload->do_upload('comment_logo_2')) {
                    $path = $this->upload->data();
                    $img_url = "uploads/" . $path['file_name'];

                    $data4 = array(
                        'comment_logo_2' => $img_url
                    );
                    $this->frontend_model->updateSettings($id, $data4);
                }

                $data5 = array();
                $file_name = $_FILES['partner_image_1']['name'];
                $file_name_pieces = explode('_', $file_name);
                $new_file_name = '';
                $count = 1;
                foreach ($file_name_pieces as $piece) {
                    if ($count !== 1) {
                        $piece = ucfirst($piece);
                    }

                    $new_file_name .= $piece;
                    $count++;
                }
                $config = array(
                    'file_name' => $new_file_name,
                    'upload_path' => "./uploads/",
                    'allowed_types' => "gif|jpg|png|svg|jpeg|pdf",
                    'overwrite' => False,
                    'max_size' => "20480000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
                    'max_height' => "10000",
                    'max_width' => "10000"
                );

                $this->load->library('Upload', $config);
                $this->upload->initialize($config);

                if ($this->upload->do_upload('partner_image_1')) {
                    $path = $this->upload->data();
                    $img_url = "uploads/" . $path['file_name'];

                    $data5 = array(
                        'partner_image_1' => $img_url
                    );
                    $this->frontend_model->updateSettings($id, $data5);
                }

                $data6 = array();
                $file_name = $_FILES['partner_image_2']['name'];
                $file_name_pieces = explode('_', $file_name);
                $new_file_name = '';
                $count = 1;
                foreach ($file_name_pieces as $piece) {
                    if ($count !== 1) {
                        $piece = ucfirst($piece);
                    }

                    $new_file_name .= $piece;
                    $count++;
                }
                $config = array(
                    'file_name' => $new_file_name,
                    'upload_path' => "./uploads/",
                    'allowed_types' => "gif|jpg|png|svg|jpeg|pdf",
                    'overwrite' => False,
                    'max_size' => "20480000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
                    'max_height' => "10000",
                    'max_width' => "10000"
                );

                $this->load->library('Upload', $config);
                $this->upload->initialize($config);

                if ($this->upload->do_upload('partner_image_2')) {
                    $path = $this->upload->data();
                    $img_url = "uploads/" . $path['file_name'];

                    $data6 = array(
                        'partner_image_2' => $img_url
                    );
                    $this->frontend_model->updateSettings($id, $data6);
                }

                $data7 = array();
                $file_name = $_FILES['partner_image_3']['name'];
                $file_name_pieces = explode('_', $file_name);
                $new_file_name = '';
                $count = 1;
                foreach ($file_name_pieces as $piece) {
                    if ($count !== 1) {
                        $piece = ucfirst($piece);
                    }

                    $new_file_name .= $piece;
                    $count++;
                }
                $config = array(
                    'file_name' => $new_file_name,
                    'upload_path' => "./uploads/",
                    'allowed_types' => "gif|jpg|png|svg|jpeg|pdf",
                    'overwrite' => False,
                    'max_size' => "20480000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
                    'max_height' => "10000",
                    'max_width' => "10000"
                );

                $this->load->library('Upload', $config);
                $this->upload->initialize($config);

                if ($this->upload->do_upload('partner_image_3')) {
                    $path = $this->upload->data();
                    $img_url = "uploads/" . $path['file_name'];

                    $data7 = array(
                        'partner_image_3' => $img_url
                    );
                    $this->frontend_model->updateSettings($id, $data7);
                }
                $data8 = array();
                $file_name = $_FILES['market_image']['name'];
                $file_name_pieces = explode('_', $file_name);
                $new_file_name = '';
                $count = 1;
                foreach ($file_name_pieces as $piece) {
                    if ($count !== 1) {
                        $piece = ucfirst($piece);
                    }

                    $new_file_name .= $piece;
                    $count++;
                }
                $config = array(
                    'file_name' => $new_file_name,
                    'upload_path' => "./uploads/",
                    'allowed_types' => "gif|jpg|png|svg|jpeg|pdf",
                    'overwrite' => False,
                    'max_size' => "20480000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
                    'max_height' => "10000",
                    'max_width' => "10000"
                );

                $this->load->library('Upload', $config);
                $this->upload->initialize($config);

                if ($this->upload->do_upload('market_image')) {
                    $path = $this->upload->data();
                    $img_url = "uploads/" . $path['file_name'];

                    $data8 = array(
                        'market_image' => $img_url
                    );
                    $this->frontend_model->updateSettings($id, $data8);
                }
                $data9 = array();
                $file_name = $_FILES['commentator_profile_image']['name'];
                $file_name_pieces = explode('_', $file_name);
                $new_file_name = '';
                $count = 1;
                foreach ($file_name_pieces as $piece) {
                    if ($count !== 1) {
                        $piece = ucfirst($piece);
                    }

                    $new_file_name .= $piece;
                    $count++;
                }
                $config = array(
                    'file_name' => $new_file_name,
                    'upload_path' => "./uploads/",
                    'allowed_types' => "gif|jpg|png|svg|jpeg|pdf",
                    'overwrite' => False,
                    'max_size' => "20480000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
                    'max_height' => "10000",
                    'max_width' => "10000"
                );

                $this->load->library('Upload', $config);
                $this->upload->initialize($config);

                if ($this->upload->do_upload('commentator_profile_image')) {
                    $path = $this->upload->data();
                    $img_url = "uploads/" . $path['file_name'];

                    $data9 = array(
                        'commentator_profile_image' => $img_url
                    );
                    $this->frontend_model->updateSettings($id, $data9);
                }
                $data10 = array();
                $file_name = $_FILES['commentator_logo_1']['name'];
                $file_name_pieces = explode('_', $file_name);
                $new_file_name = '';
                $count = 1;
                foreach ($file_name_pieces as $piece) {
                    if ($count !== 1) {
                        $piece = ucfirst($piece);
                    }

                    $new_file_name .= $piece;
                    $count++;
                }
                $config = array(
                    'file_name' => $new_file_name,
                    'upload_path' => "./uploads/",
                    'allowed_types' => "gif|jpg|png|svg|jpeg|pdf",
                    'overwrite' => False,
                    'max_size' => "20480000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
                    'max_height' => "10000",
                    'max_width' => "10000"
                );

                $this->load->library('Upload', $config);
                $this->upload->initialize($config);

                if ($this->upload->do_upload('commentator_logo_1')) {
                    $path = $this->upload->data();
                    $img_url = "uploads/" . $path['file_name'];

                    $data10 = array(
                        'commentator_logo_1' => $img_url
                    );
                    $this->frontend_model->updateSettings($id, $data10);
                }
                $data11 = array();
                $file_name = $_FILES['commentator_logo_2']['name'];
                $file_name_pieces = explode('_', $file_name);
                $new_file_name = '';
                $count = 1;
                foreach ($file_name_pieces as $piece) {
                    if ($count !== 1) {
                        $piece = ucfirst($piece);
                    }

                    $new_file_name .= $piece;
                    $count++;
                }
                $config = array(
                    'file_name' => $new_file_name,
                    'upload_path' => "./uploads/",
                    'allowed_types' => "gif|jpg|png|svg|jpeg|pdf",
                    'overwrite' => False,
                    'max_size' => "20480000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
                    'max_height' => "10000",
                    'max_width' => "10000"
                );

                $this->load->library('Upload', $config);
                $this->upload->initialize($config);

                if ($this->upload->do_upload('commentator_logo_2')) {
                    $path = $this->upload->data();
                    $img_url = "uploads/" . $path['file_name'];

                    $data11 = array(
                        'commentator_logo_2' => $img_url
                    );
                    $this->frontend_model->updateSettings($id, $data11);
                }
                $data12 = array();
                $file_name = $_FILES['commentator_logo_3']['name'];
                $file_name_pieces = explode('_', $file_name);
                $new_file_name = '';
                $count = 1;
                foreach ($file_name_pieces as $piece) {
                    if ($count !== 1) {
                        $piece = ucfirst($piece);
                    }

                    $new_file_name .= $piece;
                    $count++;
                }
                $config = array(
                    'file_name' => $new_file_name,
                    'upload_path' => "./uploads/",
                    'allowed_types' => "gif|jpg|png|svg|jpeg|pdf",
                    'overwrite' => False,
                    'max_size' => "20480000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
                    'max_height' => "10000",
                    'max_width' => "10000"
                );

                $this->load->library('Upload', $config);
                $this->upload->initialize($config);

                if ($this->upload->do_upload('commentator_logo_3')) {
                    $path = $this->upload->data();
                    $img_url = "uploads/" . $path['file_name'];

                    $data12 = array(
                        'commentator_logo_3' => $img_url
                    );
                    $this->frontend_model->updateSettings($id, $data12);
                }

                $data13 = array();
                $file_name = $_FILES['team_review_logo']['name'];
                $file_name_pieces = explode('_', $file_name);
                $new_file_name = '';
                $count = 1;
                foreach ($file_name_pieces as $piece) {
                    if ($count !== 1) {
                        $piece = ucfirst($piece);
                    }

                    $new_file_name .= $piece;
                    $count++;
                }
                $config = array(
                    'file_name' => $new_file_name,
                    'upload_path' => "./uploads/",
                    'allowed_types' => "gif|jpg|png|svg|jpeg|pdf",
                    'overwrite' => False,
                    'max_size' => "20480000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
                    'max_height' => "10000",
                    'max_width' => "10000"
                );

                $this->load->library('Upload', $config);
                $this->upload->initialize($config);

                if ($this->upload->do_upload('team_review_logo')) {
                    $path = $this->upload->data();
                    $img_url = "uploads/" . $path['file_name'];

                    $data13 = array(
                        'team_review_logo' => $img_url
                    );
                    $this->frontend_model->updateSettings($id, $data13);
                }

                $data14 = array();
                $file_name = $_FILES['team_commentator_image']['name'];
                $file_name_pieces = explode('_', $file_name);
                $new_file_name = '';
                $count = 1;
                foreach ($file_name_pieces as $piece) {
                    if ($count !== 1) {
                        $piece = ucfirst($piece);
                    }

                    $new_file_name .= $piece;
                    $count++;
                }
                $config = array(
                    'file_name' => $new_file_name,
                    'upload_path' => "./uploads/",
                    'allowed_types' => "gif|jpg|png|svg|jpeg|pdf",
                    'overwrite' => False,
                    'max_size' => "20480000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
                    'max_height' => "10000",
                    'max_width' => "10000"
                );

                $this->load->library('Upload', $config);
                $this->upload->initialize($config);

                if ($this->upload->do_upload('team_commentator_image')) {
                    $path = $this->upload->data();
                    $img_url = "uploads/" . $path['file_name'];

                    $data14 = array(
                        'team_commentator_image' => $img_url
                    );
                    $this->frontend_model->updateSettings($id, $data14);
                }
                show_swal(lang('updated'), 'success', lang('updated'));
                // Loading View
                redirect('frontend/settings');
            }
        } else {
            show_swal('Email Required!', 'error', lang('error'));
            redirect('frontend/settings', 'refresh');
        }
    }

    function send()
    {

        $googleReCaptchaSiteKey =  $this->settings_model->getGoogleReCaptchaSettings()->secret_key;
        $recaptcha_url = 'https://www.google.com/recaptcha/api/siteverify';
        $recaptcha_secret = $googleReCaptchaSiteKey;
        $recaptcha_response = $_POST['recaptcha_response1'];
        $recaptcha = file_get_contents($recaptcha_url . '?secret=' . $recaptcha_secret . '&response=' . $recaptcha_response);
        $recaptcha = json_decode($recaptcha);
        if ($recaptcha->score >= 0.5) {
        } else {
            show_swal(lang('not_sent'), 'error', lang('error'));
            redirect('frontend?contact_message=failed#contact');
        }


        $emailSettings = $this->email_model->getContactEmailSettings();
        $other_email = $this->input->post('other_email');
        $message = $this->input->post('message');
        $subject = $this->input->post('subject');
        $name = $this->input->post('name');
        $msg = $this->input->post('msg');
        $phone = $this->input->post('phone');
        $hospital_name = $this->input->post('hospital_name');

        $secretKey = $this->settings_model->getGoogleReCaptchaSettings()->secret_key;
        $token = $this->input->post('g-token');
        $ip = $_SERVER["REMOTE_ADDR"];
        $url = "https://www.google.com/recaptcha/api/siteverify?secret=" . $secretKey . "&response=" . $token . "&remoteip=" . $ip;
        $request = file_get_contents($url);
        $response = json_decode($request);
        if ($response->success) {
            if ($response->score > 0.8) {
            } else {
                show_swal(lang('no_sent'), 'error', lang('error'));
                redirect('frontend?contact_message=failed#contact');
            }
        } else {
            show_swal(lang('no_sent'), 'error', lang('error'));
            redirect('frontend?contact_message=failed#contact');
        }

        $data1 = array(
            'other_email' => $other_email,
            'msg' => $msg,
            'name' => $name,
            'phone' => $phone,
            'hospital_name' => $hospital_name
        );

        $recipient = $other_email;
        if (!empty($other_email)) {
            $to = $other_email;
        } else {
            if (!empty($to)) {
                $to = implode(',', $to);
            }
        }

        if (!empty($to)) {
            $autoemail = $this->email_model->getContactEmailByType('contactus');
            $subject = $this->input->post('subject');
            $message1 = $autoemail->message;
            $messageprint1 = $this->parser->parse_string($message1, $data1);
            $this->email->from($other_email);
            $this->email->to($emailSettings->admin_email);
            $this->email->subject('Contact Email');
            $this->email->message($messageprint1);
            if (function_exists('mail')) {
                $this->email->send();
            }

            show_swal(lang('request_sent_successfully'), 'success', lang('success'));
            redirect('frontend?contact_message=success#contact');
        } else {
            show_swal(lang('not_sent'), 'error', lang('error'));
            redirect('frontend?contact_message=failed#contact');
        }
    }

    public function addNewHospitalPayment()
    {



        $googleReCaptchaSiteKey =  $this->settings_model->getGoogleReCaptchaSettings()->secret_key;
        $recaptcha_url = 'https://www.google.com/recaptcha/api/siteverify';
        $recaptcha_secret = $googleReCaptchaSiteKey;
        $recaptcha_response = $_POST['recaptcha_response'];
        $recaptcha = file_get_contents($recaptcha_url . '?secret=' . $recaptcha_secret . '&response=' . $recaptcha_response);
        $recaptcha = json_decode($recaptcha);

        // if ($recaptcha->score >= 0.5) {
        // } else {
        //     show_swal(lang('not_sent'), 'error', lang('error'));
        //     redirect('frontend?#book');
        // }




        $trial_version = $this->input->post('trial_version');
        $country = $this->input->post('country');
        $name = $this->input->post('name');
        //$password = $this->input->post('password');
        $email = $this->input->post('email');
        $address = $this->input->post('address');
        $phone = $this->input->post('phone');
        $package = $this->input->post('package');
        $language = $this->input->post('language');
        $package_duration = $this->input->post('package_duration');
        $price = $this->input->post('price');
        $frontend_website_link = $this->input->post('username');
        $package_details = $this->db->get_where('package', array('id' => $package))->row();

        if ($trial_version == '1') {
            $data = array();
            $data = array(
                'name' => $name,
                'email' => $email,
                'address' => $address,
                'username' => $frontend_website_link,
                'phone' => $phone,
                'package' => $package,
                'language' => $language,
                'package_duration' => $package_duration,
                'price' => '0',
                'country' => $country,
                'package_details' => 'trial'
            );

            $this->addNewhospital($data);
        } else {
            $data = array();
            $data = array(
                'name' => $name,
                'email' => $email,
                'address' => $address,
                'phone' => $phone,
                'package' => $package,
                'country' => $country,
                'username' => $frontend_website_link,
            );
            $gateway = $this->db->get_where('settings', array('hospital_id' => 'superadmin'))->row()->payment_gateway;

            if ($gateway == 'PayPal') {
                $data['language'] = $language;
                $data['price'] = $price;
                $data['package_duration'] = $package_duration;
                $data['cardholder'] = $this->input->post('cardholder');
                $data['card_type'] = $this->input->post('card_type');
                $data['card_number'] = $this->input->post('card_number');
                $data['expire_date'] = $this->input->post('expire_date');
                $data['cvv'] = $this->input->post('cvv_number');
                $response = $this->paypal->paymentPaypalFromFrontend($data, 'Frontend');

                if ($response == 'yes') {
                    $data['gateway'] = 'PayPal';
                    $this->addNewhospital($data);
                } else {
                    show_swal(lang('Please_check_card_details'), 'warning', lang('warning'));
                    redirect('frontend?#book');
                }
            } elseif ($gateway == 'Stripe') {

                $token = $this->input->post('token');
                $stripe = $this->db->get_where('paymentGateway', array('hospital_id' => 'superadmin', 'name' => 'Stripe'))->row();

                \Stripe\Stripe::setApiKey($stripe->secret);
                $charge = \Stripe\Charge::create(array(
                    "amount" => $price * 100,
                    "currency" => "usd",
                    "source" => $token
                ));
                $chargeJson = $charge->jsonSerialize();
                if ($chargeJson['status'] == 'succeeded') {
                    $data['gateway'] = 'Stripe';
                    $data['package_duration'] = $package_duration;
                    $data['language'] = $language;
                    $data['price'] = $price;

                    $this->addNewhospital($data);
                } else {
                    show_swal(lang('Please_check_card_details'), 'warning', lang('warning'));
                    redirect('frontend?hospital_message=Please_check_card_details#book');
                }
            } elseif ($gateway == 'Pay U Money') {
                // $dfg = 11;

                // if (!empty($package)) {
                //     $data['module'] = $this->package_model->getPackageById($package)->module;
                //     $p_limit = $this->package_model->getPackageById($package)->p_limit;
                //     $d_limit = $this->package_model->getPackageById($package)->d_limit;
                // }
                // $data['p_limit'] = $p_limit;
                // $data['d_limit'] = $d_limit;
                // $this->ion_auth->register($name, '12345', $email, $dfg);
                // $ion_user_id = $this->db->get_where('users', array('email' => $email))->row()->id;
                // $data['from_where'] = 'Website';
                // $insert = $this->hospital_model->insertHospital($data);
                // $hospital_user_id = $this->db->get_where('hospital', array('email' => $email))->row()->id;
                // $id_info = array('ion_user_id' => $ion_user_id);
                // $update = $this->hospital_model->updateHospital($hospital_user_id, $id_info);
                $this->load->module('payu');
                $data['package_duration'] = $package_duration;
                $data['language'] = $language;
                $data['price'] = $price;
                $this->payu->check4($data, $price, $hospital_user_id, 'frontend');
            } elseif ($gateway == 'Paystack') {

                $paystack = $this->db->get_where('paymentGateway', array('hospital_id' => 'superadmin', 'name' => 'Paystack'))->row();

                $ref = date('Y') . '-' . rand() . date('d') . '-' . date('m');
                $amount_in_kobo = $price;
                $callback_url = base_url() . 'frontend#book';
                $postdata = array('first_name' => $name, 'email' => $email, 'amount' => $amount_in_kobo * 100, "reference" => $ref, 'callback_url' => $callback_url);

                $url = "https://api.paystack.co/transaction/initialize";
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postdata));  //Post Fields
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                //
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
                $headers = [
                    'Authorization: Bearer ' . $paystack->secret,
                    'Content-Type: application/json',
                ];
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                $request = curl_exec($ch);
                curl_close($ch);

                if ($request) {
                    $result = json_decode($request, true);
                }

                $redir = $result['data']['authorization_url'];

                header("Location: " . $redir);
                if ($result['status'] == 1) {
                    $data['gateway'] = 'Paystack';
                    $data['language'] = $language;
                    $data['package_duration'] = $package_duration;
                    $data['price'] = $price;
                    $this->addNewhospital($data);
                } else {
                    show_swal(lang('Please_check_card_details'), 'warning', lang('warning'));
                    redirect('frontend?ospital_message=Please_check_card_details#book&status=error');
                }
                exit();
            }
        }
    }

    public function addNewhospital($data1)
    {

        $name = $data1['name'];
        $password = '12345';
        $email = $data1['email'];
        $address = $data1['address'];
        $phone = $data1['phone'];
        $package = $data1['package'];
        $language = $data1['language'];
        $frontend_website_link = $data1['username'];
        $package_duration = $data1['package_duration'];
        $price = $data1['price'];
        $country = $data1['country'];
        $package_details = $data1['package_details'];
        if (empty($package_details)) {
            $gateway = $data1['gateway'];
        } else {
            $gateway = 'trial';
        }
        //$package_details=$this->package_model->getPackageById($package);
        if (!empty($package)) {
            $module = $this->package_model->getPackageById($package)->module;
            $p_limit = $this->package_model->getPackageById($package)->p_limit;
            $d_limit = $this->package_model->getPackageById($package)->d_limit;
        }




        $language_array = array('english', 'arabic', 'spanish', 'french', 'italian', 'portuguese');

        if (!in_array($language, $language_array)) {
            $language = 'english';
        }

        $data = array();
        $data = array(
            'name' => $name,
            'email' => $email,
            'address' => $address,
            'phone' => $phone,
            'package' => $package,
            'p_limit' => $p_limit,
            'd_limit' => $d_limit,
            'module' => $module,
            'country' => $country,
            'username' => $frontend_website_link,
            'from_where' => 'Website'
        );

        $username = $name;

        if ($this->ion_auth->email_check($email)) {
            show_swal(lang('this_email_address_is_already_registered'), 'error', lang('error'));
            redirect('frontend?hospital_message=this_email_address_is_already_registered#book');
        } else {


            $dfg = 11;
            $this->ion_auth->register($username, $password, $email, $dfg);
            $ion_user_id = $this->db->get_where('users', array('email' => $email))->row()->id;
            $this->hospital_model->insertHospital($data);
            $hospital_user_id = $this->db->get_where('hospital', array('email' => $email))->row()->id;
            $id_info = array('ion_user_id' => $ion_user_id);
            $this->hospital_model->updateHospital($hospital_user_id, $id_info);

            $hospital_settings_data = array();
            $hospital_settings_data = array(
                'hospital_id' => $hospital_user_id,
                'title' => $name,
                'email' => $email,
                'address' => $address,
                'phone' => $phone,
                'language' => $language,
                'system_vendor' => 'Code Aristos - Hospital management System',
                'discount' => 'flat',
                'sms_gateway' => 'Twilio',
                'currency' => '$',
                'emailtype' => 'Smtp',
                'footer_message' => 'By' . $name,
                'show_odontogram_in_history' => 'yes',
                'invoice_choose' => 'invoice1',
                'vat' => '0',
                'discount_percent' => '0'
            );
            $this->settings_model->insertSettings($hospital_settings_data);
            $hospital_blood_bank = array();
            $hospital_blood_bank = array('A+' => '0 Bags', 'A-' => '0 Bags', 'B+' => '0 Bags', 'B-' => '0 Bags', 'AB+' => '0 Bags', 'AB-' => '0 Bags', 'O+' => '0 Bags', 'O-' => '0 Bags');
            foreach ($hospital_blood_bank as $key => $value) {
                $data_bb = array('group' => $key, 'status' => $value, 'hospital_id' => $hospital_user_id);
                $this->donor_model->insertBloodBank($data_bb);
                $data_bb = NULL;
            }

            $data_sms_clickatell = array();
            $data_sms_clickatell = array(
                'name' => 'Clickatell',
                'username' => 'Your ClickAtell Username',
                'password' => 'Your ClickAtell Password',
                'api_id' => 'Your ClickAtell Api Id',
                'user' => 'self',
                'hospital_id' => $hospital_user_id
            );

            $this->sms_model->addSmsSettings($data_sms_clickatell);

            $data_sms_msg91 = array(
                'name' => 'MSG91',
                'username' => 'Your MSG91 Username',
                'api_id' => 'Your MSG91 API ID',
                'sender' => 'Sender Number',
                'authkey' => 'Your MSG91 Auth Key',
                'hospital_id' => $hospital_user_id
            );

            $this->sms_model->addSmsSettings($data_sms_msg91);

            $data_sms_twilio = array(
                'name' => 'Twilio',
                'sid' => 'SID Number',
                'token' => 'Token Number',
                'sendernumber' => 'Sender Number',
                'hospital_id' => $hospital_user_id
            );

            $this->sms_model->addSmsSettings($data_sms_twilio);
            $data_sms_80kobo = array(
                'name' => '80Kobo',
                'email' => 'Your 80Kobo Username',
                'password' => 'Your 80Kobo Password',
                'sender_name' => 'Sender Name',
                'hospital_id' => $hospital_user_id
            );

            $this->sms_model->addSmsSettings($data_sms_80kobo);

            $data_sms_hutch = array(
                'name' => 'Hutch BSMS',
                'hutch_username' => 'your@email.com',
                'hutch_password' => 'your_password',
                'mask' => 'HOSPITAL',
                'hospital_id' => $hospital_user_id
            );

            $this->sms_model->addSmsSettings($data_sms_hutch);
            $data_pgateway_paypal = array(
                'name' => 'PayPal', // Sandbox / testing mode option.
                'APIUsername' => 'PayPal API Username', // PayPal API username of the API caller
                'APIPassword' => 'PayPal API Password', // PayPal API password of the API caller
                'APISignature' => 'PayPal API Signature', // PayPal API signature of the API caller
                'status' => 'test',
                'hospital_id' => $hospital_user_id
            );

            $this->pgateway_model->addPaymentGatewaySettings($data_pgateway_paypal);

            $data_pgateway_payumoney = array(
                'name' => 'Pay U Money', // Sandbox / testing mode option.
                'merchant_key' => 'Merchant key', // PayPal API username of the API caller
                'salt' => 'Salt', // PayPal API password of the API caller
                'status' => 'test',
                'hospital_id' => $hospital_user_id
            );

            $this->pgateway_model->addPaymentGatewaySettings($data_pgateway_payumoney);

            $data_pgateway_stripe = array(
                'name' => 'Stripe', // Sandbox / testing mode option.
                'secret' => 'Secret', // Sandbox / testing mode option.
                'publish' => 'Publish', // PayPal API username of the API caller
                'hospital_id' => $hospital_user_id
            );

            $this->pgateway_model->addPaymentGatewaySettings($data_pgateway_stripe);

            $data_pgateway_payumoney = array(
                'name' => 'Paystack', // Sandbox / testing mode option.
                'public_key' => 'Public key', // PayPal API username of the API caller
                'secret' => 'secret', // PayPal API password of the API caller
                'status' => 'test',
                'hospital_id' => $hospital_user_id
            );

            $this->pgateway_model->addPaymentGatewaySettings($data_pgateway_payumoney);
            $data_email_settings = array(
                'type' => 'Domain Email',
                'admin_email' => 'Admin Email', // Sandbox / testing mode option.
                'hospital_id' => $hospital_user_id
            );
            $data_email_settings_smtp = array(
                'type' => 'Smtp',
                'smtp_host' => 'smtp_host',
                'smtp_port' => 'smtp_port',
                'send_multipart' => 'send_multipart',
                'mail_provider' => 'mail_provider',
                'hospital_id' => $hospital_user_id
            );

            $base_url = str_replace(array('http://', 'https://', ' '), '', base_url()) . "auth/login";
            $set['settings'] = $this->db->get_where('settings', array('hospital_id' => 'superadmin'))->row();
            $name1 = explode(' ', $name);
            if (!isset($name1[1])) {
                $name1[1] = null;
            }
            if (empty($package_details)) {
                if ($package_duration == 'monthly') {
                    $next_due_date_stamp = time() + 2592000;
                    $package_lang = lang('monthly');
                } else {
                    $next_due_date_stamp = time() + 31536000;
                    $package_lang = lang('yearly');
                }
            } else {
                if ($package_duration == 'monthly') {
                    $package_lang = lang('monthly');
                } else {
                    $package_lang = lang('yearly');
                }
                $next_due_date_stamp = time() + 1296000;
                $package_lang = lang($package_lang);
            }
            $next_due_date = date('d-m-Y', $next_due_date_stamp);
            $package_name = $this->db->get_where('package', array('id' => $package))->row()->name;
            $data1 = array(
                'name' => $name,
                'package_name' => $package_name,
                'subscription_duration' => $package_lang,
                'base_url' => $base_url,
                'amount' => $price,
                'password' => $password,
                'username' => $email,
                'phone' => $set['settings']->phone,
                'next_payment_date' => $next_due_date
            );
            //  $autoemail = $this->email_model->getAutoEmailByTypee('hospital');
            //if ($autoemail->status == 'Active') {

            $mail_provider = $this->db->get_where('settings', array('hospital_id' => 'superadmin'))->row()->emailtype;
            $settngs_name = $this->db->get_where('settings', array('hospital_id' => 'superadmin'))->row()->system_vendor;
            $email_Settings = $this->email_model->getAdminEmailSettingsByIdByType($mail_provider);

            $message1 = '<strong>{name}</strong> ,<br>
Your hospital is registered successfully . Please check the details Below.<br>
Package Name: {package_name}.<br>
Subscription Length: {subscription_duration}.<br>
Amount Paid: {amount}.<br>
Next Payment Date: {next_payment_date}.<br>
<u><b>Login Details:</b></u><br>
Url: {base_url}<br>
Username: {username}<br>
Password: {password}.<br>

For Any Support Please Contact with Phone No: {phone}';
            $messageprint1 = $this->parser->parse_string($message1, $data1);
            if ($mail_provider == 'Domain Email') {
                $this->load->library('email');
                $this->email->from($email_Settings->admin_email);
            }
            if ($mail_provider == 'Smtp') {
                $config['protocol'] = 'smtp';
                $config['mailpath'] = '/usr/sbin/sendmail';
                $config['smtp_host'] = $email_Settings->smtp_host;
                $config['smtp_port'] = number_format($email_Settings->smtp_port);
                $config['smtp_user'] = $email_Settings->user;
                $config['smtp_pass'] = base64_decode($email_Settings->password);
                $config['smtp_crypto'] = 'tls';
                $config['mailtype'] = 'html';
                $config['charset'] = 'utf-8';
                $config['wordwrap'] = TRUE;
                $config['send_multipart'] = TRUE;
                $config['newline'] = "\r\n";
                $this->load->library('email');
                $this->email->initialize($config);
                $this->load->library('email');
                $this->email->from($email_Settings->user, $settngs_name);
            }
            $this->email->to($email);
            $this->email->subject('Hospital Registration confirmation');
            $this->email->message($messageprint1);
            if (function_exists('mail')) {
                $this->email->send();
            }

            $this->email_model->addEmailSettings($data_email_settings_smtp);
            $this->email_model->addEmailSettings($data_email_settings);

            $this->hospital_model->createAutoSmsTemplate($hospital_user_id);
            $this->hospital_model->createAutoEmailTemplate($hospital_user_id);

            $data_payment = array();
            $data_payment = array(
                'hospital_user_id' => $hospital_user_id,
                'price' => $price,
                'package_duration' => $package_duration,
                'next_due_date_stamp' => $next_due_date_stamp,
                'next_due_date' => $next_due_date,
                'add_date_stamp' => time(),
                'add_date' => date('d-m-Y', time()),
                'package' => $package
            );
            $this->frontend_model->addHospitalPayment($data_payment);
            $inserted_id = $this->db->insert_id('hospital_payment');
            $data_deposit = array();
            $data_deposit = array(
                'payment_id' => $inserted_id,
                'date' => time(),
                'deposited_amount' => $price,
                'deposited_amount_id' => $inserted_id . 'gp',
                'gateway' => $gateway,
                'hospital_user_id' => $hospital_user_id,
                'next_due_date_stamp' => $next_due_date_stamp,
                'next_due_date' => $next_due_date,
                'add_date_stamp' => time(),
                'add_date' => date('d-m-Y', time()),
            );
            $deposit = $this->frontend_model->addHospitalDeposit($data_deposit);
            if ($deposit) {
                $data_payment_update = array('status' => 'paid');
                $this->frontend_model->updateHospitalPayment($inserted_id, $data_payment_update);
            }

            if ($gateway != 'Paystack') {
                if ($gateway == 'Pay U Money') {
                    show_swal(lang('yes'), 'success', lang('success'));

                    redirect('frontend?hospital_message=new_hospital_created#book&status=success');
                } else {
                    show_swal(lang('new_hospital_created'), 'success', lang('success'));
                    redirect('frontend?hospital_message=new_hospital_created#book&status=success');
                }
            }
        }

        // Loading View
        //}
    }

    function getPackageForHospitalRegisteration()
    {
        $id = $this->input->get('id');
        $data['package'] = $this->package_model->getPackageById($id);
        // $data['settings'] = $this->settings_model->getSettingsByHId($id);
        echo json_encode($data);
    }





    function verifyPurchase()
    {
        $data['verified'] = $this->input->get('verify');
        //   $this->load->view('home/dashboard.php');
        $this->load->view('verify', $data);
        //  $this->load->view('home/footer.php');
    }


    function verify()
    {
        $purchase_code = $this->input->post('purchase_code');
        $base_url = base_url() . '-';
        $insertPurchase = file_get_contents("http://verify.codearistos.net/api/verify?validation=" . $purchase_code . "&base_url=" . $base_url);
        $insertPurchase = json_decode($insertPurchase);
        if ($insertPurchase->message == 3) {
            show_swal('Purcase code validated successfully', 'success', lang('success'));
            redirect("frontend/verifyPurchase?verify=yes");
        } elseif ($insertPurchase->message == 1) {
            show_swal('Already Validated', 'warning', lang('warning'));
            redirect("frontend/verifyPurchase?verify=yes");
        } elseif ($insertPurchase->message == 2) {
            show_swal('This purchase code is validated for other domain. Please purchase a new licence or send request to support for removing the prevous domain.', 'error', lang('error'));
            redirect("frontend/verifyPurchase");
        } elseif ($insertPurchase->message == 4) {
            show_swal('This domain is already registerred with another purchase code.', 'error', lang('error'));
            redirect("frontend/verifyPurchase");
        } elseif ($insertPurchase->message == 0) {
            show_swal('This purchase code is invalid', 'error', lang('error'));
            redirect("frontend/verifyPurchase");
        }
    }

    function changeLanguageFlag()
    {
        $selectedLanguage = $this->input->get('lang'); // Replace this with the selected language
        $this->session->set_userdata('language_site', $selectedLanguage);
        $cookie = array(
            'name'   => 'language_site',
            'value'  => $selectedLanguage,
            'expire' => '2595000',
            'secure' => FALSE,
        );
        $this->input->set_cookie($cookie);

        redirect($_SERVER['HTTP_REFERER']);
    }



    public function chooseLanguage()
    {
        $selectedLanguage = $this->input->get('lang'); // Replace this with the selected language
        $this->session->set_userdata('language_site', $selectedLanguage);
        $cookie = array(
            'name'   => 'language_site',
            'value'  => $selectedLanguage,
            'expire' => '2595000',
            'secure' => FALSE,
        );
        $this->input->set_cookie($cookie);

        redirect($_SERVER['HTTP_REFERER']);
    }


    public function chooseLanguageForSite()
    {
        $selectedLanguage = $this->input->get('lang'); // Replace this with the selected language
        $this->session->set_userdata('language_site', $selectedLanguage);
        $cookie = array(
            'name'   => 'language_site',
            'value'  => $selectedLanguage,
            'expire' => '2595000',
            'secure' => FALSE,
        );
        $this->input->set_cookie($cookie);
        redirect($_SERVER['HTTP_REFERER']);
    }

    function checkIfUsernameAvailable()
    {
        $username = $this->input->get('username');
        $all_username = array();
        $hospitals = $this->frontend_model->getHospital();
        foreach ($hospitals as $hospital) {

            $all_username[] = $hospital->username;
        }
        if (in_array($username, $all_username)) {
            $data['check'] = 0;
        } else {
            $data['check'] = 1;
        }

        echo json_encode($data);
    }
    // Public Frontend Methods for Patient Registration and Appointment Booking

    function public_portal()
    {
        $data['settings'] = $this->db->get_where('settings', ['hospital_id' => 'superadmin'])->row();
        $data['hospitals'] = $this->hospital_model->getHospital();
        $this->load->view('public/index', $data);
    }

    function about_us()
    {
        $data['settings'] = $this->db->get_where('settings', ['hospital_id' => 'superadmin'])->row();
        $data['hospitals'] = $this->hospital_model->getHospital();
        $this->load->model('doctor/doctor_model');
        $data['doctors'] = $this->doctor_model->getDoctor();
        $this->load->view('public/about_us', $data);
    }

    function our_services()
    {
        $data['settings'] = $this->db->get_where('settings', ['hospital_id' => 'superadmin'])->row();
        $data['hospitals'] = $this->hospital_model->getHospital();
        $this->load->model('speciality/speciality_model');
        $data['specialities'] = $this->speciality_model->getAllActiveSpecialities();
        $this->load->view('public/our_services', $data);
    }

    function patient_registration()
    {
        $data['settings'] = $this->db->get_where('settings', ['hospital_id' => 'superadmin'])->row();
        $data['hospitals'] = $this->hospital_model->getHospital();

        // Debug: Log hospitals data
        log_message('debug', 'Hospitals count: ' . count($data['hospitals']));
        log_message('debug', 'Hospitals data: ' . json_encode($data['hospitals']));

        $this->load->view('public/patient_registration', $data);
    }

    function appointment_request()
    {
        $data['settings'] = $this->db->get_where('settings', ['hospital_id' => 'superadmin'])->row();
        $data['hospitals'] = $this->hospital_model->getHospital();
        $this->load->model('speciality/speciality_model');
        $data['specialities'] = $this->speciality_model->getAllActiveSpecialities();
        $this->load->view('public/appointment_request', $data);
    }

    function appointment_confirmation($appointment_id = null)
    {
        if (empty($appointment_id)) {
            redirect('frontend/public_portal');
            return;
        }

        // Load required models
        $this->load->model('appointment/appointment_model');
        $this->load->model('patient/patient_model');
        $this->load->model('doctor/doctor_model');
        $this->load->model('finance/finance_model');

        // Get appointment details
        $appointment = $this->appointment_model->getAppointmentById($appointment_id);

        if (empty($appointment)) {
            redirect('frontend/public_portal');
            return;
        }

        // Get related details
        $patient = $this->patient_model->getPatientById($appointment->patient);
        $doctor = $this->doctor_model->getDoctorById($appointment->doctor);
        $hospital = $this->hospital_model->getHospitalById($appointment->hospital_id);

        // Get payment details if exists
        $payment = $this->finance_model->getPaymentByAppointmentId($appointment_id);

        // Get visit type details
        $visit_type = null;
        if (!empty($appointment->visit_type)) {
            $this->load->model('visittype/visittype_model');
            $visit_type = $this->visittype_model->getVisitTypeById($appointment->visit_type);
        }

        // Prepare data for view
        $data['settings'] = $this->settings_model->getSettings();
        $data['appointment'] = $appointment;
        $data['patient'] = $patient;
        $data['doctor'] = $doctor;
        $data['hospital'] = $hospital;
        $data['payment'] = $payment;
        $data['visit_type'] = $visit_type;

        $this->load->view('public/appointment_confirmation', $data);
    }

    function guest_appointment()
    {
        $data['settings'] = $this->db->get_where('settings', ['hospital_id' => 'superadmin'])->row();
        $data['hospitals'] = $this->hospital_model->getHospital();
        $this->load->model('speciality/speciality_model');
        $data['specialities'] = $this->speciality_model->getAllActiveSpecialities();
        $this->load->view('public/guest_appointment', $data);
    }

    function get_doctors_by_hospital()
    {
        header('Content-Type: application/json');

        $hospital_id = $this->input->post('hospital_id');

        if (empty($hospital_id)) {
            echo json_encode(['success' => false, 'message' => 'Hospital ID required']);
            return;
        }

        $this->load->model('doctor/doctor_model');
        $doctors = $this->doctor_model->getDoctorByHospital($hospital_id);

        echo json_encode(['success' => true, 'doctors' => $doctors]);
    }

    function get_available_time_slots()
    {
        header('Content-Type: application/json');

        $doctor_id = $this->input->post('doctor_id');
        $date = $this->input->post('date');

        if (empty($doctor_id) || empty($date)) {
            echo json_encode(['success' => false, 'message' => 'Doctor ID and date required']);
            return;
        }

        // Convert date to timestamp
        $timestamp = strtotime($date);

        // Get existing appointments for this doctor on this date
        $this->load->model('appointment/appointment_model');
        $this->db->where('doctor', $doctor_id);
        $this->db->where('date', $timestamp);
        $this->db->where('status !=', 'Cancelled');
        $existing_appointments = $this->db->get('appointment')->result();

        // Get booked time slots
        $booked_slots = [];
        foreach ($existing_appointments as $appointment) {
            $booked_slots[] = $appointment->time;
        }

        // Generate available time slots (9 AM to 5 PM)
        $available_slots = [];
        for ($hour = 9; $hour <= 17; $hour++) {
            for ($minute = 0; $minute < 60; $minute += 30) {
                $time = sprintf('%02d:%02d', $hour, $minute);
                if (!in_array($time, $booked_slots)) {
                    $available_slots[] = date('g:i A', strtotime($time));
                }
            }
        }

        echo json_encode(['success' => true, 'slots' => $available_slots]);
    }

    function submit_guest_appointment()
    {
        header('Content-Type: application/json');
        ob_clean(); // Clean any previous output

        try {
            // Get form data
            $guest_name = $this->input->post('guest_name');
            $guest_phone = $this->input->post('guest_phone');
            $guest_email = $this->input->post('guest_email');
            $guest_age = $this->input->post('guest_age');
            $guest_gender = $this->input->post('guest_gender');
            $guest_address = $this->input->post('guest_address');
            $guest_emergency_contact = $this->input->post('guest_emergency_contact');
            $symptoms = $this->input->post('symptoms');
            $doctor_id = $this->input->post('doctor_id');
            $hospital_id = $this->input->post('hospital_id');
            $appointment_date = $this->input->post('appointment_date');
            $appointment_time = $this->input->post('appointment_time');

            // Validate required fields
            if (
                empty($guest_name) || empty($guest_phone) || empty($doctor_id) ||
                empty($hospital_id) || empty($appointment_date) || empty($appointment_time)
            ) {
                echo json_encode(['success' => false, 'message' => 'All required fields must be filled']);
                return;
            }

            // Convert date and time
            $date_timestamp = strtotime($appointment_date);
            $time_24hr = date('H:i', strtotime($appointment_time));

            // Load required models
            $this->load->model('appointment/appointment_model');
            $this->load->model('doctor/doctor_model');

            // Get doctor details
            $doctor = $this->doctor_model->getDoctorById($doctor_id);
            if (empty($doctor)) {
                echo json_encode(['success' => false, 'message' => 'Invalid doctor selected']);
                return;
            }

            // Check if time slot is still available
            $this->db->where('doctor', $doctor_id);
            $this->db->where('date', $date_timestamp);
            $this->db->where('time', $time_24hr);
            $this->db->where('status !=', 'Cancelled');
            $existing = $this->db->get('appointment')->row();

            if ($existing) {
                echo json_encode(['success' => false, 'message' => 'Time slot no longer available']);
                return;
            }

            // Prepare appointment data
            $appointment_data = array(
                'date' => $date_timestamp,
                'time' => $time_24hr,
                'doctor' => $doctor_id,
                'patient' => 0, // 0 indicates guest appointment
                'hospital_id' => $hospital_id,
                'status' => 'Guest Pending',
                'remarks' => $symptoms,
                'guest_name' => $guest_name,
                'guest_phone' => $guest_phone,
                'guest_email' => $guest_email,
                'guest_age' => $guest_age,
                'guest_gender' => $guest_gender,
                'guest_address' => $guest_address,
                'guest_emergency_contact' => $guest_emergency_contact,
                'booking_source' => 'online_guest'
            );

            // Insert appointment
            $appointment_id = $this->appointment_model->insertAppointment($appointment_data);

            if ($appointment_id) {
                echo json_encode([
                    'success' => true,
                    'appointment_id' => $appointment_id,
                    'message' => 'Guest appointment created successfully'
                ]);
            } else {
                echo json_encode(['success' => false, 'message' => 'Failed to create appointment']);
            }
        } catch (Exception $e) {
            log_message('error', 'Guest appointment error: ' . $e->getMessage());
            echo json_encode(['success' => false, 'message' => 'System error occurred']);
        }
        exit(); // Ensure clean exit
    }

    function guest_appointment_confirmation($appointment_id = null)
    {
        if (empty($appointment_id)) {
            redirect('frontend/public_portal');
            return;
        }

        // Load required models
        $this->load->model('appointment/appointment_model');
        $this->load->model('doctor/doctor_model');

        // Get appointment details
        $appointment = $this->appointment_model->getAppointmentById($appointment_id);

        if (empty($appointment) || $appointment->patient != 0) {
            redirect('frontend/public_portal');
            return;
        }

        // Get related details
        $doctor = $this->doctor_model->getDoctorById($appointment->doctor);
        $hospital = $this->hospital_model->getHospitalById($appointment->hospital_id);

        // Prepare data for view
        $data['settings'] = $this->settings_model->getSettings();
        $data['appointment'] = $appointment;
        $data['doctor'] = $doctor;
        $data['hospital'] = $hospital;

        $this->load->view('public/guest_appointment_confirmation', $data);
    }

    function check_existing_patient()
    {
        header('Content-Type: application/json');

        $email = $this->input->post('email');
        $phone = $this->input->post('phone');

        $patient = null;
        if (!empty($email)) {
            $patient = $this->patient_model->getPatientByEmail($email);
        }

        if (!$patient && !empty($phone)) {
            // First check if phone exists in users table
            $this->db->where('phone', $phone);
            $user = $this->db->get('users')->row();

            if ($user) {
                // Phone exists in users table but let's check if it's a patient
                $this->db->where('phone', $phone);
                $patient = $this->db->get('patient')->row();

                if ($patient) {
                    // User exists and is a patient - show patient details
                    $hospital_name = '';
                    if (!empty($patient->hospital_id)) {
                        $hospital = $this->db->get_where('hospital', array('id' => $patient->hospital_id))->row();
                        if ($hospital) {
                            $hospital_name = $hospital->name;
                        }
                    }

                    echo json_encode(array(
                        'exists' => true,
                        'is_patient' => true,
                        'patient' => array(
                            'id' => $patient->id,
                            'name' => $patient->name,
                            'email' => $patient->email,
                            'phone' => $patient->phone,
                            'hospital_id' => $patient->hospital_id,
                            'hospital_name' => $hospital_name
                        )
                    ));
                    return;
                } else {
                    // User exists but is not a patient (could be doctor, admin, etc.)
                    echo json_encode(array(
                        'exists' => true,
                        'is_patient' => false,
                        'message' => 'This phone number is already registered in the system but not as a patient'
                    ));
                    return;
                }
            } else {
                // Phone doesn't exist in users table, also check patient table as backup
                $this->db->where('phone', $phone);
                $patient = $this->db->get('patient')->row();
            }
        }

        if ($patient) {
            $hospital_name = '';
            if (!empty($patient->hospital_id)) {
                $hospital = $this->db->get_where('hospital', array('id' => $patient->hospital_id))->row();
                if ($hospital) {
                    $hospital_name = $hospital->name;
                }
            }

            echo json_encode(array(
                'exists' => true,
                'is_patient' => true,
                'patient' => array(
                    'id' => $patient->id,
                    'name' => $patient->name,
                    'email' => $patient->email,
                    'phone' => $patient->phone,
                    'hospital_id' => $patient->hospital_id,
                    'hospital_name' => $hospital_name
                )
            ));
        } else {
            echo json_encode(array('exists' => false));
        }
    }

    function check_existing_patient_by_phone()
    {
        header('Content-Type: application/json');

        $phone = $this->input->post('phone');

        if (empty($phone)) {
            echo json_encode(array('exists' => false));
            return;
        }

        // First check if phone exists in users table
        $this->db->where('phone', $phone);
        $user = $this->db->get('users')->row();

        if ($user) {
            // Phone exists in users table but let's check if it's a patient
            $this->db->where('phone', $phone);
            $patient = $this->db->get('patient')->row();

            if ($patient) {
                // User exists and is a patient - show patient details
                $hospital_name = '';
                if (!empty($patient->hospital_id)) {
                    $hospital = $this->db->get_where('hospital', array('id' => $patient->hospital_id))->row();
                    if ($hospital) {
                        $hospital_name = $hospital->name;
                    }
                }

                echo json_encode(array(
                    'exists' => true,
                    'is_patient' => true,
                    'patient' => array(
                        'id' => $patient->id,
                        'name' => $patient->name,
                        'email' => $patient->email,
                        'phone' => $patient->phone,
                        'hospital_id' => $patient->hospital_id,
                        'hospital_name' => $hospital_name
                    )
                ));
            } else {
                // User exists but is not a patient (could be doctor, admin, etc.)
                echo json_encode(array(
                    'exists' => true,
                    'is_patient' => false,
                    'message' => 'This phone number is already registered in the system but not as a patient'
                ));
            }
        } else {
            // Phone doesn't exist in users table, also check patient table as backup
            $this->db->where('phone', $phone);
            $patient = $this->db->get('patient')->row();

            if ($patient) {
                // Patient exists but no user record - orphaned patient record
                $hospital_name = '';
                if (!empty($patient->hospital_id)) {
                    $hospital = $this->db->get_where('hospital', array('id' => $patient->hospital_id))->row();
                    if ($hospital) {
                        $hospital_name = $hospital->name;
                    }
                }

                echo json_encode(array(
                    'exists' => true,
                    'is_patient' => true,
                    'patient' => array(
                        'id' => $patient->id,
                        'name' => $patient->name,
                        'email' => $patient->email,
                        'phone' => $patient->phone,
                        'hospital_id' => $patient->hospital_id,
                        'hospital_name' => $hospital_name
                    )
                ));
            } else {
                // Phone doesn't exist anywhere - new user
                echo json_encode(array('exists' => false));
            }
        }
    }

    function check_phone_exists()
    {
        header('Content-Type: application/json');

        $phone = $this->input->post('phone');

        if (empty($phone)) {
            echo json_encode(array('exists' => false));
            return;
        }

        // Check in users table
        $this->db->where('phone', $phone);
        $user = $this->db->get('users')->row();

        if ($user) {
            echo json_encode(array(
                'exists' => true,
                'message' => 'This phone number is already registered in the system'
            ));
        } else {
            // Also check in patient table as backup
            $this->db->where('phone', $phone);
            $patient = $this->db->get('patient')->row();

            if ($patient) {
                echo json_encode(array(
                    'exists' => true,
                    'message' => 'This phone number is already registered as a patient'
                ));
            } else {
                echo json_encode(array('exists' => false));
            }
        }
    }

    function check_existing_doctor_by_phone()
    {
        header('Content-Type: application/json');

        $phone = $this->input->post('phone');

        if (empty($phone)) {
            echo json_encode(array('exists' => false));
            return;
        }

        // First check if phone exists in users table
        $this->db->where('phone', $phone);
        $user = $this->db->get('users')->row();

        if ($user) {
            // Phone exists in users table but let's check if it's a doctor
            $this->db->where('phone', $phone);
            $doctor = $this->db->get('doctor')->row();

            if ($doctor) {
                // User exists and is a doctor - show doctor details
                $hospital_name = '';
                if (!empty($doctor->hospital_id)) {
                    $hospital = $this->db->get_where('hospital', array('id' => $doctor->hospital_id))->row();
                    if ($hospital) {
                        $hospital_name = $hospital->name;
                    }
                }

                echo json_encode(array(
                    'exists' => true,
                    'is_doctor' => true,
                    'doctor' => array(
                        'id' => $doctor->id,
                        'name' => $doctor->name,
                        'email' => $doctor->email,
                        'phone' => $doctor->phone,
                        'department' => $doctor->department,
                        'hospital_id' => $doctor->hospital_id,
                        'hospital_name' => $hospital_name
                    )
                ));
            } else {
                // User exists but is not a doctor (could be patient, admin, etc.)
                echo json_encode(array(
                    'exists' => true,
                    'is_doctor' => false,
                    'message' => 'This phone number is already registered in the system but not as a doctor'
                ));
            }
        } else {
            // Phone doesn't exist in users table, also check doctor table as backup
            $this->db->where('phone', $phone);
            $doctor = $this->db->get('doctor')->row();

            if ($doctor) {
                // Doctor exists but no user record - orphaned doctor record
                $hospital_name = '';
                if (!empty($doctor->hospital_id)) {
                    $hospital = $this->db->get_where('hospital', array('id' => $doctor->hospital_id))->row();
                    if ($hospital) {
                        $hospital_name = $hospital->name;
                    }
                }

                echo json_encode(array(
                    'exists' => true,
                    'is_doctor' => true,
                    'doctor' => array(
                        'id' => $doctor->id,
                        'name' => $doctor->name,
                        'email' => $doctor->email,
                        'phone' => $doctor->phone,
                        'department' => $doctor->department,
                        'hospital_id' => $doctor->hospital_id,
                        'hospital_name' => $hospital_name
                    )
                ));
            } else {
                // Phone doesn't exist anywhere - new user
                echo json_encode(array('exists' => false));
            }
        }
    }

    function register_patient()
    {
        header('Content-Type: application/json');
        ob_clean(); // Clear any previous output

        try {
            // Log all POST data for debugging
            log_message('debug', 'Patient registration POST data: ' . json_encode($this->input->post()));

            $name = $this->input->post('name');
            $email = $this->input->post('email');
            $phone = $this->input->post('phone');
            $address = $this->input->post('address');
            $age = $this->input->post('age');
            $sex = $this->input->post('sex');
            $hospital_id = $this->input->post('hospital_id');
            $sms_language = 'english';

            // Load Simple OTP library for verification
            $this->load->library('simple_otp');
            // Validation
            if (empty($name)) {
                echo json_encode(array('success' => false, 'message' => 'Name is required'));
                return;
            }

            if (empty($phone)) {
                echo json_encode(array('success' => false, 'message' => 'Phone number is required'));
                return;
            }

            if (empty($hospital_id)) {
                echo json_encode(array('success' => false, 'message' => 'Hospital selection is required'));
                return;
            }

            if (empty($age) || !is_numeric($age) || $age < 1 || $age > 120) {
                echo json_encode(array('success' => false, 'message' => 'Valid age is required'));
                return;
            }

            if (empty($sex)) {
                echo json_encode(array('success' => false, 'message' => 'Gender is required'));
                return;
            }

            if (empty($address)) {
                echo json_encode(array('success' => false, 'message' => 'Address is required'));
                return;
            }

            // Check OTP verification before proceeding
            if (!$this->simple_otp->hasVerifiedOTP($phone, 'patient_registration', 30)) {
                echo json_encode(array('success' => false, 'message' => 'Phone number verification required. Please complete OTP verification first.'));
                return;
            }

            // Check if phone number already exists in users table (for login accounts)
            if ($this->ion_auth->phone_check($phone)) {
                echo json_encode(array('success' => false, 'message' => 'This phone number is already registered'));
                return;
            }

            // Also check patient table as backup
            $this->db->where('phone', $phone);
            $existing_patient = $this->db->get('patient')->row();

            if ($existing_patient) {
                echo json_encode(array('success' => false, 'message' => 'This phone number is already registered'));
                return;
            }

            // Check if email already exists (only if email is provided)
            if (!empty($email)) {
                $this->db->where('email', $email);
                $existing_email = $this->db->get('patient')->row();

                if ($existing_email) {
                    echo json_encode(array('success' => false, 'message' => 'This email address is already registered'));
                    return;
                }
            }

            // Generate default email if not provided
            if (empty($email)) {
                $email = $name . '@' . $phone . '.com';
            }

            // Generate default password
            $password = 12345;

            // Create patient data
            $patient_data = array(
                'name' => $name,
                'email' => $email,
                'phone' => $phone,
                'address' => $address,
                'age' => $age,
                'sex' => $sex,
                'hospital_id' => $hospital_id,
                'patient_id' => 'P' . time(),
                'add_date' => date('Y-m-d H:i:s'),
                'how_added' => 'from_registration',
                'payment_confirmation' => 'Active',
                'appointment_confirmation' => 'Active',
                'appointment_creation' => 'Active',
                'meeting_schedule' => 'Active'
            );

            // Create user account for login access using ion_auth
            $dfg = 5; // Patient group ID
            $additional_data = array('phone' => $phone);
            $user_created = $this->ion_auth->register($phone, $password, $email, $dfg, $additional_data);

            if ($user_created) {
                // Get the ion_user_id
                $identity_column = $this->config->item('identity', 'ion_auth');
                $ion_user_id = $this->db->get_where('users', array($identity_column => $phone))->row()->id;

                // Save original password for SMS and first-time login detection
                $this->db->update('users', array('original_password' => $password), array('id' => $ion_user_id));

                // Insert patient record
                $this->db->insert('patient', $patient_data);
                $patient_id = $this->db->insert_id();

                if ($patient_id) {
                    // Update patient with ion_user_id
                    $this->db->update('patient', array('ion_user_id' => $ion_user_id), array('id' => $patient_id));

                    // Add hospital_id to ion_user
                    $this->hospital_model->addHospitalIdToIonUser($ion_user_id, $hospital_id);




                    // Send clean JSON response and exit immediately
                    echo json_encode(array(
                        'success' => true,
                        'patient_id' => $patient_id,
                        'message' => 'Patient registered successfully! You can now login with phone: ' . $phone . ' and password: ' . $password,
                        'sms_data' => array(
                            'phone' => $phone,
                            'patient_id' => $patient_id,
                            'name' => $name,
                            'email' => $email,
                            'password' => $password,
                            'hospital_id' => $hospital_id
                        )
                    ));
                    exit(); // CRITICAL: Exit immediately to prevent any SMS output contamination

                } else {
                    echo json_encode(array(
                        'success' => false,
                        'message' => 'Failed to create patient record. Please try again.'
                    ));
                }
            } else {
                echo json_encode(array(
                    'success' => false,
                    'message' => 'Failed to create user account. Phone number might already be registered.'
                ));
            }
        } catch (Exception $e) {
            log_message('error', 'Patient Registration Error: ' . $e->getMessage());
            echo json_encode(array(
                'success' => false,
                'message' => 'System error occurred: ' . $e->getMessage()
            ));
        }
    }

    /**
     * Send registration SMS separately (called after successful registration)
     */
    public function send_registration_sms()
    {
        header('Content-Type: application/json');

        try {
            $phone = $this->input->post('phone');
            $patient_id = $this->input->post('patient_id');
            $name = $this->input->post('name');
            $email = $this->input->post('email');
            $password = $this->input->post('password');
            $hospital_id = $this->input->post('hospital_id');
            $sms_language = 'english';

            if (empty($phone) || empty($patient_id) || empty($hospital_id)) {
                echo json_encode(array('success' => false, 'message' => 'Missing required data for SMS'));
                return;
            }

            $set['settings'] = $this->db->get_where('settings', array('hospital_id' => $hospital_id))->row();
            $autosms = $this->frontend_model->getAutoSmsByType('patient_registration', $sms_language, $hospital_id);
            $message = $autosms->message;
            $to = $phone;
            $name1 = explode(' ', $name);
            if (!isset($name1[1])) {
                $name1[1] = null;
            }
            $data1 = array(
                'firstname' => $name1[0],
                'lastname' => $name1[1],
                'name' => $name,
                'email' => $email,
                'password' => $password,
                'patient_id' => $patient_id,
                'hospital_name' => $set['settings']->system_vendor
            );

            $hospital_info = $this->hospital_model->getHospitalById($hospital_id);
            $hospital_sms_doctor_registration = $hospital_info->sms_doctor_registration;

            if ($hospital_sms_doctor_registration == 'yes' && $autosms->status == 'Active') {
                $messageprint = $this->parser->parse_string($message, $data1);
                $data2[] = array($to => $messageprint);
                $this->sendSms($to, $messageprint, $data2, $hospital_id);

                echo json_encode(array('success' => true, 'message' => 'SMS sent successfully'));
            } else {
                echo json_encode(array('success' => false, 'message' => 'SMS not configured or disabled'));
            }
        } catch (Exception $e) {
            log_message('error', 'SMS Sending Error: ' . $e->getMessage());
            echo json_encode(array('success' => false, 'message' => 'Failed to send SMS'));
        }
    }

    /**
     * Send doctor registration SMS separately
     */
    public function send_doctor_registration_sms()
    {
        header('Content-Type: application/json');

        try {
            $phone = $this->input->post('phone');
            $doctor_id = $this->input->post('doctor_id');
            $name = $this->input->post('name');
            $email = $this->input->post('email');
            $password = $this->input->post('password');
            $department = $this->input->post('department');
            $hospital_id = $this->input->post('hospital_id');
            $sms_language = 'english';

            if (empty($phone) || empty($doctor_id) || empty($hospital_id)) {
                echo json_encode(array('success' => false, 'message' => 'Missing required data for SMS'));
                return;
            }

            $set['settings'] = $this->db->get_where('settings', array('hospital_id' => $hospital_id))->row();
            $autosms = $this->frontend_model->getAutoSmsByType('doctor_registration', $sms_language, $hospital_id);

            if (is_object($autosms) && isset($autosms->message)) {
                $message = $autosms->message;
                $to = $phone;
                $name1 = explode(' ', $name);
                if (!isset($name1[1])) {
                    $name1[1] = null;
                }
                $data1 = array(
                    'firstname' => $name1[0],
                    'lastname' => $name1[1],
                    'name' => $name,
                    'email' => $email,
                    'password' => $password,
                    'department' => $department,
                    'hospital_name' => $set['settings']->system_vendor
                );

                $hospital_info = $this->hospital_model->getHospitalById($hospital_id);
                $hospital_sms_doctor_registration = $hospital_info->sms_doctor_registration;

                if ($hospital_sms_doctor_registration == 'yes' && $autosms->status == 'Active') {
                    $messageprint = $this->parser->parse_string($message, $data1);
                    $data2[] = array($to => $messageprint);
                    $this->sendSms($to, $messageprint, $data2, $hospital_id);

                    echo json_encode(array('success' => true, 'message' => 'SMS sent successfully'));
                } else {
                    echo json_encode(array('success' => false, 'message' => 'SMS not configured or disabled'));
                }
            } else {
                echo json_encode(array('success' => false, 'message' => 'SMS template not found'));
            }
        } catch (Exception $e) {
            log_message('error', 'Doctor SMS Sending Error: ' . $e->getMessage());
            echo json_encode(array('success' => false, 'message' => 'Failed to send SMS'));
        }
    }

    function register_doctor()
    {
        header('Content-Type: application/json');
        ob_clean(); // Clear any previous output

        try {
            // Load required models
            $this->load->model('hospital/hospital_model');
            $this->load->library('otp_lib');

            // Log all POST data for debugging
            log_message('debug', 'Doctor registration POST data: ' . json_encode($this->input->post()));

            $name = $this->input->post('name');
            $email = $this->input->post('email');
            $phone = $this->input->post('phone');
            $address = $this->input->post('address');
            $department = $this->input->post('department');
            $profile = $this->input->post('profile');
            $hospital_id = $this->input->post('hospital_id');
            $sms_language = 'english';
            $speciality_id = $this->input->post('speciality_id');
            $speciality_details = $this->speciality_model->getSpecialityById($speciality_id);

            // Log extracted values
            log_message('debug', 'Doctor registration extracted values: name=' . $name . ', phone=' . $phone . ', department=' . $department . ', hospital_id=' . $hospital_id);

            // Validation with detailed logging
            if (empty($name)) {
                log_message('error', 'Doctor registration failed: Name is empty');
                echo json_encode(array('success' => false, 'message' => 'Name is required'));
                exit;
            }

            if (empty($phone)) {
                log_message('error', 'Doctor registration failed: Phone is empty');
                echo json_encode(array('success' => false, 'message' => 'Phone number is required'));
                exit;
            }

            if (empty($hospital_id)) {
                log_message('error', 'Doctor registration failed: Hospital ID is empty');
                echo json_encode(array('success' => false, 'message' => 'Hospital selection is required'));
                exit;
            }

            // Speciality is optional - no validation required

            if (empty($profile)) {
                log_message('error', 'Doctor registration failed: Profile is empty');
                echo json_encode(array('success' => false, 'message' => 'Qualification is required'));
                exit;
            }

            if (empty($address)) {
                log_message('error', 'Doctor registration failed: Address is empty');
                echo json_encode(array('success' => false, 'message' => 'Address is required'));
                exit;
            }

            // Check OTP verification before proceeding
            if (!$this->otp_lib->hasVerifiedOTP($phone, 'doctor_registration', 30)) {
                echo json_encode(array('success' => false, 'message' => 'Phone number verification required. Please complete OTP verification first.'));
                exit;
            }

            // Check if phone number already exists
            $this->db->where('phone', $phone);
            $existing_user = $this->db->get('users')->row();

            if ($existing_user) {
                log_message('debug', 'Doctor registration failed: Phone already exists in users table');
                echo json_encode(array('success' => false, 'message' => 'This phone number is already registered'));
                exit;
            }

            // Check if email already exists (only if email is provided)
            if (!empty($email)) {
                $this->db->where('email', $email);
                $existing_email = $this->db->get('doctor')->row();

                if ($existing_email) {
                    log_message('debug', 'Doctor registration failed: Email already exists in doctor table');
                    echo json_encode(array('success' => false, 'message' => 'This email address is already registered'));
                    exit;
                }
            }

            // Generate default email if not provided
            if (empty($email)) {
                $email = $name . '@' . $phone . '.com';
            }

            // Generate default password
            $password = 12345;

            // Get speciality details for department_name (speciality is optional)
            $speciality_name = 'General'; // Default value
            if (!empty($department)) {
                $this->db->where('id', $department);
                $speciality_details = $this->db->get('speciality')->row();
                $speciality_name = $speciality_details ? $speciality_details->name : 'General';
            }

            // Create doctor data with only confirmed existing fields from doctor controller
            $doctor_data = array(
                'name' => $name,
                'email' => $email,
                'phone' => $phone,
                'address' => $address,
                'department' => !empty($department) ? $department : null,
                'department_name' => $speciality_name,
                'profile' => $profile,
                'qualification' => $profile,
                'hospital_id' => $hospital_id,
                'speciality_id' => !empty($department) ? $department : null,
                'schedule_type' => 'weekday',
                'online_payment_enabled' => 'optional',
                'cancellation_permission' => 'allow',
                'sms_advanced_paid_bookings' => 'yes',
                'sms_online_no_payment' => 'yes',
                'sms_ivr_bookings' => 'yes',
                'appointment_confirmation' => 'Active'
            );

            log_message('debug', 'Doctor registration data to insert: ' . json_encode($doctor_data));

            // Create user account for login access using ion_auth
            $dfg = 4; // Doctor group ID
            $additional_data = array('phone' => $phone);
            $user_created = $this->ion_auth->register($phone, $password, $email, $dfg, $additional_data);

            if ($user_created) {
                // Get the ion_user_id
                $identity_column = $this->config->item('identity', 'ion_auth');
                $ion_user_id = $this->db->get_where('users', array($identity_column => $phone))->row()->id;

                // Save original password for SMS and first-time login detection
                $this->db->update('users', array('original_password' => $password), array('id' => $ion_user_id));

                // Insert doctor record
                $insert_result = $this->db->insert('doctor', $doctor_data);
                $doctor_id = $this->db->insert_id();

                // Check for database errors
                if ($this->db->error()['code'] !== 0) {
                    $db_error = $this->db->error();
                    log_message('error', 'Doctor registration database error: ' . json_encode($db_error));
                    echo json_encode(array(
                        'success' => false,
                        'message' => 'Database error: ' . $db_error['message']
                    ));
                    exit;
                }

                if ($doctor_id && $insert_result) {
                    // Update doctor with ion_user_id
                    $this->db->update('doctor', array('ion_user_id' => $ion_user_id), array('id' => $doctor_id));

                    // Add hospital_id to ion_user
                    $this->hospital_model->addHospitalIdToIonUser($ion_user_id, $hospital_id);
                    log_message('debug', 'Doctor registration successful: doctor_id=' . $doctor_id);

                    // Send clean JSON response and exit immediately  
                    echo json_encode(array(
                        'success' => true,
                        'doctor_id' => $doctor_id,
                        'message' => 'Doctor registered successfully! You can now login with phone: ' . $phone . ' and password: ' . $password,
                        'sms_data' => array(
                            'phone' => $phone,
                            'doctor_id' => $doctor_id,
                            'name' => $name,
                            'email' => $email,
                            'password' => $password,
                            'department' => $speciality_name,
                            'hospital_id' => $hospital_id
                        )
                    ));
                    exit(); // CRITICAL: Exit immediately to prevent SMS output contamination
                } else {
                    log_message('error', 'Doctor registration failed: Insert returned false or no ID');
                    echo json_encode(array(
                        'success' => false,
                        'message' => 'Failed to register doctor. Database insert failed.'
                    ));
                }
            } else {
                echo json_encode(array(
                    'success' => false,
                    'message' => 'Failed to create user account. Phone number might already be registered.'
                ));
            }
        } catch (Exception $e) {
            log_message('error', 'Doctor registration exception: ' . $e->getMessage());
            echo json_encode(array(
                'success' => false,
                'message' => 'System error: ' . $e->getMessage(),
                'debug_info' => array(
                    'POST_data' => $this->input->post(),
                    'error_line' => $e->getLine(),
                    'error_file' => $e->getFile()
                )
            ));
        }

        exit;
    }

    function doctor_registration()
    {
        $data['settings'] = $this->db->get_where('settings', ['hospital_id' => 'superadmin'])->row();
        $data['hospitals'] = $this->hospital_model->getHospital();

        // Debug: Log hospitals data
        log_message('debug', 'Hospitals count: ' . count($data['hospitals']));
        log_message('debug', 'Hospitals data: ' . json_encode($data['hospitals']));

        $this->load->view('public/doctor_registration', $data);
    }

    function get_specialities_by_hospital()
    {
        header('Content-Type: application/json');

        $hospital_id = $this->input->post('hospital_id');

        $this->db->select('*');
        $this->db->from('speciality');
        $this->db->where('status', 'active');

        if (!empty($hospital_id)) {
            $this->db->where('hospital_id', $hospital_id);
        }

        $this->db->order_by('name', 'asc');
        $specialities = $this->db->get()->result();

        echo json_encode($specialities);
    }

    function get_doctors_by_speciality()
    {
        header('Content-Type: application/json');

        $hospital_id = $this->input->post('hospital_id');
        $speciality_id = $this->input->post('speciality_id');

        $this->db->select('doctor.*, hospital.name as hospital_name, speciality.name as speciality_name');
        $this->db->from('doctor');
        $this->db->join('hospital', 'doctor.hospital_id = hospital.id', 'left');
        $this->db->join('speciality', 'doctor.speciality_id = speciality.id', 'left');

        if (!empty($speciality_id)) {
            $this->db->where('doctor.speciality_id', $speciality_id);
        }
        if (!empty($hospital_id)) {
            $this->db->where('doctor.hospital_id', $hospital_id);
        }

        // Don't check available field - show all doctors regardless of available status
        $this->db->order_by('doctor.name', 'asc');
        $doctors = $this->db->get()->result();

        echo json_encode($doctors);
    }

    function get_doctors_filtered()
    {
        header('Content-Type: application/json');

        $hospital_id = $this->input->post('hospital_id');
        $speciality_id = $this->input->post('speciality_id');

        $this->db->select('doctor.*, hospital.name as hospital_name, speciality.name as speciality_name');
        $this->db->from('doctor');
        $this->db->join('hospital', 'doctor.hospital_id = hospital.id', 'left');
        $this->db->join('speciality', 'doctor.speciality_id = speciality.id', 'left');

        if (!empty($hospital_id)) {
            $this->db->where('doctor.hospital_id', $hospital_id);
        }
        if (!empty($speciality_id)) {
            $this->db->where('doctor.speciality_id', $speciality_id);
        }

        // Don't check available field - show all doctors regardless of available status
        $this->db->order_by('doctor.name', 'asc');
        $doctors = $this->db->get()->result();

        echo json_encode($doctors);
    }

    function search_doctors()
    {
        header('Content-Type: application/json');

        $search_term = $this->input->post('search_term');

        if (empty($search_term) || strlen(trim($search_term)) < 2) {
            echo json_encode([]);
            return;
        }

        $search_term = trim($search_term);

        $this->db->select('doctor.*, hospital.name as hospital_name, speciality.name as speciality_name');
        $this->db->from('doctor');
        $this->db->join('hospital', 'doctor.hospital_id = hospital.id', 'left');
        $this->db->join('speciality', 'doctor.speciality_id = speciality.id', 'left');

        $this->db->group_start();
        $this->db->like('doctor.name', $search_term);
        $this->db->or_like('hospital.name', $search_term);
        $this->db->or_like('speciality.name', $search_term);
        $this->db->group_end();

        // Don't check available field - show all doctors regardless of available status
        $this->db->order_by('doctor.name', 'asc');
        $this->db->limit(20);

        $doctors = $this->db->get()->result();

        echo json_encode($doctors);
    }

    function get_doctor_details()
    {
        $doctor_id = $this->input->post('doctor_id');

        if (empty($doctor_id)) {
            echo json_encode(['success' => false, 'message' => 'Doctor ID required']);
            return;
        }

        $this->db->select('doctor.*, hospital.name as hospital_name, hospital.id as hospital_id, speciality.name as speciality_name, speciality.id as speciality_id');
        $this->db->from('doctor');
        $this->db->join('hospital', 'doctor.hospital_id = hospital.id', 'left');
        $this->db->join('speciality', 'doctor.speciality_id = speciality.id', 'left');
        $this->db->where('doctor.id', $doctor_id);

        $doctor = $this->db->get()->row();

        if ($doctor) {
            // Ensure online_payment_enabled has a default value if null
            if (empty($doctor->online_payment_enabled)) {
                $doctor->online_payment_enabled = 'disabled';
            }

            echo json_encode(['success' => true, 'doctor' => $doctor]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Doctor not found']);
        }
    }

    function get_available_dates()
    {
        $doctor_id = $this->input->post('doctor_id');

        if (empty($doctor_id)) {
            echo json_encode(['success' => false, 'message' => 'Doctor ID required']);
            return;
        }

        // Get doctor's schedule type
        $this->db->select('schedule_type');
        $this->db->where('id', $doctor_id);
        $doctor = $this->db->get('doctor')->row();

        if (!$doctor) {
            echo json_encode(['success' => false, 'message' => 'Doctor not found']);
            return;
        }

        $schedule_type = $doctor->schedule_type ?? 'weekday'; // Default to weekday if not set

        // Get available dates for the next 90 days
        $start_date = time(); // Today
        $end_date = strtotime('+90 days'); // Next 90 days

        // Get all holidays for this doctor in the date range to avoid repeated queries
        $this->db->where('doctor', $doctor_id);
        $this->db->where('date >=', $start_date);
        $this->db->where('date <=', $end_date);
        $holidays = $this->db->get('holidays')->result();
        $holiday_dates = array();
        foreach ($holidays as $holiday) {
            $holiday_dates[] = $holiday->date;
        }

        if ($schedule_type === 'date') {
            // Handle date-based scheduling
            $available_dates = $this->getDateBasedAvailableDates($doctor_id, $start_date, $end_date, $holiday_dates);
        } else {
            // Handle traditional weekday-based scheduling
            $available_dates = $this->getWeekdayBasedAvailableDates($doctor_id, $start_date, $end_date, $holiday_dates);
        }

        echo json_encode([
            'success' => true,
            'available_dates' => $available_dates,
            'schedule_type' => $schedule_type
        ]);
    }

    private function getWeekdayBasedAvailableDates($doctor_id, $start_date, $end_date, $holiday_dates)
    {
        // Get all time slots for this doctor grouped by weekday
        $this->db->where('doctor', $doctor_id);
        $this->db->where('schedule_type', 'weekday'); // Only weekday schedules
        $this->db->order_by('weekday, s_time_key', 'asc');
        $time_slots = $this->db->get('time_slot')->result();

        $slots_by_weekday = array();
        foreach ($time_slots as $slot) {
            if (!isset($slots_by_weekday[$slot->weekday])) {
                $slots_by_weekday[$slot->weekday] = array();
            }
            $slots_by_weekday[$slot->weekday][] = $slot;
        }

        // If doctor has no time slots, return empty
        if (empty($slots_by_weekday)) {
            return array();
        }

        // Get all booked appointments for this doctor in the date range
        $start_date_string = date('Y-m-d', $start_date);
        $end_date_string = date('Y-m-d', $end_date);

        $this->db->where('doctor', $doctor_id);
        $this->db->where('date >=', $start_date_string);
        $this->db->where('date <=', $end_date_string);
        $this->db->where('status !=', 'Cancelled');
        $booked_appointments = $this->db->get('appointment')->result();

        $booked_slots_by_date = array();
        foreach ($booked_appointments as $appointment) {
            if (!isset($booked_slots_by_date[$appointment->date])) {
                $booked_slots_by_date[$appointment->date] = array();
            }
            $booked_slots_by_date[$appointment->date][] = $appointment->time_slot;
        }

        $available_dates = array();

        // Check each date in the range
        for ($current_date = $start_date; $current_date <= $end_date; $current_date = strtotime('+1 day', $current_date)) {
            $weekday = date("l", $current_date);
            $date_string = date('Y-m-d', $current_date);

            // Skip if doctor is on holiday
            if (in_array($current_date, $holiday_dates)) {
                continue;
            }

            // Skip if no time slots for this weekday
            if (!isset($slots_by_weekday[$weekday])) {
                continue;
            }

            // Get booked slots for this date
            $booked_slots = isset($booked_slots_by_date[$date_string]) ? $booked_slots_by_date[$date_string] : array();

            // Check if there are any available slots for this date
            $has_available_slots = false;
            foreach ($slots_by_weekday[$weekday] as $slot) {
                $slot_text = $slot->s_time . ' To ' . $slot->e_time;
                if (!in_array($slot_text, $booked_slots)) {
                    $has_available_slots = true;
                    break;
                }
            }

            if ($has_available_slots) {
                $available_dates[] = $date_string;
            }
        }

        return $available_dates;
    }

    private function getDateBasedAvailableDates($doctor_id, $start_date, $end_date, $holiday_dates)
    {
        // Get all date-based schedules for this doctor from unified time_schedule table
        $this->db->where('doctor', $doctor_id);
        $this->db->where('schedule_type', 'date');
        $date_schedules = $this->db->get('time_schedule')->result();

        if (empty($date_schedules)) {
            return array();
        }

        // Get all booked appointments for this doctor in the date range
        $start_date_string = date('Y-m-d', $start_date);
        $end_date_string = date('Y-m-d', $end_date);

        $this->db->where('doctor', $doctor_id);
        $this->db->where('date >=', $start_date_string);
        $this->db->where('date <=', $end_date_string);
        $this->db->where('status !=', 'Cancelled');
        $booked_appointments = $this->db->get('appointment')->result();

        $booked_slots_by_date = array();
        foreach ($booked_appointments as $appointment) {
            if (!isset($booked_slots_by_date[$appointment->date])) {
                $booked_slots_by_date[$appointment->date] = array();
            }
            $booked_slots_by_date[$appointment->date][] = $appointment->time_slot;
        }

        $available_dates = array();

        // Check each date in the range
        for ($current_date = $start_date; $current_date <= $end_date; $current_date = strtotime('+1 day', $current_date)) {
            $day_of_month = (int)date('j', $current_date); // Day of month (1-31)
            $date_string = date('Y-m-d', $current_date);

            // Skip if doctor is on holiday
            if (in_array($current_date, $holiday_dates)) {
                continue;
            }

            // Check if doctor has schedule for this day of month
            $has_schedule = false;
            foreach ($date_schedules as $schedule) {
                if ((int)$schedule->date_of_month === $day_of_month) {
                    $has_schedule = true;
                    break;
                }
            }

            if (!$has_schedule) {
                continue;
            }

            // Get booked slots for this date
            $booked_slots = isset($booked_slots_by_date[$date_string]) ? $booked_slots_by_date[$date_string] : array();

            // Check if there are any available slots for this date by looking at actual time_slot records
            $has_available_slots = false;

            // Get actual time slots from time_slot table for this day of month
            $this->db->where('doctor', $doctor_id);
            $this->db->where('date_of_month', $day_of_month);
            $this->db->where('schedule_type', 'date');
            $this->db->order_by('s_time_key', 'asc');
            $time_slots = $this->db->get('time_slot')->result();

            foreach ($time_slots as $slot) {
                $slot_text = $slot->s_time . ' To ' . $slot->e_time;
                if (!in_array($slot_text, $booked_slots)) {
                    $has_available_slots = true;
                    break;
                }
            }

            if ($has_available_slots) {
                $available_dates[] = $date_string;
            }
        }

        return $available_dates;
    }

    function get_available_slots()
    {
        $doctor_id = $this->input->post('doctor_id');
        $date = $this->input->post('date');

        if (empty($doctor_id) || empty($date)) {
            echo json_encode(array());
            return;
        }

        $date_timestamp = strtotime($date);

        // Check if doctor is on holiday
        $this->db->where('date', $date_timestamp);
        $this->db->where('doctor', $doctor_id);
        $holiday = $this->db->get('holidays')->row();

        if ($holiday) {
            echo json_encode(array());
            return;
        }

        // Get doctor's schedule type
        $this->db->select('schedule_type');
        $this->db->where('id', $doctor_id);
        $doctor = $this->db->get('doctor')->row();

        if (!$doctor) {
            echo json_encode(array());
            return;
        }

        $schedule_type = $doctor->schedule_type ?? 'weekday';

        if ($schedule_type === 'date') {
            // Handle date-based scheduling
            $time_slots = $this->getDateBasedTimeSlots($doctor_id, $date);
        } else {
            // Handle traditional weekday-based scheduling
            $time_slots = $this->getWeekdayBasedTimeSlots($doctor_id, $date);
        }

        if (empty($time_slots)) {
            echo json_encode(array());
            return;
        }

        // Get booked appointments for this date and doctor
        $this->db->where('doctor', $doctor_id);
        $this->db->where('date', $date);
        $this->db->where('status !=', 'Cancelled');
        $booked_appointments = $this->db->get('appointment')->result();

        $booked_slots = array();
        foreach ($booked_appointments as $appointment) {
            $booked_slots[] = $appointment->time_slot;
        }

        // Prepare available slots
        $available_slots = array();
        foreach ($time_slots as $slot) {
            if (!in_array($slot['slot'], $booked_slots)) {
                $available_slots[] = array(
                    'slot' => $slot['slot'],
                    'start_time' => $slot->s_time,
                    'end_time' => $slot->e_time
                );
            }
        }

        // Debug: Log the final available slots
        error_log("Final available slots for date " . $date . ": " . json_encode($available_slots));

        echo json_encode($available_slots);
    }

    private function getWeekdayBasedTimeSlots($doctor_id, $date)
    {
        $weekday = date("l", strtotime($date));

        // Get doctor's time slots for this weekday
        $this->db->where('doctor', $doctor_id);
        $this->db->where('weekday', $weekday);
        $this->db->where('schedule_type', 'weekday'); // Only weekday slots
        $this->db->order_by('s_time_key', 'asc');
        $time_slots = $this->db->get('time_slot')->result();

        $slots = array();
        foreach ($time_slots as $slot) {
            $slots[] = array(
                'slot' => $slot->s_time . ' To ' . $slot->e_time,
                'start_time' => $slot->s_time,
                'end_time' => $slot->e_time
            );
        }

        return $slots;
    }

    private function getDateBasedTimeSlots($doctor_id, $date)
    {
        $day_of_month = (int)date('j', strtotime($date)); // Day of month (1-31)

        // Get actual time slots from time_slot table for this day of month
        $this->db->where('doctor', $doctor_id);
        $this->db->where('date_of_month', $day_of_month);
        $this->db->where('schedule_type', 'date');
        $this->db->order_by('s_time_key', 'asc');
        $time_slots = $this->db->get('time_slot')->result();


        if (empty($time_slots)) {
            error_log("No date-based time slots found for doctor " . $doctor_id . " on day " . $day_of_month);
            return array();
        }

        $slots = array();
        foreach ($time_slots as $slot) {
            $slots[] = array(
                'slot' => $slot->s_time . ' To ' . $slot->e_time,
                'start_time' => $slot->s_time,
                'end_time' => $slot->e_time
            );
        }

        return $slots;
    }

    function book_appointment()
    {
        $patient_id = $this->input->post('patient_id');
        $doctor_id = $this->input->post('doctor_id');
        $hospital_id = $this->input->post('hospital_id');
        $date = $this->input->post('date');
        $time_slot = $this->input->post('time_slot');
        $problem = $this->input->post('problem');

        // Validate input
        if (empty($patient_id) || empty($doctor_id) || empty($date) || empty($time_slot)) {
            echo json_encode(['success' => false, 'message' => 'All fields are required']);
            return;
        }

        // Get doctor details to check online payment requirement
        $doctor = $this->doctor_model->getDoctorById($doctor_id);
        if (!$doctor) {
            echo json_encode(['success' => false, 'message' => 'Doctor not found']);
            return;
        }

        // Get patient details
        $patient = $this->patient_model->getPatientById($patient_id);
        if (!$patient) {
            echo json_encode(['success' => false, 'message' => 'Patient not found']);
            return;
        }

        $date_timestamp = strtotime($date);
        $time_slot_explode = explode('To', $time_slot);
        $s_time = isset($time_slot_explode[0]) ? trim($time_slot_explode[0]) : '';
        $e_time = isset($time_slot_explode[1]) ? trim($time_slot_explode[1]) : '';

        // Get consultant fee
        $consultant_fee = !empty($doctor->price) ? $doctor->price : 0;

        // Prepare appointment data
        $appointment_data = array(
            'patient' => $patient_id,
            'doctor' => $doctor_id,
            'date' => $date_timestamp,
            's_time' => $s_time,
            'e_time' => $e_time,
            'remarks' => $problem,
            'status' => 'Requested',
            'request' => 'Yes',
            'add_date' => date('m/d/y'),
            'registration_time' => time(),
            'hospital_id' => $hospital_id,
            'payment_status' => 'unpaid',
            'visit_description' => '' // No visit type in simple booking
        );

        // Create payment record
        $payment_data = array(
            'category_name' => 'Consultant Fee',
            'patient' => $patient_id,
            'amount' => $consultant_fee,
            'doctor' => $doctor_id,
            'discount' => 0,
            'flat_discount' => 0,
            'gross_total' => $consultant_fee,
            'status' => 'unpaid',
            'hospital_amount' => 0,
            'doctor_amount' => $consultant_fee,
            'patient_name' => $patient->name,
            'patient_phone' => $patient->phone,
            'patient_address' => $patient->address,
            'doctor_name' => $doctor->name,
            'remarks' => $problem,
            'payment_from' => 'appointment', // Use 'appointment' to match invoice templates
            'date' => time(),
            'date_string' => date('d-m-Y'),
            'hospital_id' => $hospital_id
        );

        // Insert appointment
        $this->appointment_model->insertAppointment($appointment_data);
        $appointment_id = $this->db->insert_id();

        // Insert payment record
        $payment_data['appointment_id'] = $appointment_id;
        $this->finance_model->insertPayment($payment_data);
        $payment_id = $this->db->insert_id();

        // Update appointment with payment ID
        $this->appointment_model->updateAppointment($appointment_id, array('payment_id' => $payment_id));

        // Check if online payment is required
        if ($doctor->online_payment_enabled == 'required' && $consultant_fee > 0) {
            // Online payment is required
            echo json_encode([
                'success' => true,
                'payment_required' => true,
                'appointment_id' => $appointment_id,
                'payment_id' => $payment_id,
                'amount' => $consultant_fee,
                'doctor_name' => $doctor->name,
                'patient_name' => $patient->name,
                'message' => 'Appointment created. Payment is required to confirm your appointment.'
            ]);
        } else {
            // No payment required or doctor doesn't require online payment
            // Confirm appointment immediately
            $this->appointment_model->updateAppointment($appointment_id, array('status' => 'Confirmed'));

            echo json_encode([
                'success' => true,
                'payment_required' => false,
                'message' => 'Appointment booked successfully!'
            ]);
        }
    }

    function process_appointment_payment()
    {
        $payment_id = $this->input->post('payment_id');
        $appointment_id = $this->input->post('appointment_id');
        $card_type = $this->input->post('card_type');
        $card_number = $this->input->post('card_number');
        $expire_date = $this->input->post('expire_date');
        $cardholder_name = $this->input->post('cardholder_name');
        $cvv = $this->input->post('cvv');
        $token = $this->input->post('token');

        if (empty($payment_id) || empty($appointment_id)) {
            echo json_encode(['success' => false, 'message' => 'Invalid payment data']);
            return;
        }

        // Get payment details
        $payment = $this->finance_model->getPaymentById($payment_id);
        if (!$payment) {
            echo json_encode(['success' => false, 'message' => 'Payment record not found']);
            return;
        }

        // Get appointment details
        $appointment = $this->appointment_model->getAppointmentById($appointment_id);
        if (!$appointment) {
            echo json_encode(['success' => false, 'message' => 'Appointment not found']);
            return;
        }

        // Get patient details
        $patient = $this->patient_model->getPatientById($payment->patient);

        // Get system payment gateway settings
        $gateway = $this->settings_model->getSettings()->payment_gateway;

        $payment_data = array(
            'card_type' => $card_type,
            'card_number' => $card_number,
            'expire_date' => $expire_date,
            'cardHoldername' => $cardholder_name,
            'cvv' => $cvv,
            'token' => $token,
            'grand_total' => $payment->amount,
        );

        // Process payment based on gateway
        $this->processOnlinePayment($payment_data, $payment, $appointment, $patient, $gateway);
    }

    private function processOnlinePayment($payment_data, $payment, $appointment, $patient, $gateway)
    {
        $amount = $payment->amount;
        $payment_id = $payment->id;
        $appointment_id = $appointment->id;

        try {
            if ($gateway == 'Stripe') {
                $this->load->model('pgateway/pgateway_model');
                $stripe_config = $this->pgateway_model->getPaymentGatewaySettingsByName('Stripe');

                require_once APPPATH . 'third_party/stripe/stripe-php/init.php';
                \Stripe\Stripe::setApiKey($stripe_config->secret);

                $charge = \Stripe\Charge::create(array(
                    "amount" => $amount * 100, // Amount in cents
                    "currency" => "usd",
                    "source" => $payment_data['token'],
                    "description" => "Appointment fee for " . $patient->name
                ));

                $chargeJson = $charge->jsonSerialize();

                if ($chargeJson['status'] == 'succeeded') {
                    // Payment successful
                    $this->handleSuccessfulPayment($payment_id, $appointment_id, $amount);
                    echo json_encode(['success' => true, 'message' => 'Payment successful! Your appointment is confirmed.']);
                } else {
                    echo json_encode(['success' => false, 'message' => 'Payment failed. Please try again.']);
                }
            } elseif ($gateway == 'PayPal') {
                // PayPal integration
                $this->load->module('paypal');
                $payment_details = array(
                    'patient' => $patient->id,
                    'date' => time(),
                    'amount' => $amount,
                    'doctor' => $appointment->doctor,
                    'gross_total' => $amount,
                    'patient_name' => $patient->name,
                    'patient_phone' => $patient->phone,
                    'patient_address' => $patient->address,
                    'doctor_name' => $payment->doctor_name,
                    'date_string' => date('d-m-y'),
                    'deposited_amount' => $amount,
                    'payment_id' => $payment_id,
                    'card_type' => $payment_data['card_type'],
                    'card_number' => $payment_data['card_number'],
                    'expire_date' => $payment_data['expire_date'],
                    'cvv' => $payment_data['cvv'],
                    'from' => 'public_appointment',
                    'cardholdername' => $payment_data['cardHoldername']
                );

                $this->paypal->paymentPaypal($payment_details);
            } else {
                echo json_encode(['success' => false, 'message' => 'Payment gateway not configured']);
            }
        } catch (Exception $e) {
            echo json_encode(['success' => false, 'message' => 'Payment processing error: ' . $e->getMessage()]);
        }
    }

    private function handleSuccessfulPayment($payment_id, $appointment_id, $amount)
    {
        // Update payment status
        $payment_update = array(
            'amount_received' => $amount,
            'status' => 'paid',
            'date' => time(),
            'date_string' => date('d-m-Y')
        );
        $this->finance_model->updatePayment($payment_id, $payment_update);

        // Update appointment status
        $appointment_update = array(
            'status' => 'Confirmed',
            'payment_status' => 'paid'
        );
        $this->appointment_model->updateAppointment($appointment_id, $appointment_update);

        // Insert deposit record
        $deposit_data = array(
            'date' => time(),
            'patient' => $this->finance_model->getPaymentById($payment_id)->patient,
            'payment_id' => $payment_id,
            'deposited_amount' => $amount,
            'amount_received_id' => $payment_id . '.public',
            'gateway' => $this->settings_model->getSettings()->payment_gateway,
            'payment_from' => 'appointment'
        );
        $this->finance_model->insertDeposit($deposit_data);
    }

    function book_appointment_with_payment()
    {
        // Add error logging
        log_message('debug', 'book_appointment_with_payment called with POST data: ' . json_encode($this->input->post()));

        $patient_id = $this->input->post('patient_id');
        $doctor_id = $this->input->post('doctor_id');
        $hospital_id = $this->input->post('hospital_id');
        $date = $this->input->post('date');
        $time_slot = $this->input->post('time_slot');
        $problem = $this->input->post('problem');
        $visit_type = $this->input->post('visit_type');
        $visit_charges = $this->input->post('visit_charges');
        $discount = $this->input->post('discount');
        $grand_total = $this->input->post('grand_total');
        $payment_method = $this->input->post('payment_method');
        $booking_source = $this->input->post('booking_source');
        // Validate input
        if (empty($patient_id) || empty($doctor_id) || empty($date) || empty($time_slot) || empty($visit_type)) {
            log_message('error', 'book_appointment_with_payment validation failed. Missing required fields.');
            echo json_encode(['success' => false, 'message' => 'All fields including visit type are required']);
            return;
        }

        // Get doctor details
        $doctor = $this->doctor_model->getDoctorById($doctor_id);
        if (!$doctor) {
            echo json_encode(['success' => false, 'message' => 'Doctor not found']);
            return;
        }

        // Get patient details
        $patient = $this->patient_model->getPatientById($patient_id);
        if (!$patient) {
            echo json_encode(['success' => false, 'message' => 'Patient not found']);
            return;
        }

        $date_timestamp = strtotime($date);
        $time_slot_explode = explode(' To ', $time_slot);
        $s_time = isset($time_slot_explode[0]) ? trim($time_slot_explode[0]) : '';
        $e_time = isset($time_slot_explode[1]) ? trim($time_slot_explode[1]) : '';

        // Get visit type details without session-based filtering
        $this->db->select('*');
        $this->db->from('doctor_visit');
        $this->db->where('id', $visit_type);
        $this->db->where('status', 'active');
        $visit_type_details = $this->db->get()->row();

        // Use visit charges instead of doctor's default price
        $consultant_fee = !empty($visit_charges) ? $visit_charges : 0;
        $final_amount = !empty($grand_total) ? $grand_total : $consultant_fee;

        // Prepare appointment data
        $appointment_data = array(
            'patient' => $patient_id,
            'doctor' => $doctor_id,
            'date' => $date_timestamp,
            's_time' => $s_time,
            'e_time' => $e_time,
            'remarks' => $problem,
            'status' => ($payment_method === 'pay_later') ? 'Confirmed' : 'Requested',
            'request' => 'Yes',
            'add_date' => date('m/d/y'),
            'registration_time' => time(),
            'hospital_id' => $hospital_id,
            'payment_status' => ($payment_method === 'pay_later') ? 'unpaid' : 'pending',
            'visit_description' => $visit_type, // Store visit ID, not description text
            'visit_charges' => $consultant_fee,
            'discount' => $discount,
            'grand_total' => $final_amount,
            'booking_source' => $booking_source
        );

        // Ensure hospital_id is properly set
        if (empty($hospital_id)) {
            $hospital_id = $doctor->hospital_id;
        }

        // Set hospital_id in session for finance model compatibility
        $newdata = array(
            'hospital_id' => $hospital_id
        );
        $this->session->set_userdata($newdata);

        // Create descriptive category name
        $category_name = 'Consultant Fee';
        if ($visit_type_details && !empty($visit_type_details->visit_description)) {
            $category_name = $visit_type_details->visit_description;
        }

        // Create payment record
        $payment_data = array(
            'category_name' => $category_name,
            'patient' => $patient_id,
            'amount' => $final_amount,
            'doctor' => $doctor_id,
            'discount' => $discount,
            'flat_discount' => 0,
            'gross_total' => $final_amount,
            'status' => ($payment_method === 'pay_later') ? 'unpaid' : 'pending',
            'hospital_amount' => 0,
            'doctor_amount' => $final_amount,
            'patient_name' => $patient->name,
            'patient_phone' => $patient->phone,
            'patient_address' => $patient->address,
            'doctor_name' => $doctor->name,
            'remarks' => $problem,
            'payment_from' => 'appointment', // Use 'appointment' to match invoice templates
            'date' => time(),
            'date_string' => date('d-m-Y'),
            'hospital_id' => $hospital_id
        );

        try {
            // Insert appointment
            log_message('debug', 'Inserting appointment with data: ' . json_encode($appointment_data));
            $this->appointment_model->insertAppointment($appointment_data);
            $appointment_id = $this->db->insert_id();

            if (!$appointment_id) {
                log_message('error', 'Failed to create appointment. DB Error: ' . $this->db->error()['message']);
                echo json_encode(['success' => false, 'message' => 'Failed to create appointment']);
                return;
            }

            // Insert payment record
            $payment_data['appointment_id'] = $appointment_id;
            log_message('debug', 'Inserting payment with data: ' . json_encode($payment_data));
            $this->finance_model->insertPayment($payment_data);
            $payment_id = $this->db->insert_id();

            if (!$payment_id) {
                log_message('error', 'Failed to create payment record. DB Error: ' . $this->db->error()['message']);
                echo json_encode(['success' => false, 'message' => 'Failed to create payment record']);
                return;
            }

            // Update appointment with payment ID
            $this->appointment_model->updateAppointment($appointment_id, array('payment_id' => $payment_id));

            log_message('debug', 'Successfully created appointment ID: ' . $appointment_id . ' and payment ID: ' . $payment_id);

            echo json_encode([
                'success' => true,
                'appointment_id' => $appointment_id,
                'payment_id' => $payment_id,
                'amount' => $final_amount,
                'doctor_name' => $doctor->name,
                'patient_name' => $patient->name,
                'payment_method' => $payment_method,
                'visit_type' => $visit_type_details ? $visit_type_details->visit_description : '',
                'message' => 'Appointment created successfully'
            ]);

            $data = array(
                'success' => true,
                'appointment_id' => $appointment_id,
                'payment_id' => $payment_id,
                'amount' => $final_amount,
                'doctor_name' => $doctor->name,
                'patient_name' => $patient->name,
                'payment_method' => $payment_method,
                'visit_type' => $visit_type_details ? $visit_type_details->visit_description : '',
                'message' => 'Appointment created successfully'
            );
            if ($doctor->sms_booking_confirmation_patient == 'yes') {
                $response = $this->sendSmsDuringAppointment($appointment_id, $data, $patient_id, $doctor_id, $hospital_id, $booking_source);
            }
        } catch (Exception $e) {
            log_message('error', 'Exception in book_appointment_with_payment: ' . $e->getMessage());
            echo json_encode(['success' => false, 'message' => 'System error: ' . $e->getMessage()]);
        }
    }

    function sendSmsDuringAppointment($id, $data, $patient_id, $doctor_id, $hospital_id, $booking_source)
    {




        $set['settings'] = $this->db->get_where('settings', array('hospital_id' => $hospital_id))->row();;
        $patientdetails = $this->patient_model->getPatientById($patient_id);
        $doctordetails = $this->doctor_model->getDoctorById($doctor_id);
        $sms_language = $patientdetails->sms_language;


        // $booking_source = $this->input->post('booking_source'); // online, ivr, etc.
        $payment_amount = $grand_total;

        if ($booking_source === 'online') {
            if ($doctordetails->sms_advanced_paid_bookings == 'yes') {
                $autosms = $this->frontend_model->getAutoSmsByType('online_appointment_booking', $sms_language, $hospital_id);
            }
        } elseif ($booking_source === 'ivr') {
            // IVR appointment booking
            if ($doctordetails->sms_ivr_bookings == 'yes') {
                $autosms = $this->frontend_model->getAutoSmsByType('ivr_appointment_booking', $sms_language, $hospital_id);
            }
        } elseif (!$has_payment && !empty($payment_amount) && $payment_amount > 0) {
            // Appointment without payment
            //    $appointment_sms_data['amount'] = $payment_amount;
            if ($doctordetails->sms_online_no_payment == 'yes') {
                $autosms = $this->frontend_model->getAutoSmsByType('appointment_without_payment', $sms_language, $hospital_id);
            }
        }
        $message = $autosms->message;

        $to = $patientdetails->phone;
        $name1 = explode(' ', $patientdetails->name);
        //  $length=count($name1);
        if (!isset($name1[1])) {
            $name1[1] = null;
        }
        $name_doctor = explode(' ', $doctordetails->name);

        //$length_doc=count($name_doctor);
        if (!isset($name_doctor[1])) {
            $name_doctor[1] = null;
        }
        $data1 = array(
            'firstname' => $name1[0],
            'lastname' => $name1[1],
            'name' => $patientdetails->name,
            'doctorname' => $doctordetails->name,
            'appoinmentdate' => date('d-m-Y', $data['date']),
            'time_slot' => $data['time_slot'],
            'hospital_name' => $set['settings']->system_vendor
        );


        if ($autosms->status == 'Active') {

            $messageprint = $this->parser->parse_string($message, $data1);

            $data2[] = array($to => $messageprint);
            $this->sendSms($to, $message, $data2, $hospital_id);
        }
    }

    function process_payment()
    {
        // Add error logging
        log_message('debug', 'process_payment called with POST data: ' . json_encode($this->input->post()));

        $payment_id = $this->input->post('payment_id');
        $appointment_id = $this->input->post('appointment_id');
        $amount = $this->input->post('amount');
        $payment_method = $this->input->post('payment_method');
        $card_number = $this->input->post('card_number');
        $cardholder_name = $this->input->post('cardholder_name');
        $expiry_date = $this->input->post('expiry_date');
        $cvv = $this->input->post('cvv');
        $token = $this->input->post('token');

        if (empty($payment_id) || empty($appointment_id)) {
            log_message('error', 'process_payment validation failed - missing payment_id or appointment_id');
            echo json_encode(['success' => false, 'message' => 'Invalid payment data']);
            return;
        }

        // Get payment details - First, query directly to get hospital_id
        $this->db->where('id', $payment_id);
        $payment_raw = $this->db->get('payment')->row();
        if (!$payment_raw) {
            log_message('error', 'Payment record not found in database for ID: ' . $payment_id);
            echo json_encode(['success' => false, 'message' => 'Payment record not found']);
            return;
        }

        // Set hospital_id in session for finance model compatibility
        $newdata = array(
            'hospital_id' => $payment_raw->hospital_id
        );
        $this->session->set_userdata($newdata);

        // Now get payment details using the model
        $payment = $this->finance_model->getPaymentById($payment_id);
        if (!$payment) {
            log_message('error', 'Payment record not found in finance model for ID: ' . $payment_id);
            echo json_encode(['success' => false, 'message' => 'Payment record not found in model']);
            return;
        }

        // Get appointment details
        $appointment = $this->appointment_model->getAppointmentById($appointment_id);
        if (!$appointment) {
            log_message('error', 'Appointment not found for ID: ' . $appointment_id);
            echo json_encode(['success' => false, 'message' => 'Appointment not found']);
            return;
        }

        // Get patient details
        $patient = $this->patient_model->getPatientById($payment->patient);
        if (!$patient) {
            log_message('error', 'Patient not found for ID: ' . $payment->patient);
            echo json_encode(['success' => false, 'message' => 'Patient not found']);
            return;
        }

        try {
            if ($payment_method === 'stripe') {
                // Get system payment gateway settings
                $gateway = $this->settings_model->getSettings()->payment_gateway;

                log_message('debug', 'Processing Stripe payment. Gateway setting: ' . $gateway);

                if ($gateway == 'Stripe') {
                    $this->processStripePayment($payment, $appointment, $patient, $card_number, $cardholder_name, $expiry_date, $cvv, $token);
                } else {
                    log_message('error', 'Stripe not configured as payment gateway. Current gateway: ' . $gateway);
                    echo json_encode(['success' => false, 'message' => 'Stripe is not configured as payment gateway']);
                    return;
                }
            } else {
                log_message('error', 'Invalid payment method: ' . $payment_method);
                echo json_encode(['success' => false, 'message' => 'Invalid payment method']);
                return;
            }
        } catch (Exception $e) {
            log_message('error', 'Exception in process_payment: ' . $e->getMessage());
            echo json_encode(['success' => false, 'message' => 'Payment processing error: ' . $e->getMessage()]);
        }
    }

    private function processStripePayment($payment, $appointment, $patient, $card_number, $cardholder_name, $expiry_date, $cvv, $token)
    {
        try {
            // Check if this is a demo/test payment
            if ($token === 'demo_token') {
                // For demo purposes, simulate successful payment
                // In production, remove this block and require real Stripe tokens

                // Update payment status
                $payment_update = array(
                    'amount_received' => $payment->amount,
                    'status' => 'paid',
                    'date' => time(),
                    'date_string' => date('d-m-Y')
                );
                $this->finance_model->updatePayment($payment->id, $payment_update);

                // Update appointment status
                $appointment_update = array(
                    'status' => 'Confirmed',
                    'payment_status' => 'paid'
                );
                $this->appointment_model->updateAppointment($appointment->id, $appointment_update);

                // Insert deposit record
                $deposit_data = array(
                    'date' => time(),
                    'patient' => $payment->patient,
                    'payment_id' => $payment->id,
                    'deposited_amount' => $payment->amount,
                    'amount_received_id' => $payment->id . '.demo',
                    'gateway' => 'Demo Payment',
                    'payment_from' => 'appointment'
                );
                $this->finance_model->insertDeposit($deposit_data);

                echo json_encode(['success' => true, 'message' => 'Demo payment successful! Your appointment is confirmed.']);
                return;
            }

            // Get Stripe settings from database
            $stripe_settings = $this->pgateway_model->getPaymentGatewaySettingsByName('Stripe');

            if (!$stripe_settings || empty($stripe_settings->secret)) {
                echo json_encode(['success' => false, 'message' => 'Stripe settings not configured properly. Please contact administrator.']);
                return;
            }

            // Set Stripe API key
            \Stripe\Stripe::setApiKey($stripe_settings->secret);

            // Create Stripe charge
            $charge = \Stripe\Charge::create(array(
                "amount" => $payment->amount * 100, // Stripe expects amount in cents
                "currency" => "usd",
                "source" => $token,
                "description" => "Appointment payment for " . $patient->name
            ));

            $chargeJson = $charge->jsonSerialize();

            if ($chargeJson['status'] == 'succeeded') {
                // Update payment status
                $payment_update = array(
                    'amount_received' => $payment->amount,
                    'status' => 'paid',
                    'date' => time(),
                    'date_string' => date('d-m-Y')
                );
                $this->finance_model->updatePayment($payment->id, $payment_update);

                // Update appointment status
                $appointment_update = array(
                    'status' => 'Confirmed',
                    'payment_status' => 'paid'
                );
                $this->appointment_model->updateAppointment($appointment->id, $appointment_update);

                // Insert deposit record
                $deposit_data = array(
                    'date' => time(),
                    'patient' => $payment->patient,
                    'payment_id' => $payment->id,
                    'deposited_amount' => $payment->amount,
                    'amount_received_id' => $payment->id . '.stripe',
                    'gateway' => 'Stripe',
                    'payment_from' => 'appointment'
                );
                $this->finance_model->insertDeposit($deposit_data);

                echo json_encode(['success' => true, 'message' => 'Payment successful via Stripe! Your appointment is confirmed.']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Payment failed. Please try again.']);
            }
        } catch (\Stripe\Exception\CardException $e) {
            // Card was declined
            echo json_encode(['success' => false, 'message' => 'Your card was declined: ' . $e->getError()->message]);
        } catch (\Stripe\Exception\RateLimitException $e) {
            // Too many requests made to the API too quickly
            echo json_encode(['success' => false, 'message' => 'Payment processing is temporarily unavailable. Please try again later.']);
        } catch (\Stripe\Exception\InvalidRequestException $e) {
            // Invalid parameters were supplied to Stripe's API
            echo json_encode(['success' => false, 'message' => 'Invalid payment data. Please check your card details.']);
        } catch (\Stripe\Exception\AuthenticationException $e) {
            // Authentication with Stripe's API failed
            echo json_encode(['success' => false, 'message' => 'Payment system configuration error. Please contact administrator.']);
        } catch (\Stripe\Exception\ApiConnectionException $e) {
            // Network communication with Stripe failed
            echo json_encode(['success' => false, 'message' => 'Unable to connect to payment processor. Please try again.']);
        } catch (\Stripe\Exception\ApiErrorException $e) {
            // Display a very generic error to the user, and maybe send yourself an email
            echo json_encode(['success' => false, 'message' => 'Payment processing error. Please try again.']);
        } catch (Exception $e) {
            // Something else happened
            echo json_encode(['success' => false, 'message' => 'An unexpected error occurred: ' . $e->getMessage()]);
        }
    }



    function get_doctor_visit_types()
    {
        $doctor_id = $this->input->post('doctor_id');

        if (empty($doctor_id)) {
            echo json_encode(['success' => false, 'message' => 'Doctor ID required']);
            return;
        }

        $this->load->model('doctorvisit/doctorvisit_model');

        // Get visit types for the doctor
        $this->db->select('*');
        $this->db->from('doctor_visit');
        $this->db->where('doctor_id', $doctor_id);
        $this->db->where('status', 'active');
        $this->db->order_by('visit_description', 'asc');
        $visit_types = $this->db->get()->result();

        echo json_encode([
            'success' => true,
            'visit_types' => $visit_types
        ]);
    }

    function get_visit_charges()
    {
        $visit_type_id = $this->input->post('visit_type_id');

        if (empty($visit_type_id)) {
            echo json_encode(['success' => false, 'message' => 'Visit type ID required']);
            return;
        }

        // Query directly without session-based hospital_id filtering
        $this->db->select('*');
        $this->db->from('doctor_visit');
        $this->db->where('id', $visit_type_id);
        $this->db->where('status', 'active');
        $visit_type = $this->db->get()->row();

        if ($visit_type) {
            echo json_encode([
                'success' => true,
                'visit_charges' => $visit_type->visit_charges,
                'visit_description' => $visit_type->visit_description
            ]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Visit type not found']);
        }
    }

    // Debug function to check what data exists
    function debug_data()
    {
        header('Content-Type: application/json');

        $debug_info = array();

        // Check if tables exist
        $debug_info['tables_exist'] = array(
            'speciality' => $this->db->table_exists('speciality'),
            'doctor' => $this->db->table_exists('doctor'),
            'hospital' => $this->db->table_exists('hospital')
        );

        // Get counts
        if ($this->db->table_exists('speciality')) {
            $debug_info['speciality_count'] = $this->db->count_all('speciality');
            $debug_info['active_speciality_count'] = $this->db->where('status', 'active')->count_all_results('speciality');
        }

        if ($this->db->table_exists('doctor')) {
            $debug_info['doctor_count'] = $this->db->count_all('doctor');
            $debug_info['available_doctor_count'] = $this->db->where('available', 1)->count_all_results('doctor');
        }

        if ($this->db->table_exists('hospital')) {
            $debug_info['hospital_count'] = $this->db->count_all('hospital');
        }

        // Get sample data
        if ($this->db->table_exists('speciality')) {
            $debug_info['sample_specialities'] = $this->db->limit(3)->get('speciality')->result();
        }

        if ($this->db->table_exists('doctor')) {
            $debug_info['sample_doctors'] = $this->db->limit(3)->get('doctor')->result();
        }

        echo json_encode($debug_info);
    }

    // Simple test endpoint
    function test_db()
    {
        header('Content-Type: application/json');

        $response = array();

        // Test speciality query
        $this->db->select('*');
        $this->db->from('speciality');
        $this->db->where('status', 'active');
        $this->db->limit(5);
        $response['specialities'] = $this->db->get()->result();

        // Test doctor query
        $this->db->select('doctor.*, hospital.name as hospital_name, speciality.name as speciality_name');
        $this->db->from('doctor');
        $this->db->join('hospital', 'doctor.hospital_id = hospital.id', 'left');
        $this->db->join('speciality', 'doctor.speciality_id = speciality.id', 'left');
        $this->db->limit(5);
        $response['doctors'] = $this->db->get()->result();

        // Test unified time_schedule table for date-based schedules
        $this->db->select('*');
        $this->db->from('time_schedule');
        $this->db->where('doctor', 51); // Demo Doctor ID
        $this->db->where('schedule_type', 'date');
        $response['date_schedules'] = $this->db->get()->result();
        $response['date_schedules_count'] = count($response['date_schedules']);

        // Test unified time_slot table for date-based slots
        $this->db->select('*');
        $this->db->from('time_slot');
        $this->db->where('doctor', 51); // Demo Doctor ID
        $this->db->where('schedule_type', 'date');
        $response['date_time_slots'] = $this->db->get()->result();
        $response['date_time_slots_count'] = count($response['date_time_slots']);

        echo json_encode($response);
    }

    // Test method to check a specific doctor's schedule
    function test_doctor_schedule()
    {
        header('Content-Type: application/json');

        $doctor_id = $this->input->get('doctor_id') ?? 51; // Default to demo doctor

        $response = array();
        $response['doctor_id'] = $doctor_id;

        // Check doctor details
        $this->db->select('id, name, schedule_type');
        $this->db->where('id', $doctor_id);
        $doctor = $this->db->get('doctor')->row();
        $response['doctor'] = $doctor;

        if ($doctor) {
            // Get date-based schedules
            $this->db->select('*');
            $this->db->from('time_schedule');
            $this->db->where('doctor', $doctor_id);
            $this->db->where('schedule_type', 'date');
            $response['date_schedules'] = $this->db->get()->result();

            // Get date-based time slots
            $this->db->select('*');
            $this->db->from('time_slot');
            $this->db->where('doctor', $doctor_id);
            $this->db->where('schedule_type', 'date');
            $this->db->order_by('date_of_month, s_time_key', 'asc');
            $response['date_time_slots'] = $this->db->get()->result();

            // Test get_available_dates for this doctor
            $start_date = time();
            $end_date = strtotime('+30 days');

            $this->db->where('doctor', $doctor_id);
            $this->db->where('date >=', $start_date);
            $this->db->where('date <=', $end_date);
            $holidays = $this->db->get('holidays')->result();
            $holiday_dates = array();
            foreach ($holidays as $holiday) {
                $holiday_dates[] = $holiday->date;
            }

            if ($doctor->schedule_type === 'date') {
                $available_dates = $this->getDateBasedAvailableDates($doctor_id, $start_date, $end_date, $holiday_dates);
            } else {
                $available_dates = $this->getWeekdayBasedAvailableDates($doctor_id, $start_date, $end_date, $holiday_dates);
            }

            $response['available_dates'] = $available_dates;
            $response['available_dates_count'] = count($available_dates);
        }

        echo json_encode($response);
    }

    // OTP Verification Methods

    /**
     * Send OTP to phone number
     * POST: phone, purpose, hospital_id (optional)
     */
    public function send_otp()
    {
        header('Content-Type: application/json');

        try {
            $this->load->library('simple_otp');

            $phone = $this->input->post('phone');
            $purpose = $this->input->post('purpose');

            // Basic validation
            if (empty($phone)) {
                echo json_encode(array('success' => false, 'message' => 'Phone number is required'));
                return;
            }

            if (empty($purpose)) {
                $purpose = 'verification'; // Default purpose
            }

            // Send OTP (simple!)
            $result = $this->simple_otp->sendOTP($phone, $purpose);

            // Add debugging information
            if (!$result['success']) {
                log_message('error', 'OTP Send Failed for phone: ' . $phone . ' - ' . $result['message']);

                // Check if it's a configuration issue
                $this->load->model('settings_model');
                $settings = $this->settings_model->getSettings();
                if (empty($settings->sms_gateway)) {
                    $result['message'] = 'SMS gateway not configured. Please contact administrator.';
                }
            }

            echo json_encode($result);
        } catch (Exception $e) {
            log_message('error', 'Simple OTP Send Error: ' . $e->getMessage());
            echo json_encode(array('success' => false, 'message' => 'System error occurred'));
        }
    }

    /**
     * Verify OTP code
     * POST: phone, otp_code, purpose
     */
    public function verify_otp()
    {
        header('Content-Type: application/json');

        try {
            $this->load->library('simple_otp');

            $phone = $this->input->post('phone');
            $otp_code = $this->input->post('otp_code');
            $purpose = $this->input->post('purpose');

            // Basic validation
            if (empty($phone)) {
                echo json_encode(array('success' => false, 'message' => 'Phone number is requiredd'));
                return;
            }

            if (empty($otp_code)) {
                echo json_encode(array('success' => false, 'message' => 'OTP code is required'));
                return;
            }

            if (empty($purpose)) {
                $purpose = 'verification'; // Default purpose
            }

            // Verify OTP (simple!)
            $result = $this->simple_otp->verifyOTP($phone, $otp_code, $purpose);

            echo json_encode($result);
        } catch (Exception $e) {
            log_message('error', 'Simple OTP Verify Error: ' . $e->getMessage());
            echo json_encode(array('success' => false, 'message' => 'System error occurred'));
        }
    }

    /**
     * Check if phone has verified OTP for specific purpose
     * POST: phone, purpose, within_minutes (optional, default 30)
     */
    public function check_verified_otp()
    {
        header('Content-Type: application/json');

        try {
            $this->load->library('otp_lib');

            $phone = $this->input->post('phone');
            $purpose = $this->input->post('purpose');
            $within_minutes = $this->input->post('within_minutes') ?: 30;

            // Validation
            if (empty($phone)) {
                echo json_encode(array('success' => false, 'message' => 'Phone number is required'));
                return;
            }

            if (empty($purpose)) {
                echo json_encode(array('success' => false, 'message' => 'Purpose is required'));
                return;
            }

            // Check verification status
            $is_verified = $this->otp_lib->hasVerifiedOTP($phone, $purpose, $within_minutes);

            echo json_encode(array(
                'success' => true,
                'verified' => $is_verified,
                'message' => $is_verified ? 'Phone number is verified' : 'Phone number not verified'
            ));
        } catch (Exception $e) {
            log_message('error', 'OTP Check Error: ' . $e->getMessage());
            echo json_encode(array('success' => false, 'message' => 'System error occurred'));
        }
    }

    /**
     * Resend OTP to phone number
     * POST: phone, purpose
     */
    public function resend_otp()
    {
        header('Content-Type: application/json');

        try {
            $this->load->library('simple_otp');

            $phone = $this->input->post('phone');
            $purpose = $this->input->post('purpose');

            // Basic validation
            if (empty($phone)) {
                echo json_encode(array('success' => false, 'message' => 'Phone number is required'));
                return;
            }

            if (empty($purpose)) {
                $purpose = 'verification'; // Default purpose
            }

            // Resend OTP (same as sending)
            $result = $this->simple_otp->sendOTP($phone, $purpose);

            echo json_encode($result);
        } catch (Exception $e) {
            log_message('error', 'Simple OTP Resend Error: ' . $e->getMessage());
            echo json_encode(array('success' => false, 'message' => 'System error occurred'));
        }
    }

    /**
     * Debug OTP configuration - helps troubleshoot SMS issues
     */
    public function debug_otp_config()
    {
        header('Content-Type: application/json');

        try {
            $debug_info = array();

            // Check if user is logged in (for security)
            if (!$this->ion_auth->logged_in() || !$this->ion_auth->in_group(array('admin', 'superadmin'))) {
                echo json_encode(array('error' => 'Access denied - admin access required'));
                return;
            }

            $this->load->model('settings_model');
            $this->load->model('sms/sms_model');
            $this->load->model('hospital/hospital_model');

            // Check database tables
            $debug_info['tables'] = array(
                'otp_verification_exists' => $this->db->table_exists('otp_verification'),
                'autosmstemplate_exists' => $this->db->table_exists('autosmstemplate'),
                'sms_table_exists' => $this->db->table_exists('sms')
            );

            // Check settings
            $settings = $this->settings_model->getSettings();
            $debug_info['settings'] = array(
                'sms_gateway' => $settings->sms_gateway ?? 'Not set',
                'system_vendor' => $settings->system_vendor ?? 'Not set'
            );

            // Check hospital settings
            $hospital_id = $this->session->userdata('hospital_id') ?: 1;
            $hospital_info = $this->hospital_model->getHospitalById($hospital_id);
            $debug_info['hospital'] = array(
                'id' => $hospital_id,
                'exists' => !empty($hospital_info)
            );

            // Check SMS gateway settings
            if (!empty($settings->sms_gateway)) {
                $sms_settings = $this->sms_model->getSmsSettingsByGatewayName($settings->sms_gateway);
                $debug_info['sms_gateway_configured'] = !empty($sms_settings);
            }

            // OTP uses direct message (no template needed)
            $debug_info['otp_message'] = 'Using direct message - no template required';

            echo json_encode(array('success' => true, 'debug_info' => $debug_info));
        } catch (Exception $e) {
            echo json_encode(array('error' => $e->getMessage()));
        }
    }
}

/* End of file Frontend.php */
    /* Location: ./application/modules/frontend/controllers/Frontend.php */
