<div class="content-wrapper bg-gradient-light" style="min-height: 2726.9px;">
    <section class="content-header py-4 bg-white shadow-sm">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h1 class="display-4 font-weight-black mb-0">
                        <i class="fas fa-cog text-primary mr-3"></i>
                        <?php echo lang('settings'); ?>
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb bg-transparent mb-0">
                            <li class="breadcrumb-item"><a href="home"><?php echo lang('home'); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo lang('settings'); ?></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </section>

    <section class="content py-5">
        <div class="container-fluid">


            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card shadow-lg border-0">
                        <div class="card-header bg-primary text-white">
                            <h4 class="mb-0">
                                <i class="fas fa-user-cog mr-2"></i>
                                <?php echo lang('doctor'); ?> <?php echo lang('settings'); ?>
                            </h4>
                        </div>
                        <div class="card-body p-0">
                            <div class="row no-gutters">
                                <!-- Vertical Tab Navigation -->
                                <div class="col-md-3 bg-light border-right">
                                    <div class="nav flex-column nav-pills p-4" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                                        <a class="nav-link active mb-3 d-flex align-items-center" id="v-pills-schedule-tab" data-toggle="pill" href="#v-pills-schedule" role="tab" aria-controls="v-pills-schedule" aria-selected="true">
                                            <i class="fas fa-calendar-alt text-primary mr-3" style="width: 20px;"></i>
                                            <div>
                                                <div class="font-weight-bold">Schedule Settings</div>
                                                <small class="text-muted">Manage your schedule type</small>
                                            </div>
                                        </a>
                                        <a class="nav-link d-flex align-items-center" id="v-pills-payment-tab" data-toggle="pill" href="#v-pills-payment" role="tab" aria-controls="v-pills-payment" aria-selected="false">
                                            <i class="fas fa-credit-card text-success mr-3" style="width: 20px;"></i>
                                            <div>
                                                <div class="font-weight-bold">Online Payment</div>
                                                <small class="text-muted">Configure payment options</small>
                                            </div>
                                        </a>
                                        <a class="nav-link d-flex align-items-center" id="v-pills-cancellation-tab" data-toggle="pill" href="#v-pills-cancellation" role="tab" aria-controls="v-pills-cancellation" aria-selected="false">
                                            <i class="fas fa-ban text-warning mr-3" style="width: 20px;"></i>
                                            <div>
                                                <div class="font-weight-bold">Cancellation Permission</div>
                                                <small class="text-muted">Control appointment cancellations</small>
                                            </div>
                                        </a>
                                        <a class="nav-link d-flex align-items-center" id="v-pills-sms-tab" data-toggle="pill" href="#v-pills-sms" role="tab" aria-controls="v-pills-sms" aria-selected="false">
                                            <i class="fas fa-sms text-info mr-3" style="width: 20px;"></i>
                                            <div>
                                                <div class="font-weight-bold">SMS Settings</div>
                                                <small class="text-muted">Configure SMS notifications</small>
                                            </div>
                                        </a>
                                    </div>
                                </div>

                                <!-- Tab Content -->
                                <div class="col-md-9">
                                    <div class="tab-content p-4" id="v-pills-tabContent">
                                        <!-- Schedule Settings Tab -->
                                        <div class="tab-pane fade show active" id="v-pills-schedule" role="tabpanel" aria-labelledby="v-pills-schedule-tab">
                            <div class="row">
                                                <div class="col-md-8">
                                                    <h5 class="mb-4">
                                                <i class="fas fa-calendar-alt text-primary mr-2"></i>
                                                        Schedule Settings
                                            </h5>
                                                    
                                                    <div class="card border-left-primary mb-4">
                                        <div class="card-body">
                                                <div class="form-group">
                                                    <label class="font-weight-bold text-muted"><?php echo lang('current_schedule_type'); ?>:</label>
                                                    <div class="alert alert-info">
                                                        <i class="fas fa-info-circle mr-2"></i>
                                                        <?php if ($doctor->schedule_type == 'weekday') { ?>
                                                            <strong><?php echo lang('weekday_based'); ?></strong><br>
                                                            <small><?php echo lang('schedule_based_on_weekdays'); ?></small>
                                                        <?php } else { ?>
                                                            <strong><?php echo lang('date_based'); ?></strong><br>
                                                            <small><?php echo lang('schedule_based_on_monthly_dates'); ?></small>
                                                        <?php } ?>
                                                    </div>
                                                </div>

                                                            <form role="form" action="doctor/settings/updateScheduleType" method="post">
                                                <div class="form-group">
                                                    <label class="font-weight-bold text-muted"><?php echo lang('change_schedule_type'); ?>:</label>
                                                    <select class="form-control form-control-lg shadow-sm" name="schedule_type" required>
                                                        <option value="weekday" <?php echo ($doctor->schedule_type == 'weekday') ? 'selected' : ''; ?>>
                                                            <?php echo lang('weekday_based'); ?>
                                                        </option>
                                                        <option value="date" <?php echo ($doctor->schedule_type == 'date') ? 'selected' : ''; ?>>
                                                            <?php echo lang('date_based'); ?>
                                                        </option>
                                                    </select>
                                                    <small class="form-text text-muted">
                                                        <strong><?php echo lang('note'); ?>:</strong> <?php echo lang('changing_schedule_type_note'); ?>
                                                    </small>
                                                </div>

                                                                <button type="submit" class="btn btn-primary">
                                                    <i class="fas fa-save mr-2"></i>
                                                    <?php echo lang('update_schedule_type'); ?>
                                                </button>
                                            </form>
                                                        </div>
                                                    </div>
                                        </div>
                                    </div>
                                </div>

                                        <!-- Online Payment Settings Tab -->
                                        <div class="tab-pane fade" id="v-pills-payment" role="tabpanel" aria-labelledby="v-pills-payment-tab">
                                            <div class="row">
                                                <div class="col-md-10">
                                                    <h5 class="mb-4">
                                                <i class="fas fa-credit-card text-success mr-2"></i>
                                                Online Payment Settings
                                            </h5>
                                                    
                                                    <div class="card border-left-success mb-4">
                                        <div class="card-body">
                                                <div class="form-group">
                                                                <label class="font-weight-bold text-muted">Current Payment Setting:</label>
                                                                <div class="alert <?php 
                                                                    if ($doctor->online_payment_enabled == 'required') echo 'alert-danger';
                                                                    elseif ($doctor->online_payment_enabled == 'optional') echo 'alert-warning'; 
                                                                    else echo 'alert-secondary';
                                                                ?>">
                                                                    <i class="fas <?php 
                                                                        if ($doctor->online_payment_enabled == 'required') echo 'fa-exclamation-triangle';
                                                                        elseif ($doctor->online_payment_enabled == 'optional') echo 'fa-info-circle'; 
                                                                        else echo 'fa-times-circle';
                                                                    ?> mr-2"></i>
                                                                    <?php 
                                                                        $current_setting = $doctor->online_payment_enabled ?? 'disabled';
                                                                        switch($current_setting) {
                                                                            case 'required':
                                                                                echo '<strong>Payment is Required</strong><br><small>All patients must pay online when booking appointments</small>';
                                                                                break;
                                                                            case 'optional':
                                                                                echo '<strong>Payment is Optional</strong><br><small>Patients can choose to pay online or book without payment</small>';
                                                                                break;
                                                                            default:
                                                                                echo '<strong>Book Without Payment</strong><br><small>Patients can book appointments without any payment</small>';
                                                                        }
                                                                    ?>
                                                    </div>
                                                </div>

                                                            <form role="form" action="doctor/settings/updateOnlinePayment" method="post">
                                                <div class="form-group">
                                                                    <label class="font-weight-bold text-muted">Select Payment Policy:</label>
                                                                    
                                                                    <div class="row">
                                                                        <div class="col-md-4 mb-3">
                                                                            <div class="card payment-option <?php echo ($doctor->online_payment_enabled == 'required') ? 'border-danger bg-light' : 'border-secondary'; ?>" style="cursor: pointer;">
                                                                                <div class="card-body text-center p-3">
                                                                                    <div class="custom-control custom-radio">
                                                                                        <input type="radio" class="custom-control-input" name="online_payment_enabled" value="required" id="payment-required" <?php echo ($doctor->online_payment_enabled == 'required') ? 'checked' : ''; ?>>
                                                                                        <label class="custom-control-label" for="payment-required">
                                                                                            <i class="fas fa-exclamation-triangle text-danger fa-2x d-block mb-2"></i>
                                                                                            <strong>Payment Required</strong>
                                                                                            <small class="d-block text-muted">Patients must pay online before booking</small>
                                                                                        </label>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                </div>

                                                                        <div class="col-md-4 mb-3">
                                                                            <div class="card payment-option <?php echo ($doctor->online_payment_enabled == 'optional') ? 'border-warning bg-light' : 'border-secondary'; ?>" style="cursor: pointer;">
                                                                                <div class="card-body text-center p-3">
                                                                                    <div class="custom-control custom-radio">
                                                                                        <input type="radio" class="custom-control-input" name="online_payment_enabled" value="optional" id="payment-optional" <?php echo ($doctor->online_payment_enabled == 'optional') ? 'checked' : ''; ?>>
                                                                                        <label class="custom-control-label" for="payment-optional">
                                                                                            <i class="fas fa-info-circle text-warning fa-2x d-block mb-2"></i>
                                                                                            <strong>Optional</strong>
                                                                                            <small class="d-block text-muted">Patient chooses to pay online or not</small>
                                                                                        </label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                                                                        <div class="col-md-4 mb-3">
                                                                            <div class="card payment-option <?php echo ($doctor->online_payment_enabled == 'disabled' || empty($doctor->online_payment_enabled)) ? 'border-secondary bg-light' : 'border-secondary'; ?>" style="cursor: pointer;">
                                                                                <div class="card-body text-center p-3">
                                                                                    <div class="custom-control custom-radio">
                                                                                        <input type="radio" class="custom-control-input" name="online_payment_enabled" value="disabled" id="payment-disabled" <?php echo ($doctor->online_payment_enabled == 'disabled' || empty($doctor->online_payment_enabled)) ? 'checked' : ''; ?>>
                                                                                        <label class="custom-control-label" for="payment-disabled">
                                                                                            <i class="fas fa-times-circle text-secondary fa-2x d-block mb-2"></i>
                                                                                            <strong>Book Without Payment</strong>
                                                                                            <small class="d-block text-muted">No online payment required</small>
                                                                                        </label>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                        </div>
                                                </div>

                                                    <small class="form-text text-muted">
                                                                        <strong>Note:</strong> This setting affects how patients can book appointments from the public website.
                                                    </small>
                                                </div>

                                                                <button type="submit" class="btn btn-success">
                                                                    <i class="fas fa-save mr-2"></i>
                                                                    Update Payment Settings
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Cancellation Permission Settings Tab -->
                                        <div class="tab-pane fade" id="v-pills-cancellation" role="tabpanel" aria-labelledby="v-pills-cancellation-tab">
                                            <div class="row">
                                                <div class="col-md-10">
                                                    <h5 class="mb-4">
                                                        <i class="fas fa-ban text-warning mr-2"></i>
                                                        Cancellation Permission Settings
                                                    </h5>
                                                    
                                                    <div class="card border-left-warning mb-4">
                                                        <div class="card-body">
                                                            <div class="form-group">
                                                                <label class="font-weight-bold text-muted">Current Cancellation Policy:</label>
                                                                <div class="alert <?php 
                                                                    $current_permission = isset($doctor->cancellation_permission) ? $doctor->cancellation_permission : 'allow';
                                                                    echo ($current_permission == 'disallow') ? 'alert-danger' : 'alert-success';
                                                                ?>">
                                                                    <i class="fas <?php 
                                                                        echo ($current_permission == 'disallow') ? 'fa-ban' : 'fa-check-circle';
                                                                    ?> mr-2"></i>
                                                                    <?php 
                                                                        if($current_permission == 'disallow') {
                                                                            echo '<strong>Cancellation Not Allowed</strong><br><small>Patients cannot cancel appointments once booked</small>';
                                                                        } else {
                                                                            echo '<strong>Cancellation Allowed</strong><br><small>Patients can cancel their appointments</small>';
                                                                        }
                                                                    ?>
                                                                </div>
                                                            </div>

                                                            <form role="form" action="doctor/settings/updateCancellationPermission" method="post">
                                                                <div class="form-group">
                                                                    <label class="font-weight-bold text-muted">Select Cancellation Policy:</label>
                                                                    
                                                                    <div class="row">
                                                                        <div class="col-md-6 mb-3">
                                                                            <div class="card cancellation-option <?php 
                                                                                $current_permission = isset($doctor->cancellation_permission) ? $doctor->cancellation_permission : 'allow';
                                                                                echo ($current_permission == 'allow') ? 'border-success bg-light' : 'border-secondary'; 
                                                                            ?>" style="cursor: pointer;">
                                                                                <div class="card-body text-center p-4">
                                                                                    <div class="custom-control custom-radio">
                                                                                        <input type="radio" class="custom-control-input" name="cancellation_permission" value="allow" id="cancellation-allow" <?php echo ($current_permission == 'allow') ? 'checked' : ''; ?>>
                                                                                        <label class="custom-control-label" for="cancellation-allow">
                                                                                            <i class="fas fa-check-circle text-success fa-3x d-block mb-3"></i>
                                                                                            <strong>Allow Cancellation</strong>
                                                                                            <small class="d-block text-muted mt-2">Patients can cancel their appointments</small>
                                                                                        </label>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>

                                                                        <div class="col-md-6 mb-3">
                                                                            <div class="card cancellation-option <?php 
                                                                                $current_permission = isset($doctor->cancellation_permission) ? $doctor->cancellation_permission : 'allow';
                                                                                echo ($current_permission == 'disallow') ? 'border-danger bg-light' : 'border-secondary'; 
                                                                            ?>" style="cursor: pointer;">
                                                                                <div class="card-body text-center p-4">
                                                                                    <div class="custom-control custom-radio">
                                                                                        <input type="radio" class="custom-control-input" name="cancellation_permission" value="disallow" id="cancellation-disallow" <?php echo ($current_permission == 'disallow') ? 'checked' : ''; ?>>
                                                                                        <label class="custom-control-label" for="cancellation-disallow">
                                                                                            <i class="fas fa-ban text-danger fa-3x d-block mb-3"></i>
                                                                                            <strong>Disallow Cancellation</strong>
                                                                                            <small class="d-block text-muted mt-2">Patients cannot cancel appointments</small>
                                                                                        </label>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>

                                                                <!-- Cancellation Type Section (shown when cancellation is allowed) -->
                                                                <div id="cancellation-type-section" style="<?php echo ($current_permission == 'allow') ? '' : 'display: none;'; ?>">
                                                                    <div class="form-group mt-4">
                                                                        <label class="font-weight-bold text-muted">Select Cancellation Type:</label>
                                                                        
                                                                        <div class="row">
                                                                            <?php $current_type = isset($doctor->cancellation_type) ? $doctor->cancellation_type : 'both'; ?>
                                                                            
                                                                            <div class="col-md-4 mb-3">
                                                                                <div class="card cancellation-type-option <?php echo ($current_type == 'paid_only') ? 'border-info bg-light' : 'border-secondary'; ?>" style="cursor: pointer;">
                                                                                    <div class="card-body text-center p-3">
                                                                                        <div class="custom-control custom-radio">
                                                                                            <input type="radio" class="custom-control-input" name="cancellation_type" value="paid_only" id="cancellation-paid" <?php echo ($current_type == 'paid_only') ? 'checked' : ''; ?>>
                                                                                            <label class="custom-control-label" for="cancellation-paid">
                                                                                                <i class="fas fa-credit-card text-info fa-2x d-block mb-2"></i>
                                                                                                <strong>Paid Only</strong>
                                                                                                <small class="d-block text-muted mt-1">Only paid appointments</small>
                                                                                            </label>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            
                                                                            <div class="col-md-4 mb-3">
                                                                                <div class="card cancellation-type-option <?php echo ($current_type == 'non_paid_only') ? 'border-warning bg-light' : 'border-secondary'; ?>" style="cursor: pointer;">
                                                                                    <div class="card-body text-center p-3">
                                                                                        <div class="custom-control custom-radio">
                                                                                            <input type="radio" class="custom-control-input" name="cancellation_type" value="non_paid_only" id="cancellation-non-paid" <?php echo ($current_type == 'non_paid_only') ? 'checked' : ''; ?>>
                                                                                            <label class="custom-control-label" for="cancellation-non-paid">
                                                                                                <i class="fas fa-handshake text-warning fa-2x d-block mb-2"></i>
                                                                                                <strong>Non-Paid Only</strong>
                                                                                                <small class="d-block text-muted mt-1">Only non-paid appointments</small>
                                                                                            </label>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            
                                                                            <div class="col-md-4 mb-3">
                                                                                <div class="card cancellation-type-option <?php echo ($current_type == 'both') ? 'border-success bg-light' : 'border-secondary'; ?>" style="cursor: pointer;">
                                                                                    <div class="card-body text-center p-3">
                                                                                        <div class="custom-control custom-radio">
                                                                                            <input type="radio" class="custom-control-input" name="cancellation_type" value="both" id="cancellation-both" <?php echo ($current_type == 'both') ? 'checked' : ''; ?>>
                                                                                            <label class="custom-control-label" for="cancellation-both">
                                                                                                <i class="fas fa-calendar-check text-success fa-2x d-block mb-2"></i>
                                                                                                <strong>Both</strong>
                                                                                                <small class="d-block text-muted mt-1">Paid & non-paid appointments</small>
                                                                                            </label>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>

                                                                <div class="alert alert-info">
                                                                    <i class="fas fa-info-circle mr-2"></i>
                                                                    <strong>Note:</strong> 
                                                                    <small>
                                                                        This setting controls whether patients can cancel appointments through the patient portal. 
                                                                        The cancellation type determines which appointments (based on payment status) can be cancelled.
                                                                        Admin users will always be able to cancel appointments regardless of these settings.
                                                                    </small>
                                                                </div>

                                                                                                                <button type="submit" class="btn btn-warning">
                                                    <i class="fas fa-save mr-2"></i>
                                                    Update Cancellation Settings
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                                        <!-- SMS Settings Tab -->
                                        <div class="tab-pane fade" id="v-pills-sms" role="tabpanel" aria-labelledby="v-pills-sms-tab">
                                            <div class="row">
                                                <div class="col-md-10">
                                                    <h5 class="mb-4">
                                                        <i class="fas fa-sms text-info mr-2"></i>
                                                        SMS Notification Settings
                                                    </h5>
                                                    
                                                    <div class="card border-left-info mb-4">
                                                        <div class="card-body">
                                                            <div class="form-group">
                                                                <label class="font-weight-bold text-muted">Current SMS Settings:</label>
                                                                <div class="alert alert-info">
                                                                    <i class="fas fa-info-circle mr-2"></i>
                                                                    <strong>SMS Notifications</strong><br>
                                                                    <small>Configure when SMS notifications should be sent to patients for different booking types</small>
                                                                </div>
                                                            </div>

                                                            <form role="form" action="doctor/settings/updateSmsSettings" method="post">
                                                                <div class="form-group">
                                                                    <label class="font-weight-bold text-muted mb-3">SMS will be sent for:</label>
                                                                    
                                                                    <div class="row">
                                                                        <div class="col-md-12 mb-4">
                                                                            <div class="card sms-option border">
                                                                                <div class="card-body">
                                                                                    <div class="custom-control custom-checkbox">
                                                                                        <input type="checkbox" class="custom-control-input" 
                                                                                               name="sms_advanced_paid_bookings" 
                                                                                               value="yes" 
                                                                                               id="sms-advanced-paid" 
                                                                                               <?php echo (isset($doctor->sms_advanced_paid_bookings) && $doctor->sms_advanced_paid_bookings == 'yes') ? 'checked' : ''; ?>>
                                                                                        <label class="custom-control-label" for="sms-advanced-paid">
                                                                                            <div class="d-flex align-items-center">
                                                                                                <i class="fas fa-credit-card text-success fa-2x mr-3"></i>
                                                                                                <div>
                                                                                                    <strong class="text-dark">Advanced Paid Online Bookings</strong>
                                                                                                    <br>
                                                                                                    <small class="text-muted">Send SMS when patients book appointments online with advance payment</small>
                                                                                                </div>
                                                                                            </div>
                                                                                        </label>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>

                                                                        <div class="col-md-12 mb-4">
                                                                            <div class="card sms-option border">
                                                                                <div class="card-body">
                                                                                    <div class="custom-control custom-checkbox">
                                                                                        <input type="checkbox" class="custom-control-input" 
                                                                                               name="sms_online_no_payment" 
                                                                                               value="yes" 
                                                                                               id="sms-online-no-payment" 
                                                                                               <?php echo (isset($doctor->sms_online_no_payment) && $doctor->sms_online_no_payment == 'yes') ? 'checked' : ''; ?>>
                                                                                        <label class="custom-control-label" for="sms-online-no-payment">
                                                                                            <div class="d-flex align-items-center">
                                                                                                <i class="fas fa-calendar-check text-warning fa-2x mr-3"></i>
                                                                                                <div>
                                                                                                    <strong class="text-dark">Online Bookings Without Advance Payment</strong>
                                                                                                    <br>
                                                                                                    <small class="text-muted">Send SMS when patients book appointments online without advance payment</small>
                                                                                                </div>
                                                                                            </div>
                                                                                        </label>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>

                                                                        <div class="col-md-12 mb-4">
                                                                            <div class="card sms-option border">
                                                                                <div class="card-body">
                                                                                    <div class="custom-control custom-checkbox">
                                                                                        <input type="checkbox" class="custom-control-input" 
                                                                                               name="sms_ivr_bookings" 
                                                                                               value="yes" 
                                                                                               id="sms-ivr-bookings" 
                                                                                               <?php echo (isset($doctor->sms_ivr_bookings) && $doctor->sms_ivr_bookings == 'yes') ? 'checked' : ''; ?>>
                                                                                        <label class="custom-control-label" for="sms-ivr-bookings">
                                                                                            <div class="d-flex align-items-center">
                                                                                                <i class="fas fa-phone text-primary fa-2x mr-3"></i>
                                                                                                <div>
                                                                                                    <strong class="text-dark">Booking Through IVR</strong>
                                                                                                    <br>
                                                                                                    <small class="text-muted">Send SMS when patients book appointments through Interactive Voice Response (IVR)</small>
                                                                                                </div>
                                                                                            </div>
                                                                                        </label>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>

                                                                        <div class="col-md-12 mb-4">
                                                                            <div class="card sms-option border">
                                                                                <div class="card-body">
                                                                                    <div class="custom-control custom-checkbox">
                                                                                        <input type="checkbox" class="custom-control-input" 
                                                                                               name="sms_session_start_notification_patient" 
                                                                                               value="yes" 
                                                                                               id="sms-session-start" 
                                                                                               <?php echo (isset($doctor->sms_session_start_notification_patient) && $doctor->sms_session_start_notification_patient == 'yes') ? 'checked' : ''; ?>>
                                                                                        <label class="custom-control-label" for="sms-session-start">
                                                                                            <div class="d-flex align-items-center">
                                                                                                <i class="fas fa-user-md text-success fa-2x mr-3"></i>
                                                                                                <div>
                                                                                                    <strong class="text-dark">Session Start Notification</strong>
                                                                                                    <br>
                                                                                                    <small class="text-muted">Send SMS to patient when you start their treatment session in the queue</small>
                                                                                                </div>
                                                                                            </div>
                                                                                        </label>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>

                                                                <div class="alert alert-warning">
                                                                    <i class="fas fa-info-circle mr-2"></i>
                                                                    <strong>Note:</strong> 
                                                                    <small>
                                                                        SMS notifications will only be sent if the hospital has SMS services configured. 
                                                                        Unchecking these options will disable SMS for the respective booking types.
                                                                    </small>
                                                                </div>

                                                                <button type="submit" class="btn btn-info">
                                                                    <i class="fas fa-save mr-2"></i>
                                                                    Update SMS Settings
                                                                </button>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                                                                 </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

</div>

<style>
.payment-option {
    transition: all 0.3s ease;
}

.payment-option:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}

.nav-pills .nav-link {
    border-radius: 0.5rem;
    margin-bottom: 0.5rem;
    padding: 1rem;
    color: #6c757d;
}

.nav-pills .nav-link:hover {
    background-color: #f8f9fa;
    color: #495057;
}

.nav-pills .nav-link.active {
    background-color: #007bff;
    color: white !important;
    box-shadow: 0 2px 4px rgba(0,123,255,0.3);
}

.nav-pills .nav-link.active .text-muted {
    color: rgba(255,255,255,0.8) !important;
}

.nav-pills .nav-link.active i {
    color: white !important;
}

.border-left-primary {
    border-left: 0.25rem solid #007bff !important;
}

.border-left-success {
    border-left: 0.25rem solid #28a745 !important;
}
</style>

<script>
$(document).ready(function() {
    // Handle payment option card clicks
    $('.payment-option').click(function() {
        const radio = $(this).find('input[type="radio"]');
        
        // First uncheck all radios
        $('input[name="online_payment_enabled"]').prop('checked', false);
        
        // Then check the clicked one
        radio.prop('checked', true);
        
        // Update card styling
        $('.payment-option').removeClass('border-danger border-warning border-secondary bg-light');
        $('.payment-option').addClass('border-secondary');
        
        const value = radio.val();
        if (value === 'required') {
            $(this).removeClass('border-secondary').addClass('border-danger bg-light');
        } else if (value === 'optional') {
            $(this).removeClass('border-secondary').addClass('border-warning bg-light');
        } else {
            $(this).removeClass('border-secondary').addClass('border-secondary bg-light');
        }
        
        console.log('Selected payment option:', value);
    });
    
    // Also handle direct radio button clicks
    $('input[name="online_payment_enabled"]').change(function() {
        const value = $(this).val();
        const card = $(this).closest('.payment-option');
        
        // Update card styling
        $('.payment-option').removeClass('border-danger border-warning border-secondary bg-light');
        $('.payment-option').addClass('border-secondary');
        
        if (value === 'required') {
            card.removeClass('border-secondary').addClass('border-danger bg-light');
        } else if (value === 'optional') {
            card.removeClass('border-secondary').addClass('border-warning bg-light');
        } else {
            card.removeClass('border-secondary').addClass('border-secondary bg-light');
        }
        
        console.log('Selected payment option via radio:', value);
    });
    
    // Handle cancellation option card clicks
    $('.cancellation-option').click(function() {
        const radio = $(this).find('input[type="radio"]');
        
        // First uncheck all radios
        $('input[name="cancellation_permission"]').prop('checked', false);
        
        // Then check the clicked one
        radio.prop('checked', true);
        
        // Update card styling
        $('.cancellation-option').removeClass('border-success border-danger bg-light');
        $('.cancellation-option').addClass('border-secondary');
        
        const value = radio.val();
        if (value === 'allow') {
            $(this).removeClass('border-secondary').addClass('border-success bg-light');
        } else {
            $(this).removeClass('border-secondary').addClass('border-danger bg-light');
        }
        
        // Show/hide cancellation type section based on permission
        if (value === 'allow') {
            $('#cancellation-type-section').fadeIn();
        } else {
            $('#cancellation-type-section').fadeOut();
        }
        
        console.log('Selected cancellation option:', value);
    });
    
    // Also handle direct cancellation radio button clicks
    $('input[name="cancellation_permission"]').change(function() {
        const value = $(this).val();
        const card = $(this).closest('.cancellation-option');
        
        // Update card styling
        $('.cancellation-option').removeClass('border-success border-danger bg-light');
        $('.cancellation-option').addClass('border-secondary');
        
        if (value === 'allow') {
            card.removeClass('border-secondary').addClass('border-success bg-light');
        } else {
            card.removeClass('border-secondary').addClass('border-danger bg-light');
        }
        
        console.log('Selected cancellation option via radio:', value);
        
        // Show/hide cancellation type section based on permission
        if (value === 'allow') {
            $('#cancellation-type-section').fadeIn();
        } else {
            $('#cancellation-type-section').fadeOut();
        }
    });
    
    // Handle cancellation type option card clicks
    $('.cancellation-type-option').click(function() {
        const radio = $(this).find('input[type="radio"]');
        
        // First uncheck all radios
        $('input[name="cancellation_type"]').prop('checked', false);
        
        // Then check the clicked one
        radio.prop('checked', true);
        
        // Update card styling
        $('.cancellation-type-option').removeClass('border-info border-warning border-success bg-light');
        $('.cancellation-type-option').addClass('border-secondary');
        
        const value = radio.val();
        if (value === 'paid_only') {
            $(this).removeClass('border-secondary').addClass('border-info bg-light');
        } else if (value === 'non_paid_only') {
            $(this).removeClass('border-secondary').addClass('border-warning bg-light');
        } else if (value === 'both') {
            $(this).removeClass('border-secondary').addClass('border-success bg-light');
        }
        
        console.log('Selected cancellation type:', value);
    });
    
    // Also handle direct cancellation type radio button clicks
    $('input[name="cancellation_type"]').change(function() {
        const value = $(this).val();
        const card = $(this).closest('.cancellation-type-option');
        
        // Update card styling
        $('.cancellation-type-option').removeClass('border-info border-warning border-success bg-light');
        $('.cancellation-type-option').addClass('border-secondary');
        
        if (value === 'paid_only') {
            card.removeClass('border-secondary').addClass('border-info bg-light');
        } else if (value === 'non_paid_only') {
            card.removeClass('border-secondary').addClass('border-warning bg-light');
        } else if (value === 'both') {
            card.removeClass('border-secondary').addClass('border-success bg-light');
        }
        
        console.log('Selected cancellation type via radio:', value);
    });
    
    // Debug form submission
    $('form[action="doctor/settings/updateOnlinePayment"]').submit(function() {
        const selectedValue = $('input[name="online_payment_enabled"]:checked').val();
        console.log('Form submitting with value:', selectedValue);
        
        if (!selectedValue) {
            alert('Please select a payment option');
            return false;
        }
        
        return true;
    });
});
</script> 