<!--sidebar end-->
<!--main content start-->
<link href="common/extranal/css/doctor/add_new.css" rel="stylesheet">

<div class="content-wrapper bg-light">
    <section class="content-header py-4 bg-white shadow-sm">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h1 class="display-4 font-weight-black mb-0">
                        <i class="fas fa-calendar-plus text-primary mr-3"></i>
                        <?php
                        if (!empty($doctor->id))
                            echo lang('edit_doctor');
                        else
                            echo lang('add_doctor');
                        ?>
                    </h1>
                </div>
                <div class="col-sm-6">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb float-sm-right bg-transparent">
                            <li class="breadcrumb-item"><a href="home" class="text-primary"><?php echo lang('home') ?></a></li>
                            <li class="breadcrumb-item active font-weight-bold">
                                <?php
                                if (!empty($doctor->id))
                                    echo lang('edit_doctor');
                                else
                                    echo lang('add_doctor');
                                ?>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </section>

    <section class="content py-4">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-10">
                    <div class="card shadow-lg border-0">
                        <div class="card-header bg-gradient-primary py-4">
                            <h2 class="card-title mb-0 text-white display-6 font-weight-800"><?php echo lang('doctor_registration_form'); ?></h2>
                        </div>
                        <div class="card-body bg-light p-4">
                            <?php echo validation_errors(); ?>
                            <?php echo $this->session->flashdata('feedback'); ?>

                            <form role="form" action="doctor/addNew" method="post" enctype="multipart/form-data">

                                <!-- Personal Information -->
                                <div class="row mb-5">
                                    <div class="col-12 mb-4">
                                        <h3 class="border-bottom border-primary pb-3 text-uppercase font-weight-900">
                                            <i class="fas fa-user-circle mr-3 text-primary"></i><?php echo lang('personal_details'); ?>
                                        </h3>
                                    </div>

                                    <div class="col-md-6 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('name'); ?> <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control form-control-lg shadow-sm" name="name" value='<?php
                                                                                                                                    if (!empty($setval)) {
                                                                                                                                        echo set_value('name');
                                                                                                                                    }
                                                                                                                                    if (!empty($doctor->name)) {
                                                                                                                                        echo $doctor->name;
                                                                                                                                    }
                                                                                                                                    ?>' required="">
                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('email'); ?> <span class="text-danger">*</span></label>
                                            <input type="email" class="form-control form-control-lg shadow-sm" name="email" value='<?php
                                                                                                                                    if (!empty($setval)) {
                                                                                                                                        echo set_value('email');
                                                                                                                                    }
                                                                                                                                    if (!empty($doctor->email)) {
                                                                                                                                        echo $doctor->email;
                                                                                                                                    }
                                                                                                                                    ?>' required="">
                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('password'); ?></label>
                                            <input type="password" class="form-control form-control-lg shadow-sm" name="password" placeholder="********">
                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('phone'); ?> <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control form-control-lg shadow-sm" name="phone" value='<?php
                                                                                                                                    if (!empty($setval)) {
                                                                                                                                        echo set_value('phone');
                                                                                                                                    }
                                                                                                                                    if (!empty($doctor->phone)) {
                                                                                                                                        echo $doctor->phone;
                                                                                                                                    }
                                                                                                                                    ?>' required>
                                        </div>
                                    </div>

                                    <div class="col-md-12 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('address'); ?> <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control form-control-lg shadow-sm" name="address" value='<?php
                                                                                                                                    if (!empty($setval)) {
                                                                                                                                        echo set_value('address');
                                                                                                                                    }
                                                                                                                                    if (!empty($doctor->address)) {
                                                                                                                                        echo $doctor->address;
                                                                                                                                    }
                                                                                                                                    ?>' required>
                                        </div>
                                    </div>

                                    <div class="col-md-12 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('department'); ?></label>
                                            <select class="form-control form-control-lg shadow-sm" name="department">
                                                <?php foreach ($departments as $department) { ?>
                                                    <option value="<?php echo $department->id; ?>" <?php
                                                                                                    if (!empty($setval)) {
                                                                                                        if ($department->id == set_value('department')) {
                                                                                                            echo 'selected';
                                                                                                        }
                                                                                                    }
                                                                                                    if (!empty($doctor->department)) {
                                                                                                        if ($department->id == $doctor->department) {
                                                                                                            echo 'selected';
                                                                                                        }
                                                                                                    }
                                                                                                    ?>> <?php echo $department->name; ?> </option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-12 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('speciality'); ?></label>
                                            <select class="form-control form-control-lg shadow-sm" name="speciality_id">
                                                <option value="">-- <?php echo lang('select'); ?> <?php echo lang('speciality'); ?> --</option>
                                                <?php foreach ($specialities as $speciality) { ?>
                                                    <option value="<?php echo $speciality->id; ?>" <?php
                                                                                                    if (!empty($setval)) {
                                                                                                        if ($speciality->id == set_value('speciality_id')) {
                                                                                                            echo 'selected';
                                                                                                        }
                                                                                                    }
                                                                                                    if (!empty($doctor->speciality_id)) {
                                                                                                        if ($speciality->id == $doctor->speciality_id) {
                                                                                                            echo 'selected';
                                                                                                        }
                                                                                                    }
                                                                                                    ?>> <?php echo $speciality->name; ?> </option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-12 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('qualification'); ?></label>
                                            <input type="text" class="form-control form-control-lg shadow-sm" name="qualification" value='<?php
                                                                                                                                        if (!empty($setval)) {
                                                                                                                                            echo set_value('qualification');
                                                                                                                                        }
                                                                                                                                        if (!empty($doctor->qualification)) {
                                                                                                                                            echo $doctor->qualification;
                                                                                                                                        }
                                                                                                                                        ?>' placeholder="<?php echo lang('qualification'); ?>">
                                        </div>
                                    </div>

                                                            <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('schedule_type'); ?></label>
                                <select class="form-control form-control-lg shadow-sm" name="schedule_type">
                                    <option value="weekday" <?php 
                                        if (!empty($doctor->schedule_type) && $doctor->schedule_type == 'weekday') {
                                            echo 'selected';
                                        } elseif (empty($doctor->schedule_type)) {
                                            echo 'selected';
                                        }
                                    ?>><?php echo lang('weekday_based'); ?></option>
                                    <option value="date" <?php 
                                        if (!empty($doctor->schedule_type) && $doctor->schedule_type == 'date') {
                                            echo 'selected';
                                        }
                                    ?>><?php echo lang('date_based'); ?></option>
                                </select>
                                <small class="form-text text-muted">
                                    <?php echo lang('weekday_based'); ?>: <?php echo lang('schedule_based_on_weekdays'); ?><br>
                                    <?php echo lang('date_based'); ?>: <?php echo lang('schedule_based_on_monthly_dates'); ?>
                                </small>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted">Online Payment Setting</label>
                                <select class="form-control form-control-lg shadow-sm" name="online_payment_enabled">
                                    <option value="disabled" <?php 
                                        if (empty($doctor->online_payment_enabled) || $doctor->online_payment_enabled == 'disabled') {
                                            echo 'selected';
                                        }
                                    ?>>Book Without Payment</option>
                                    <option value="optional" <?php 
                                        if (!empty($doctor->online_payment_enabled) && $doctor->online_payment_enabled == 'optional') {
                                            echo 'selected';
                                        }
                                    ?>>Optional</option>
                                    <option value="required" <?php 
                                        if (!empty($doctor->online_payment_enabled) && $doctor->online_payment_enabled == 'required') {
                                            echo 'selected';
                                        }
                                    ?>>Payment Required</option>
                                </select>
                                <small class="form-text text-muted">
                                    Controls how patients pay when booking appointments online
                                </small>
                            </div>
                        </div>

                                    <div class="col-md-12 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('profile'); ?> <span class="text-danger">*</span></label>
                                            <textarea class="form-control ckeditor" id="editor1" name="profile" rows="6"><?php
                                                                                                                            if (!empty($setval)) {
                                                                                                                                echo set_value('profile');
                                                                                                                            }
                                                                                                                            if (!empty($doctor->profile)) {
                                                                                                                                echo $doctor->profile;
                                                                                                                            }
                                                                                                                            ?></textarea>
                                        </div>
                                    </div>
                                </div>

                                <!-- Images -->
                                <div class="row mb-5">
                                    <div class="col-12 mb-4">
                                        <h3 class="border-bottom border-info pb-3 text-uppercase font-weight-900">
                                            <i class="fas fa-images mr-3 text-info"></i>Images
                                        </h3>
                                    </div>

                                    <div class="col-md-6 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('image'); ?></label>
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input" name="img_url" id="customFile1">
                                                <label class="custom-file-label" for="customFile1">Choose profile image</label>
                                            </div>
                                            <?php if (!empty($doctor->img_url)) { ?>
                                                <div class="mt-3">
                                                    <img src="<?php echo $doctor->img_url; ?>" class="img-thumbnail" height="100px">
                                                </div>
                                            <?php } ?>
                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('signature'); ?> <span class="text-danger">*</span></label>
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input" name="signature" id="customFile2">
                                                <label class="custom-file-label" for="customFile2"><?php echo lang('choose_signature_image'); ?></label>
                                            </div>
                                            <?php if (!empty($doctor->signature)) { ?>
                                                <div class="mt-3">
                                                    <img src="<?php echo $doctor->signature; ?>" class="img-thumbnail" height="100px">
                                                </div>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>

                                <!-- Doctor Settings -->
                                <div class="row mb-5">
                                    <div class="col-12 mb-4">
                                        <h3 class="border-bottom border-warning pb-3 text-uppercase font-weight-900">
                                            <i class="fas fa-cog mr-3 text-warning"></i>Doctor Settings
                                        </h3>
                                    </div>

                                    <!-- Cancellation Permission -->
                                    <div class="col-md-12 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted mb-3">Cancellation Policy:</label>
                                            
                                            <div class="row">
                                                <?php $current_permission = isset($doctor->cancellation_permission) ? $doctor->cancellation_permission : 'allow'; ?>
                                                
                                                <div class="col-md-6 mb-3">
                                                    <div class="card cancellation-option <?php echo ($current_permission == 'allow') ? 'border-success bg-light' : 'border-secondary'; ?>" style="cursor: pointer;">
                                                        <div class="card-body text-center p-4">
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" class="custom-control-input" name="cancellation_permission" value="allow" id="cancellation-allow" <?php echo ($current_permission == 'allow') ? 'checked' : ''; ?>>
                                                                <label class="custom-control-label" for="cancellation-allow">
                                                                    <i class="fas fa-check-circle text-success fa-3x d-block mb-3"></i>
                                                                    <strong>Allow Cancellation</strong>
                                                                    <small class="d-block text-muted mt-2">Patients can cancel their appointments</small>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <div class="card cancellation-option <?php echo ($current_permission == 'disallow') ? 'border-danger bg-light' : 'border-secondary'; ?>" style="cursor: pointer;">
                                                        <div class="card-body text-center p-4">
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" class="custom-control-input" name="cancellation_permission" value="disallow" id="cancellation-disallow" <?php echo ($current_permission == 'disallow') ? 'checked' : ''; ?>>
                                                                <label class="custom-control-label" for="cancellation-disallow">
                                                                    <i class="fas fa-ban text-danger fa-3x d-block mb-3"></i>
                                                                    <strong>Disallow Cancellation</strong>
                                                                    <small class="d-block text-muted mt-2">Patients cannot cancel appointments</small>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Cancellation Type Section -->
                                    <div class="col-md-12 mb-4" id="cancellation-type-section" style="<?php echo ($current_permission == 'allow') ? '' : 'display: none;'; ?>">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted mb-3">Cancellation Type:</label>
                                            
                                            <div class="row">
                                                <?php $current_type = isset($doctor->cancellation_type) ? $doctor->cancellation_type : 'both'; ?>
                                                
                                                <div class="col-md-4 mb-3">
                                                    <div class="card cancellation-type-option <?php echo ($current_type == 'paid_only') ? 'border-info bg-light' : 'border-secondary'; ?>" style="cursor: pointer;">
                                                        <div class="card-body text-center p-3">
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" class="custom-control-input" name="cancellation_type" value="paid_only" id="cancellation-paid" <?php echo ($current_type == 'paid_only') ? 'checked' : ''; ?>>
                                                                <label class="custom-control-label" for="cancellation-paid">
                                                                    <i class="fas fa-credit-card text-info fa-2x d-block mb-2"></i>
                                                                    <strong>Paid Only</strong>
                                                                    <small class="d-block text-muted mt-1">Only paid appointments</small>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                <div class="col-md-4 mb-3">
                                                    <div class="card cancellation-type-option <?php echo ($current_type == 'non_paid_only') ? 'border-warning bg-light' : 'border-secondary'; ?>" style="cursor: pointer;">
                                                        <div class="card-body text-center p-3">
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" class="custom-control-input" name="cancellation_type" value="non_paid_only" id="cancellation-non-paid" <?php echo ($current_type == 'non_paid_only') ? 'checked' : ''; ?>>
                                                                <label class="custom-control-label" for="cancellation-non-paid">
                                                                    <i class="fas fa-handshake text-warning fa-2x d-block mb-2"></i>
                                                                    <strong>Non-Paid Only</strong>
                                                                    <small class="d-block text-muted mt-1">Only non-paid appointments</small>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                <div class="col-md-4 mb-3">
                                                    <div class="card cancellation-type-option <?php echo ($current_type == 'both') ? 'border-success bg-light' : 'border-secondary'; ?>" style="cursor: pointer;">
                                                        <div class="card-body text-center p-3">
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" class="custom-control-input" name="cancellation_type" value="both" id="cancellation-both" <?php echo ($current_type == 'both') ? 'checked' : ''; ?>>
                                                                <label class="custom-control-label" for="cancellation-both">
                                                                    <i class="fas fa-calendar-check text-success fa-2x d-block mb-2"></i>
                                                                    <strong>Both</strong>
                                                                    <small class="d-block text-muted mt-1">Paid & non-paid appointments</small>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- SMS Settings -->
                                <div class="row mb-5">
                                    <div class="col-12 mb-4">
                                        <h3 class="border-bottom border-info pb-3 text-uppercase font-weight-900">
                                            <i class="fas fa-sms mr-3 text-info"></i>SMS Notification Settings
                                        </h3>
                                    </div>

                                    <div class="col-md-12 mb-4">
                                        <div class="alert alert-info">
                                            <i class="fas fa-info-circle mr-2"></i>
                                            <strong>SMS Notifications</strong><br>
                                            <small>Configure when SMS notifications should be sent to patients for different booking types</small>
                                        </div>
                                    </div>

                                    <!-- SMS Options -->
                                    <div class="col-md-6 mb-4">
                                        <div class="card sms-option border">
                                            <div class="card-body">
                                                <div class="custom-control custom-checkbox">
                                                    <input type="checkbox" class="custom-control-input" 
                                                           name="sms_advanced_paid_bookings" 
                                                           value="yes" 
                                                           id="sms-advanced-paid" 
                                                           <?php echo (isset($doctor->sms_advanced_paid_bookings) && $doctor->sms_advanced_paid_bookings == 'yes') ? 'checked' : ''; ?>>
                                                    <label class="custom-control-label" for="sms-advanced-paid">
                                                        <div class="d-flex align-items-center">
                                                            <i class="fas fa-credit-card text-success fa-2x mr-3"></i>
                                                            <div>
                                                                <strong class="text-dark">Advanced Paid Online Bookings</strong>
                                                                <br>
                                                                <small class="text-muted">Send SMS when patients book appointments online with advance payment</small>
                                                            </div>
                                                        </div>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-4">
                                        <div class="card sms-option border">
                                            <div class="card-body">
                                                <div class="custom-control custom-checkbox">
                                                    <input type="checkbox" class="custom-control-input" 
                                                           name="sms_online_no_payment" 
                                                           value="yes" 
                                                           id="sms-online-no-payment" 
                                                           <?php echo (isset($doctor->sms_online_no_payment) && $doctor->sms_online_no_payment == 'yes') ? 'checked' : ''; ?>>
                                                    <label class="custom-control-label" for="sms-online-no-payment">
                                                        <div class="d-flex align-items-center">
                                                            <i class="fas fa-calendar-check text-warning fa-2x mr-3"></i>
                                                            <div>
                                                                <strong class="text-dark">Online Bookings Without Advance Payment</strong>
                                                                <br>
                                                                <small class="text-muted">Send SMS when patients book appointments online without advance payment</small>
                                                            </div>
                                                        </div>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-4">
                                        <div class="card sms-option border">
                                            <div class="card-body">
                                                <div class="custom-control custom-checkbox">
                                                    <input type="checkbox" class="custom-control-input" 
                                                           name="sms_ivr_bookings" 
                                                           value="yes" 
                                                           id="sms-ivr-bookings" 
                                                           <?php echo (isset($doctor->sms_ivr_bookings) && $doctor->sms_ivr_bookings == 'yes') ? 'checked' : ''; ?>>
                                                    <label class="custom-control-label" for="sms-ivr-bookings">
                                                        <div class="d-flex align-items-center">
                                                            <i class="fas fa-phone text-primary fa-2x mr-3"></i>
                                                            <div>
                                                                <strong class="text-dark">Booking Through IVR</strong>
                                                                <br>
                                                                <small class="text-muted">Send SMS when patients book appointments through Interactive Voice Response (IVR)</small>
                                                            </div>
                                                        </div>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-4">
                                        <div class="card sms-option border">
                                            <div class="card-body">
                                                <div class="custom-control custom-checkbox">
                                                    <input type="checkbox" class="custom-control-input" 
                                                           name="sms_session_start_notification_patient" 
                                                           value="yes" 
                                                           id="sms-session-start" 
                                                           <?php echo (isset($doctor->sms_session_start_notification_patient) && $doctor->sms_session_start_notification_patient == 'yes') ? 'checked' : ''; ?>>
                                                    <label class="custom-control-label" for="sms-session-start">
                                                        <div class="d-flex align-items-center">
                                                            <i class="fas fa-user-md text-success fa-2x mr-3"></i>
                                                            <div>
                                                                <strong class="text-dark">Session Start Notification</strong>
                                                                <br>
                                                                <small class="text-muted">Send SMS to patient when you start their treatment session in the queue</small>
                                                            </div>
                                                        </div>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <input type="hidden" name="id" value='<?php
                                                                        if (!empty($doctor->id)) {
                                                                            echo $doctor->id;
                                                                        }
                                                                        ?>'>

                                <div class="row">
                                    <div class="col-md-12">
                                        <button type="submit" name="submit" class="btn btn-primary btn-lg btn-block shadow-lg py-3">
                                            <i class="fas fa-save mr-3"></i><?php echo lang('submit'); ?>
                                        </button>
                                    </div>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!--main content end-->
<!--footer start-->
<script src="common/js/codearistos.min.js"></script>
<script type="text/javascript">
    var language = "<?php echo $this->language; ?>";
</script>
<script src="common/assets/tinymce/tinymce.min.js"></script>
<script src="common/extranal/js/doctor/doctor.js"></script>

<script>
$(document).ready(function() {
    // Handle cancellation permission change
    $('input[name="cancellation_permission"]').change(function() {
        var selectedValue = $(this).val();
        var typeSection = $('#cancellation-type-section');
        
        if (selectedValue === 'allow') {
            typeSection.slideDown(300);
        } else {
            typeSection.slideUp(300);
        }
        
        // Update card styling
        $('.cancellation-option').removeClass('border-success bg-light border-danger');
        $('.cancellation-option').addClass('border-secondary');
        
        if (selectedValue === 'allow') {
            $('#cancellation-allow').closest('.cancellation-option').removeClass('border-secondary').addClass('border-success bg-light');
        } else {
            $('#cancellation-disallow').closest('.cancellation-option').removeClass('border-secondary').addClass('border-danger bg-light');
        }
    });
    
    // Handle cancellation type change
    $('input[name="cancellation_type"]').change(function() {
        var selectedValue = $(this).val();
        
        // Update card styling
        $('.cancellation-type-option').removeClass('border-info bg-light border-warning border-success');
        $('.cancellation-type-option').addClass('border-secondary');
        
        if (selectedValue === 'paid_only') {
            $('#cancellation-paid').closest('.cancellation-type-option').removeClass('border-secondary').addClass('border-info bg-light');
        } else if (selectedValue === 'non_paid_only') {
            $('#cancellation-non-paid').closest('.cancellation-type-option').removeClass('border-secondary').addClass('border-warning bg-light');
        } else if (selectedValue === 'both') {
            $('#cancellation-both').closest('.cancellation-type-option').removeClass('border-secondary').addClass('border-success bg-light');
        }
    });
    
    // Make cards clickable
    $('.cancellation-option, .cancellation-type-option').click(function() {
        $(this).find('input[type="radio"]').prop('checked', true).trigger('change');
    });
});
</script>