<!--sidebar end-->
<!--main content start-->

<link href="common/extranal/css/appointment/appointment.css" rel="stylesheet">

<div class="content-wrapper bg-light">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row my-2 pl-1">
                <div class="col-sm-6">
                    <h1 class="font-weight-bold">
                        <i class="fas fa-calendar-check mr-2"></i>
                        <?php echo lang('appointments') ?>
                    </h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="home"><?php echo lang('home') ?></a></li>
                        <li class="breadcrumb-item active"><?php echo lang('appointments') ?></li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header bg-light border-bottom">
                            <div class="row align-items-center">
                                <div class="col-md-6">
                                    <h3 class="card-title mb-0">
                                        <i class="fas fa-calendar-check mr-2 text-primary"></i>
                                        <?php echo lang('All the appointments details'); ?>
                                    </h3>
                                </div>
                                <div class="col-md-6 text-right">
                                    <?php if ($this->ion_auth->in_group(array('Patient')) && isset($hospitals)) { ?>
                                        <select class="form-control form-control-sm d-inline-block mb-2" id="patient_hospital_select" name="hospital_id" 
                                                style="width: 280px; border: 2px solid #007bff;">
                                            <option value="consolidated" <?php echo ($selected_hospital === 'consolidated') ? 'selected' : ''; ?>>
                                                📊 All Hospitals Data
                                            </option>
                                            <?php foreach ($hospitals as $hospital) { ?>
                                                <option value="<?php echo $hospital->id; ?>" 
                                                        <?php echo ($selected_hospital == $hospital->id) ? 'selected' : ''; ?>>
                                                    🏥 <?php echo $hospital->name; ?>
                                                </option>
                                            <?php } ?>
                                        </select>
                                        <br>
                                    <?php } ?>
                                    <a data-toggle="modal" href="#myModal">
                                        <button id="" onclick="javascript:window.print();" class="btn btn-success btn-sm no-print">
                                            <i class="fa fa-print"></i> <?php echo lang('print'); ?>
                                        </button>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table class="table table-bordered table-hover" id="editable-sample">
                                <thead>
                                    <tr>
                                        <th> <?php echo lang('id'); ?></th>
                                        <th> <?php echo lang('patient'); ?></th>
                                        <th> <?php echo lang('doctor'); ?></th>
                                        <th> <?php echo lang('date-time'); ?></th>
                                        <th> <?php echo lang('remarks'); ?></th>
                                        <th> <?php echo lang('status'); ?></th>
                                        <th> <?php echo lang('description'); ?></th>
                                        <th> <?php echo lang('invoice_id'); ?></th>
                                        <th> <?php echo lang('amount'); ?></th>
                                        <th> <?php echo lang('bill'); ?> <?php echo lang('status'); ?></th>
                                        <th> <?php echo lang('options'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>


                                    <?php
                                    foreach ($appointments as $appointment) {
                                        if ($user_id == $appointment->patient) {



                                            $payment_details = $this->finance_model->getPaymentByAppointmentId($appointment->id);
                                            $total_deposited_amount = $this->finance_model->getDepositAmountByPaymentId($payment_details->id);
                                            $total_due = $payment_details->gross_total - $total_deposited_amount;
                                            if ($payment_details->gross_total == $total_due) {
                                                if ($payment_details->gross_total != 0) {
                                                    $bill_status = '<span class="badge badge-warning">' . lang('unpaid') . '</span>';
                                                } else {
                                                    $bill_status = '<span class="badge badge-primary">' . lang('paid') . '</span>';
                                                }
                                            } elseif ($total_due == 0) {
                                                $bill_status = '<span class="badge badge-primary">' . lang('paid') . '</span>';
                                            } else {
                                                $bill_status = '<span class="badge badge-warning">' . lang('due') . '</span>';
                                            }
                                            $patientdetails = $this->patient_model->getPatientById($appointment->patient);
                                            if (!empty($patientdetails)) {
                                                $patientname = ' <a type="button" class="history" data-toggle = "modal" data-id="' . $appointment->patient . '"> ' . $patientdetails->name . '</a>';
                                            } else {
                                                $patientname = ' <a type="button" class="history" data-toggle = "modal" data-id="' . $appointment->patient . '"> ' . $appointment->patientname . '</a>';
                                            }
                                            $doctordetails = $this->doctor_model->getDoctorById($appointment->doctor);
                                            if (!empty($doctordetails)) {
                                                $doctorname = $doctordetails->name;
                                            } else {
                                                $doctorname = $appointment->doctorname;
                                            }


                                            if ($appointment->status == 'Confirmed') {
                                                if (empty($appointment->meeting_id)) {
                                                    $options7 = '';
                                                } else {
                                                    $options7 = '<a class="btn btn-info btn-sm btn_width detailsbutton buttoncolor" title="' . lang('start_live') . '"  href="' . $appointment->join_url . '" target="_blank" onclick="return confirm(\'Are you sure you want to start a live meeting with the doctor?\');"><i class="fa fa-headphones"></i> ' . lang('live') . '</a>';
                                                }
                                            } else {
                                                $options7 = '';
                                            }

                                            // Add cancellation button logic
                                            $cancel_button = '';
                                            if (in_array($appointment->status, ['Confirmed', 'Pending Confirmation'])) {
                                                $doctor_details = $this->doctor_model->getDoctorById($appointment->doctor);
                                                $cancellation_permission = isset($doctor_details->cancellation_permission) ? $doctor_details->cancellation_permission : 'allow';
                                                $cancellation_type = isset($doctor_details->cancellation_type) ? $doctor_details->cancellation_type : 'both';
                                                
                                                // Check if cancellation is allowed
                                                $can_cancel = false;
                                                if ($cancellation_permission == 'allow') {
                                                    // Check payment status and cancellation type
                                                    $is_paid = (!empty($appointment->payment_amount) && $appointment->payment_amount > 0);
                                                    
                                                    if ($cancellation_type == 'both') {
                                                        $can_cancel = true;
                                                    } elseif ($cancellation_type == 'paid_only' && $is_paid) {
                                                        $can_cancel = true;
                                                    } elseif ($cancellation_type == 'non_paid_only' && !$is_paid) {
                                                        $can_cancel = true;
                                                    }
                                                }
                                                
                                                if ($can_cancel) {
                                                    $cancel_button = '<a class="btn btn-danger btn-sm ml-2 cancel-appointment" 
                                                                         data-appointment-id="' . $appointment->id . '" 
                                                                         data-doctor-name="' . (isset($doctorname) ? $doctorname : 'Unknown') . '" 
                                                                         data-appointment-date="' . date('d-m-Y', $appointment->date) . '" 
                                                                         data-appointment-status="' . $appointment->status . '"
                                                                         title="Cancel Appointment">
                                                                         <i class="fa fa-times"></i> Cancel
                                                                     </a>';
                                                }
                                            }

                                            // Combine options
                                            $all_options = $options7 . $cancel_button;



                                            if (!empty($appointment->visit_description)) {
                                                $visit_type = $this->doctorvisit_model->GetDoctorVisitById($appointment->visit_description);
                                                if ($visit_type) {
                                                    $visit_type_name = $visit_type->visit_description;
                                                } else {
                                                    $visit_type_name = '';
                                                }
                                            } else {
                                                $visit_type_name = '';
                                            }

                                            if (!empty($payment_details->id)) {
                                                $invoice = '<a href="finance/invoice?id=' . $payment_details->id . '">' . $payment_details->id . '</a>';
                                            } else {
                                                $invoice = '';
                                            }


                                            if ($appointment->s_time == 'Not Selected') {
                                                $time_string = lang('not_selected');
                                            } else {
                                                $this->db->where('hospital_id', $this->hospital_id);
                                                $this->settings = $this->db->get('settings')->row();
                                                if ($this->settings->time_format == '24') {
                                                    $appointment->s_time = $this->settings_model->convert_to_24h($appointment->s_time);
                                                    $appointment->e_time = $this->settings_model->convert_to_24h($appointment->e_time);
                                                }
                                                $time_string = $appointment->s_time . ' - ' . $appointment->e_time;
                                            }









                                    ?>

                                            <tr class="">
                                                <td><?php echo $appointment->id; ?></td>
                                                <td><?php echo $this->patient_model->getPatientById($appointment->patient)->name; ?></td>
                                                <td><?php echo $this->doctor_model->getDoctorById($appointment->doctor)->name; ?></td>
                                                <td><?php echo date('d-m-Y', $appointment->date) . ' <br> ' . $time_string; ?></td>
                                                <td><?php echo $appointment->remarks; ?></td>
                                                <td><?php echo lang(strtolower($appointment->status)); ?></td>
                                                <td><?php echo $visit_type_name; ?></td>
                                                <td><?php echo $invoice; ?></td>
                                                <td><?php echo $this->settings->currency . '' . $appointment->visit_charges; ?></td>
                                                <td><?php echo $bill_status; ?></td>
                                                <td><?php echo $all_options; ?></td>
                                            </tr>
                                    <?php
                                        }
                                    }
                                    ?>


                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>

    <!-- /.content -->
</div>

<!-- Appointment Cancellation Confirmation Modal -->
<div class="modal fade" id="cancelAppointmentModal" tabindex="-1" role="dialog" aria-labelledby="cancelAppointmentModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title" id="cancelAppointmentModalLabel">
                    <i class="fas fa-exclamation-triangle mr-2"></i>
                    Cancel Appointment
                </h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="text-center mb-3">
                    <i class="fas fa-calendar-times text-danger" style="font-size: 48px;"></i>
                </div>
                <h6 class="text-center mb-3">Are you sure you want to cancel this appointment?</h6>
                
                <div class="card border-left-danger">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-sm-4 font-weight-bold text-muted">Doctor:</div>
                            <div class="col-sm-8" id="modal-doctor-name">-</div>
                        </div>
                        <div class="row mt-2">
                            <div class="col-sm-4 font-weight-bold text-muted">Date:</div>
                            <div class="col-sm-8" id="modal-appointment-date">-</div>
                        </div>
                        <div class="row mt-2">
                            <div class="col-sm-4 font-weight-bold text-muted">Status:</div>
                            <div class="col-sm-8" id="modal-appointment-status">-</div>
                        </div>
                    </div>
                </div>
                
                <div class="alert alert-warning mt-3">
                    <i class="fas fa-info-circle mr-2"></i>
                    <strong>Note:</strong> This action cannot be undone. You will need to book a new appointment if required.
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="fas fa-times mr-1"></i> Keep Appointment
                </button>
                <button type="button" class="btn btn-danger" id="confirmCancelButton">
                    <i class="fas fa-check mr-1"></i> Yes, Cancel Appointment
                </button>
            </div>
        </div>
    </div>
</div>



<!--main content end-->
<!--footer start-->



<script src="common/js/codearistos.min.js"></script>

<script type="text/javascript">
    var select_doctor = "<?php echo lang('select_doctor'); ?>";
</script>
<script type="text/javascript">
    var select_patient = "<?php echo lang('select_patient'); ?>";
</script>
<script type="text/javascript">
    var language = <?php echo $this->language; ?>;
</script>
<script type="text/javascript">
    var no_available_timeslots = "<?php echo lang('no_available_timeslots'); ?>";
</script>

<script>
    $(document).ready(function() {
        "use strict";
        var table = $("#editable-sample").DataTable({
            responsive: true,

            processing: true,
            searchable: true,
            scroller: {
                loadingIndicator: true,
            },
            dom: "<'row'<'col-sm-3'l><'col-sm-5 text-center'B><'col-sm-4 text-right'f>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-5'i><'col-sm-7'p>>",

            buttons: [{
                    extend: "copyHtml5",
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
                    },
                },
                {
                    extend: "excelHtml5",
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
                    },
                },
                {
                    extend: "csvHtml5",
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
                    },
                },
                {
                    extend: "pdfHtml5",
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
                    },
                },
                {
                    extend: "print",
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
                    }
                },
            ],
            aLengthMenu: [
                [10, 25, 50, 100, -1],
                [10, 25, 50, 100, "All"],
            ],
            iDisplayLength: 100,
            order: [
                [0, "desc"]
            ],
            language: {
                lengthMenu: "_MENU_",
                search: "_INPUT_",
                searchPlaceholder: "Search...",
                url: "common/assets/DataTables/languages/" + language + ".json",
            },
        });
        table.buttons().container().appendTo(".custom_buttons");
    });
    
    // Patient hospital selection dropdown change handler
    $('#patient_hospital_select').change(function() {
        const selectedHospital = $(this).val();
        
        // Build URL with hospital parameter
        let url = 'appointment/myAppointments';
        if (selectedHospital) {
            url += '?hospital_id=' + selectedHospital;
        }
        
        // Show loading indication
        $(this).prop('disabled', true);
        $('body').append('<div id="loading-overlay" style="position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,0.5);z-index:9999;display:flex;align-items:center;justify-content:center;color:white;font-size:18px;"><i class="fas fa-spinner fa-spin mr-2"></i>Loading hospital data...</div>');
        
        // Redirect to reload page with selected hospital
        window.location.href = url;
    });
    
    // Handle appointment cancellation
    $(document).on('click', '.cancel-appointment', function(e) {
        e.preventDefault();
        
        const appointmentId = $(this).data('appointment-id');
        const doctorName = $(this).data('doctor-name');
        const appointmentDate = $(this).data('appointment-date');
        const appointmentStatus = $(this).data('appointment-status');
        const $button = $(this);
        
        // Set modal content
        $('#modal-doctor-name').text(doctorName);
        $('#modal-appointment-date').text(appointmentDate);
        $('#modal-appointment-status').text(appointmentStatus);
        
        // Show modal
        $('#cancelAppointmentModal').modal('show');
        
        // Handle confirmation button
        $('#confirmCancelButton').off('click').on('click', function() {
            // Hide modal first
            $('#cancelAppointmentModal').modal('hide');
            
            // Disable button and show loading
            $button.prop('disabled', true);
            $button.html('<i class="fa fa-spinner fa-spin"></i> Cancelling...');
            
            // AJAX request to cancel appointment
            $.ajax({
                url: 'appointment/cancelPatientAppointment',
                type: 'POST',
                data: {
                    appointment_id: appointmentId
                },
                dataType: 'json',
                success: function(response) {
                    console.log('Success response:', response);
                    if (response.status === 'success') {
                        // Show success notification
                        showNotification('success', 'Appointment cancelled successfully!');
                        // Reload the page to show updated status after a short delay
                        setTimeout(function() {
                            window.location.reload();
                        }, 1000);
                    } else {
                        // Show error notification
                        showNotification('error', response.message || 'Failed to cancel appointment');
                        // Re-enable button
                        $button.prop('disabled', false);
                        $button.html('<i class="fa fa-times"></i> Cancel');
                    }
                },
                error: function(xhr, status, error) {
                    console.error('AJAX Error Details:');
                    console.error('Status:', status);
                    console.error('Error:', error);
                    console.error('Response Text:', xhr.responseText);
                    console.error('Status Code:', xhr.status);
                    
                    // Try to parse response as JSON in case it's a valid JSON with error status
                    try {
                        var response = JSON.parse(xhr.responseText);
                        if (response.status === 'success') {
                            // Success hidden in error response
                            showNotification('success', 'Appointment cancelled successfully!');
                            setTimeout(function() {
                                window.location.reload();
                            }, 1000);
                            return;
                        } else if (response.message) {
                            showNotification('error', response.message);
                        } else {
                            showNotification('error', 'Failed to cancel appointment. Please try again.');
                        }
                    } catch (parseError) {
                        // If response is not JSON, check if cancellation might have worked
                        if (xhr.status === 200 && xhr.responseText.includes('success')) {
                            showNotification('success', 'Appointment cancelled successfully!');
                            setTimeout(function() {
                                window.location.reload();
                            }, 1000);
                        } else {
                            showNotification('error', 'Failed to cancel appointment. Please refresh the page to check status.');
                        }
                    }
                    
                    // Re-enable button
                    $button.prop('disabled', false);
                    $button.html('<i class="fa fa-times"></i> Cancel');
                }
            });
        });
    });
    
    // Helper function to show notifications
    function showNotification(type, message) {
        const alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
        const icon = type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle';
        
        const notification = `
            <div class="alert ${alertClass} alert-dismissible fade show notification-alert" role="alert" style="position: fixed; top: 20px; right: 20px; z-index: 9999; min-width: 300px;">
                <i class="fas ${icon} mr-2"></i>
                ${message}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        `;
        
        $('body').append(notification);
        
        // Auto-dismiss after 5 seconds
        setTimeout(function() {
            $('.notification-alert').fadeOut();
        }, 5000);
    }
</script>