<!--sidebar end-->
<!--main content start-->

<style>
    .select2-container--default .select2-selection--single {
        width: 248px !important;
    }
</style>





<div class="content-wrapper bg-gradient-light" style="min-height: 2726.9px;">
    <section class="content-header py-4 bg-white shadow-sm">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h1 class="display-4 font-weight-black mb-0">
                        <i class="fas fa-calendar-check text-primary mr-3"></i>
                        <?php echo lang('appointment'); ?>
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb bg-transparent mb-0">
                            <li class="breadcrumb-item"><a href="home"><?php echo lang('home'); ?></a></li> 
                            <li class="breadcrumb-item active"><?php echo lang('appointment'); ?></li>
                        </ol>
                    </nav>
                </div>
                <div class="col-sm-6 text-right">
                    <?php if ($this->ion_auth->in_group(array('Doctor')) && isset($hospitals)) { ?>
                        <select class="form-control form-control-sm d-inline-block mb-2 mr-2" id="doctor_hospital_select" name="hospital_id" 
                                style="width: 250px; border: 2px solid #007bff;">
                            <option value="consolidated" <?php echo ($selected_hospital === 'consolidated') ? 'selected' : ''; ?>>
                                📊 All Hospitals Data
                            </option>
                            <?php foreach ($hospitals as $hospital) { ?>
                                <option value="<?php echo $hospital->id; ?>"  
                                        <?php echo ($selected_hospital == $hospital->id) ? 'selected' : ''; ?>>
                                    🏥 <?php echo $hospital->name; ?>
                                </option>
                            <?php } ?>
                        </select>
                    <?php } ?>
                    <a data-toggle="modal" href="#myModal" class="btn btn-primary btn-sm px-4 py-3">
                        <i class="fa fa-plus"></i> <?php echo lang('add_appointment'); ?>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <section class="content py-5">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card shadow-lg border-0">
                        <div class="card-header bg-white py-4">
                            <h3 class="card-title font-weight-bold"><?php echo lang('List of All Appointments'); ?></h3>
                        </div>

                        <div class="card-body bg-light p-4">
                            <ul class="nav nav-tabs mb-4">
                                <li class="nav-item">
                                    <a class="nav-link active" data-toggle="tab" href="#all"><?php echo lang('all'); ?></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" data-toggle="tab" href="#pending"><?php echo lang('pending_confirmation'); ?></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" data-toggle="tab" href="#confirmed"><?php echo lang('confirmed'); ?></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" data-toggle="tab" href="#treated"><?php echo lang('treated'); ?></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" data-toggle="tab" href="#cancelled"><?php echo lang('cancelled'); ?></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" data-toggle="tab" href="#requested"><?php echo lang('requested'); ?></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" data-toggle="tab" href="#guest_pending">
                                        <i class="fas fa-user-clock mr-2"></i>Guest Appointments
                                        <span class="badge badge-warning ml-1" id="guest_count">0</span>
                                    </a>
                                </li>
                            </ul>

                            <div class="tab-content">
                                <div id="all" class="tab-pane active">
                                    <table class="table table-bordered" id="editable-sample5" width="100%">
                                        <thead>
                                            <tr class="bg-light">
                                                <th class="font-weight-bold"><?php echo lang('id'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('patient'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('doctor'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('date-time'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('remarks'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('status'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('description'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('invoice_id'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('amount'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('bill'); ?> <?php echo lang('status'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('options'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>

                                <div id="pending" class="tab-pane">
                                    <table class="table table-bordered" id="editable-sample1" width="100%">
                                        <thead>
                                            <tr class="bg-light">
                                                <th class="font-weight-bold"><?php echo lang('id'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('patient'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('doctor'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('date-time'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('remarks'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('status'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('description'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('invoice_id'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('amount'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('bill'); ?> <?php echo lang('status'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('options'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>

                                <div id="confirmed" class="tab-pane">
                                    <table class="table table-bordered" id="editable-sample2" width="100%">
                                        <thead>
                                            <tr class="bg-light">
                                                <th class="font-weight-bold"><?php echo lang('id'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('patient'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('doctor'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('date-time'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('remarks'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('status'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('description'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('invoice_id'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('amount'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('bill'); ?> <?php echo lang('status'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('options'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>

                                <div id="treated" class="tab-pane">
                                    <table class="table table-bordered" id="editable-sample3" width="100%">
                                        <thead>
                                            <tr class="bg-light">
                                                <th class="font-weight-bold"><?php echo lang('id'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('patient'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('doctor'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('date-time'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('remarks'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('status'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('description'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('invoice_id'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('amount'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('bill'); ?> <?php echo lang('status'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('options'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>

                                <div id="cancelled" class="tab-pane">
                                    <table class="table table-bordered" id="editable-sample4" width="100%">
                                        <thead>
                                            <tr class="bg-light">
                                                <th class="font-weight-bold"><?php echo lang('id'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('patient'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('doctor'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('date-time'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('remarks'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('status'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('description'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('invoice_id'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('amount'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('bill'); ?> <?php echo lang('status'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('options'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>

                                <div id="requested" class="tab-pane">
                                    <table class="table table-bordered" id="editable-sample6" width="100%">
                                        <thead>
                                            <tr class="bg-light">
                                                <th class="font-weight-bold"><?php echo lang('id'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('patient'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('doctor'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('date-time'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('remarks'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('status'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('description'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('invoice_id'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('amount'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('bill'); ?> <?php echo lang('status'); ?></th>
                                                <th class="font-weight-bold"><?php echo lang('options'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>

                                <!-- Guest Appointments Tab -->
                                <div id="guest_pending" class="tab-pane">
                                    <div class="alert alert-info border-left-primary">
                                        <div class="d-flex align-items-center">
                                            <i class="fas fa-info-circle fa-2x text-primary mr-3"></i>
                                            <div>
                                                <h6 class="font-weight-bold mb-1">Guest Appointments</h6>
                                                <p class="mb-0">These are appointments booked by guests who haven't registered as patients yet. You can register them as patients by clicking the "Register Patient" button.</p>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <table class="table table-bordered" id="editable-sample-guest" width="100%">
                                        <thead>
                                            <tr class="bg-warning">
                                                <th class="font-weight-bold text-dark"><?php echo lang('id'); ?></th>
                                                <th class="font-weight-bold text-dark">Guest Name</th>
                                                <th class="font-weight-bold text-dark">Phone</th>
                                                <th class="font-weight-bold text-dark">Age/Gender</th>
                                                <th class="font-weight-bold text-dark"><?php echo lang('doctor'); ?></th>
                                                <th class="font-weight-bold text-dark"><?php echo lang('date-time'); ?></th>
                                                <th class="font-weight-bold text-dark">Problem/Remarks</th>
                                                <th class="font-weight-bold text-dark"><?php echo lang('status'); ?></th>
                                                <th class="font-weight-bold text-dark">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>










<!--main content end-->
<!--footer start-->




<!-- Add Appointment Modal-->
<div class="modal fade" id="myModal" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title font-weight-bold"> <?php echo lang('add_appointment'); ?></h4>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            <div class="modal-body row">
                <form role="form" action="appointment/addNew" id="addAppointmentForm" method="post" class="clearfix" enctype="multipart/form-data">

                    <div class="form-row">
                        <div class="col-md-6 patient_div">
                            <label for="exampleInputEmail1"> <?php echo lang('patient'); ?> &#42;</label>
                            <select class="form-control form-control-lg col-sm-8 m-bot15 pos_select" id="pos_select" name="patient" value='' required>
                            </select>
                        </div>
                        <input type="hidden" name="redirectlink" value="10">
                        <div class="pos_client clearfix col-md-12 row">
                            <div class="payment pad_bot float-right patient_div col-md-6 mt-3">
                                <label for="exampleInputEmail1"> <?php echo lang('patient'); ?> <?php echo lang('name'); ?></label>
                                <input type="text" class="form-control form-control-lg col-sm-8 pay_in" name="p_name" value='' placeholder="">
                            </div>
                            <div class="payment pad_bot float-right col-md-6 mt-3">
                                <label for="exampleInputEmail1"> <?php echo lang('patient'); ?> <?php echo lang('email'); ?></label>
                                <input type="text" class="form-control form-control-lg col-sm-8 pay_in" name="p_email" value='' placeholder="">
                            </div>
                            <div class="payment pad_bot float-right col-md-6 mt-3">
                                <label for="exampleInputEmail1"> <?php echo lang('patient'); ?> <?php echo lang('phone'); ?></label>
                                <input type="text" class="form-control form-control-lg col-sm-8 pay_in" name="p_phone" value='' placeholder="">
                            </div>
                            <div class="payment pad_bot float-right col-md-6 mt-3">
                                <label for="exampleInputEmail1"> <?php echo lang('patient'); ?> <?php echo lang('age'); ?></label>
                                <input type="text" class="form-control form-control-lg col-sm-8 pay_in" name="p_age" value='' placeholder="">
                            </div>
                            <div class="payment pad_bot col-md-6 mt-3">
                                <label for="exampleInputEmail1"> <?php echo lang('patient'); ?> <?php echo lang('gender'); ?></label>
                                <select class="form-control form-control-lg" name="p_gender" value=''>
                                    <option value="Male"> <?php echo lang('male'); ?> </option>
                                    <option value="Female"> <?php echo lang('female'); ?> </option>
                                </select>
                            </div>
                        </div>

                        <?php if ($this->ion_auth->in_group(array('Doctor')) && isset($hospitals)) { ?>
                        <div class="col-md-6 mt-3">
                            <label for="appointment_hospital_id"> 
                                <i class="fas fa-hospital mr-2"></i><?php echo lang('hospital'); ?> &#42;
                            </label>
                            <select class="form-control form-control-lg" id="appointment_hospital_id" name="appointment_hospital_id" required>
                                <?php foreach ($hospitals as $hospital) { ?>
                                    <option value="<?php echo $hospital->id; ?>" 
                                            <?php echo ($selected_hospital == $hospital->id) ? 'selected' : ''; ?>>
                                        🏥 <?php echo $hospital->name; ?>
                                    </option>
                                <?php } ?>
                            </select>
                        </div>
                        <?php } ?>

                        <div class="col-md-6 doctor_div">
                            <label for="exampleInputEmail1"> <?php echo lang('doctor'); ?> &#42;</label>
                            <select class="form-control form-control-lg col-sm-8 m-bot15" id="adoctors" name="doctor" value='' required>
                            </select>
                        </div>

                        <div class="col-md-6 mt-3">
                            <label for="exampleInputEmail1"> <?php echo lang('date'); ?> &#42;</label>
                            <input type="text" class="form-control form-control-lg col-sm-8 default-date-picker" autocomplete="off" id="date" onkeypress="return false;" name="date" id="exampleInputEmail1" value='' placeholder="" required>
                        </div>
                        <div class="col-md-6 aslots mt-3">
                            <label for="exampleInputEmail1"><?php echo lang('available_slots'); ?> </label>
                            <select class="form-control form-control-lg col-sm-8 m-bot15" name="time_slot" id="aslots" value=''>
                            </select>
                        </div>
                        <div class="col-md-6 mt-3">
                            <label for="exampleInputEmail1"> <?php echo lang(''); ?> <?php echo lang('status'); ?></label>
                            <select class="form-control form-control-lg col-sm-8 m-bot15" name="status" value=''>
                                <option value="Pending Confirmation"> <?php echo lang('pending_confirmation'); ?> </option>
                                <option value="Confirmed"> <?php echo lang('confirmed'); ?> </option>
                                <option value="Treated"> <?php echo lang('treated'); ?> </option>
                                <option value="Cancelled"> <?php echo lang('cancelled'); ?> </option>
                            </select>
                        </div>

                        <div class="col-md-6 mt-3">
                            <label for="exampleInputEmail1"> <?php echo lang('remarks'); ?></label>
                            <input type="text" class="form-control form-control-lg" name="remarks" id="exampleInputEmail1" value='' placeholder="">
                        </div>
                        <div class="col-md-6 mt-3">
                            <label class="col-sm-4"><?php echo lang('visit'); ?> <?php echo lang('type'); ?> &#42;</label>
                            <select class="form-control form-control-lg col-sm-8 m-bot15" name="visit_description" id="visit_description" value='' required>
                            </select>
                        </div>
                        <div class="form-group col-md-6 form_data mt-3">
                            <label for="exampleInputEmail1"><?php echo lang(''); ?> <?php echo lang('charges'); ?></label>
                            <input type="number" class="form-control form-control-lg" name="visit_charges" id="visit_charges" value='' placeholder="" readonly="">
                        </div>
                        <div class="form-group col-md-6 form_data mt-3">
                            <label for="exampleInputEmail1"><?php echo lang('discount'); ?></label>
                            <input type="number" class="form-control form-control-lg" name="discount" id="discount" value='0' placeholder="">
                        </div>
                        <div class="form-group col-md-6 form_data mt-3">
                            <label for="exampleInputEmail1"><?php echo lang('grand_total'); ?></label>
                            <input type="number" class="form-control form-control-lg" name="grand_total" id="grand_total" value='0' placeholder="" readonly="">
                        </div>
                        <?php if (!$this->ion_auth->in_group(array('Nurse', 'Doctor'))) { ?>
                            <div class="col-md-6">
                                <label for="" class="col-sm-4"> <?php echo lang('pay_now'); ?></label>
                                <input type="checkbox" id="pay_now_appointment" name="pay_now_appointment" value="pay_now_appointment">
                                <br>
                                <br>
                                <?php if (!$this->ion_auth->in_group(array('Patient'))) { ?>
                                    <span class="info_message"><?php echo lang('if_pay_now_checked_please_select_status_to_confirmed') ?></span>
                                <?php } ?>
                            </div>

                            <div class="payment_label col-md-6 d-none deposit_type">
                                <label for="exampleInputEmail1"><?php echo lang('deposit_type'); ?></label>
                                <div class="">
                                    <select class="form-control form-control-lg col-sm-8 m-bot15 js-example-basic-single selecttype" id="selecttype" name="deposit_type" value=''>
                                        <?php if ($this->ion_auth->in_group(array('admin', 'Accountant', 'Receptionist'))) { ?>
                                            <option value="Cash"> <?php echo lang('cash'); ?> </option>
                                            <option value="Card"> <?php echo lang('card'); ?> </option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <?php
                                $payment_gateway = $settings->payment_gateway;
                                ?>

                                <div class="cardPayment">
                                    <hr>
                                    <?php if ($payment_gateway != 'Paymob') { ?>
                                        <div class="col-md-12 payment pad_bot">
                                            <label for="exampleInputEmail1"> <?php echo lang('accepted'); ?> <?php echo lang('cards'); ?></label>
                                            <div class="payment pad_bot">
                                                <img src="uploads/card.png" width="100%">
                                            </div>
                                        </div>
                                    <?php } ?>

                                    <?php if ($payment_gateway == 'PayPal') { ?>
                                        <div class="col-md-12 payment pad_bot my-3">
                                            <label for="exampleInputEmail1"> <?php echo lang('card'); ?> <?php echo lang('type'); ?></label>
                                            <select class="form-control form-control-lg col-sm-8 m-bot15" name="card_type" value=''>
                                                <option value="Mastercard"> <?php echo lang('mastercard'); ?> </option>
                                                <option value="Visa"> <?php echo lang('visa'); ?> </option>
                                                <option value="American Express"> <?php echo lang('american_express'); ?> </option>
                                            </select>
                                        </div>
                                    <?php } ?>

                                    <?php if ($payment_gateway == '2Checkout' || $payment_gateway == 'PayPal') { ?>
                                        <div class="col-md-12 payment pad_bot my-3">
                                            <label for="exampleInputEmail1"> <?php echo lang('cardholder'); ?> <?php echo lang('name'); ?></label>
                                            <input type="text" id="cardholder" class="form-control form-control-lg col-sm-8 pay_in" name="cardholder" value='' placeholder="">
                                        </div>
                                    <?php } ?>

                                    <?php if ($payment_gateway != 'Pay U Money' && $payment_gateway != 'Paystack' && $payment_gateway != 'SSLCOMMERZ' && $payment_gateway != 'Paytm') { ?>
                                        <div class="col-md-12 payment pad_bot my-3">
                                            <label for="exampleInputEmail1"> <?php echo lang('card'); ?> <?php echo lang('number'); ?></label>
                                            <input type="text" id="card" class="form-control form-control-lg col-sm-8 pay_in" name="card_number" value='' placeholder="">
                                        </div>

                                        <div class="col-md-12 payment pad_bot mt-3 my-3">
                                            <label for="exampleInputEmail1"> <?php echo lang('expire'); ?> <?php echo lang('date'); ?></label>
                                            <input type="text" class="form-control form-control-lg col-sm-8 pay_in" id="expire" data-date="" data-date-format="MM YY" placeholder="Expiry (MM/YY)" name="expire_date" maxlength="7" aria-describedby="basic-addon1" value='' placeholder="">
                                        </div>
                                        <div class="col-md-12 payment pad_bot mt-3 my-3">
                                            <label for="exampleInputEmail1"> <?php echo lang('cvv'); ?> </label>
                                            <input type="text" class="form-control form-control-lg col-sm-8 pay_in" id="cvv" maxlength="3" name="cvv" value='' placeholder="">
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                            <div class="btn-block">
                                <div class="">
                                    <?php $twocheckout = $this->db->get_where('paymentGateway', array('name =' => '2Checkout'))->row(); ?>
                                    <div class="form-group cashsubmit payment btn-block">
                                        <button type="submit" name="submit2" id="submit1" class="btn btn-primary btn-block float-right"> <?php echo lang('submit'); ?></button>
                                    </div>
                                    <?php $twocheckout = $this->db->get_where('paymentGateway', array('name =' => '2Checkout'))->row(); ?>
                                    <div class="form-group cardsubmit btn-block d-none">
                                        <button type="submit" name="pay_now" id="submit-btn" class="btn btn-primary btn-block float-right" <?php if ($settings->payment_gateway == 'Stripe') { ?>onClick="stripePay(event);" <?php } ?> <?php if ($settings->payment_gateway == '2Checkout' && $twocheckout->status == 'live') { ?>onClick="twoCheckoutPay(event);" <?php } ?>> <?php echo lang('submit'); ?></button>
                                    </div>
                                </div>
                            </div>
                        <?php } else { ?>
                            <div class="form-group payment btn-block">
                                <button type="submit" name="submit2" id="submit1" class="btn btn-primary btn-block float-right mr-0"> <?php echo lang('submit'); ?></button>
                            </div>
                        <?php } ?>
                    </div>
                </form>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>
<!-- Add Appointment Modal-->

<!-- Edit Event Modal-->
<div class="modal fade" id="myModal2" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title font-weight-bold"> <?php echo lang('edit_appointment'); ?></h4>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            <div class="modal-body row">
                <form role="form" id="editAppointmentForm" action="appointment/addNew" class="clearfix" method="post" enctype="multipart/form-data">
                    <div class="form-row">
                        <div class="col-md-6 patient_div">
                            <label for="exampleInputEmail1"> <?php echo lang('patient'); ?> &#42;</label>
                            <select class="form-control form-control-lg col-sm-8 m-bot15  pos_select1 patient" id="pos_select1" name="patient" value='' required>
                            </select>
                        </div>
                        <div class="pos_client1 clearfix col-md-12 row">
                            <div class="payment pad_bot float-right col-md-6">
                                <label for="exampleInputEmail1"> <?php echo lang('patient'); ?> <?php echo lang('name'); ?></label>
                                <input type="text" class="form-control form-control-lg col-sm-8 pay_in" name="p_name" value='' placeholder="">
                            </div>
                            <div class="payment pad_bot float-right col-md-6">
                                <label for="exampleInputEmail1"> <?php echo lang('patient'); ?> <?php echo lang('email'); ?></label>
                                <input type="text" class="form-control form-control-lg col-sm-8 pay_in" name="p_email" value='' placeholder="">
                            </div>
                            <div class="payment pad_bot float-right col-md-6">
                                <label for="exampleInputEmail1"> <?php echo lang('patient'); ?> <?php echo lang('phone'); ?></label>
                                <input type="text" class="form-control form-control-lg col-sm-8 pay_in" name="p_phone" value='' placeholder="">
                            </div>
                            <div class="payment pad_bot float-right col-md-6">
                                <label for="exampleInputEmail1"> <?php echo lang('patient'); ?> <?php echo lang('age'); ?></label>
                                <input type="text" class="form-control form-control-lg col-sm-8 pay_in" name="p_age" value='' placeholder="">
                            </div>
                            <div class="payment pad_bot col-md-6">
                                <label for="exampleInputEmail1"> <?php echo lang('patient'); ?> <?php echo lang('gender'); ?></label>
                                <select class="form-control form-control-lg" name="p_gender" value=''>
                                    <option value="Male"> <?php echo lang('male'); ?> </option>
                                    <option value="Female"> <?php echo lang('female'); ?> </option>
                                </select>
                            </div>
                        </div>

                        <?php if ($this->ion_auth->in_group(array('Doctor')) && isset($hospitals)) { ?>
                        <div class="col-md-6 mt-3">
                            <label for="edit_appointment_hospital_id"> 
                                <i class="fas fa-hospital mr-2"></i><?php echo lang('hospital'); ?> &#42;
                            </label>
                            <select class="form-control form-control-lg" id="edit_appointment_hospital_id" name="appointment_hospital_id" required>
                                <?php foreach ($hospitals as $hospital) { ?>
                                    <option value="<?php echo $hospital->id; ?>" 
                                            <?php echo ($selected_hospital == $hospital->id) ? 'selected' : ''; ?>>
                                        🏥 <?php echo $hospital->name; ?>
                                    </option>
                                <?php } ?>
                            </select>
                        </div>
                        <?php } ?>

                        <div class="col-md-6 doctor_div1">
                            <label for="exampleInputEmail1"> <?php echo lang('doctor'); ?> &#42;</label>
                            <select class="form-control form-control-lg col-sm-8 m-bot15 doctor" id="adoctors1" name="doctor" value='' required>
                            </select>
                        </div>
                        <input type="hidden" name="redirectlink" value="10">
                        <div class="col-md-6 mt-3">
                            <label for="exampleInputEmail1"> <?php echo lang('date'); ?> &#42;</label>
                            <input type="text" class="form-control form-control-lg col-sm-8 default-date-picker" autocomplete="off" id="date1" required="" onkeypress="return false;" name="date" id="exampleInputEmail1" value='' placeholder="">
                        </div>
                        <div class="col-md-6 mt-3">
                            <label for="exampleInputEmail1">Available Slots</label>
                            <select class="form-control form-control-lg col-sm-8 m-bot15" name="time_slot" id="aslots1" value=''>
                            </select>
                        </div>
                        <div class="col-md-6 mt-3">
                            <label for="exampleInputEmail1"> <?php echo lang(''); ?> <?php echo lang('status'); ?></label>
                            <select class="form-control form-control-lg col-sm-8 m-bot15" name="status" value=''>
                                <option value="Pending Confirmation"> <?php echo lang('pending_confirmation'); ?> </option>
                                <option value="Confirmed"> <?php echo lang('confirmed'); ?> </option>
                                <option value="Treated"> <?php echo lang('treated'); ?> </option>
                                <option value="Cancelled"> <?php echo lang('cancelled'); ?> </option>
                            </select>
                        </div>

                        <div class="col-md-6 mt-3">
                            <label for="exampleInputEmail1"> <?php echo lang('remarks'); ?></label>
                            <input type="text" class="form-control form-control-lg" name="remarks" id="exampleInputEmail1" value='' placeholder="">
                        </div>
                        <div class="col-md-6 mt-3">
                            <label class="col-sm-4"><?php echo lang('visit'); ?> <?php echo lang('type'); ?> &#42;</label>
                            <select class="form-control form-control-lg col-sm-8 m-bot15" name="visit_description" id="visit_description1" value='' required>
                            </select>
                        </div>

                        <input type="hidden" name="id" id="appointment_id" value=''>
                        <div class="form-group col-md-6 d-none consultant_fee_div mt-3">
                            <label for="exampleInputEmail1"><?php echo lang(''); ?> <?php echo lang('charges'); ?></label>
                            <input type="number" class="form-control form-control-lg" name="visit_charges" id="visit_charges1" value='' placeholder="" readonly="">
                        </div>
                        <div class="form-group col-md-6 d-none consultant_fee_div mt-3">
                            <label for="exampleInputEmail1"><?php echo lang('discount'); ?></label>
                            <input type="number" class="form-control form-control-lg" name="discount" id="discount1" value='0' placeholder="">
                        </div>
                        <div class="form-group col-md-6 d-none consultant_fee_div mt-3">
                            <label for="exampleInputEmail1"><?php echo lang('grand_total'); ?></label>
                            <input type="number" class="form-control form-control-lg" name="grand_total" id="grand_total1" value='0' placeholder="" readonly="">
                        </div>
                        <?php if (!$this->ion_auth->in_group(array('Nurse', 'Doctor'))) { ?>
                            <div class="col-md-6 d-none pay_now">
                                <label for="" class="col-sm-4"> <?php echo lang('pay_now'); ?></label>
                                <input type="checkbox" id="pay_now_appointment1" name="pay_now_appointment" value="pay_now_appointment">
                                <br>
                                <br>
                                <span class="info_message"><?php echo lang('if_pay_now_checked_please_select_status_to_confirmed') ?></span>
                            </div>
                            <div class="col-md-12 d-none payment_status form-group mt-3">
                                <label for="" class="col-sm-4"> <?php echo lang('payment'); ?> <?php echo lang('status'); ?></label><br>
                                <input type="text" class="form-control form-control-lg" id="pay_now_appointment" name="payment_status_appointment" value="paid" readonly="">
                            </div>
                            <div class="payment_label col-md-12 d-none deposit_type1">
                                <label for="exampleInputEmail1"><?php echo lang('deposit_type'); ?></label>
                                <div class="col-sm-8">
                                    <select class="form-control form-control-lg m-bot15 js-example-basic-single selecttype1" id="selecttype1" name="deposit_type" value=''>
                                        <?php if ($this->ion_auth->in_group(array('admin', 'Accountant', 'Receptionist'))) { ?>
                                            <option value="Cash"> <?php echo lang('cash'); ?> </option>
                                            <option value="Card"> <?php echo lang('card'); ?> </option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <?php
                                $payment_gateway = $settings->payment_gateway;
                                ?>

                                <div class="card1">
                                    <hr>
                                    <?php if ($payment_gateway != 'Paymob') { ?>
                                        <div class="col-md-12 payment pad_bot">
                                            <label for="exampleInputEmail1"> <?php echo lang('accepted'); ?> <?php echo lang('cards'); ?></label>
                                            <div class="payment pad_bot">
                                                <img src="uploads/card.png" width="100%">
                                            </div>
                                        </div>
                                    <?php } ?>
                                    <?php if ($payment_gateway == 'PayPal') { ?>
                                        <div class="col-md-12 payment pad_bot">
                                            <label for="exampleInputEmail1"> <?php echo lang('card'); ?> <?php echo lang('type'); ?></label>
                                            <select class="form-control form-control-lg col-sm-8 m-bot15" name="card_type" value=''>
                                                <option value="Mastercard"> <?php echo lang('mastercard'); ?> </option>
                                                <option value="Visa"> <?php echo lang('visa'); ?> </option>
                                                <option value="American Express"> <?php echo lang('american_express'); ?> </option>
                                            </select>
                                        </div>
                                    <?php } ?>
                                    <?php if ($payment_gateway == '2Checkout' || $payment_gateway == 'PayPal') { ?>
                                        <div class="col-md-12 payment pad_bot">
                                            <label for="exampleInputEmail1"> <?php echo lang('cardholder'); ?> <?php echo lang('name'); ?></label>
                                            <input type="text" id="cardholder1" class="form-control form-control-lg col-sm-8 pay_in" name="cardholder" value='' placeholder="">
                                        </div>
                                    <?php } ?>
                                    <?php if ($payment_gateway != 'Pay U Money' && $payment_gateway != 'Paystack' && $payment_gateway != 'SSLCOMMERZ' && $payment_gateway != 'Paytm') { ?>
                                        <div class="col-md-12 payment pad_bot">
                                            <label for="exampleInputEmail1"> <?php echo lang('card'); ?> <?php echo lang('number'); ?></label>
                                            <input type="text" id="card1" class="form-control form-control-lg col-sm-8 pay_in" name="card_number" value='' placeholder="">
                                        </div>

                                        <div class="col-md-8 payment pad_bot">
                                            <label for="exampleInputEmail1"> <?php echo lang('expire'); ?> <?php echo lang('date'); ?></label>
                                            <input type="text" class="form-control form-control-lg col-sm-8 pay_in" id="expire1" data-date="" data-date-format="MM YY" placeholder="Expiry (MM/YY)" name="expire_date" maxlength="7" aria-describedby="basic-addon1" value='' placeholder="" readonly>
                                        </div>
                                        <div class="col-md-4 payment pad_bot">
                                            <label for="exampleInputEmail1"> <?php echo lang('cvv'); ?> </label>
                                            <input type="text" class="form-control form-control-lg col-sm-8 pay_in" id="cvv1" maxlength="3" name="cvv" value='' placeholder="">
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                            <div class="btn-block">
                                <div class="">
                                    <?php $twocheckout = $this->db->get_where('paymentGateway', array('name =' => '2Checkout'))->row(); ?>
                                    <div class="form-group cashsubmit1 payment btn-block">
                                        <button type="submit" name="submit2" id="submit1" class="btn btn-primary btn-block float-right"> <?php echo lang('submit'); ?></button>
                                    </div>
                                    <?php $twocheckout = $this->db->get_where('paymentGateway', array('name =' => '2Checkout'))->row(); ?>
                                    <div class="form-group cardsubmit1  btn-block d-none">
                                        <button type="submit" name="pay_now" id="submit-btn1" class="btn btn-primary btn-block float-right" <?php if ($settings->payment_gateway == 'Stripe') { ?>onClick="stripePay1(event);" <?php } ?> <?php if ($settings->payment_gateway == '2Checkout' && $twocheckout->status == 'live') { ?>onClick="twoCheckoutPay1(event);" <?php } ?>> <?php echo lang('submit'); ?></button>
                                    </div>
                                </div>
                            </div>
                        <?php } else { ?>
                            <div class="form-group paymentbtn-block">
                                <button type="submit" name="submit2" id="submit1" class="btn btn-primary btn-block float-right mr-0"> <?php echo lang('submit'); ?></button>
                            </div>
                        <?php } ?>
                    </div>
                </form>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>
<!-- Edit Event Modal-->

















<div class="modal fade" role="dialog" id="cmodal">
    <div class="modal-dialog modal-xl med_his" role="document">
        <div class="modal-content">

            <div id='medical_history' class="row">
                <div class="col-md-12">

                </div>
            </div>
            <div class="modal-footer">
                <div class="col-md-12">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
</div>





<?php if (!empty($gateway->publish)) {
    $gateway_stripe = $gateway->publish;
} else {
    $gateway_stripe = '';
} ?>



<script src="common/js/codearistos.min.js"></script>
<script src="common/js/moment.min.js"></script>
<script type="text/javascript" src="https://js.stripe.com/v2/"></script>
<!-- <script type="text/javascript" src="https://www.2checkout.com/checkout/api/2co.min.js"></script> -->
<script type="text/javascript">
    var publish = "<?php echo $gateway_stripe; ?>";
</script>
<script type="text/javascript">
    var payment_gateway = "<?php echo $settings->payment_gateway; ?>";
</script>

<?php if ($this->ion_auth->in_group(array('Doctor')) && isset($hospitals)) { ?>
<script>
$(document).ready(function() {
    // Doctor hospital selection dropdown change handler
    $('#doctor_hospital_select').change(function() {
        const selectedHospital = $(this).val();
        
        // Build URL with hospital parameter
        let url = '<?php echo base_url(); ?>appointment'; 
        if (selectedHospital) {
            url += '?hospital_id=' + selectedHospital;
        }
        
        // Show loading feedback
        $(this).next('.loading-feedback').remove();
        $(this).after('<div class="loading-feedback ml-2"><i class="fas fa-spinner fa-spin mr-2"></i>Loading hospital data...</div>');
        
        // Redirect to reload page with selected hospital
        window.location.href = url;
    });
});
</script>
<?php } ?>

<script type="text/javascript">
    var select_doctor = "<?php echo lang('select_doctor'); ?>";
</script>
<script type="text/javascript">
    var select_patient = "<?php echo lang('select_patient'); ?>";
</script>
<script type="text/javascript">
    var language = "<?php echo $this->language; ?>";
</script>
<script type="text/javascript">
    var no_available_timeslots = "<?php echo lang('no_available_timeslots'); ?>";
</script>

<script src="common/extranal/js/appointment/appointment.js"></script>
<script src="common/extranal/js/appointment/appointment_select2.js"></script>

<!-- Guest Patient Registration Modal -->
<div class="modal fade" id="guestRegistrationModal" tabindex="-1" role="dialog" aria-labelledby="guestRegistrationModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-warning text-dark">
                <h5 class="modal-title font-weight-bold" id="guestRegistrationModalLabel">
                    <i class="fas fa-user-plus mr-2"></i>Register Guest as Patient
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="guestRegistrationForm">
                    <input type="hidden" id="guest_appointment_id" name="appointment_id">
                    
                    <!-- Guest Information Display -->
                    <div class="card bg-light mb-4">
                        <div class="card-header">
                            <h6 class="card-title mb-0"><i class="fas fa-user-clock mr-2"></i>Guest Information</h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <p><strong>Name:</strong> <span id="display_guest_name"></span></p>
                                    <p><strong>Phone:</strong> <span id="display_guest_phone"></span></p>
                                    <p><strong>Age:</strong> <span id="display_guest_age"></span></p>
                                </div>
                                <div class="col-md-6">
                                    <p><strong>Gender:</strong> <span id="display_guest_gender"></span></p>
                                    <p><strong>Email:</strong> <span id="display_guest_email"></span></p>
                                    <p><strong>Emergency Contact:</strong> <span id="display_guest_emergency"></span></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Patient Registration Form -->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="font-weight-bold">Patient Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="patient_name" name="patient_name" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="font-weight-bold">Phone Number <span class="text-danger">*</span></label>
                                <input type="tel" class="form-control" id="patient_phone" name="patient_phone" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="font-weight-bold">Email Address</label>
                                <input type="email" class="form-control" id="patient_email" name="patient_email">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="font-weight-bold">Date of Birth</label>
                                <input type="date" class="form-control" id="patient_dob" name="patient_dob">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="font-weight-bold">Gender <span class="text-danger">*</span></label>
                                <select class="form-control" id="patient_gender" name="patient_gender" required>
                                    <option value="">Select Gender</option>
                                    <option value="Male">Male</option>
                                    <option value="Female">Female</option>
                                    <option value="Other">Other</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="font-weight-bold">Blood Group</label>
                                <select class="form-control" id="patient_blood_group" name="patient_blood_group">
                                    <option value="">Select Blood Group</option>
                                    <option value="A+">A+</option>
                                    <option value="A-">A-</option>
                                    <option value="B+">B+</option>
                                    <option value="B-">B-</option>
                                    <option value="AB+">AB+</option>
                                    <option value="AB-">AB-</option>
                                    <option value="O+">O+</option>
                                    <option value="O-">O-</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label class="font-weight-bold">Address</label>
                                <textarea class="form-control" id="patient_address" name="patient_address" rows="3"></textarea>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="font-weight-bold">Emergency Contact</label>
                                <input type="tel" class="form-control" id="patient_emergency_contact" name="patient_emergency_contact">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="font-weight-bold">SMS Language</label>
                                <select class="form-control" id="patient_sms_language" name="patient_sms_language">
                                    <option value="english">English</option>
                                    <option value="sinhala">Sinhala</option>
                                    <option value="tamil">Tamil</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="fas fa-times mr-2"></i>Cancel
                </button>
                <button type="button" class="btn btn-warning" onclick="registerGuestAsPatient()">
                    <i class="fas fa-user-plus mr-2"></i>Register Patient & Confirm Appointment
                </button>
            </div>
        </div>
    </div>
</div>

<script>
let guestAppointmentTable;

$(document).ready(function() {
    // Initialize guest appointments table when tab is shown
    $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
        if ($(e.target).attr('href') === '#guest_pending') {
            if (!guestAppointmentTable) {
                initializeGuestAppointmentTable();
            }
        }
    });
    
    // Load guest appointments count on page load
    loadGuestAppointmentsCount();
});

function initializeGuestAppointmentTable() {
    guestAppointmentTable = $('#editable-sample-guest').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "<?php echo base_url('appointment/getGuestAppointmentsByFilter'); ?>",
            "type": "POST",
            "data": function(d) {
                d.status = 'Guest Pending';
            }
        },
        "columns": [
            { "data": "id" },
            { "data": "guest_name" },
            { "data": "guest_phone" },
            { 
                "data": null,
                "render": function(data) {
                    return data.guest_age + ' / ' + data.guest_gender;
                }
            },
            { "data": "doctor_name" },
            { 
                "data": null,
                "render": function(data) {
                    const date = new Date(data.date * 1000);
                    return date.toLocaleDateString() + ' ' + data.time;
                }
            },
            { 
                "data": "remarks",
                "render": function(data) {
                    return data ? (data.length > 50 ? data.substring(0, 50) + '...' : data) : 'N/A';
                }
            },
            { 
                "data": "status",
                "render": function(data) {
                    return '<span class="badge badge-warning">' + data + '</span>';
                }
            },
            { 
                "data": null,
                "render": function(data) {
                    return `
                        <button class="btn btn-warning btn-sm" onclick="openGuestRegistrationModal(${data.id})" title="Register as Patient">
                            <i class="fas fa-user-plus"></i> Register
                        </button>
                        <button class="btn btn-info btn-sm ml-1" onclick="viewGuestDetails(${data.id})" title="View Details">
                            <i class="fas fa-eye"></i>
                        </button>
                        <button class="btn btn-danger btn-sm ml-1" onclick="cancelGuestAppointment(${data.id})" title="Cancel">
                            <i class="fas fa-times"></i>
                        </button>
                    `;
                }
            }
        ],
        "order": [[0, "desc"]],
        "pageLength": 25,
        "responsive": true
    });
}

function loadGuestAppointmentsCount() {
    $.ajax({
        url: '<?php echo base_url('appointment/getGuestAppointmentsCount'); ?>',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            $('#guest_count').text(response.count || 0);
        }
    });
}

function openGuestRegistrationModal(appointmentId) {
    // Get guest appointment details
    $.ajax({
        url: '<?php echo base_url('appointment/getGuestAppointmentById'); ?>',
        type: 'POST',
        data: { appointment_id: appointmentId },
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                const guest = response.appointment;
                
                // Fill guest information display
                $('#display_guest_name').text(guest.guest_name);
                $('#display_guest_phone').text(guest.guest_phone);
                $('#display_guest_age').text(guest.guest_age);
                $('#display_guest_gender').text(guest.guest_gender);
                $('#display_guest_email').text(guest.guest_email || 'N/A');
                $('#display_guest_emergency').text(guest.guest_emergency_contact || 'N/A');
                
                // Pre-fill patient registration form with guest data
                $('#guest_appointment_id').val(appointmentId);
                $('#patient_name').val(guest.guest_name);
                $('#patient_phone').val(guest.guest_phone);
                $('#patient_email').val(guest.guest_email);
                $('#patient_gender').val(guest.guest_gender);
                $('#patient_address').val(guest.guest_address);
                $('#patient_emergency_contact').val(guest.guest_emergency_contact);
                
                // Calculate approximate birth year from age
                if (guest.guest_age) {
                    const currentYear = new Date().getFullYear();
                    const birthYear = currentYear - guest.guest_age;
                    $('#patient_dob').val(birthYear + '-01-01');
                }
                
                $('#guestRegistrationModal').modal('show');
            } else {
                alert('Error loading guest details: ' + response.message);
            }
        },
        error: function() {
            alert('Error loading guest details');
        }
    });
}

function registerGuestAsPatient() {
    const formData = $('#guestRegistrationForm').serialize();
    
    if (!$('#patient_name').val() || !$('#patient_phone').val() || !$('#patient_gender').val()) {
        alert('Please fill in all required fields');
        return;
    }
    
    $.ajax({
        url: '<?php echo base_url('appointment/registerGuestAsPatient'); ?>',
        type: 'POST',
        data: formData,
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                alert('Guest successfully registered as patient and appointment confirmed!');
                $('#guestRegistrationModal').modal('hide');
                
                // Refresh the guest appointments table
                if (guestAppointmentTable) {
                    guestAppointmentTable.ajax.reload();
                }
                
                // Update guest count
                loadGuestAppointmentsCount();
                
                // Refresh main appointments table if it exists
                if (typeof table !== 'undefined' && table.ajax) {
                    table.ajax.reload();
                }
            } else {
                alert('Error: ' + response.message);
            }
        },
        error: function() {
            alert('Error registering patient');
        }
    });
}

function viewGuestDetails(appointmentId) {
    // Open guest appointment details in a new window or modal
    window.open('<?php echo base_url('frontend/guest_appointment_confirmation'); ?>/' + appointmentId, '_blank');
}

function cancelGuestAppointment(appointmentId) {
    if (confirm('Are you sure you want to cancel this guest appointment?')) {
        $.ajax({
            url: '<?php echo base_url('appointment/cancelGuestAppointment'); ?>',
            type: 'POST',
            data: { appointment_id: appointmentId },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    alert('Guest appointment cancelled successfully');
                    if (guestAppointmentTable) {
                        guestAppointmentTable.ajax.reload();
                    }
                    loadGuestAppointmentsCount();
                } else {
                    alert('Error: ' + response.message);
                }
            },
            error: function() {
                alert('Error cancelling appointment');
            }
        });
    }
}
</script>