<div class="content-wrapper bg-gradient-light" style="min-height: 2726.9px;">
    <section class="content-header py-4 bg-white shadow-sm">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h1 class="display-4 font-weight-black mb-0">
                        <i class="fas fa-clipboard-list text-primary mr-3"></i>
                        <?php echo lang('usage_logs') ?>
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb bg-transparent mb-0">
                            <li class="breadcrumb-item"><a href="home"><?php echo lang('home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="inventory"><?php echo lang('inventory'); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo lang('usage_logs'); ?></li>
                        </ol>
                    </nav>
                </div>
                <div class="col-sm-6 text-right">
                    <a data-toggle="modal" href="#addUsageModal" class="btn btn-success btn-sm px-4 py-3">
                        <i class="fa fa-plus-circle"></i> <?php echo lang('log_usage'); ?>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <section class="content py-5">
        <div class="container-fluid">
            <!-- Flash Messages -->
            <?php if ($this->session->flashdata('success')) { ?>
                <div class="alert alert-success alert-dismissible fade show">
                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                    <?php echo $this->session->flashdata('success'); ?>
                </div>
            <?php } ?>
            
            <?php if ($this->session->flashdata('error')) { ?>
                <div class="alert alert-danger alert-dismissible fade show">
                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                    <?php echo $this->session->flashdata('error'); ?>
                </div>
            <?php } ?>
            
            <?php if ($this->session->flashdata('warning')) { ?>
                <div class="alert alert-warning alert-dismissible fade show">
                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                    <?php echo $this->session->flashdata('warning'); ?>
                </div>
            <?php } ?>
            
            <div class="row justify-content-center">
                <div class="col-12">
                    <div class="card shadow-lg border-0">
                        <div class="card-header">
                            <h3 class="card-title text-black font-weight-800"><?php echo lang('all') . ' ' . lang('usage_logs'); ?></h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>

                        <div class="card-body bg-light">
                            <div class="table-responsive">
                                <table class="table table-hover" id="usageLogsTable">
                                    <thead>
                                        <tr class="bg-light">
                                            <th class="font-weight-bold text-uppercase"><?php echo lang('usage_date'); ?></th>
                                            <th class="font-weight-bold text-uppercase"><?php echo lang('item_name'); ?></th>
                                            <th class="font-weight-bold text-uppercase"><?php echo lang('quantity_used'); ?></th>
                                            <th class="font-weight-bold text-uppercase"><?php echo lang('used_by_type'); ?></th>
                                            <th class="font-weight-bold text-uppercase"><?php echo lang('purpose'); ?></th>
                                            <th class="font-weight-bold text-uppercase"><?php echo lang('total_cost'); ?></th>
                                            <th class="font-weight-bold text-uppercase"><?php echo lang('options'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if (!empty($usage_logs)) { ?>
                                            <?php foreach ($usage_logs as $usage) { ?>
                                                <tr>
                                                    <td><?php echo date('Y-m-d H:i', strtotime($usage->usage_date)); ?></td>
                                                    <td class="font-weight-bold">
                                                        <a href="inventory/usage/view/<?php echo $usage->id; ?>">
                                                            <?php echo $usage->item_name; ?>
                                                        </a>
                                                        <br>
                                                        <small class="text-muted"><?php echo $usage->item_code; ?></small>
                                                    </td>
                                                    <td>
                                                        <span class="badge badge-info">
                                                            <?php echo $usage->quantity_used . ' ' . $usage->unit_of_measure; ?>
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <span class="badge badge-<?php 
                                                            echo $usage->used_by_type == 'patient' ? 'primary' : 
                                                                 ($usage->used_by_type == 'doctor' ? 'success' : 
                                                                 ($usage->used_by_type == 'nurse' ? 'warning' : 'secondary')); 
                                                        ?>">
                                                            <?php echo ucfirst($usage->used_by_type); ?>
                                                        </span>
                                                    </td>
                                                    <td><?php echo $usage->purpose; ?></td>
                                                    <td><?php echo $settings->currency . ' ' . number_format($usage->total_cost, 2); ?></td>
                                                    <td>
                                                        <div class="btn-group">
                                                            <button type="button" class="btn btn-info btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                                <i class="fas fa-cog"></i>
                                                            </button>
                                                            <div class="dropdown-menu">
                                                                <a class="dropdown-item" href="inventory/usage/view/<?php echo $usage->id; ?>">
                                                                    <i class="fas fa-eye mr-2"></i>
                                                                    <?php echo lang('view'); ?>
                                                                </a>
                                                                <a class="dropdown-item" href="inventory/usage/edit/<?php echo $usage->id; ?>">
                                                                    <i class="fas fa-edit mr-2"></i>
                                                                    <?php echo lang('edit'); ?>
                                                                </a>
                                                                <div class="dropdown-divider"></div>
                                                                <a class="dropdown-item text-danger" href="inventory/usage/delete/<?php echo $usage->id; ?>" onclick="return confirm('Are you sure? This will return the used quantity to inventory.')">
                                                                    <i class="fas fa-trash mr-2"></i>
                                                                    <?php echo lang('delete'); ?>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        <?php } else { ?>
                                            <tr>
                                                <td colspan="7" class="text-center py-4">
                                                    <i class="fas fa-clipboard-list fa-3x text-muted mb-3"></i>
                                                    <h5 class="text-muted"><?php echo lang('no_data_available'); ?></h5>
                                                                                        <a data-toggle="modal" href="#addUsageModal" class="btn btn-primary">
                                        <i class="fas fa-plus mr-2"></i>
                                        <?php echo lang('log_usage'); ?>
                                    </a>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Add Usage Modal -->
<div class="modal fade" id="addUsageModal" role="dialog" aria-labelledby="addUsageModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title font-weight-bold" id="addUsageModalLabel"><?php echo lang('log_usage'); ?></h4>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            <div class="modal-body">
                <div class="card shadow-lg border-0">
                    <div class="card-body p-4">
                        <?php echo validation_errors('<div class="alert alert-danger">', '</div>'); ?>
                        
                        <form role="form" action="<?php echo base_url('inventory/add_usage'); ?>" method="post" id="addUsageForm">
                            <div class="row">
                                <!-- Item Information -->
                                <div class="col-md-6">
                                    <h6 class="mb-3"><i class="fas fa-box mr-2"></i><?php echo lang('item_information'); ?></h6>
                                    
                                    <div class="form-group">
                                        <label for="inventory_item_id"><?php echo lang('inventory_item'); ?> <span class="text-danger">*</span></label>
                                        <select class="form-control" name="inventory_item_id" id="inventory_item_id" required>
                                            <option value=""><?php echo lang('select') . ' ' . lang('item'); ?></option>
                                            <?php if (!empty($inventory_items)) { ?>
                                                <?php foreach ($inventory_items as $item) { ?>
                                                    <option value="<?php echo $item->id; ?>" data-stock="<?php echo $item->current_stock; ?>" data-cost="<?php echo $item->unit_cost; ?>">
                                                        <?php echo $item->name; ?> (<?php echo $item->item_code; ?>) - Stock: <?php echo $item->current_stock; ?>
                                                    </option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="quantity_used"><?php echo lang('quantity_used'); ?> <span class="text-danger">*</span></label>
                                        <input type="number" class="form-control" name="quantity_used" id="quantity_used" min="1" required>
                                        <small class="form-text text-muted">Available stock: <span id="available_stock">-</span></small>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="usage_date"><?php echo lang('usage_date'); ?> <span class="text-danger">*</span></label>
                                        <input type="datetime-local" class="form-control" name="usage_date" id="usage_date" 
                                               value="<?php echo date('Y-m-d\TH:i'); ?>" required>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="purpose"><?php echo lang('purpose'); ?> <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" name="purpose" id="purpose" required>
                                    </div>
                                </div>
                                
                                <!-- Usage Details -->
                                <div class="col-md-6">
                                    <h6 class="mb-3"><i class="fas fa-user mr-2"></i><?php echo lang('usage_details'); ?></h6>
                                    
                                    <div class="form-group">
                                        <label for="used_by_type"><?php echo lang('used_by_type'); ?> <span class="text-danger">*</span></label>
                                        <select class="form-control" name="used_by_type" id="used_by_type" required>
                                            <option value=""><?php echo lang('select') . ' ' . lang('type'); ?></option>
                                            <option value="patient">Patient</option>
                                            <option value="doctor">Doctor</option>
                                            <option value="nurse">Nurse</option>
                                            <option value="department">Department</option>
                                            <option value="other">Other</option>
                                        </select>
                                    </div>
                                    
                                    <div class="form-group" id="patient_group" style="display: none;">
                                        <label for="patient_id"><?php echo lang('patient'); ?></label>
                                        <select class="form-control" name="patient_id" id="patient_id">
                                            <option value=""><?php echo lang('select') . ' ' . lang('patient'); ?></option>
                                            <?php if (!empty($patients)) { ?>
                                                <?php foreach ($patients as $patient) { ?>
                                                    <option value="<?php echo $patient->id; ?>">
                                                        <?php echo $patient->name; ?> (ID: <?php echo $patient->patient_id; ?>)
                                                    </option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                                    </div>
                                    
                                    <div class="form-group" id="doctor_group" style="display: none;">
                                        <label for="doctor_id"><?php echo lang('doctor'); ?></label>
                                        <select class="form-control" name="doctor_id" id="doctor_id">
                                            <option value=""><?php echo lang('select') . ' ' . lang('doctor'); ?></option>
                                            <?php if (!empty($doctors)) { ?>
                                                <?php foreach ($doctors as $doctor) { ?>
                                                    <option value="<?php echo $doctor->id; ?>">
                                                        <?php echo $doctor->name; ?>
                                                    </option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                                    </div>
                                    
                                    <div class="form-group" id="department_group" style="display: none;">
                                        <label for="department_id"><?php echo lang('department'); ?></label>
                                        <select class="form-control" name="department_id" id="department_id">
                                            <option value=""><?php echo lang('select') . ' ' . lang('department'); ?></option>
                                            <?php if (!empty($departments)) { ?>
                                                <?php foreach ($departments as $department) { ?>
                                                    <option value="<?php echo $department->id; ?>">
                                                        <?php echo $department->name; ?>
                                                    </option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="notes"><?php echo lang('notes'); ?></label>
                                        <textarea class="form-control" name="notes" id="notes" rows="3"></textarea>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Hidden fields with default values -->
                            <input type="hidden" name="used_by_id" value="">
                            <input type="hidden" name="batch_number" value="">
                            <input type="hidden" name="expiry_date" value="">
                            <!-- Hidden submit field -->
                            <input type="hidden" name="submit" value="1">
                        </form>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="fas fa-times mr-2"></i><?php echo lang('cancel'); ?>
                </button>
                <button type="submit" form="addUsageForm" name="submit" class="btn btn-success">
                    <i class="fas fa-save mr-2"></i><?php echo lang('save'); ?>
                </button>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript -->
<script>
$(document).ready(function() {
    $('#usageLogsTable').DataTable({
        "responsive": true,
        "lengthChange": false,
        "autoWidth": false,
        "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"],
        "order": [[ 0, "desc" ]]
    }).buttons().container().appendTo('#usageLogsTable_wrapper .col-md-6:eq(0)');
    
    // Initialize Select2 for dropdowns
    $('#inventory_item_id').select2({
        placeholder: "Select Item",
        allowClear: true,
        dropdownParent: $('#addUsageModal')
    });
    
    $('#used_by_type').select2({
        placeholder: "Select Used By Type",
        allowClear: true,
        minimumResultsForSearch: Infinity,
        dropdownParent: $('#addUsageModal')
    });
    
    $('#patient_id').select2({
        placeholder: "Select Patient",
        allowClear: true,
        dropdownParent: $('#addUsageModal')
    });
    
    $('#doctor_id').select2({
        placeholder: "Select Doctor",
        allowClear: true,
        dropdownParent: $('#addUsageModal')
    });
    
    $('#department_id').select2({
        placeholder: "Select Department",
        allowClear: true,
        dropdownParent: $('#addUsageModal')
    });
    
    // Handle item selection
    $('#inventory_item_id').change(function() {
        var selectedOption = $(this).find('option:selected');
        var stock = selectedOption.data('stock');
        var cost = selectedOption.data('cost');
        
        $('#available_stock').text(stock || '-');
        $('#quantity_used').attr('max', stock);
    });
    
    // Handle used by type change
    $('#used_by_type').change(function() {
        var type = $(this).val();
        
        // Hide all groups
        $('#patient_group, #doctor_group, #department_group').hide();
        
        // Show relevant group
        if (type === 'patient') {
            $('#patient_group').show();
        } else if (type === 'doctor') {
            $('#doctor_group').show();
        } else if (type === 'department') {
            $('#department_group').show();
        }
    });
    
    // Validate stock
    $('#quantity_used').on('blur', function() {
        var quantity = parseFloat($(this).val());
        var availableStock = parseFloat($('#available_stock').text());
        
        if (quantity > availableStock) {
            alert('Quantity cannot exceed available stock (' + availableStock + ')');
            $(this).val(availableStock);
        }
    });
    
    // Reset form when modal is closed
    $('#addUsageModal').on('hidden.bs.modal', function () {
        $('#addUsageForm')[0].reset();
        $('#usage_date').val(new Date().toISOString().slice(0, 16));
        $('#available_stock').text('-');
        $('#patient_group, #doctor_group, #department_group').hide();
    });
});
</script>